# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel
from lidarr.models.album_resource import AlbumResource
from lidarr.models.artist_resource import ArtistResource
from lidarr.models.custom_format_resource import CustomFormatResource
from lidarr.models.entity_history_event_type import EntityHistoryEventType
from lidarr.models.quality_model import QualityModel
from lidarr.models.track_resource import TrackResource

class HistoryResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    album_id: Optional[int]
    artist_id: Optional[int]
    track_id: Optional[int]
    source_title: Optional[str]
    quality: Optional[QualityModel]
    custom_formats: Optional[List]
    quality_cutoff_not_met: Optional[bool]
    var_date: Optional[datetime]
    download_id: Optional[str]
    event_type: Optional[EntityHistoryEventType]
    data: Optional[Dict]
    album: Optional[AlbumResource]
    artist: Optional[ArtistResource]
    track: Optional[TrackResource]
    __properties = ["id", "albumId", "artistId", "trackId", "sourceTitle", "quality", "customFormats", "qualityCutoffNotMet", "date", "downloadId", "eventType", "data", "album", "artist", "track"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HistoryResource:
        """Create an instance of HistoryResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_formats (list)
        _items = []
        if self.custom_formats:
            for _item in self.custom_formats:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customFormats'] = _items
        # override the default output from pydantic by calling `to_dict()` of album
        if self.album:
            _dict['album'] = self.album.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artist
        if self.artist:
            _dict['artist'] = self.artist.to_dict()
        # override the default output from pydantic by calling `to_dict()` of track
        if self.track:
            _dict['track'] = self.track.to_dict()
        # set to None if source_title (nullable) is None
        if self.source_title is None:
            _dict['sourceTitle'] = None

        # set to None if custom_formats (nullable) is None
        if self.custom_formats is None:
            _dict['customFormats'] = None

        # set to None if download_id (nullable) is None
        if self.download_id is None:
            _dict['downloadId'] = None

        # set to None if data (nullable) is None
        if self.data is None:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HistoryResource:
        """Create an instance of HistoryResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return HistoryResource.parse_obj(obj)

        _obj = HistoryResource.parse_obj({
            "id": obj.get("id"),
            "album_id": obj.get("albumId"),
            "artist_id": obj.get("artistId"),
            "track_id": obj.get("trackId"),
            "source_title": obj.get("sourceTitle"),
            "quality": QualityModel.from_dict(obj.get("quality")) if obj.get("quality") is not None else None,
            "custom_formats": [CustomFormatResource.from_dict(_item) for _item in obj.get("customFormats")] if obj.get("customFormats") is not None else None,
            "quality_cutoff_not_met": obj.get("qualityCutoffNotMet"),
            "var_date": obj.get("date"),
            "download_id": obj.get("downloadId"),
            "event_type": obj.get("eventType"),
            "data": obj.get("data"),
            "album": AlbumResource.from_dict(obj.get("album")) if obj.get("album") is not None else None,
            "artist": ArtistResource.from_dict(obj.get("artist")) if obj.get("artist") is not None else None,
            "track": TrackResource.from_dict(obj.get("track")) if obj.get("track") is not None else None
        })
        return _obj

