# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.add_artist_options import AddArtistOptions
from lidarr.models.artist_metadata_lazy_loaded import ArtistMetadataLazyLoaded
from lidarr.models.metadata_profile_lazy_loaded import MetadataProfileLazyLoaded
from lidarr.models.new_item_monitor_types import NewItemMonitorTypes
from lidarr.models.quality_profile_lazy_loaded import QualityProfileLazyLoaded

class Artist(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    artist_metadata_id: Optional[int]
    clean_name: Optional[str]
    sort_name: Optional[str]
    monitored: Optional[bool]
    monitor_new_items: Optional[NewItemMonitorTypes]
    last_info_sync: Optional[datetime]
    path: Optional[str]
    root_folder_path: Optional[str]
    added: Optional[datetime]
    quality_profile_id: Optional[int]
    metadata_profile_id: Optional[int]
    tags: Optional[List]
    add_options: Optional[AddArtistOptions]
    metadata: Optional[ArtistMetadataLazyLoaded]
    quality_profile: Optional[QualityProfileLazyLoaded]
    metadata_profile: Optional[MetadataProfileLazyLoaded]
    albums: Optional[AlbumListLazyLoaded]
    name: Optional[str]
    foreign_artist_id: Optional[str]
    __properties = ["id", "artistMetadataId", "cleanName", "sortName", "monitored", "monitorNewItems", "lastInfoSync", "path", "rootFolderPath", "added", "qualityProfileId", "metadataProfileId", "tags", "addOptions", "metadata", "qualityProfile", "metadataProfile", "albums", "name", "foreignArtistId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Artist:
        """Create an instance of Artist from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality_profile
        if self.quality_profile:
            _dict['qualityProfile'] = self.quality_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata_profile
        if self.metadata_profile:
            _dict['metadataProfile'] = self.metadata_profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of albums
        if self.albums:
            _dict['albums'] = self.albums.to_dict()
        # set to None if clean_name (nullable) is None
        if self.clean_name is None:
            _dict['cleanName'] = None

        # set to None if sort_name (nullable) is None
        if self.sort_name is None:
            _dict['sortName'] = None

        # set to None if last_info_sync (nullable) is None
        if self.last_info_sync is None:
            _dict['lastInfoSync'] = None

        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if root_folder_path (nullable) is None
        if self.root_folder_path is None:
            _dict['rootFolderPath'] = None

        # set to None if tags (nullable) is None
        if self.tags is None:
            _dict['tags'] = None

        # set to None if name (nullable) is None
        if self.name is None:
            _dict['name'] = None

        # set to None if foreign_artist_id (nullable) is None
        if self.foreign_artist_id is None:
            _dict['foreignArtistId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Artist:
        """Create an instance of Artist from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Artist.parse_obj(obj)

        _obj = Artist.parse_obj({
            "id": obj.get("id"),
            "artist_metadata_id": obj.get("artistMetadataId"),
            "clean_name": obj.get("cleanName"),
            "sort_name": obj.get("sortName"),
            "monitored": obj.get("monitored"),
            "monitor_new_items": obj.get("monitorNewItems"),
            "last_info_sync": obj.get("lastInfoSync"),
            "path": obj.get("path"),
            "root_folder_path": obj.get("rootFolderPath"),
            "added": obj.get("added"),
            "quality_profile_id": obj.get("qualityProfileId"),
            "metadata_profile_id": obj.get("metadataProfileId"),
            "tags": obj.get("tags"),
            "add_options": AddArtistOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "metadata": ArtistMetadataLazyLoaded.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "quality_profile": QualityProfileLazyLoaded.from_dict(obj.get("qualityProfile")) if obj.get("qualityProfile") is not None else None,
            "metadata_profile": MetadataProfileLazyLoaded.from_dict(obj.get("metadataProfile")) if obj.get("metadataProfile") is not None else None,
            "albums": AlbumListLazyLoaded.from_dict(obj.get("albums")) if obj.get("albums") is not None else None,
            "name": obj.get("name"),
            "foreign_artist_id": obj.get("foreignArtistId")
        })
        return _obj

