"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mesh = exports.MeshFilterType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const virtual_gateway_1 = require("./virtual-gateway");
const virtual_node_1 = require("./virtual-node");
const virtual_router_1 = require("./virtual-router");
/**
 * A utility enum defined for the egressFilter type property, the default of DROP_ALL,
 * allows traffic only to other resources inside the mesh, or API calls to amazon resources.
 *
 * @default DROP_ALL
 */
var MeshFilterType;
(function (MeshFilterType) {
    /**
     * Allows all outbound traffic
     */
    MeshFilterType["ALLOW_ALL"] = "ALLOW_ALL";
    /**
     * Allows traffic only to other resources inside the mesh, or API calls to amazon resources
     */
    MeshFilterType["DROP_ALL"] = "DROP_ALL";
})(MeshFilterType = exports.MeshFilterType || (exports.MeshFilterType = {}));
/**
 * Represents a new or imported AppMesh mesh
 */
class MeshBase extends cdk.Resource {
    /**
     * Adds a VirtualRouter to the Mesh with the given id and props
     */
    addVirtualRouter(id, props = {}) {
        return new virtual_router_1.VirtualRouter(this, id, {
            ...props,
            mesh: this,
        });
    }
    /**
     * Adds a VirtualNode to the Mesh
     */
    addVirtualNode(id, props = {}) {
        return new virtual_node_1.VirtualNode(this, id, {
            ...props,
            mesh: this,
        });
    }
    /**
     * Adds a VirtualGateway to the Mesh
     */
    addVirtualGateway(id, props) {
        return new virtual_gateway_1.VirtualGateway(this, id, {
            ...props,
            mesh: this,
        });
    }
}
/**
 * Define a new AppMesh mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html
 */
class Mesh extends MeshBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.meshName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appmesh_MeshProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Mesh);
            }
            throw error;
        }
        const mesh = new appmesh_generated_1.CfnMesh(this, 'Resource', {
            meshName: this.physicalName,
            spec: {
                egressFilter: props.egressFilter ? {
                    type: props.egressFilter,
                } : undefined,
            },
        });
        this.meshName = this.getResourceNameAttribute(mesh.attrMeshName);
        this.meshArn = this.getResourceArnAttribute(mesh.ref, {
            service: 'appmesh',
            resource: 'mesh',
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing mesh by arn
     */
    static fromMeshArn(scope, id, meshArn) {
        const parts = cdk.Stack.of(scope).splitArn(meshArn, cdk.ArnFormat.SLASH_RESOURCE_NAME);
        class Import extends MeshBase {
            constructor() {
                super(...arguments);
                this.meshName = parts.resourceName || '';
                this.meshArn = meshArn;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: meshArn,
        });
    }
    /**
     * Import an existing mesh by name
     */
    static fromMeshName(scope, id, meshName) {
        const arn = cdk.Stack.of(scope).formatArn({
            service: 'appmesh',
            resource: 'mesh',
            resourceName: meshName,
        });
        class Import extends MeshBase {
            constructor() {
                super(...arguments);
                this.meshName = meshName;
                this.meshArn = arn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Mesh = Mesh;
_a = JSII_RTTI_SYMBOL_1;
Mesh[_a] = { fqn: "@aws-cdk/aws-appmesh.Mesh", version: "1.161.0" };
//# sourceMappingURL=data:application/json;base64,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