# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: builder/v1/builder.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict, List, Optional

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class Container(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class OutputResponse(betterproto.Message):
    """Logs output from a given action"""

    log: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AddRequest(betterproto.Message):
    # args
    container: "Container" = betterproto.message_field(1)
    src: str = betterproto.string_field(2)
    dest: str = betterproto.string_field(3)
    # options
    from_: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class CommitRequest(betterproto.Message):
    # args
    container: "Container" = betterproto.message_field(1)
    tag: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ConfigRequest(betterproto.Message):
    # args
    container: "Container" = betterproto.message_field(1)
    # options
    entrypoint: List[str] = betterproto.string_field(10)
    cmd: List[str] = betterproto.string_field(11)
    working_dir: str = betterproto.string_field(12)
    user: str = betterproto.string_field(13)
    env: Dict[str, str] = betterproto.map_field(
        14, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    ports: List[int] = betterproto.int32_field(15)
    volumes: List[str] = betterproto.string_field(16)


@dataclass(eq=False, repr=False)
class CopyRequest(betterproto.Message):
    # args
    container: "Container" = betterproto.message_field(1)
    source: str = betterproto.string_field(2)
    dest: str = betterproto.string_field(3)
    # options
    from_: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class FromRequest(betterproto.Message):
    # args
    image: str = betterproto.string_field(1)
    # options set the state id of this working container
    as_: str = betterproto.string_field(10)
    # set files to ignore from the workspace (used in operations like copy)
    ignore: List[str] = betterproto.string_field(11)


@dataclass(eq=False, repr=False)
class FromResponse(betterproto.Message):
    container: "Container" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RunRequest(betterproto.Message):
    container: "Container" = betterproto.message_field(1)
    command: List[str] = betterproto.string_field(2)


class BuilderStub(betterproto.ServiceStub):
    async def add(
        self,
        *,
        container: "Container" = None,
        src: str = "",
        dest: str = "",
        from_: str = "",
    ) -> AsyncIterator["OutputResponse"]:

        request = AddRequest()
        if container is not None:
            request.container = container
        request.src = src
        request.dest = dest
        request.from_ = from_

        async for response in self._unary_stream(
            "/boxygen.builder.v1.Builder/Add",
            request,
            OutputResponse,
        ):
            yield response

    async def commit(
        self, *, container: "Container" = None, tag: str = ""
    ) -> AsyncIterator["OutputResponse"]:

        request = CommitRequest()
        if container is not None:
            request.container = container
        request.tag = tag

        async for response in self._unary_stream(
            "/boxygen.builder.v1.Builder/Commit",
            request,
            OutputResponse,
        ):
            yield response

    async def config(
        self,
        *,
        container: "Container" = None,
        entrypoint: Optional[List[str]] = None,
        cmd: Optional[List[str]] = None,
        working_dir: str = "",
        user: str = "",
        env: Dict[str, str] = None,
        ports: Optional[List[int]] = None,
        volumes: Optional[List[str]] = None,
    ) -> AsyncIterator["OutputResponse"]:
        entrypoint = entrypoint or []
        cmd = cmd or []
        ports = ports or []
        volumes = volumes or []

        request = ConfigRequest()
        if container is not None:
            request.container = container
        request.entrypoint = entrypoint
        request.cmd = cmd
        request.working_dir = working_dir
        request.user = user
        request.env = env
        request.ports = ports
        request.volumes = volumes

        async for response in self._unary_stream(
            "/boxygen.builder.v1.Builder/Config",
            request,
            OutputResponse,
        ):
            yield response

    async def copy(
        self,
        *,
        container: "Container" = None,
        source: str = "",
        dest: str = "",
        from_: str = "",
    ) -> AsyncIterator["OutputResponse"]:

        request = CopyRequest()
        if container is not None:
            request.container = container
        request.source = source
        request.dest = dest
        request.from_ = from_

        async for response in self._unary_stream(
            "/boxygen.builder.v1.Builder/Copy",
            request,
            OutputResponse,
        ):
            yield response

    async def from_(
        self, *, image: str = "", as_: str = "", ignore: Optional[List[str]] = None
    ) -> "FromResponse":
        ignore = ignore or []

        request = FromRequest()
        request.image = image
        request.as_ = as_
        request.ignore = ignore

        return await self._unary_unary(
            "/boxygen.builder.v1.Builder/From", request, FromResponse
        )

    async def run(
        self, *, container: "Container" = None, command: Optional[List[str]] = None
    ) -> AsyncIterator["OutputResponse"]:
        command = command or []

        request = RunRequest()
        if container is not None:
            request.container = container
        request.command = command

        async for response in self._unary_stream(
            "/boxygen.builder.v1.Builder/Run",
            request,
            OutputResponse,
        ):
            yield response


class BuilderBase(ServiceBase):
    async def add(
        self, container: "Container", src: str, dest: str, from_: str
    ) -> AsyncIterator["OutputResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def commit(
        self, container: "Container", tag: str
    ) -> AsyncIterator["OutputResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def config(
        self,
        container: "Container",
        entrypoint: Optional[List[str]],
        cmd: Optional[List[str]],
        working_dir: str,
        user: str,
        env: Dict[str, str],
        ports: Optional[List[int]],
        volumes: Optional[List[str]],
    ) -> AsyncIterator["OutputResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def copy(
        self, container: "Container", source: str, dest: str, from_: str
    ) -> AsyncIterator["OutputResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def from_(
        self, image: str, as_: str, ignore: Optional[List[str]]
    ) -> "FromResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def run(
        self, container: "Container", command: Optional[List[str]]
    ) -> AsyncIterator["OutputResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "container": request.container,
            "src": request.src,
            "dest": request.dest,
            "from_": request.from_,
        }

        await self._call_rpc_handler_server_stream(
            self.add,
            stream,
            request_kwargs,
        )

    async def __rpc_commit(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "container": request.container,
            "tag": request.tag,
        }

        await self._call_rpc_handler_server_stream(
            self.commit,
            stream,
            request_kwargs,
        )

    async def __rpc_config(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "container": request.container,
            "entrypoint": request.entrypoint,
            "cmd": request.cmd,
            "working_dir": request.working_dir,
            "user": request.user,
            "env": request.env,
            "ports": request.ports,
            "volumes": request.volumes,
        }

        await self._call_rpc_handler_server_stream(
            self.config,
            stream,
            request_kwargs,
        )

    async def __rpc_copy(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "container": request.container,
            "source": request.source,
            "dest": request.dest,
            "from_": request.from_,
        }

        await self._call_rpc_handler_server_stream(
            self.copy,
            stream,
            request_kwargs,
        )

    async def __rpc_from_(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "image": request.image,
            "as_": request.as_,
            "ignore": request.ignore,
        }

        response = await self.from_(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_run(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "container": request.container,
            "command": request.command,
        }

        await self._call_rpc_handler_server_stream(
            self.run,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/boxygen.builder.v1.Builder/Add": grpclib.const.Handler(
                self.__rpc_add,
                grpclib.const.Cardinality.UNARY_STREAM,
                AddRequest,
                OutputResponse,
            ),
            "/boxygen.builder.v1.Builder/Commit": grpclib.const.Handler(
                self.__rpc_commit,
                grpclib.const.Cardinality.UNARY_STREAM,
                CommitRequest,
                OutputResponse,
            ),
            "/boxygen.builder.v1.Builder/Config": grpclib.const.Handler(
                self.__rpc_config,
                grpclib.const.Cardinality.UNARY_STREAM,
                ConfigRequest,
                OutputResponse,
            ),
            "/boxygen.builder.v1.Builder/Copy": grpclib.const.Handler(
                self.__rpc_copy,
                grpclib.const.Cardinality.UNARY_STREAM,
                CopyRequest,
                OutputResponse,
            ),
            "/boxygen.builder.v1.Builder/From": grpclib.const.Handler(
                self.__rpc_from_,
                grpclib.const.Cardinality.UNARY_UNARY,
                FromRequest,
                FromResponse,
            ),
            "/boxygen.builder.v1.Builder/Run": grpclib.const.Handler(
                self.__rpc_run,
                grpclib.const.Cardinality.UNARY_STREAM,
                RunRequest,
                OutputResponse,
            ),
        }
