# This code was automatically generated by tools/build_data.py

from typing import Dict, Optional, TypedDict

from .types import NumberTypes


class _PrefixData(TypedDict, total=False):
    f: int
    m: int
    l: Optional[int]
    t: NumberTypes
    st: str
    a: str


PREFIXES: Dict[str, _PrefixData] = {
    "03": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "東京"},
    "12": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "固定優先接続の解除"},
    "011": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "札幌"},
    "010": {"f": 3, "m": 0, "t": "国際電話", "l": None},
    "044": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "川崎"},
    "045": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "横浜"},
    "052": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "名古屋"},
    "050": {"f": 3, "m": 4, "t": "IP", "l": 11},
    "064": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "大阪"},
    "066": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "大阪"},
    "067": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "大阪"},
    "060": {"f": 4, "m": 3, "t": "FMC", "l": None},
    "075": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "京都"},
    "078": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "神戸"},
    "070": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "090": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "100": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "オペレータ経由呼接続"},
    "102": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "非常・緊急扱い通話"},
    "104": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "番号案内"},
    "106": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "オペレータ経由呼接続"},
    "108": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "呼接続に関する付加的な処理"},
    "110": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "警察機関への緊急通報"},
    "111": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "試験"},
    "112": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "共同相互通話"},
    "113": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "故障受付"},
    "114": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "話中調べ"},
    "115": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "電報受付"},
    "116": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "営業・料金案内"},
    "117": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "時報"},
    "118": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "海上保安機関への緊急通報"},
    "119": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "消防機関への緊急通報"},
    "131": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "通話料分計"},
    "134": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "135": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "136": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "発信番号電話通知サービス応用"},
    "140": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "141": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "留守番電話"},
    "142": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "着信転送"},
    "143": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "ドライブモード"},
    "144": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "迷惑電話対応"},
    "145": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "話し中時対応"},
    "146": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "特定者向け情報の蓄積・再生"},
    "147": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "発信番号電話通知サービス応用"},
    "148": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "通知要請"},
    "149": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "151": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "営業・料金案内"},
    "154": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "157": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "営業・料金案内"},
    "158": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "159": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "サービス条件設定"},
    "161": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "特定者向け情報の蓄積・再生"},
    "162": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "特定者向け情報の蓄積・再生"},
    "164": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "端末切り替え"},
    "165": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "メール送受信"},
    "171": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "災害用伝言ダイヤル"},
    "177": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "天気予報"},
    "178": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "呼接続に関する付加的な処理"},
    "179": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "呼接続に関する付加的な処理"},
    "181": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "ローミング"},
    "184": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "発信者番号通知拒否"},
    "186": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "発信者番号通知"},
    "188": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "消費生活相談受付"},
    "189": {"f": 3, "m": 0, "t": "特番", "l": 3, "st": "児童虐待通告・児童相談受付"},
    "0124": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "芦別"},
    "0125": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "滝川"},
    "0120": {"f": 4, "m": 3, "t": "フリーダイヤル", "l": 10},
    "0134": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小樽"},
    "0138": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "函館"},
    "0142": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊達"},
    "0143": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "室蘭"},
    "0144": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "苫小牧"},
    "0157": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北見"},
    "0162": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "稚内"},
    "0166": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "旭川"},
    "0167": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富良野"},
    "0172": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "弘前"},
    "0174": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "蟹田"},
    "0176": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "十和田"},
    "0177": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "青森"},
    "0178": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八戸"},
    "0179": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三戸"},
    "0182": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "横手"},
    "0183": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "湯沢"},
    "0184": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "本荘"},
    "0188": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "秋田"},
    "0191": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "一関"},
    "0192": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大船渡"},
    "0196": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "盛岡"},
    "0199": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "盛岡"},
    "0222": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "0227": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "0220": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "迫"},
    "0225": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石巻"},
    "0226": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "気仙沼"},
    "0228": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "築館"},
    "0229": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "古川"},
    "0233": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新庄"},
    "0234": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "酒田"},
    "0235": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鶴岡"},
    "0236": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山形"},
    "0240": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "磐城富岡"},
    "0242": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "会津若松"},
    "0243": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "二本松"},
    "0244": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "原町"},
    "0245": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福島"},
    "0246": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "いわき"},
    "0249": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "郡山"},
    "0252": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "新潟"},
    "0253": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "新潟"},
    "0250": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新津"},
    "0259": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐渡"},
    "0260": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿南町"},
    "0262": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "0263": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松本"},
    "0266": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "諏訪"},
    "0268": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上田"},
    "0270": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊勢崎"},
    "0272": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前橋"},
    "0273": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "高崎"},
    "0276": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "太田"},
    "0277": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "桐生"},
    "0280": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "古河"},
    "0282": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栃木"},
    "0284": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "足利"},
    "0281": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "0286": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "0288": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "今市"},
    "0292": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "0294": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "常陸太田"},
    "0298": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "土浦"},
    "0204": {"f": 4, "m": 3, "t": "ポケベル", "l": 11},
    "0201": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0202": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0203": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0205": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0206": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0207": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0208": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0209": {"f": 3, "m": 3, "t": "M2M", "l": 11},
    "0423": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "国分寺"},
    "0425": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "立川"},
    "0426": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "八王子"},
    "0427": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "相模原"},
    "0420": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "0432": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "千葉"},
    "0433": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "千葉"},
    "0434": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "千葉"},
    "0436": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "市原"},
    "0438": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木更津"},
    "0439": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木更津"},
    "0460": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小田原"},
    "0462": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "厚木"},
    "0464": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "厚木"},
    "0463": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "平塚"},
    "0465": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小田原"},
    "0466": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤沢"},
    "0467": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤沢"},
    "0468": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "横須賀"},
    "0471": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "柏"},
    "0473": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "市川"},
    "0474": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "船橋"},
    "0476": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "成田"},
    "0478": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐原"},
    "0486": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浦和"},
    "0487": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浦和"},
    "0488": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浦和"},
    "0482": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "川口"},
    "0484": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "川口"},
    "0480": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久喜"},
    "0485": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "熊谷"},
    "0489": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "草加"},
    "0492": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "川越"},
    "0493": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東松山"},
    "0494": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "秩父"},
    "0495": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "本庄"},
    "0534": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "0535": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "0531": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田原"},
    "0532": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊橋"},
    "0533": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊橋"},
    "0537": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "掛川"},
    "0538": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "磐田"},
    "0542": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "静岡"},
    "0543": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "静岡"},
    "0546": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "静岡"},
    "0549": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "静岡"},
    "0544": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富士宮"},
    "0545": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富士"},
    "0547": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "島田"},
    "0548": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "榛原"},
    "0550": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "御殿場"},
    "0551": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "韮崎"},
    "0552": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "甲府"},
    "0553": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "山梨"},
    "0554": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大月"},
    "0555": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "吉田"},
    "0557": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊東"},
    "0559": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "沼津"},
    "0561": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "瀬戸"},
    "0562": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "尾張横須賀"},
    "0563": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西尾"},
    "0564": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岡崎"},
    "0565": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊田"},
    "0566": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "刈谷"},
    "0567": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津島"},
    "0568": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "春日井"},
    "0569": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "半田"},
    "0572": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "多治見"},
    "0577": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高山"},
    "0578": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "神岡"},
    "0570": {"f": 4, "m": 3, "t": "ナビダイヤル", "l": 10},
    "0582": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岐阜"},
    "0583": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岐阜"},
    "0581": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高富"},
    "0584": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大垣"},
    "0585": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "揖斐川"},
    "0586": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "一宮"},
    "0587": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "一宮"},
    "0591": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "津"},
    "0592": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "津"},
    "0593": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "四日市"},
    "0594": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "桑名"},
    "0596": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊勢"},
    "0728": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "寝屋川"},
    "0721": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富田林"},
    "0722": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "0724": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岸和田貝塚"},
    "0725": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "和泉"},
    "0726": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "茨木"},
    "0727": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "池田"},
    "0729": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "八尾"},
    "0734": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "和歌山"},
    "0737": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "湯浅"},
    "0738": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "御坊"},
    "0739": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田辺"},
    "0740": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "今津"},
    "0742": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "奈良"},
    "0743": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "奈良"},
    "0744": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "0762": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "金沢"},
    "0763": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福野"},
    "0764": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "富山"},
    "0765": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "魚津"},
    "0766": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高岡"},
    "0774": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇治"},
    "0775": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "大津"},
    "0776": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福井"},
    "0778": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武生"},
    "0779": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大野"},
    "0792": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "姫路"},
    "0793": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "姫路"},
    "0797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西宮"},
    "0798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西宮"},
    "0822": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "0825": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "0828": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "0823": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "呉"},
    "0827": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩国"},
    "0832": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "0833": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下松"},
    "0834": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "徳山"},
    "0835": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "防府"},
    "0845": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "因島"},
    "0848": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "尾道"},
    "0852": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松江"},
    "0853": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "出雲"},
    "0857": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鳥取"},
    "0864": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "0862": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "0875": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "観音寺"},
    "0877": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "丸亀"},
    "0878": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "高松"},
    "0885": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松島"},
    "0886": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "徳島"},
    "0888": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "高知"},
    "0892": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久万"},
    "0893": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大洲"},
    "0896": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊予三島"},
    "0898": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "今治"},
    "0899": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "松山"},
    "0800": {"f": 4, "m": 3, "t": "フリーダイヤル", "l": 11},
    "0801": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0802": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0803": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0804": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0805": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0806": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0807": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0808": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0809": {"f": 3, "m": 4, "t": "携帯", "l": 11},
    "0922": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0924": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0925": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0926": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0927": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0928": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0929": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "0932": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0933": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0934": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0935": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0936": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0937": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0938": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0939": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "北九州"},
    "0930": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "行橋"},
    "0940": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宗像"},
    "0942": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久留米"},
    "0944": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "瀬高"},
    "0946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "甘木"},
    "0947": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田川"},
    "0948": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯塚"},
    "0950": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "平戸"},
    "0952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐賀"},
    "0956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐世保"},
    "0958": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長崎"},
    "0962": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "熊本"},
    "0963": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "熊本"},
    "0964": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松橋"},
    "0965": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八代"},
    "0969": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天草"},
    "0975": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "大分"},
    "0977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "別府"},
    "0979": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中津"},
    "0988": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "那覇"},
    "0989": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "那覇"},
    "0983": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高鍋"},
    "0984": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小林"},
    "0985": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮崎"},
    "0986": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "都城"},
    "0987": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日南"},
    "0992": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "0998": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "0990": {"f": 4, "m": 3, "t": "災害募金サービス", "l": 10},
    "01232": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千歳"},
    "01233": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千歳"},
    "01234": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千歳"},
    "01236": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千歳"},
    "01235": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "01237": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "01238": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "01262": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩見沢"},
    "01263": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩見沢"},
    "01264": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩見沢"},
    "01265": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩見沢"},
    "01266": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩見沢"},
    "01267": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "岩見沢"},
    "01336": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石狩"},
    "01337": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石狩"},
    "01332": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "当別"},
    "01333": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "当別"},
    "01352": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "余市"},
    "01353": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "余市"},
    "01354": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "余市"},
    "01356": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩内"},
    "01357": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩内"},
    "01362": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倶知安"},
    "01363": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倶知安"},
    "01364": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倶知安"},
    "01365": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倶知安"},
    "01366": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "寿都"},
    "01367": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "寿都"},
    "01372": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "鹿部"},
    "01374": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "森"},
    "01375": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八雲"},
    "01376": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八雲"},
    "01377": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "八雲"},
    "01378": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "今金"},
    "01392": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "木古内"},
    "01393": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松前"},
    "01394": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松前"},
    "01395": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "江差"},
    "01396": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "江差"},
    "01397": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "奥尻"},
    "01398": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊石"},
    "01452": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "早来"},
    "01453": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "早来"},
    "01454": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鵡川"},
    "01455": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鵡川"},
    "01456": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "門別富川"},
    "01457": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "門別富川"},
    "01462": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "01464": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "01465": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "01466": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "えりも"},
    "01524": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "網走"},
    "01525": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "網走"},
    "01526": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "網走"},
    "01522": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "斜里"},
    "01523": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "斜里"},
    "01527": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美幌"},
    "01528": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美幌"},
    "01535": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "厚岸"},
    "01536": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "厚岸"},
    "01532": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根室"},
    "01533": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根室"},
    "01534": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中標津"},
    "01537": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中標津"},
    "01538": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根室標津"},
    "01539": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根室標津"},
    "01542": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01543": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01544": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01545": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01546": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01549": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釧路"},
    "01547": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "白糠"},
    "01541": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "弟子屈"},
    "01548": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "弟子屈"},
    "01552": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01553": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01554": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01555": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01556": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01559": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "帯広"},
    "01551": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "十勝池田"},
    "01557": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "十勝池田"},
    "01558": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "広尾"},
    "01562": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "本別"},
    "01563": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "本別"},
    "01564": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "上士幌"},
    "01566": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "十勝清水"},
    "01567": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "十勝清水"},
    "01582": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "紋別"},
    "01583": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "紋別"},
    "01584": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "遠軽"},
    "01585": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "遠軽"},
    "01586": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "中湧別"},
    "01587": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "中湧別"},
    "01588": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "興部"},
    "01589": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "興部"},
    "01632": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "天塩"},
    "01634": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "浜頓別"},
    "01635": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "浜頓別"},
    "01636": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北見枝幸"},
    "01637": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北見枝幸"},
    "01638": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "利尻礼文"},
    "01639": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "利尻礼文"},
    "01644": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "留萌"},
    "01645": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "留萌"},
    "01642": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石狩深川"},
    "01643": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石狩深川"},
    "01646": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "羽幌"},
    "01647": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "羽幌"},
    "01648": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "焼尻"},
    "01652": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "士別"},
    "01653": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "士別"},
    "01654": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "名寄"},
    "01655": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "名寄"},
    "01656": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "美深"},
    "01658": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "上川"},
    "01732": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五所川原"},
    "01733": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五所川原"},
    "01734": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五所川原"},
    "01735": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五所川原"},
    "01736": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五所川原"},
    "01737": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰺ケ沢"},
    "01738": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰺ケ沢"},
    "01752": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "むつ"},
    "01753": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "むつ"},
    "01754": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "むつ"},
    "01756": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "野辺地"},
    "01757": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "野辺地"},
    "01852": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "男鹿"},
    "01853": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "男鹿"},
    "01854": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "男鹿"},
    "01855": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能代"},
    "01856": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能代"},
    "01857": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能代"},
    "01858": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能代"},
    "01862": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿角"},
    "01863": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿角"},
    "01864": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大館"},
    "01865": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大館"},
    "01869": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大館"},
    "01866": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鷹巣"},
    "01867": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鷹巣"},
    "01868": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鷹巣"},
    "01876": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大曲"},
    "01877": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大曲"},
    "01878": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大曲"},
    "01873": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "角館"},
    "01874": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "角館"},
    "01875": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "角館"},
    "01936": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮古"},
    "01937": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮古"},
    "01938": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮古"},
    "01939": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮古"},
    "01932": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釜石"},
    "01933": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釜石"},
    "01934": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釜石"},
    "01935": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "釜石"},
    "01945": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久慈"},
    "01946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久慈"},
    "01947": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久慈"},
    "01942": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩泉"},
    "01943": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩泉"},
    "01944": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩泉"},
    "01956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩手"},
    "01957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩手"},
    "01958": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩手"},
    "01952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "二戸"},
    "01953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "二戸"},
    "01954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "二戸"},
    "01955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "二戸"},
    "01972": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水沢"},
    "01973": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水沢"},
    "01974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水沢"},
    "01975": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水沢"},
    "01976": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北上"},
    "01977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北上"},
    "01978": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "北上"},
    "01982": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "花巻"},
    "01983": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "花巻"},
    "01984": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "花巻"},
    "01986": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "遠野"},
    "01987": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "遠野"},
    "02230": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02234": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02235": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02236": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02237": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02238": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02239": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "仙台"},
    "02232": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩沼"},
    "02233": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩沼"},
    "02245": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大河原"},
    "02246": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大河原"},
    "02247": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大河原"},
    "02248": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大河原"},
    "02242": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白石"},
    "02243": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白石"},
    "02244": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白石"},
    "02376": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "寒河江"},
    "02377": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "寒河江"},
    "02378": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "寒河江"},
    "02372": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村山"},
    "02373": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村山"},
    "02374": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村山"},
    "02375": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村山"},
    "02382": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米沢"},
    "02383": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米沢"},
    "02384": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米沢"},
    "02385": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米沢"},
    "02389": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米沢"},
    "02386": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長井"},
    "02387": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長井"},
    "02388": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長井"},
    "02412": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "喜多方"},
    "02413": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "喜多方"},
    "02416": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "02417": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "会津山口"},
    "02418": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "会津山口"},
    "02414": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳津"},
    "02415": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳津"},
    "02472": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石川"},
    "02473": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石川"},
    "02474": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石川"},
    "02475": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石川"},
    "02476": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三春"},
    "02477": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三春"},
    "02478": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三春"},
    "02486": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須賀川"},
    "02487": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須賀川"},
    "02488": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須賀川"},
    "02489": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須賀川"},
    "02482": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白河"},
    "02483": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白河"},
    "02484": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白河"},
    "02485": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "白河"},
    "02542": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新発田"},
    "02543": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新発田"},
    "02544": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新発田"},
    "02545": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "02546": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "02547": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "02549": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "02551": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "上越"},
    "02552": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "上越"},
    "02553": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "上越"},
    "02554": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "上越"},
    "02557": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新井"},
    "02558": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新井"},
    "02555": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "糸魚川"},
    "02556": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "糸魚川"},
    "02550": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "安塚"},
    "02559": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "安塚"},
    "02560": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "糸魚川"},
    "02567": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "巻"},
    "02568": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "巻"},
    "02569": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "巻"},
    "02562": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三条"},
    "02563": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三条"},
    "02564": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三条"},
    "02565": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三条"},
    "02566": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三条"},
    "02575": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "十日町"},
    "02576": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "十日町"},
    "02572": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柏崎"},
    "02573": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柏崎"},
    "02574": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柏崎"},
    "02571": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "六日町"},
    "02577": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "六日町"},
    "02578": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "六日町"},
    "02570": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "小出"},
    "02579": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "小出"},
    "02580": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "十日町"},
    "02582": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02583": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02584": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02585": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02586": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02587": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02588": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02589": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長岡"},
    "02612": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02613": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02614": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02615": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02616": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02618": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02619": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "02640": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "02646": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "02647": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "02648": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "02649": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "02642": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木曾福島"},
    "02643": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木曾福島"},
    "02644": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木曾福島"},
    "02645": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木曾福島"},
    "02656": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊那"},
    "02657": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊那"},
    "02658": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊那"},
    "02659": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊那"},
    "02652": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯田"},
    "02653": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯田"},
    "02654": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯田"},
    "02655": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯田"},
    "02672": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小諸"},
    "02673": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小諸"},
    "02674": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小諸"},
    "02675": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐久"},
    "02676": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐久"},
    "02677": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐久"},
    "02678": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐久"},
    "02679": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐久"},
    "02692": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中野"},
    "02693": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中野"},
    "02694": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中野"},
    "02695": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中野"},
    "02696": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯山"},
    "02697": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯山"},
    "02698": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "飯山"},
    "02780": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前橋"},
    "02788": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前橋"},
    "02789": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前橋"},
    "02782": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02783": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02784": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02785": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02786": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02787": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沼田"},
    "02746": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富岡"},
    "02747": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富岡"},
    "02748": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "富岡"},
    "02742": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤岡"},
    "02743": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤岡"},
    "02744": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤岡"},
    "02745": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "藤岡"},
    "02792": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02793": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02794": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02795": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02796": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "渋川"},
    "02798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長野原"},
    "02799": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長野原"},
    "02832": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02835": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02836": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02837": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02838": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02839": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐野"},
    "02830": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02833": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02834": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02856": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "真岡"},
    "02857": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "真岡"},
    "02858": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "真岡"},
    "02852": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小山"},
    "02853": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小山"},
    "02854": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小山"},
    "02855": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小山"},
    "02859": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小山"},
    "02890": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02892": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02893": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02894": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02895": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "宇都宮"},
    "02896": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿沼"},
    "02897": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿沼"},
    "02898": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿沼"},
    "02899": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿沼"},
    "02876": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "黒磯"},
    "02877": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "黒磯"},
    "02872": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大田原"},
    "02873": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大田原"},
    "02874": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大田原"},
    "02875": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大田原"},
    "02878": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "02911": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鉾田"},
    "02913": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鉾田"},
    "02914": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鉾田"},
    "02917": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02930": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02935": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02936": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02937": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02938": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02939": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "水戸"},
    "02932": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高萩"},
    "02933": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高萩"},
    "02934": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高萩"},
    "02955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "常陸大宮"},
    "02956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "常陸大宮"},
    "02957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大子"},
    "02967": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "笠間"},
    "02968": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "笠間"},
    "02962": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下館"},
    "02963": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下館"},
    "02964": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下館"},
    "02965": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下館"},
    "02976": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜ケ崎"},
    "02977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜ケ崎"},
    "02978": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜ケ崎"},
    "02979": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜ケ崎"},
    "02972": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水海道"},
    "02973": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水海道"},
    "02974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水海道"},
    "02975": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水海道"},
    "02992": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石岡"},
    "02993": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石岡"},
    "02994": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石岡"},
    "02995": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石岡"},
    "02996": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "潮来"},
    "02997": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "潮来"},
    "02998": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "潮来"},
    "02999": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "潮来"},
    "04222": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04223": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04224": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04225": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04226": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04227": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04228": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04229": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04220": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "国分寺"},
    "04240": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "国分寺"},
    "04241": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04242": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04243": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04244": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04245": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04246": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04247": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04248": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04249": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "武蔵野三鷹"},
    "04280": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "立川"},
    "04284": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "立川"},
    "04281": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "相模原"},
    "04285": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "相模原"},
    "04286": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "相模原"},
    "04282": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "青梅"},
    "04283": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "青梅"},
    "04287": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "青梅"},
    "04288": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "青梅"},
    "04289": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "青梅"},
    "04290": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04292": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04293": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04294": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04295": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04296": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04299": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "所沢"},
    "04291": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "飯能"},
    "04297": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "飯能"},
    "04298": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "飯能"},
    "04702": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "館山"},
    "04703": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "館山"},
    "04704": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "館山"},
    "04705": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "館山"},
    "04706": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大原"},
    "04707": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大原"},
    "04708": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大原"},
    "04700": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "鴨川"},
    "04701": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "鴨川"},
    "04709": {"f": 2, "m": 4, "t": "固定", "l": 10, "a": "鴨川"},
    "04770": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "市川"},
    "04771": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "市川"},
    "04772": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "市川"},
    "04775": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "船橋"},
    "04776": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "船橋"},
    "04777": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "船橋"},
    "04755": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東金"},
    "04756": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東金"},
    "04757": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東金"},
    "04758": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東金"},
    "04752": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "茂原"},
    "04753": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "茂原"},
    "04754": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "茂原"},
    "04792": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "04793": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "04794": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "04796": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "04797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "04798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "04992": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "伊豆大島"},
    "04994": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "三宅"},
    "04996": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "八丈島"},
    "04998": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "小笠原"},
    "05392": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "05393": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "05394": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "05395": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "05398": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "05399": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "05362": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新城"},
    "05363": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新城"},
    "05366": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "設楽"},
    "05367": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "設楽"},
    "05368": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "設楽"},
    "05562": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰍沢青柳"},
    "05563": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰍沢青柳"},
    "05564": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰍沢青柳"},
    "05565": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鰍沢青柳"},
    "05566": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "身延"},
    "05587": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "修善寺大仁"},
    "05588": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "修善寺大仁"},
    "05589": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "修善寺大仁"},
    "05582": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下田"},
    "05583": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下田"},
    "05584": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下田"},
    "05585": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下田"},
    "05586": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下田"},
    "05732": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "恵那"},
    "05733": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "恵那"},
    "05734": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "恵那"},
    "05735": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "恵那"},
    "05736": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中津川"},
    "05737": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中津川"},
    "05738": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "中津川"},
    "05742": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃加茂"},
    "05743": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃加茂"},
    "05744": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃加茂"},
    "05745": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃加茂"},
    "05746": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃加茂"},
    "05747": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃白川"},
    "05748": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美濃白川"},
    "05752": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "関"},
    "05753": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "関"},
    "05754": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "関"},
    "05755": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "関"},
    "05756": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郡上八幡"},
    "05757": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郡上八幡"},
    "05758": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郡上八幡"},
    "05762": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05763": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05764": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05765": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05766": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05767": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05768": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下呂"},
    "05769": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "荘川"},
    "05999": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "津"},
    "05992": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鳥羽"},
    "05993": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鳥羽"},
    "05994": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿児"},
    "05995": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿児"},
    "05996": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿児"},
    "05997": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿児"},
    "05998": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿児"},
    "05952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "上野"},
    "05958": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀山"},
    "05959": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀山"},
    "05972": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "尾鷲"},
    "05973": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "尾鷲"},
    "05974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "尾鷲"},
    "05977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "05978": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "05982": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松阪"},
    "05983": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松阪"},
    "05984": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松阪"},
    "05985": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松阪"},
    "05986": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "松阪"},
    "05987": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三瀬谷"},
    "05988": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三瀬谷"},
    "07230": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "寝屋川"},
    "07238": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "寝屋川"},
    "07239": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "寝屋川"},
    "07231": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07232": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07233": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07234": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07235": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07236": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07237": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "堺"},
    "07352": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新宮"},
    "07353": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新宮"},
    "07354": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新宮"},
    "07355": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新宮"},
    "07356": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "串本"},
    "07357": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "串本"},
    "07366": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩出"},
    "07367": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩出"},
    "07368": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "岩出"},
    "07362": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "和歌山橋本"},
    "07363": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "和歌山橋本"},
    "07364": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "和歌山橋本"},
    "07365": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "和歌山橋本"},
    "07452": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07453": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07454": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07455": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07456": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07457": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和高田"},
    "07458": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和榛原"},
    "07459": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大和榛原"},
    "07463": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "吉野"},
    "07464": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "吉野"},
    "07465": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "吉野"},
    "07466": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "十津川"},
    "07468": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "上北山"},
    "07472": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五条"},
    "07473": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五条"},
    "07474": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "五条"},
    "07475": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下市"},
    "07476": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "下市"},
    "07482": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市"},
    "07483": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市"},
    "07484": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市"},
    "07485": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市"},
    "07486": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水口"},
    "07487": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水口"},
    "07488": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水口"},
    "07492": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "彦根"},
    "07493": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "彦根"},
    "07494": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "彦根"},
    "07495": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長浜"},
    "07496": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長浜"},
    "07497": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長浜"},
    "07498": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長浜"},
    "07612": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松"},
    "07613": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松"},
    "07614": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松"},
    "07615": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松"},
    "07616": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小松"},
    "07617": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加賀"},
    "07618": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加賀"},
    "07675": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "七尾"},
    "07676": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "七尾"},
    "07677": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "七尾"},
    "07678": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "七尾"},
    "07672": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "羽咋"},
    "07673": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "羽咋"},
    "07674": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "羽咋"},
    "07682": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "輪島"},
    "07683": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "輪島"},
    "07684": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "輪島"},
    "07685": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "輪島"},
    "07686": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能都"},
    "07687": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能都"},
    "07688": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "能都"},
    "07702": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "敦賀"},
    "07703": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "敦賀"},
    "07704": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "敦賀"},
    "07705": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小浜"},
    "07706": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小浜"},
    "07707": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "小浜"},
    "07712": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀岡"},
    "07713": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀岡"},
    "07714": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀岡"},
    "07715": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "亀岡"},
    "07716": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "園部"},
    "07717": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "園部"},
    "07718": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "園部"},
    "07722": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮津"},
    "07723": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮津"},
    "07724": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮津"},
    "07725": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宮津"},
    "07726": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "峰山"},
    "07727": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "峰山"},
    "07728": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "峰山"},
    "07732": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福知山"},
    "07733": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福知山"},
    "07734": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福知山"},
    "07735": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福知山"},
    "07736": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "舞鶴"},
    "07737": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "舞鶴"},
    "07738": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "舞鶴"},
    "07906": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "播磨山崎"},
    "07907": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "播磨山崎"},
    "07908": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "播磨山崎"},
    "07902": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福崎"},
    "07903": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福崎"},
    "07904": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福崎"},
    "07905": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福崎"},
    "07916": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜野"},
    "07917": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竜野"},
    "07912": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "相生"},
    "07914": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "相生"},
    "07915": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "相生"},
    "07940": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07942": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07943": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07944": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07945": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07949": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "加古川"},
    "07946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三木"},
    "07947": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三木"},
    "07948": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三木"},
    "07952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西脇"},
    "07953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西脇"},
    "07954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "西脇"},
    "07950": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "三田"},
    "07955": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "三田"},
    "07956": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "三田"},
    "07959": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "三田"},
    "07957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "丹波柏原"},
    "07958": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "丹波柏原"},
    "07962": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊岡"},
    "07963": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊岡"},
    "07964": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊岡"},
    "07965": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊岡"},
    "07968": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浜坂"},
    "07969": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浜坂"},
    "07960": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "八鹿"},
    "07966": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "八鹿"},
    "07967": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "八鹿"},
    "07992": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "洲本"},
    "07993": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "洲本"},
    "07994": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "洲本"},
    "07995": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "洲本"},
    "07996": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津名"},
    "07997": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津名"},
    "07998": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津名"},
    "08290": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "08296": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "08299": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "08293": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "08295": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "08297": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "08298": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "08202": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳井"},
    "08203": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳井"},
    "08204": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳井"},
    "08205": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳井"},
    "08206": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳井"},
    "08207": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久賀"},
    "08208": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久賀"},
    "08244": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三次"},
    "08245": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三次"},
    "08246": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三次"},
    "08240": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "東広島"},
    "08242": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "東広島"},
    "08243": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "東広島"},
    "08249": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "東広島"},
    "08247": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "庄原"},
    "08248": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "庄原"},
    "08266": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千代田"},
    "08267": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千代田"},
    "08268": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "千代田"},
    "08264": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安芸吉田"},
    "08265": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安芸吉田"},
    "08262": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加計"},
    "08263": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加計"},
    "08377": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "08378": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "08372": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長門"},
    "08373": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長門"},
    "08374": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "長門"},
    "08375": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "08362": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08363": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08364": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08365": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08366": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08367": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08368": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08369": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇部"},
    "08360": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08382": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "萩"},
    "08383": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "萩"},
    "08384": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "萩"},
    "08385": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "萩"},
    "08387": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "田万川"},
    "08388": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "田万川"},
    "08390": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08391": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08392": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08393": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08394": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08395": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08397": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08398": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08399": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "08462": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竹原"},
    "08463": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竹原"},
    "08464": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竹原"},
    "08466": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木江"},
    "08467": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木江"},
    "08474": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "府中"},
    "08475": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "府中"},
    "08476": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "府中"},
    "08472": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "甲山"},
    "08473": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "甲山"},
    "08477": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "東城"},
    "08478": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東城"},
    "08479": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "東城"},
    "08490": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "08491": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08492": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08494": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08495": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08496": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08497": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08498": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08499": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "08512": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "西郷"},
    "08514": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "海士"},
    "08542": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安来"},
    "08543": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安来"},
    "08544": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木次"},
    "08545": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "木次"},
    "08546": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "掛合"},
    "08547": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "掛合"},
    "08548": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石見大田"},
    "08549": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "石見大田"},
    "08552": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浜田"},
    "08553": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浜田"},
    "08554": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浜田"},
    "08555": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "江津"},
    "08556": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "江津"},
    "08557": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川本"},
    "08558": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川本"},
    "08559": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川本"},
    "08562": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "益田"},
    "08563": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "益田"},
    "08564": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "益田"},
    "08565": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "益田"},
    "08567": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津和野"},
    "08568": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津和野"},
    "08587": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郡家"},
    "08588": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郡家"},
    "08582": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倉吉"},
    "08583": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倉吉"},
    "08584": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倉吉"},
    "08585": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倉吉"},
    "08586": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "倉吉"},
    "08592": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米子"},
    "08593": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米子"},
    "08594": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米子"},
    "08595": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米子"},
    "08596": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "米子"},
    "08597": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根雨"},
    "08598": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "根雨"},
    "08652": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "08654": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "08656": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "笠岡"},
    "08657": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "笠岡"},
    "08662": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高梁"},
    "08664": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高梁"},
    "08665": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高梁"},
    "08666": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "井原"},
    "08667": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "井原"},
    "08668": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "井原"},
    "08663": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "08660": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "08632": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08633": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08634": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08635": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08637": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08638": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "08677": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新見"},
    "08678": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新見"},
    "08679": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新見"},
    "08674": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久世"},
    "08675": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久世"},
    "08676": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "久世"},
    "08680": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "08689": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "08682": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津山"},
    "08683": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津山"},
    "08684": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津山"},
    "08685": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津山"},
    "08686": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津山"},
    "08687": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美作"},
    "08688": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美作"},
    "08690": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "08694": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "08696": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "備前"},
    "08697": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "備前"},
    "08698": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "備前"},
    "08692": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "邑久"},
    "08693": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "邑久"},
    "08792": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三本松"},
    "08793": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三本松"},
    "08794": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三本松"},
    "08795": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三本松"},
    "08796": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土庄"},
    "08797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土庄"},
    "08798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土庄"},
    "08803": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐中村"},
    "08804": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐中村"},
    "08805": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐中村"},
    "08806": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宿毛"},
    "08807": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宿毛"},
    "08802": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "08808": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "08832": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨島"},
    "08833": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨島"},
    "08834": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨島"},
    "08835": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "脇町"},
    "08836": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "脇町"},
    "08837": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿波池田"},
    "08838": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿波池田"},
    "08842": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿南"},
    "08843": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿南"},
    "08844": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "阿南"},
    "08845": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "丹生谷"},
    "08846": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "丹生谷"},
    "08847": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "牟岐"},
    "08848": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "牟岐"},
    "08877": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "嶺北"},
    "08878": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "嶺北"},
    "08872": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "室戸"},
    "08879": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "室戸"},
    "08873": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安芸"},
    "08874": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "安芸"},
    "08875": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐山田"},
    "08876": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐山田"},
    "08892": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐川"},
    "08893": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐川"},
    "08894": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須崎"},
    "08895": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須崎"},
    "08896": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "須崎"},
    "08942": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八幡浜"},
    "08943": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八幡浜"},
    "08944": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八幡浜"},
    "08945": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八幡浜"},
    "08946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和"},
    "08947": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和"},
    "08948": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和"},
    "08949": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和"},
    "08952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和島"},
    "08953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和島"},
    "08954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和島"},
    "08955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和島"},
    "08956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "宇和島"},
    "08957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "御荘"},
    "08958": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "御荘"},
    "08977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伯方"},
    "08978": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伯方"},
    "08972": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新居浜"},
    "08973": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新居浜"},
    "08974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新居浜"},
    "08975": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新居浜"},
    "08976": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "新居浜"},
    "09232": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前原"},
    "09233": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "前原"},
    "09230": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09231": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09234": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09235": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09236": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09237": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09238": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09239": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福岡"},
    "09204": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "郷ノ浦"},
    "09205": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "厳原"},
    "09208": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "対馬佐賀"},
    "09432": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八女"},
    "09433": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八女"},
    "09434": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八女"},
    "09435": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八女"},
    "09437": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田主丸"},
    "09438": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田主丸"},
    "09492": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "直方"},
    "09493": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "直方"},
    "09494": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "直方"},
    "09495": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "直方"},
    "09496": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "直方"},
    "09542": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武雄"},
    "09543": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武雄"},
    "09544": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "武雄"},
    "09546": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿島"},
    "09547": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿島"},
    "09555": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "唐津"},
    "09556": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "唐津"},
    "09557": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "唐津"},
    "09558": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "唐津"},
    "09552": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊万里"},
    "09553": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊万里"},
    "09554": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "伊万里"},
    "09572": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "諫早"},
    "09573": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "諫早"},
    "09574": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "諫早"},
    "09575": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "諫早"},
    "09576": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "島原"},
    "09577": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "島原"},
    "09578": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "島原"},
    "09592": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大瀬戸"},
    "09593": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大瀬戸"},
    "09599": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大瀬戸"},
    "09596": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福江"},
    "09597": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福江"},
    "09598": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "福江"},
    "09594": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "有川"},
    "09595": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "有川"},
    "09662": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "人吉"},
    "09663": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "人吉"},
    "09664": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "人吉"},
    "09665": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "人吉"},
    "09666": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水俣"},
    "09667": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水俣"},
    "09668": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "水俣"},
    "09672": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊本一の宮"},
    "09673": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊本一の宮"},
    "09674": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊本一の宮"},
    "09675": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊本一の宮"},
    "09677": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "矢部"},
    "09678": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "矢部"},
    "09676": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高森"},
    "09679": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高森"},
    "09682": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "山鹿"},
    "09683": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "山鹿"},
    "09684": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "山鹿"},
    "09685": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉名"},
    "09686": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉名"},
    "09687": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉名"},
    "09688": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉名"},
    "09722": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐伯"},
    "09723": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐伯"},
    "09724": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐伯"},
    "09725": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "佐伯"},
    "09726": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "臼杵"},
    "09727": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "臼杵"},
    "09728": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "臼杵"},
    "09732": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日田"},
    "09733": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日田"},
    "09734": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日田"},
    "09735": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日田"},
    "09737": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玖珠"},
    "09738": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玖珠"},
    "09742": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三重"},
    "09743": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三重"},
    "09744": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "三重"},
    "09746": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竹田"},
    "09747": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "竹田"},
    "09787": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "国東"},
    "09788": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "国東"},
    "09782": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊後高田"},
    "09783": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊後高田"},
    "09784": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊後高田"},
    "09785": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "豊後高田"},
    "09786": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "杵築"},
    "09789": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "杵築"},
    "09803": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "名護"},
    "09804": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "名護"},
    "09805": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "名護"},
    "09802": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "南大東"},
    "09806": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沖縄宮古"},
    "09807": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "沖縄宮古"},
    "09808": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八重山"},
    "09809": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八重山"},
    "09822": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "09823": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "09824": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "09825": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "09826": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "09827": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高千穂"},
    "09828": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "高千穂"},
    "09912": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "中之島"},
    "09913": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "硫黄島"},
    "09932": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "09935": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加世田"},
    "09936": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加世田"},
    "09937": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加世田"},
    "09938": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加世田"},
    "09940": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "志布志"},
    "09947": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "志布志"},
    "09948": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "志布志"},
    "09943": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿屋"},
    "09944": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿屋"},
    "09945": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿屋"},
    "09946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鹿屋"},
    "09942": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大根占"},
    "09949": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大根占"},
    "09954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加治木"},
    "09955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加治木"},
    "09956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加治木"},
    "09957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加治木"},
    "09952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大口"},
    "09953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大口"},
    "09966": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "出水"},
    "09967": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "出水"},
    "09968": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "出水"},
    "09962": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川内"},
    "09963": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川内"},
    "09964": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川内"},
    "09965": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "川内"},
    "09969": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "中甑"},
    "09975": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "名瀬"},
    "09976": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "名瀬"},
    "09978": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "徳之島"},
    "09979": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "徳之島"},
    "09972": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "種子島"},
    "09973": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "種子島"},
    "09974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "屋久島"},
    "09977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "瀬戸内"},
    "012390": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "012391": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "012392": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "012393": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "012394": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "夕張"},
    "012395": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "012396": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "012397": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "012398": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "012399": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "栗山"},
    "014630": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "014631": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "014636": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "014638": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "014639": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "浦河"},
    "014632": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "014633": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "014634": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "014635": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "014637": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "静内"},
    "024190": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024191": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024192": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024193": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024194": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024195": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024198": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024199": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "田島"},
    "024196": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳津"},
    "024197": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "柳津"},
    "025480": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "025481": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "025482": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "025483": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "025484": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "村上"},
    "025485": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "025486": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "025487": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "025488": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "025489": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "津川"},
    "026170": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026171": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026172": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026173": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026174": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026175": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026176": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026178": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026179": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大町"},
    "026177": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "長野"},
    "028798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "大田原"},
    "028790": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028791": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028792": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028793": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028794": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028795": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028796": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "028799": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "烏山"},
    "047951": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047952": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047953": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047954": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047956": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047958": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047959": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "銚子"},
    "047950": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "047955": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "047957": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "八日市場"},
    "053964": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053965": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053966": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053967": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053968": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053969": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053960": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "053961": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "053962": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "053963": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "053970": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053971": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053972": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053973": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053975": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053976": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053978": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053979": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "浜松"},
    "053974": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "053977": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "天竜"},
    "059790": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "059791": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "059797": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "059798": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "熊野"},
    "059792": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "059793": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "059794": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "059795": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "059796": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "059799": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "熊野"},
    "082921": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082922": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082923": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082924": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082925": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082926": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082927": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082928": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082929": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082920": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082941": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082942": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082943": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "広島"},
    "082940": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082944": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082945": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082946": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082947": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082948": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "082949": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "廿日市"},
    "083766": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "083767": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "083768": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "下関"},
    "083760": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083761": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083762": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083763": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083764": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083765": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083769": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "美祢"},
    "083960": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "083963": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "083966": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "山口"},
    "083962": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "083964": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "083965": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "083967": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "083968": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "083969": {"f": 5, "m": 1, "t": "固定", "l": 10, "a": "山口"},
    "084930": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084933": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084934": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084935": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084936": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084937": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084938": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084939": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "尾道"},
    "084931": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "084932": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "福山"},
    "086552": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "086553": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "086550": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086551": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086554": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086555": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086556": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086557": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086558": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086559": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "鴨方"},
    "086691": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "086697": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "086698": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "倉敷"},
    "086690": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086692": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086693": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086694": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086695": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086696": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086699": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "総社"},
    "086362": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086363": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086364": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086365": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086367": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086368": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086369": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086366": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "玉野"},
    "086722": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086723": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086724": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086726": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086728": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086720": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086721": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086725": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086727": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086729": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086737": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086738": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086730": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086731": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086732": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086733": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086734": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086735": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086736": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086739": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "加茂川"},
    "086952": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086953": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086959": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "岡山"},
    "086950": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086951": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086954": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086955": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086956": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086957": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086958": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086992": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "備前"},
    "086993": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "備前"},
    "086994": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086995": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086996": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086997": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086998": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "086999": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "赤磐"},
    "088090": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "088091": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "088092": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "088093": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "088094": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "窪川"},
    "088095": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "088096": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "088097": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "088098": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "088099": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "土佐清水"},
    "098290": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "098291": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "098292": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "098293": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "098294": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "延岡"},
    "098295": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "098296": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "098297": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "098298": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "098299": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "日向"},
    "099331": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "099330": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099332": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099333": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099334": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099335": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099336": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099337": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099338": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099339": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099343": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "099345": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "099347": {"f": 3, "m": 3, "t": "固定", "l": 10, "a": "鹿児島"},
    "099340": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099341": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099342": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099344": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099346": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099348": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
    "099349": {"f": 4, "m": 2, "t": "固定", "l": 10, "a": "指宿"},
}

CARRIER_SELECTORS: Dict[str, str] = {
    "001": "KDDI株式会社",
    "0031": "株式会社アイ・ピー・エス",
    "0032": "株式会社アイ・ピー・エス",
    "0033": "エヌ・ティ・ティ・コミュニケーションズ株式会社",
    "0034": "エヌ・ティ・ティ・コミュニケーションズ株式会社",
    "0035": "エヌ・ティ・ティ・コミュニケーションズ株式会社",
    "0036": "東日本電信電話株式会社",
    "0037": "楽天モバイル株式会社",
    "0038": "楽天モバイル株式会社",
    "0039": "西日本電信電話株式会社",
    "0041": "ソフトバンク株式会社",
    "0044": "大江戸テレコム株式会社",
    "0046": "ソフトバンク株式会社",
    "0051": "KDDI株式会社",
    "0052": "KDDI株式会社",
    "0053": "KDDI株式会社",
    "0055": "KDDI株式会社",
    "0056": "KDDI株式会社",
    "0057": "KDDI株式会社",
    "0060": "アルテリア・ネットワークス株式会社",
    "0061": "ソフトバンク株式会社",
    "0062": "ソフトバンク株式会社",
    "0063": "ソフトバンク株式会社",
    "0065": "ソフトバンク株式会社",
    "0066": "ソフトバンク株式会社",
    "0067": "株式会社りーふねっと",
    "0077": "KDDI株式会社",
    "0078": "株式会社コムスクエア",
    "0081": "楽天モバイル株式会社",
    "0082": "楽天モバイル株式会社",
    "0083": "ソフトバンク株式会社",
    "0084": "ソフトバンク株式会社",
    "0088": "ソフトバンク株式会社",
    "009120": "ブラステル株式会社",
    "009121": "ブラステル株式会社",
    "009130": "株式会社NTTドコモ",
    "009181": "株式会社関西コムネット",
    "009192": "フリービット株式会社",
}
