#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Jul 17 15:20:35 2023 by generateDS.py version 2.41.5.
# Python 3.9.5 (default, May 18 2021, 12:31:01)  [Clang 10.0.0 ]
#
# Command line options:
#   ('--root-element', 'emd')
#   ('-f', '')
#   ('-o', 'emdb-schemas/emdb_schemas/v3/v3_0_7_2/emdb.py')
#   ('--no-warnings', '')
#   ('--external-encoding', 'utf-8')
#
# Command line arguments:
#   emdb-schemas/emdb_schemas/v3/v3_0_7_2/emdb.xsd
#
# Command line:
#   /Users/amudha/project/generateDS-2.41.5/generateDS.py --root-element="emd" -f -o "emdb-schemas/emdb_schemas/v3/v3_0_7_2/emdb.py" --no-warnings --external-encoding="utf-8" emdb-schemas/emdb_schemas/v3/v3_0_7_2/emdb.xsd
#
# Current working directory (os.getcwd()):
#   IdeaProjects
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class aggregation_stateType(str, Enum):
    PARTICLE='particle'
    FILAMENT='filament'
    TWO_D_ARRAY='twoDArray'
    THREE_D_ARRAY='threeDArray'
    HELICAL_ARRAY='helicalArray'
    CELL='cell'
    TISSUE='tissue'


class allowed_film_or_detector_model(str, Enum):
    AGFASCIENTAFILM='AGFA SCIENTA FILM'
    DECTRISSINGLA_1_KX_1_K='DECTRIS SINGLA (1k x 1k)'
    DIRECTELECTRONAPOLLO_4_KX_4_K='DIRECT ELECTRON APOLLO (4k x 4k)'
    DIRECTELECTRONDE_10_5_KX_4_K='DIRECT ELECTRON DE-10 (5k x 4k)'
    DIRECTELECTRONDE_12_4_KX_3_K='DIRECT ELECTRON DE-12 (4k x 3k)'
    DIRECTELECTRONDE_16_4_KX_4_K='DIRECT ELECTRON DE-16 (4k x 4k)'
    DIRECTELECTRONDE_20_5_KX_3_K='DIRECT ELECTRON DE-20 (5k x 3k)'
    DIRECTELECTRONDE_64_8_KX_8_K='DIRECT ELECTRON DE-64 (8k x 8k)'
    FEICETA_4_KX_4_K='FEI CETA (4k x 4k)'
    FEIEAGLE_2_KX_2_K='FEI EAGLE (2k x 2k)'
    FEIEAGLE_4_KX_4_K='FEI EAGLE (4k x 4k)'
    FEIFALCONI_4_KX_4_K='FEI FALCON I (4k x 4k)'
    FEIFALCONII_4_KX_4_K='FEI FALCON II (4k x 4k)'
    FEIFALCONIII_4_KX_4_K='FEI FALCON III (4k x 4k)'
    FEIFALCONIV_4_KX_4_K='FEI FALCON IV (4k x 4k)'
    GATANK_2_4_KX_4_K='GATAN K2 (4k x 4k)'
    GATANK_2BASE_4_KX_4_K='GATAN K2 BASE (4k x 4k)'
    GATANK_2IS_4_KX_4_K='GATAN K2 IS (4k x 4k)'
    GATANK_2QUANTUM_4_KX_4_K='GATAN K2 QUANTUM (4k x 4k)'
    GATANK_2SUMMIT_4_KX_4_K='GATAN K2 SUMMIT (4k x 4k)'
    GATANK_3_6_KX_4_K='GATAN K3 (6k x 4k)'
    GATANK_3BIOQUANTUM_6_KX_4_K='GATAN K3 BIOQUANTUM (6k x 4k)'
    GATANMULTISCAN='GATAN MULTISCAN'
    GATANORIUSSC_1000_4_KX_2_7_K='GATAN ORIUS SC1000 (4k x 2.7k)'
    GATANORIUSSC_200_2_KX_2_K='GATAN ORIUS SC200 (2k x 2k)'
    GATANORIUSSC_600_2_7_KX_2_7_K='GATAN ORIUS SC600 (2.7k x 2.7k)'
    GATANULTRASCAN_1000_2_KX_2_K='GATAN ULTRASCAN 1000 (2k x 2k)'
    GATANULTRASCAN_10000_10_KX_10_K='GATAN ULTRASCAN 10000 (10k x 10k)'
    GATANULTRASCAN_4000_4_KX_4_K='GATAN ULTRASCAN 4000 (4k x 4k)'
    GENERICCCD='GENERIC CCD'
    GENERICCCD_2_KX_2_K='GENERIC CCD (2k x 2k)'
    GENERICCCD_4_KX_4_K='GENERIC CCD (4k x 4k)'
    GENERICFILM='GENERIC FILM'
    GENERICGATAN='GENERIC GATAN'
    GENERICGATAN_2_KX_2_K='GENERIC GATAN (2k x 2k)'
    GENERICGATAN_4_KX_4_K='GENERIC GATAN (4k x 4k)'
    GENERICIMAGEPLATES='GENERIC IMAGE PLATES'
    GENERICTVIPS='GENERIC TVIPS'
    GENERICTVIPS_2_KX_2_K='GENERIC TVIPS (2k x 2k)'
    GENERICTVIPS_4_KX_4_K='GENERIC TVIPS (4k x 4k)'
    KODAK_4489FILM='KODAK 4489 FILM'
    KODAKSO_163FILM='KODAK SO-163 FILM'
    OTHER='OTHER'
    PROSCANTEMPIV_2_KX_2_K='PROSCAN TEM-PIV (2k x 2k)'
    SIA_15_C_3_KX_3_K='SIA 15C (3k x 3k)'
    TFSFALCON_4_I_4_KX_4_K='TFS FALCON 4i (4k x 4k)'
    TVIPSTEMCAMF_216_2_KX_2_K='TVIPS TEMCAM-F216 (2k x 2k)'
    TVIPSTEMCAMF_224_2_KX_2_K='TVIPS TEMCAM-F224 (2k x 2k)'
    TVIPSTEMCAMF_415_4_KX_4_K='TVIPS TEMCAM-F415 (4k x 4k)'
    TVIPSTEMCAMF_416_4_KX_4_K='TVIPS TEMCAM-F416 (4k x 4k)'
    TVIPSTEMCAMF_816_8_KX_8_K='TVIPS TEMCAM-F816 (8k x 8k)'


class atmosphereType(str, Enum):
    AIR='AIR'
    AMYLAMINE='AMYLAMINE'
    NITROGEN='NITROGEN'
    OTHER='OTHER'


class author_enums(str, Enum):
    ACCELERATED_TECHNOLOGIES_CENTERFOR_GENETO_3_D_STRUCTUREATCG_3_D='Accelerated Technologies Center for Gene to 3D Structure (ATCG3D)'
    ASSEMBLY_DYNAMICSAND_EVOLUTIONOF_CELL_CELLAND_CELL_MATRIX_ADHESIONSCELLMAT='Assembly, Dynamics and Evolution of Cell-Cell and Cell-Matrix Adhesions (CELLMAT)'
    ATOMSTO_ANIMALS_THE_IMMUNE_FUNCTION_NETWORKIFN='Atoms-to-Animals: The Immune Function Network (IFN)'
    BACTERIALTARGETSATIGSCNRS_FRANCEBIGS='Bacterial targets at IGS-CNRS, France (BIGS)'
    BERKELEY_STRUCTURAL_GENOMICS_CENTERBSGC='Berkeley Structural Genomics Center (BSGC)'
    CENTERFOR_EUKARYOTIC_STRUCTURAL_GENOMICSCESG='Center for Eukaryotic Structural Genomics (CESG)'
    CENTERFOR_HIGH_THROUGHPUT_STRUCTURAL_BIOLOGYCHTSB='Center for High-Throughput Structural Biology (CHTSB)'
    CENTERFOR_MEMBRANE_PROTEINSOF_INFECTIOUS_DISEASESMPID='Center for Membrane Proteins of Infectious Diseases (MPID)'
    CENTERFOR_STRUCTURAL_BIOLOGYOF_INFECTIOUS_DISEASESCSBID='Center for Structural Biology of Infectious Diseases (CSBID)'
    CENTERFOR_STRUCTURAL_GENOMICSOF_INFECTIOUS_DISEASESCSGID='Center for Structural Genomics of Infectious Diseases (CSGID)'
    CENTERFOR_STRUCTURESOF_MEMBRANE_PROTEINSCSMP='Center for Structures of Membrane Proteins (CSMP)'
    CENTERFORTHEXRAY_STRUCTURE_DETERMINATIONOF_HUMAN_TRANSPORTERS_TRANSPORT_PDB='Center for the X-ray Structure Determination of Human Transporters (TransportPDB)'
    CHAPERONE_ENABLED_STUDIESOF_EPIGENETIC_REGULATION_ENZYMESCEBS='Chaperone-Enabled Studies of Epigenetic Regulation Enzymes (CEBS)'
    ENZYME_DISCOVERYFOR_NATURAL_PRODUCT_BIOSYNTHESIS_NAT_PRO='Enzyme Discovery for Natural Product Biosynthesis (NatPro)'
    GPCR_NETWORKGPCR='GPCR Network (GPCR)'
    INTEGRATED_CENTERFOR_STRUCTUREAND_FUNCTION_INNOVATIONISFI='Integrated Center for Structure and Function Innovation (ISFI)'
    ISRAEL_STRUCTURAL_PROTEOMICS_CENTERISPC='Israel Structural Proteomics Center (ISPC)'
    JOINT_CENTERFOR_STRUCTURAL_GENOMICSJCSG='Joint Center for Structural Genomics (JCSG)'
    MARSEILLES_STRUCTURAL_GENOMICS_PROGRAMAFMBMSGP='Marseilles Structural Genomics Program @ AFMB (MSGP)'
    MEDICAL_STRUCTURAL_GENOMICSOF_PATHOGENIC_PROTOZOAMSGPP='Medical Structural Genomics of Pathogenic Protozoa (MSGPP)'
    MEMBRANE_PROTEIN_STRUCTURAL_BIOLOGY_CONSORTIUMMPSBC='Membrane Protein Structural Biology Consortium (MPSBC)'
    MEMBRANE_PROTEIN_STRUCTURESBY_SOLUTIONNMRMP_SBY_NMR='Membrane Protein Structures by Solution NMR (MPSbyNMR)'
    MIDWEST_CENTERFOR_MACROMOLECULAR_RESEARCHMCMR='Midwest Center for Macromolecular Research (MCMR)'
    MIDWEST_CENTERFOR_STRUCTURAL_GENOMICSMCSG='Midwest Center for Structural Genomics (MCSG)'
    MITOCHONDRIAL_PROTEIN_PARTNERSHIPMPP='Mitochondrial Protein Partnership (MPP)'
    MONTREAL_KINGSTON_BACTERIAL_STRUCTURAL_GENOMICS_INITIATIVEBSGI='Montreal-Kingston Bacterial Structural Genomics Initiative (BSGI)'
    MYCOBACTERIUM_TUBERCULOSIS_STRUCTURAL_PROTEOMICS_PROJECTXMTB='Mycobacterium Tuberculosis Structural Proteomics Project (XMTB)'
    NEW_YORK_CONSORTIUMON_MEMBRANE_PROTEIN_STRUCTURENYCOMPS='New York Consortium on Membrane Protein Structure (NYCOMPS)'
    NEW_YORKSGX_RESEARCH_CENTERFOR_STRUCTURAL_GENOMICSNYSGXRC='New York SGX Research Center for Structural Genomics (NYSGXRC)'
    NEW_YORK_STRUCTURAL_GENOMI_X_RESEARCH_CONSORTIUMNYSGXRC='New York Structural GenomiX Research Consortium (NYSGXRC)'
    NEW_YORK_STRUCTURAL_GENOMICS_RESEARCH_CONSORTIUMNYSGRC='New York Structural Genomics Research Consortium (NYSGRC)'
    NORTHEAST_STRUCTURAL_GENOMICS_CONSORTIUMNESG='Northeast Structural Genomics Consortium (NESG)'
    NUCLEOCYTOPLASMIC_TRANSPORTA_TARGETFOR_CELLULAR_CONTROLNPC_XSTALS='Nucleocytoplasmic Transport: a Target for Cellular Control (NPCXstals)'
    ONTARIO_CENTREFOR_STRUCTURAL_PROTEOMICSOCSP='Ontario Centre for Structural Proteomics (OCSP)'
    OXFORD_PROTEIN_PRODUCTION_FACILITYOPPF='Oxford Protein Production Facility (OPPF)'
    PARIS_SUD_YEAST_STRUCTURAL_GENOMICSYSG='Paris-Sud Yeast Structural Genomics (YSG)'
    PARTNERSHIPFOR_NUCLEAR_RECEPTOR_SIGNALING_CODE_BIOLOGYNH_RS='Partnership for Nuclear Receptor Signaling Code Biology (NHRs)'
    PARTNERSHIPFOR_STEM_CELL_BIOLOGYSTEMCELL='Partnership for Stem Cell Biology (STEMCELL)'
    PARTNERSHIPFORT_CELL_BIOLOGYTCELL='Partnership for T-Cell Biology (TCELL)'
    PROGRAMFORTHE_CHARACTERIZATIONOF_SECRETED_EFFECTOR_PROTEINSPCSEP='Program for the Characterization of Secreted Effector Proteins (PCSEP)'
    PROTEIN_STRUCTURE_FACTORYPSF='Protein Structure Factory (PSF)'
    QCRG_STRUCTURAL_BIOLOGY_CONSORTIUM='QCRG Structural Biology Consortium'
    RIKEN_STRUCTURAL_GENOMICS_PROTEOMICS_INITIATIVERSGI='RIKEN Structural Genomics/Proteomics Initiative (RSGI)'
    SCOTTISH_STRUCTURAL_PROTEOMICS_FACILITYSSPF='Scottish Structural Proteomics Facility (SSPF)'
    SEATTLE_STRUCTURAL_GENOMICS_CENTERFOR_INFECTIOUS_DISEASESSGCID='Seattle Structural Genomics Center for Infectious Disease (SSGCID)'
    SOUTH_AFRICA_STRUCTURAL_TARGETS_ANNOTATION_DATABASESASTAD='South Africa Structural Targets Annotation Database (SASTAD)'
    SOUTHEAST_COLLABORATORYFOR_STRUCTURAL_GENOMICSSECSG='Southeast Collaboratory for Structural Genomics (SECSG)'
    STRUCTURAL_GENOMICS_CONSORTIUMSGC='Structural Genomics Consortium (SGC)'
    STRUCTURAL_GENOMICS_CONSORTIUMFOR_RESEARCHON_GENE_EXPRESSIONSGCGES='Structural Genomics Consortium for Research on Gene Expression (SGCGES)'
    STRUCTURAL_GENOMICSOF_PATHOGENIC_PROTOZOA_CONSORTIUMSGPP='Structural Genomics of Pathogenic Protozoa Consortium (SGPP)'
    STRUCTURAL_PROTEOMICSIN_EUROPESPINE='Structural Proteomics in Europe (SPINE)'
    STRUCTURAL_PROTEOMICSIN_EUROPE_2SPINE_2='Structural Proteomics in Europe 2 (SPINE-2)'
    STRUCTURE_2_FUNCTION_PROJECTS_2_F='Structure 2 Function Project (S2F)'
    STRUCTURE_DYNAMICSAND_ACTIVATION_MECHANISMSOF_CHEMOKINE_RECEPTORSCHSAM='Structure, Dynamics and Activation Mechanisms of Chemokine Receptors (CHSAM)'
    STRUCTURE_FUNCTION_ANALYSISOF_POLYMORPHICCDI_TOXIN_IMMUNITY_PROTEIN_COMPLEXESUC_4_CDI='Structure-Function Analysis of Polymorphic CDI Toxin-Immunity Protein Complexes (UC4CDI)'
    STRUCTURE_FUNCTION_STUDIESOF_TIGHT_JUNCTION_MEMBRANE_PROTEINSTJMP='Structure-Function Studies of Tight Junction Membrane Proteins (TJMP)'
    STRUCTURESOF_MTB_PROTEINS_CONFERRING_SUSCEPTIBILITYTO_KNOWN_MTB_INHIBITORSMTBI='Structures of Mtb Proteins Conferring Susceptibility to Known Mtb Inhibitors (MTBI)'
    TB_STRUCTURAL_GENOMICS_CONSORTIUMTBSGC='TB Structural Genomics Consortium (TBSGC)'
    TRANSCONTINENTALEM_INITIATIVEFOR_MEMBRANE_PROTEIN_STRUCTURETEMIMPS='Transcontinental EM Initiative for Membrane Protein Structure (TEMIMPS)'
    TRANSMEMBRANE_PROTEIN_CENTERTMPC='Transmembrane Protein Center (TMPC)'


class categoryType43(str, Enum):
    CCD='CCD'
    CMOS='CMOS'
    DIRECTELECTRONDETECTOR='DIRECT ELECTRON DETECTOR'
    STORAGEPHOSPORIMAGEPLATES='STORAGE PHOSPOR (IMAGE PLATES)'
    FILM='FILM'


class classificationType(str, Enum):
    DNA='DNA'


class classificationType32(str, Enum):
    MESSENGER='MESSENGER'
    TRANSFER='TRANSFER'
    RIBOSOMAL='RIBOSOMAL'
    NONCODING='NON-CODING'
    INTERFERENCE='INTERFERENCE'
    SMALLINTERFERENCE='SMALL INTERFERENCE'
    GENOMIC='GENOMIC'
    PREMESSENGER='PRE-MESSENGER'
    SMALLNUCLEOLAR='SMALL NUCLEOLAR'
    TRANSFERMESSENGER='TRANSFER-MESSENGER'
    OTHER='OTHER'


class cooling_holder_cryogenType(str, Enum):
    HELIUM='HELIUM'
    NITROGEN='NITROGEN'


class correction_operationType(str, Enum):
    MULTIPLICATION='MULTIPLICATION'
    DIVISION='DIVISION'


class correction_space_type(str, Enum):
    REAL='REAL'
    RECIPROCAL='RECIPROCAL'


class countryType(str, Enum):
    UK='UK'
    USA='USA'
    JAPAN='Japan'


class cryogen_nameType(str, Enum):
    ETHANE='ETHANE'
    ETHANEPROPANE='ETHANE-PROPANE'
    FREON_12='FREON 12'
    FREON_22='FREON 22'
    HELIUM='HELIUM'
    METHANE='METHANE'
    NITROGEN='NITROGEN'
    OTHER='OTHER'
    PROPANE='PROPANE'


class databaseType(str, Enum):
    NCBI='NCBI'


class databaseType12(str, Enum):
    NCBI='NCBI'


class depositionType(str, Enum):
    PD_BE='PDBe'
    PD_BJ='PDBj'
    RCSB='RCSB'
    PD_BC='PDBc'


class detector_modeType(str, Enum):
    COUNTING='COUNTING'
    INTEGRATING='INTEGRATING'
    OTHER='OTHER'
    SUPERRESOLUTION='SUPER-RESOLUTION'


class electron_sourceType(str, Enum):
    TUNGSTENHAIRPIN='TUNGSTEN HAIRPIN'
    LAB_6='LAB6'
    OTHER='OTHER'
    FIELDEMISSIONGUN='FIELD EMISSION GUN'


class enantiomerType(str, Enum):
    LEVO='LEVO'
    DEXTRO='DEXTRO'


class enantiomerType34(str, Enum):
    LEVO='LEVO'
    DEXTRO='DEXTRO'


class film_materialType(str, Enum):
    CARBON='CARBON'
    CELLULOSEACETATE='CELLULOSE ACETATE'
    FORMVAR='FORMVAR'
    GOLD='GOLD'
    GRAPHENE='GRAPHENE'
    GRAPHENEOXIDE='GRAPHENE OXIDE'
    PARLODION='PARLODION'


class film_topologyType(str, Enum):
    CONTINUOUS='CONTINUOUS'
    HOLEY='HOLEY'
    HOLEYARRAY='HOLEY ARRAY'
    LACEY='LACEY'


class geometrical_shapeType(str, Enum):
    SPHERE='SPHERE'
    SOFTSPHERE='SOFT SPHERE'
    GAUSSIAN='GAUSSIAN'
    CIRCLE='CIRCLE'
    RECTANGLE='RECTANGLE'
    CYLINDER='CYLINDER'
    OTHER='OTHER'


class illumination_modeType(str, Enum):
    FLOODBEAM='FLOOD BEAM'
    SPOTSCAN='SPOT SCAN'
    OTHER='OTHER'


class imaging_modeType(str, Enum):
    BRIGHTFIELD='BRIGHT FIELD'
    DARKFIELD='DARK FIELD'
    DIFFRACTION='DIFFRACTION'
    OTHER='OTHER'


class in_frameType(str, Enum):
    NOOVERLAP='NOOVERLAP'
    PARTIALOVERLAP='PARTIALOVERLAP'
    FULLOVERLAP='FULLOVERLAP'


class in_frameType7(str, Enum):
    NOOVERLAP='NOOVERLAP'
    PARTIALOVERLAP='PARTIALOVERLAP'
    FULLOVERLAP='FULLOVERLAP'


class initial_model_typeType(str, Enum):
    EXPERIMENTALMODEL='experimental model'
    INSILICOMODEL='in silico model'
    INTEGRATIVEMODEL='integrative model'
    OTHER='other'


class instrumentType(str, Enum):
    EMS_002RAPIDIMMERSIONFREEZER='EMS-002 RAPID IMMERSION FREEZER'
    FEIVITROBOTMARKI='FEI VITROBOT MARK I'
    FEIVITROBOTMARKII='FEI VITROBOT MARK II'
    FEIVITROBOTMARKIII='FEI VITROBOT MARK III'
    FEIVITROBOTMARKIV='FEI VITROBOT MARK IV'
    GATANCRYOPLUNGE_3='GATAN CRYOPLUNGE 3'
    HOMEMADEPLUNGER='HOMEMADE PLUNGER'
    LEICAEMCPC='LEICA EM CPC'
    LEICAEMGP='LEICA EM GP'
    LEICAKF_80='LEICA KF80'
    LEICAPLUNGER='LEICA PLUNGER'
    REICHERTJUNGPLUNGER='REICHERT-JUNG PLUNGER'
    SPOTITON='SPOTITON'
    OTHER='OTHER'


class instrumentType41(str, Enum):
    BALTECHPM_010='BAL-TEC HPM 010'
    EMS_002RAPIDIMMERSIONFREEZER='EMS-002 RAPID IMMERSION FREEZER'
    LEICAEMHPM_100='LEICA EM HPM100'
    LEICAEMPACT='LEICA EM PACT'
    LEICAEMPACT_2='LEICA EM PACT2'
    OTHER='OTHER'


class instrumentType42(str, Enum):
    DB_235='DB235'
    OTHER='OTHER'


class ionType(str, Enum):
    GALLIUM='GALLIUM+'
    OTHER='OTHER'


class last_processingType(str, Enum):
    PD_BE='PDBe'
    PD_BJ='PDBj'
    RCSB='RCSB'
    PD_BC='PDBc'


class map_data_type(str, Enum):
    IMAGESTOREDASSIGNEDBYTE='IMAGE STORED AS SIGNED BYTE'
    IMAGESTOREDASSIGNEDINTEGER_2BYTES='IMAGE STORED AS SIGNED INTEGER (2 BYTES)'
    IMAGESTOREDASFLOATINGPOINTNUMBER_4BYTES='IMAGE STORED AS FLOATING POINT NUMBER (4 BYTES)'


class materialType(str, Enum):
    COPPER='COPPER'
    COPPERPALLADIUM='COPPER/PALLADIUM'
    COPPERRHODIUM='COPPER/RHODIUM'
    GOLD='GOLD'
    GRAPHENEOXIDE='GRAPHENE OXIDE'
    MOLYBDENUM='MOLYBDENUM'
    NICKEL='NICKEL'
    NICKELTITANIUM='NICKEL/TITANIUM'
    PLATINUM='PLATINUM'
    SILICONNITRIDE='SILICON NITRIDE'
    TITANIUM='TITANIUM'
    TUNGSTEN='TUNGSTEN'


class methodType(str, Enum):
    SINGLE_PARTICLE='singleParticle'
    SUBTOMOGRAM_AVERAGING='subtomogramAveraging'
    TOMOGRAPHY='tomography'
    ELECTRON_CRYSTALLOGRAPHY='electronCrystallography'
    HELICAL='helical'


class microscopeType(str, Enum):
    FEIMORGAGNI='FEI MORGAGNI'
    FEIPOLARA_300='FEI POLARA 300'
    FEITALOSARCTICA='FEI TALOS ARCTICA'
    FEITECNAI_10='FEI TECNAI 10'
    FEITECNAI_12='FEI TECNAI 12'
    FEITECNAI_20='FEI TECNAI 20'
    FEITECNAIARCTICA='FEI TECNAI ARCTICA'
    FEITECNAIF_20='FEI TECNAI F20'
    FEITECNAIF_30='FEI TECNAI F30'
    FEITECNAISPHERA='FEI TECNAI SPHERA'
    FEITECNAISPIRIT='FEI TECNAI SPIRIT'
    FEITITAN='FEI TITAN'
    FEITITANKRIOS='FEI TITAN KRIOS'
    FEIPHILIPSCM_10='FEI/PHILIPS CM10'
    FEIPHILIPSCM_12='FEI/PHILIPS CM12'
    FEIPHILIPSCM_120_T='FEI/PHILIPS CM120T'
    FEIPHILIPSCM_200_FEG='FEI/PHILIPS CM200FEG'
    FEIPHILIPSCM_200_FEGSOPHIE='FEI/PHILIPS CM200FEG/SOPHIE'
    FEIPHILIPSCM_200_FEGST='FEI/PHILIPS CM200FEG/ST'
    FEIPHILIPSCM_200_FEGUT='FEI/PHILIPS CM200FEG/UT'
    FEIPHILIPSCM_200_T='FEI/PHILIPS CM200T'
    FEIPHILIPSCM_300_FEGHE='FEI/PHILIPS CM300FEG/HE'
    FEIPHILIPSCM_300_FEGST='FEI/PHILIPS CM300FEG/ST'
    FEIPHILIPSCM_300_FEGT='FEI/PHILIPS CM300FEG/T'
    FEIPHILIPSEM_400='FEI/PHILIPS EM400'
    FEIPHILIPSEM_420='FEI/PHILIPS EM420'
    HITACHIEF_2000='HITACHI EF2000'
    HITACHIH_9500_SD='HITACHI H-9500SD'
    HITACHIH_3000UHVEM='HITACHI H3000 UHVEM'
    HITACHIH_7600='HITACHI H7600'
    HITACHIHF_2000='HITACHI HF2000'
    HITACHIHF_3000='HITACHI HF3000'
    JEOL_100_CX='JEOL 100CX'
    JEOL_1000_EES='JEOL 1000EES'
    JEOL_1010='JEOL 1010'
    JEOL_1200='JEOL 1200'
    JEOL_1200_EX='JEOL 1200EX'
    JEOL_1200_EXII='JEOL 1200EXII'
    JEOL_1230='JEOL 1230'
    JEOL_1400='JEOL 1400'
    JEOL_1400HRYPSFEG='JEOL 1400/HR + YPS FEG'
    JEOL_2000_EX='JEOL 2000EX'
    JEOL_2000_EXII='JEOL 2000EXII'
    JEOL_2010='JEOL 2010'
    JEOL_2010_F='JEOL 2010F'
    JEOL_2010_HC='JEOL 2010HC'
    JEOL_2010_HT='JEOL 2010HT'
    JEOL_2010_UHR='JEOL 2010UHR'
    JEOL_2011='JEOL 2011'
    JEOL_2100='JEOL 2100'
    JEOL_2100_F='JEOL 2100F'
    JEOL_2200_FS='JEOL 2200FS'
    JEOL_2200_FSC='JEOL 2200FSC'
    JEOL_3000_SFF='JEOL 3000SFF'
    JEOL_3100_FEF='JEOL 3100FEF'
    JEOL_3100_FFC='JEOL 3100FFC'
    JEOL_3200_FS='JEOL 3200FS'
    JEOL_3200_FSC='JEOL 3200FSC'
    JEOL_4000='JEOL 4000'
    JEOL_4000_EX='JEOL 4000EX'
    JEOLCRYOARM_200='JEOL CRYO ARM 200'
    JEOLCRYOARM_300='JEOL CRYO ARM 300'
    JEOLKYOTO_3000_SFF='JEOL KYOTO-3000SFF'
    TFSGLACIOS='TFS GLACIOS'
    TFSKRIOS='TFS KRIOS'
    TFSTALOS='TFS TALOS'
    TFSTALOSL_120_C='TFS TALOS L120C'
    TFSTALOSF_200_C='TFS TALOS F200C'
    TFSTUNDRA='TFS TUNDRA'
    ZEISSLEO_912='ZEISS LEO912'
    ZEISSLIBRA_120_PLUS='ZEISS LIBRA120PLUS'


class nameType(str, Enum):
    MICRO_CENTER__1='MICRO_CENTER_1'
    MICRO_CENTER__2='MICRO_CENTER_2'
    MICRO_CENTER__3='MICRO_CENTER_3'


class phase_plateType(str, Enum):
    ZERNIKEPHASEPLATE='ZERNIKE PHASE PLATE'
    VOLTAPHASEPLATE='VOLTA PHASE PLATE'
    OTHER='OTHER'


class plane_groupType(str, Enum):
    C_1_2='C 1 2'
    C_2_2_2='C 2 2 2'
    P_1='P 1'
    P_1_2='P 1 2'
    P_1_21='P 1 21'
    P_2='P 2'
    P_2_2_2='P 2 2 2'
    P_2_2_21='P 2 2 21'
    P_2_21_21='P 2 21 21'
    P_3='P 3'
    P_3_1_2='P 3 1 2'
    P_3_2_1='P 3 2 1'
    P_4='P 4'
    P_4_2_2='P 4 2 2'
    P_4_21_2='P 4 21 2'
    P_6='P 6'
    P_6_2_2='P 6 2 2'


class processing_siteType(str, Enum):
    PD_BE='PDBe'
    RCSB='RCSB'
    PD_BJ='PDBj'
    PD_BC='PDBc'


class reconstruction_algorithm_type(str, Enum):
    ALGEBRAICARTS='ALGEBRAIC (ARTS)'
    BACKPROJECTION='BACK PROJECTION'
    EXACTBACKPROJECTION='EXACT BACK PROJECTION'
    FOURIERSPACE='FOURIER SPACE'
    SIMULTANEOUSITERATIVESIRT='SIMULTANEOUS ITERATIVE (SIRT)'


class refinement_protocolType(str, Enum):
    ABINITIOMODEL='AB INITIO MODEL'
    BACKBONETRACE='BACKBONE TRACE'
    FLEXIBLEFIT='FLEXIBLE FIT'
    OTHER='OTHER'
    RIGIDBODYFIT='RIGID BODY FIT'


class res_typeType(str, Enum):
    BYAUTHOR='BY AUTHOR'


class resolution_methodType(str, Enum):
    DIFFRACTIONPATTERNLAYERLINES='DIFFRACTION PATTERN/LAYERLINES'
    FSC_0_143CUTOFF='FSC 0.143 CUT-OFF'
    FSC_0_33CUTOFF='FSC 0.33 CUT-OFF'
    FSC_0_5CUTOFF='FSC 0.5 CUT-OFF'
    FSC_1_2BITCUTOFF='FSC 1/2 BIT CUT-OFF'
    FSC_3SIGMACUTOFF='FSC 3 SIGMA CUT-OFF'
    OTHER='OTHER'


class roleType(str, Enum):
    INVESTIGATOR='INVESTIGATOR'
    PRINCIPALINVESTIGATORGROUPLEADER='PRINCIPAL INVESTIGATOR/GROUP LEADER'
    RESPONSIBLESCIENTIST='RESPONSIBLE SCIENTIST'


class scannerType(str, Enum):
    EIKONIXIEEE_488='EIKONIX IEEE 488'
    EMIL_10='EMIL 10'
    IMACON='IMACON'
    NIKONCOOLSCAN='NIKON COOLSCAN'
    NIKONSUPERCOOLSCAN_9000='NIKON SUPER COOLSCAN 9000'
    OPTRONICS='OPTRONICS'
    OTHER='OTHER'
    PATCHWORKDENSITOMETER='PATCHWORK DENSITOMETER'
    PERKINELMER='PERKIN ELMER'
    PRIMESCAN='PRIMESCAN'
    TEMSCAN='TEMSCAN'
    ZEISSSCAI='ZEISS SCAI'


class sourceType(str, Enum):
    EMDB='EMDB'
    AUTHOR='AUTHOR'
    SOFTWARE='SOFTWARE'
    ANNOTATOR='ANNOTATOR'


class source_nameType(str, Enum):
    PDB='PDB'
    ALPHA_FOLD='AlphaFold'
    I_TASSER='ITasser'
    MODEL_ARCHIVE='ModelArchive'
    MODELLER='Modeller'
    ROSE_TTA_FOLD='RoseTTAFold'
    SWISS_MODEL='SwissModel'
    OTHER='Other'


class specimen_holder_modelType(str, Enum):
    FISCHIONE_2550='FISCHIONE 2550'
    FISCHIONEINSTRUMENTSDUALAXISTOMOGRAPHYHOLDER='FISCHIONE INSTRUMENTS DUAL AXIS TOMOGRAPHY HOLDER'
    FEITITANKRIOSAUTOGRIDHOLDER='FEI TITAN KRIOS AUTOGRID HOLDER'
    GATAN_626SINGLETILTLIQUIDNITROGENCRYOTRANSFERHOLDER='GATAN 626 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER'
    GATAN_910MULTISPECIMENSINGLETILTCRYOTRANSFERHOLDER='GATAN 910 MULTI-SPECIMEN SINGLE TILT CRYO TRANSFER HOLDER'
    GATAN_914HIGHTILTLIQUIDNITROGENCRYOTRANSFERTOMOGRAPHYHOLDER='GATAN 914 HIGH TILT LIQUID NITROGEN CRYO TRANSFER TOMOGRAPHY HOLDER'
    GATAN_915DOUBLETILTLIQUIDNITROGENCRYOTRANSFERHOLDER='GATAN 915 DOUBLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER'
    GATANCHDT_3504DOUBLETILTHIGHRESOLUTIONNITROGENCOOLINGHOLDER='GATAN CHDT 3504 DOUBLE TILT HIGH RESOLUTION NITROGEN COOLING HOLDER'
    GATANCT_3500SINGLETILTLIQUIDNITROGENCRYOTRANSFERHOLDER='GATAN CT3500 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER'
    GATANCT_3500_TRSINGLETILTROTATIONLIQUIDNITROGENCRYOTRANSFERHOLDER='GATAN CT3500TR SINGLE TILT ROTATION LIQUID NITROGEN CRYO TRANSFER HOLDER'
    GATANELSA_698SINGLETILTLIQUIDNITROGENCRYOTRANSFERHOLDER='GATAN ELSA 698 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER'
    GATANHC_3500SINGLETILTHEATINGNITROGENCOOLINGHOLDER='GATAN HC 3500 SINGLE TILT HEATING/NITROGEN COOLING HOLDER'
    GATANHCHDT_3010DOUBLETILTHIGHRESOLUTIONHELIUMCOOLINGHOLDER='GATAN HCHDT 3010 DOUBLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER'
    GATANHCHST_3008SINGLETILTHIGHRESOLUTIONHELIUMCOOLINGHOLDER='GATAN HCHST 3008 SINGLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER'
    GATANHELIUM='GATAN HELIUM'
    GATANLIQUIDNITROGEN='GATAN LIQUID NITROGEN'
    GATANUHRST_3500SINGLETILTULTRAHIGHRESOLUTIONNITROGENCOOLINGHOLDER='GATAN UHRST 3500 SINGLE TILT ULTRA HIGH RESOLUTION NITROGEN COOLING HOLDER'
    GATANULTDTULTRALOWTEMPERATUREDOUBLETILTHELIUMCOOLINGHOLDER='GATAN ULTDT ULTRA LOW TEMPERATURE DOUBLE TILT HELIUM COOLING HOLDER'
    GATANULTSTULTRALOWTEMPERATURESINGLETILTHELIUMCOOLINGHOLDER='GATAN ULTST ULTRA LOW TEMPERATURE SINGLE TILT HELIUM COOLING HOLDER'
    HOMEBUILD='HOME BUILD'
    JEOL='JEOL'
    JEOL_3200_FSCCRYOHOLDER='JEOL 3200FSC CRYOHOLDER'
    OTHER='OTHER'
    PHILIPSROTATIONHOLDER='PHILIPS ROTATION HOLDER'
    SIDEENTRYEUCENTRIC='SIDE ENTRY, EUCENTRIC'
    JEOLCRYOSPECPORTER='JEOL CRYOSPECPORTER'


class status_code_type(str, Enum):
    AUCO='AUCO'
    AUTH='AUTH'
    AUXS='AUXS'
    AUXU='AUXU'
    HOLD='HOLD'
    HOLD_8_W='HOLD8W'
    HPUB='HPUB'
    OBS='OBS'
    POLC='POLC'
    PROC='PROC'
    REFI='REFI'
    REL='REL'
    REPL='REPL'
    REUP='REUP'
    WAIT='WAIT'
    WDRN='WDRN'


class titleType(str, Enum):
    DR='DR.'
    MR='MR.'
    MRS='MRS.'
    MS='MS.'
    PROF='PROF.'


class typeType(str, Enum):
    ACADEMIC='ACADEMIC'
    COMMERCIAL='COMMERCIAL'
    GOVERMENT='GOVERMENT'
    OTHER='OTHER'


class typeType11(str, Enum):
    UNIPROTKB='UNIPROTKB'
    UNIPARC='UNIPARC'
    INTERPRO='INTERPRO'
    GO='GO'


class typeType15(str, Enum):
    REFSEQ='REFSEQ'
    GENBANK='GENBANK'


class typeType17(str, Enum):
    CAS='CAS'
    PUBCHEM='PUBCHEM'
    DRUGBANK='DRUGBANK'
    CHEBI='CHEBI'
    CHEMBL='CHEMBL'


class typeType2(str, Enum):
    PUBMED='PUBMED'
    DOI='DOI'
    ISBN='ISBN'
    ISSN='ISSN'
    CAS='CAS'
    CSD='CSD'
    MEDLINE='MEDLINE'
    ASTM='ASTM'


class typeType26(str, Enum):
    UNIPROTKB='UNIPROTKB'
    UNIPARC='UNIPARC'
    INTERPRO='INTERPRO'
    GO='GO'
    GENBANK='GENBANK'


class typeType31(str, Enum):
    REFSEQ='REFSEQ'
    GENBANK='GENBANK'
    UNIPROTKB='UNIPROTKB'


class typeType36(str, Enum):
    CARDBANK='CARDBANK'


class typeType38(str, Enum):
    NEGATIVE='NEGATIVE'
    NONE='NONE'
    POSITIVE='POSITIVE'


class typeType5(str, Enum):
    PUBMED='PUBMED'
    DOI='DOI'
    ISBN='ISBN'
    ISSN='ISSN'
    CAS='CAS'
    CSD='CSD'
    MEDLINE='MEDLINE'
    ASTM='ASTM'


class typeType56(str, Enum):
    ANGULARRECONSTITUTION='ANGULAR RECONSTITUTION'
    COMMONLINE='COMMON LINE'
    NOTAPPLICABLE='NOT APPLICABLE'
    OTHER='OTHER'
    PROJECTIONMATCHING='PROJECTION MATCHING'
    RANDOMASSIGNMENT='RANDOM ASSIGNMENT'
    MAXIMUMLIKELIHOOD='MAXIMUM LIKELIHOOD'


class typeType8(str, Enum):
    _2_DEMDATA='2D EM DATA'
    CORRELATIVELIGHTMICROSCOPY='CORRELATIVE LIGHT MICROSCOPY'


class typeType9(str, Enum):
    GO='GO'
    ARBITRARYDEFINITION='ARBITRARY DEFINITION'
    PROTEINONTOLOGY='PROTEIN ONTOLOGY'


class unitsType(str, Enum):
    M_DA='MDa'
    K_DANM='kDa/nm'


class unitsType13(str, Enum):
    M_DA='MDa'
    K_DANM='kDa/nm'


class unitsType37(str, Enum):
    MGM_L='mg/mL'
    M_M='mM'


class unitsType40(str, Enum):
    MINUTE='MINUTE'
    HOUR='HOUR'
    DAY='DAY'


class unitsType47(str, Enum):
    PIXEL='PIXEL'
    Å='Å'


class unitsType49(str, Enum):
    PIXEL='PIXEL'
    Å='Å'


class unitsType51(str, Enum):
    PIXEL='PIXEL'
    Å='Å'


class unitsType52(str, Enum):
    PIXEL='PIXEL'
    Å='Å'


class virus_isolateType(str, Enum):
    OTHER='OTHER'
    SEROCOMPLEX='SEROCOMPLEX'
    SEROTYPE='SEROTYPE'
    SPECIES='SPECIES'
    STRAIN='STRAIN'
    SUBSPECIES='SUBSPECIES'


class virus_typeType(str, Enum):
    PRION='PRION'
    SATELLITE='SATELLITE'
    VIRION='VIRION'
    VIROID='VIROID'
    VIRUSLIKEPARTICLE='VIRUS-LIKE PARTICLE'


class entry_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, emdb_id=None, version='3.0.7.2', admin=None, crossreferences=None, sample=None, structure_determination_list=None, map=None, interpretation=None, validation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.emdb_id = _cast(None, emdb_id)
        self.emdb_id_nsprefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        self.admin = admin
        self.admin_nsprefix_ = None
        self.crossreferences = crossreferences
        self.crossreferences_nsprefix_ = None
        self.sample = sample
        self.sample_nsprefix_ = None
        self.structure_determination_list = structure_determination_list
        self.structure_determination_list_nsprefix_ = None
        self.map = map
        self.map_nsprefix_ = None
        self.interpretation = interpretation
        self.interpretation_nsprefix_ = None
        self.validation = validation
        self.validation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, entry_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if entry_type.subclass:
            return entry_type.subclass(*args_, **kwargs_)
        else:
            return entry_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_admin(self):
        return self.admin
    def set_admin(self, admin):
        self.admin = admin
    def get_crossreferences(self):
        return self.crossreferences
    def set_crossreferences(self, crossreferences):
        self.crossreferences = crossreferences
    def get_sample(self):
        return self.sample
    def set_sample(self, sample):
        self.sample = sample
    def get_structure_determination_list(self):
        return self.structure_determination_list
    def set_structure_determination_list(self, structure_determination_list):
        self.structure_determination_list = structure_determination_list
    def get_map(self):
        return self.map
    def set_map(self, map):
        self.map = map
    def get_interpretation(self):
        return self.interpretation
    def set_interpretation(self, interpretation):
        self.interpretation = interpretation
    def get_validation(self):
        return self.validation
    def set_validation(self, validation):
        self.validation = validation
    def get_emdb_id(self):
        return self.emdb_id
    def set_emdb_id(self, emdb_id):
        self.emdb_id = emdb_id
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def validate_emdb_id_type(self, value):
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emdb_id_type_patterns_, ))
    validate_emdb_id_type_patterns_ = [['^(EMD-\\d{4,})$']]
    def has__content(self):
        if (
            self.admin is not None or
            self.crossreferences is not None or
            self.sample is not None or
            self.structure_determination_list is not None or
            self.map is not None or
            self.interpretation is not None or
            self.validation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='entry_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('entry_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'entry_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='entry_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='entry_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='entry_type'):
        if self.emdb_id is not None and 'emdb_id' not in already_processed:
            already_processed.add('emdb_id')
            outfile.write(' emdb_id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.emdb_id), input_name='emdb_id')), ))
        if self.version != "3.0.7.2" and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='entry_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.admin is not None:
            namespaceprefix_ = self.admin_nsprefix_ + ':' if (UseCapturedNS_ and self.admin_nsprefix_) else ''
            self.admin.export(outfile, level, namespaceprefix_, namespacedef_='', name_='admin', pretty_print=pretty_print)
        if self.crossreferences is not None:
            namespaceprefix_ = self.crossreferences_nsprefix_ + ':' if (UseCapturedNS_ and self.crossreferences_nsprefix_) else ''
            self.crossreferences.export(outfile, level, namespaceprefix_, namespacedef_='', name_='crossreferences', pretty_print=pretty_print)
        if self.sample is not None:
            namespaceprefix_ = self.sample_nsprefix_ + ':' if (UseCapturedNS_ and self.sample_nsprefix_) else ''
            self.sample.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sample', pretty_print=pretty_print)
        if self.structure_determination_list is not None:
            namespaceprefix_ = self.structure_determination_list_nsprefix_ + ':' if (UseCapturedNS_ and self.structure_determination_list_nsprefix_) else ''
            self.structure_determination_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='structure_determination_list', pretty_print=pretty_print)
        if self.map is not None:
            namespaceprefix_ = self.map_nsprefix_ + ':' if (UseCapturedNS_ and self.map_nsprefix_) else ''
            self.map.export(outfile, level, namespaceprefix_, namespacedef_='', name_='map', pretty_print=pretty_print)
        if self.interpretation is not None:
            namespaceprefix_ = self.interpretation_nsprefix_ + ':' if (UseCapturedNS_ and self.interpretation_nsprefix_) else ''
            self.interpretation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='interpretation', pretty_print=pretty_print)
        if self.validation is not None:
            namespaceprefix_ = self.validation_nsprefix_ + ':' if (UseCapturedNS_ and self.validation_nsprefix_) else ''
            self.validation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='validation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('emdb_id', node)
        if value is not None and 'emdb_id' not in already_processed:
            already_processed.add('emdb_id')
            self.emdb_id = value
            self.emdb_id = ' '.join(self.emdb_id.split())
            self.validate_emdb_id_type(self.emdb_id)    # validate type emdb_id_type
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
            self.version = ' '.join(self.version.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'admin':
            obj_ = admin_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.admin = obj_
            obj_.original_tagname_ = 'admin'
        elif nodeName_ == 'crossreferences':
            obj_ = crossreferences_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.crossreferences = obj_
            obj_.original_tagname_ = 'crossreferences'
        elif nodeName_ == 'sample':
            obj_ = sample_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sample = obj_
            obj_.original_tagname_ = 'sample'
        elif nodeName_ == 'structure_determination_list':
            obj_ = structure_determination_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.structure_determination_list = obj_
            obj_.original_tagname_ = 'structure_determination_list'
        elif nodeName_ == 'map':
            obj_ = map_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.map = obj_
            obj_.original_tagname_ = 'map'
        elif nodeName_ == 'interpretation':
            obj_ = interpretation_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.interpretation = obj_
            obj_.original_tagname_ = 'interpretation'
        elif nodeName_ == 'validation':
            obj_ = validationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.validation = obj_
            obj_.original_tagname_ = 'validation'
# end class entry_type


class admin_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, status_history_list=None, current_status=None, sites=None, key_dates=None, obsolete_list=None, superseded_by_list=None, grant_support=None, microscopy_center=None, contact_author=None, title=None, authors_list=None, details=None, keywords=None, replace_existing_entry=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.status_history_list = status_history_list
        self.status_history_list_nsprefix_ = None
        self.current_status = current_status
        self.current_status_nsprefix_ = None
        self.sites = sites
        self.sites_nsprefix_ = None
        self.key_dates = key_dates
        self.key_dates_nsprefix_ = None
        self.obsolete_list = obsolete_list
        self.obsolete_list_nsprefix_ = None
        self.superseded_by_list = superseded_by_list
        self.superseded_by_list_nsprefix_ = None
        self.grant_support = grant_support
        self.grant_support_nsprefix_ = None
        self.microscopy_center = microscopy_center
        self.microscopy_center_nsprefix_ = None
        if contact_author is None:
            self.contact_author = []
        else:
            self.contact_author = contact_author
        self.contact_author_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.authors_list = authors_list
        self.authors_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.keywords = keywords
        self.keywords_nsprefix_ = None
        self.replace_existing_entry = replace_existing_entry
        self.replace_existing_entry_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, admin_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if admin_type.subclass:
            return admin_type.subclass(*args_, **kwargs_)
        else:
            return admin_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_status_history_list(self):
        return self.status_history_list
    def set_status_history_list(self, status_history_list):
        self.status_history_list = status_history_list
    def get_current_status(self):
        return self.current_status
    def set_current_status(self, current_status):
        self.current_status = current_status
    def get_sites(self):
        return self.sites
    def set_sites(self, sites):
        self.sites = sites
    def get_key_dates(self):
        return self.key_dates
    def set_key_dates(self, key_dates):
        self.key_dates = key_dates
    def get_obsolete_list(self):
        return self.obsolete_list
    def set_obsolete_list(self, obsolete_list):
        self.obsolete_list = obsolete_list
    def get_superseded_by_list(self):
        return self.superseded_by_list
    def set_superseded_by_list(self, superseded_by_list):
        self.superseded_by_list = superseded_by_list
    def get_grant_support(self):
        return self.grant_support
    def set_grant_support(self, grant_support):
        self.grant_support = grant_support
    def get_microscopy_center(self):
        return self.microscopy_center
    def set_microscopy_center(self, microscopy_center):
        self.microscopy_center = microscopy_center
    def get_contact_author(self):
        return self.contact_author
    def set_contact_author(self, contact_author):
        self.contact_author = contact_author
    def add_contact_author(self, value):
        self.contact_author.append(value)
    def insert_contact_author_at(self, index, value):
        self.contact_author.insert(index, value)
    def replace_contact_author_at(self, index, value):
        self.contact_author[index] = value
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_authors_list(self):
        return self.authors_list
    def set_authors_list(self, authors_list):
        self.authors_list = authors_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_keywords(self):
        return self.keywords
    def set_keywords(self, keywords):
        self.keywords = keywords
    def get_replace_existing_entry(self):
        return self.replace_existing_entry
    def set_replace_existing_entry(self, replace_existing_entry):
        self.replace_existing_entry = replace_existing_entry
    def has__content(self):
        if (
            self.status_history_list is not None or
            self.current_status is not None or
            self.sites is not None or
            self.key_dates is not None or
            self.obsolete_list is not None or
            self.superseded_by_list is not None or
            self.grant_support is not None or
            self.microscopy_center is not None or
            self.contact_author or
            self.title is not None or
            self.authors_list is not None or
            self.details is not None or
            self.keywords is not None or
            self.replace_existing_entry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='admin_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('admin_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'admin_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='admin_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='admin_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='admin_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='admin_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.status_history_list is not None:
            namespaceprefix_ = self.status_history_list_nsprefix_ + ':' if (UseCapturedNS_ and self.status_history_list_nsprefix_) else ''
            self.status_history_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='status_history_list', pretty_print=pretty_print)
        if self.current_status is not None:
            namespaceprefix_ = self.current_status_nsprefix_ + ':' if (UseCapturedNS_ and self.current_status_nsprefix_) else ''
            self.current_status.export(outfile, level, namespaceprefix_, namespacedef_='', name_='current_status', pretty_print=pretty_print)
        if self.sites is not None:
            namespaceprefix_ = self.sites_nsprefix_ + ':' if (UseCapturedNS_ and self.sites_nsprefix_) else ''
            self.sites.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sites', pretty_print=pretty_print)
        if self.key_dates is not None:
            namespaceprefix_ = self.key_dates_nsprefix_ + ':' if (UseCapturedNS_ and self.key_dates_nsprefix_) else ''
            self.key_dates.export(outfile, level, namespaceprefix_, namespacedef_='', name_='key_dates', pretty_print=pretty_print)
        if self.obsolete_list is not None:
            namespaceprefix_ = self.obsolete_list_nsprefix_ + ':' if (UseCapturedNS_ and self.obsolete_list_nsprefix_) else ''
            self.obsolete_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='obsolete_list', pretty_print=pretty_print)
        if self.superseded_by_list is not None:
            namespaceprefix_ = self.superseded_by_list_nsprefix_ + ':' if (UseCapturedNS_ and self.superseded_by_list_nsprefix_) else ''
            self.superseded_by_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superseded_by_list', pretty_print=pretty_print)
        if self.grant_support is not None:
            namespaceprefix_ = self.grant_support_nsprefix_ + ':' if (UseCapturedNS_ and self.grant_support_nsprefix_) else ''
            self.grant_support.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grant_support', pretty_print=pretty_print)
        if self.microscopy_center is not None:
            namespaceprefix_ = self.microscopy_center_nsprefix_ + ':' if (UseCapturedNS_ and self.microscopy_center_nsprefix_) else ''
            self.microscopy_center.export(outfile, level, namespaceprefix_, namespacedef_='', name_='microscopy_center', pretty_print=pretty_print)
        for contact_author_ in self.contact_author:
            namespaceprefix_ = self.contact_author_nsprefix_ + ':' if (UseCapturedNS_ and self.contact_author_nsprefix_) else ''
            contact_author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contact_author', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        if self.authors_list is not None:
            namespaceprefix_ = self.authors_list_nsprefix_ + ':' if (UseCapturedNS_ and self.authors_list_nsprefix_) else ''
            self.authors_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authors_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
        if self.keywords is not None:
            namespaceprefix_ = self.keywords_nsprefix_ + ':' if (UseCapturedNS_ and self.keywords_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeywords>%s</%skeywords>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.keywords), input_name='keywords')), namespaceprefix_ , eol_))
        if self.replace_existing_entry is not None:
            namespaceprefix_ = self.replace_existing_entry_nsprefix_ + ':' if (UseCapturedNS_ and self.replace_existing_entry_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreplace_existing_entry>%s</%sreplace_existing_entry>%s' % (namespaceprefix_ , self.gds_format_boolean(self.replace_existing_entry, input_name='replace_existing_entry'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'status_history_list':
            obj_ = version_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.status_history_list = obj_
            obj_.original_tagname_ = 'status_history_list'
        elif nodeName_ == 'current_status':
            class_obj_ = self.get_class_obj_(child_, version_type)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.current_status = obj_
            obj_.original_tagname_ = 'current_status'
        elif nodeName_ == 'sites':
            obj_ = sitesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sites = obj_
            obj_.original_tagname_ = 'sites'
        elif nodeName_ == 'key_dates':
            obj_ = key_datesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.key_dates = obj_
            obj_.original_tagname_ = 'key_dates'
        elif nodeName_ == 'obsolete_list':
            obj_ = obsolete_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.obsolete_list = obj_
            obj_.original_tagname_ = 'obsolete_list'
        elif nodeName_ == 'superseded_by_list':
            obj_ = superseded_by_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.superseded_by_list = obj_
            obj_.original_tagname_ = 'superseded_by_list'
        elif nodeName_ == 'grant_support':
            obj_ = grant_supportType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.grant_support = obj_
            obj_.original_tagname_ = 'grant_support'
        elif nodeName_ == 'microscopy_center':
            obj_ = microscopy_centerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.microscopy_center = obj_
            obj_.original_tagname_ = 'microscopy_center'
        elif nodeName_ == 'contact_author':
            obj_ = contact_authorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact_author.append(obj_)
            obj_.original_tagname_ = 'contact_author'
        elif nodeName_ == 'title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'authors_list':
            obj_ = authors_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authors_list = obj_
            obj_.original_tagname_ = 'authors_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
        elif nodeName_ == 'keywords':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'keywords')
            value_ = self.gds_validate_string(value_, node, 'keywords')
            self.keywords = value_
            self.keywords_nsprefix_ = child_.prefix
        elif nodeName_ == 'replace_existing_entry':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'replace_existing_entry')
            ival_ = self.gds_validate_boolean(ival_, node, 'replace_existing_entry')
            self.replace_existing_entry = ival_
            self.replace_existing_entry_nsprefix_ = child_.prefix
# end class admin_type


class version_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, status=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if status is None:
            self.status = []
        else:
            self.status = status
        self.status_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, version_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if version_list_type.subclass:
            return version_list_type.subclass(*args_, **kwargs_)
        else:
            return version_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_status(self):
        return self.status
    def set_status(self, status):
        self.status = status
    def add_status(self, value):
        self.status.append(value)
    def insert_status_at(self, index, value):
        self.status.insert(index, value)
    def replace_status_at(self, index, value):
        self.status[index] = value
    def has__content(self):
        if (
            self.status
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='version_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('version_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'version_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='version_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='version_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='version_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='version_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for status_ in self.status:
            namespaceprefix_ = self.status_nsprefix_ + ':' if (UseCapturedNS_ and self.status_nsprefix_) else ''
            status_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='status', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'status':
            obj_ = statusType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.status.append(obj_)
            obj_.original_tagname_ = 'status'
# end class version_list_type


class version_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, date=None, code=None, processing_site=None, annotator=None, details=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.date_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.processing_site = processing_site
        self.validate_processing_siteType(self.processing_site)
        self.processing_site_nsprefix_ = None
        self.annotator = annotator
        self.annotator_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, version_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if version_type.subclass:
            return version_type.subclass(*args_, **kwargs_)
        else:
            return version_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_processing_site(self):
        return self.processing_site
    def set_processing_site(self, processing_site):
        self.processing_site = processing_site
    def get_annotator(self):
        return self.annotator
    def set_annotator(self, annotator):
        self.annotator = annotator
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_dateType(self, value):
        result = True
        # Validate type dateType, a restriction on xs:date.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, datetime_.date):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (datetime_.date)' % {"value": value, "lineno": lineno, })
                return False
            if value < self.gds_parse_date('2002-01-01'):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dateType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_processing_siteType(self, value):
        result = True
        # Validate type processing_siteType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PDBe', 'RCSB', 'PDBj', 'PDBc']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on processing_siteType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.date is not None or
            self.code is not None or
            self.processing_site is not None or
            self.annotator is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='version_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('version_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'version_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='version_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='version_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='version_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='version_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_format_date(self.date, input_name='date'), namespaceprefix_ , eol_))
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.processing_site is not None:
            namespaceprefix_ = self.processing_site_nsprefix_ + ':' if (UseCapturedNS_ and self.processing_site_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocessing_site>%s</%sprocessing_site>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.processing_site), input_name='processing_site')), namespaceprefix_ , eol_))
        if self.annotator is not None:
            namespaceprefix_ = self.annotator_nsprefix_ + ':' if (UseCapturedNS_ and self.annotator_nsprefix_) else ''
            self.annotator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='annotator', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
            self.date_nsprefix_ = child_.prefix
            # validate type dateType
            self.validate_dateType(self.date)
        elif nodeName_ == 'code':
            obj_ = code_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'processing_site':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'processing_site')
            value_ = self.gds_validate_string(value_, node, 'processing_site')
            self.processing_site = value_
            self.processing_site_nsprefix_ = child_.prefix
            # validate type processing_siteType
            self.validate_processing_siteType(self.processing_site)
        elif nodeName_ == 'annotator':
            obj_ = annotatorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotator = obj_
            obj_.original_tagname_ = 'annotator'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class version_type


class code_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, superseded=None, supersedes=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.superseded = _cast(bool, superseded)
        self.superseded_nsprefix_ = None
        self.supersedes = _cast(bool, supersedes)
        self.supersedes_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, code_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if code_type.subclass:
            return code_type.subclass(*args_, **kwargs_)
        else:
            return code_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_superseded(self):
        return self.superseded
    def set_superseded(self, superseded):
        self.superseded = superseded
    def get_supersedes(self):
        return self.supersedes
    def set_supersedes(self, supersedes):
        self.supersedes = supersedes
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_status_code_type(self, value):
        result = True
        # Validate type status_code_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AUCO', 'AUTH', 'AUXS', 'AUXU', 'HOLD', 'HOLD8W', 'HPUB', 'OBS', 'POLC', 'PROC', 'REFI', 'REL', 'REPL', 'REUP', 'WAIT', 'WDRN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on status_code_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='code_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('code_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'code_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='code_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='code_type'):
        if self.superseded is not None and 'superseded' not in already_processed:
            already_processed.add('superseded')
            outfile.write(' superseded="%s"' % self.gds_format_boolean(self.superseded, input_name='superseded'))
        if self.supersedes is not None and 'supersedes' not in already_processed:
            already_processed.add('supersedes')
            outfile.write(' supersedes="%s"' % self.gds_format_boolean(self.supersedes, input_name='supersedes'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='code_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('superseded', node)
        if value is not None and 'superseded' not in already_processed:
            already_processed.add('superseded')
            if value in ('true', '1'):
                self.superseded = True
            elif value in ('false', '0'):
                self.superseded = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('supersedes', node)
        if value is not None and 'supersedes' not in already_processed:
            already_processed.add('supersedes')
            if value in ('true', '1'):
                self.supersedes = True
            elif value in ('false', '0'):
                self.supersedes = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class code_type


class supersedes_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, date=None, entry=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.date_nsprefix_ = None
        self.entry = entry
        self.validate_emdb_id_type(self.entry)
        self.entry_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, supersedes_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if supersedes_type.subclass:
            return supersedes_type.subclass(*args_, **kwargs_)
        else:
            return supersedes_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_entry(self):
        return self.entry
    def set_entry(self, entry):
        self.entry = entry
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_emdb_id_type(self, value):
        result = True
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emdb_id_type_patterns_, ))
                result = False
        return result
    validate_emdb_id_type_patterns_ = [['^(EMD-\\d{4,})$']]
    def has__content(self):
        if (
            self.date is not None or
            self.entry is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='supersedes_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('supersedes_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'supersedes_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='supersedes_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='supersedes_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='supersedes_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='supersedes_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_format_date(self.date, input_name='date'), namespaceprefix_ , eol_))
        if self.entry is not None:
            namespaceprefix_ = self.entry_nsprefix_ + ':' if (UseCapturedNS_ and self.entry_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentry>%s</%sentry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.entry), input_name='entry')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == 'entry':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'entry')
            value_ = self.gds_validate_string(value_, node, 'entry')
            self.entry = value_
            self.entry_nsprefix_ = child_.prefix
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.entry)
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class supersedes_type


class grant_reference_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, funding_body=None, code=None, country=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.funding_body = funding_body
        self.funding_body_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grant_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grant_reference_type.subclass:
            return grant_reference_type.subclass(*args_, **kwargs_)
        else:
            return grant_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_funding_body(self):
        return self.funding_body
    def set_funding_body(self, funding_body):
        self.funding_body = funding_body
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def has__content(self):
        if (
            self.funding_body is not None or
            self.code is not None or
            self.country is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grant_reference_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grant_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'grant_reference_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='grant_reference_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='grant_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='grant_reference_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grant_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.funding_body is not None:
            namespaceprefix_ = self.funding_body_nsprefix_ + ':' if (UseCapturedNS_ and self.funding_body_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfunding_body>%s</%sfunding_body>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.funding_body), input_name='funding_body')), namespaceprefix_ , eol_))
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scode>%s</%scode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), namespaceprefix_ , eol_))
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'funding_body':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'funding_body')
            value_ = self.gds_validate_string(value_, node, 'funding_body')
            self.funding_body = value_
            self.funding_body_nsprefix_ = child_.prefix
        elif nodeName_ == 'code':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'code')
            value_ = self.gds_validate_string(value_, node, 'code')
            self.code = value_
            self.code_nsprefix_ = child_.prefix
        elif nodeName_ == 'country':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
# end class grant_reference_type


class contact_details_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, role=None, title=None, first_name=None, middle_name=None, last_name=None, organization=None, street=None, town_or_city=None, state_or_province=None, country=None, post_or_zip_code=None, email=None, telephone=None, fax=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.role = role
        self.validate_roleType(self.role)
        self.role_nsprefix_ = None
        self.title = title
        self.validate_titleType(self.title)
        self.title_nsprefix_ = None
        self.first_name = first_name
        self.first_name_nsprefix_ = None
        self.middle_name = middle_name
        self.validate_middle_nameType(self.middle_name)
        self.middle_name_nsprefix_ = None
        self.last_name = last_name
        self.last_name_nsprefix_ = None
        self.organization = organization
        self.organization_nsprefix_ = None
        self.street = street
        self.street_nsprefix_ = None
        self.town_or_city = town_or_city
        self.town_or_city_nsprefix_ = None
        self.state_or_province = state_or_province
        self.state_or_province_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.post_or_zip_code = post_or_zip_code
        self.post_or_zip_code_nsprefix_ = None
        self.email = email
        self.validate_emailType(self.email)
        self.email_nsprefix_ = None
        self.telephone = telephone
        self.telephone_nsprefix_ = None
        self.fax = fax
        self.fax_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contact_details_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contact_details_type.subclass:
            return contact_details_type.subclass(*args_, **kwargs_)
        else:
            return contact_details_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_role(self):
        return self.role
    def set_role(self, role):
        self.role = role
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_first_name(self):
        return self.first_name
    def set_first_name(self, first_name):
        self.first_name = first_name
    def get_middle_name(self):
        return self.middle_name
    def set_middle_name(self, middle_name):
        self.middle_name = middle_name
    def get_last_name(self):
        return self.last_name
    def set_last_name(self, last_name):
        self.last_name = last_name
    def get_organization(self):
        return self.organization
    def set_organization(self, organization):
        self.organization = organization
    def get_street(self):
        return self.street
    def set_street(self, street):
        self.street = street
    def get_town_or_city(self):
        return self.town_or_city
    def set_town_or_city(self, town_or_city):
        self.town_or_city = town_or_city
    def get_state_or_province(self):
        return self.state_or_province
    def set_state_or_province(self, state_or_province):
        self.state_or_province = state_or_province
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_post_or_zip_code(self):
        return self.post_or_zip_code
    def set_post_or_zip_code(self, post_or_zip_code):
        self.post_or_zip_code = post_or_zip_code
    def get_email(self):
        return self.email
    def set_email(self, email):
        self.email = email
    def get_telephone(self):
        return self.telephone
    def set_telephone(self, telephone):
        self.telephone = telephone
    def get_fax(self):
        return self.fax
    def set_fax(self, fax):
        self.fax = fax
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_roleType(self, value):
        result = True
        # Validate type roleType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['INVESTIGATOR', 'PRINCIPAL INVESTIGATOR/GROUP LEADER', 'RESPONSIBLE SCIENTIST']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on roleType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_titleType(self, value):
        result = True
        # Validate type titleType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DR.', 'MR.', 'MRS.', 'MS.', 'PROF.']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on titleType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_middle_nameType(self, value):
        result = True
        # Validate type middle_nameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_middle_nameType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_middle_nameType_patterns_, ))
                result = False
        return result
    validate_middle_nameType_patterns_ = [['^([A-Z])$']]
    def validate_emailType(self, value):
        result = True
        # Validate type emailType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emailType_patterns_, ))
                result = False
        return result
    validate_emailType_patterns_ = [['^([A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4})$']]
    def has__content(self):
        if (
            self.role is not None or
            self.title is not None or
            self.first_name is not None or
            self.middle_name is not None or
            self.last_name is not None or
            self.organization is not None or
            self.street is not None or
            self.town_or_city is not None or
            self.state_or_province is not None or
            self.country is not None or
            self.post_or_zip_code is not None or
            self.email is not None or
            self.telephone is not None or
            self.fax is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='contact_details_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('contact_details_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'contact_details_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='contact_details_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='contact_details_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='contact_details_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='contact_details_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.role is not None:
            namespaceprefix_ = self.role_nsprefix_ + ':' if (UseCapturedNS_ and self.role_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srole>%s</%srole>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.role), input_name='role')), namespaceprefix_ , eol_))
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        if self.first_name is not None:
            namespaceprefix_ = self.first_name_nsprefix_ + ':' if (UseCapturedNS_ and self.first_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirst_name>%s</%sfirst_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.first_name), input_name='first_name')), namespaceprefix_ , eol_))
        if self.middle_name is not None:
            namespaceprefix_ = self.middle_name_nsprefix_ + ':' if (UseCapturedNS_ and self.middle_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smiddle_name>%s</%smiddle_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.middle_name), input_name='middle_name')), namespaceprefix_ , eol_))
        if self.last_name is not None:
            namespaceprefix_ = self.last_name_nsprefix_ + ':' if (UseCapturedNS_ and self.last_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slast_name>%s</%slast_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.last_name), input_name='last_name')), namespaceprefix_ , eol_))
        if self.organization is not None:
            namespaceprefix_ = self.organization_nsprefix_ + ':' if (UseCapturedNS_ and self.organization_nsprefix_) else ''
            self.organization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organization', pretty_print=pretty_print)
        if self.street is not None:
            namespaceprefix_ = self.street_nsprefix_ + ':' if (UseCapturedNS_ and self.street_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstreet>%s</%sstreet>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.street), input_name='street')), namespaceprefix_ , eol_))
        if self.town_or_city is not None:
            namespaceprefix_ = self.town_or_city_nsprefix_ + ':' if (UseCapturedNS_ and self.town_or_city_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stown_or_city>%s</%stown_or_city>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.town_or_city), input_name='town_or_city')), namespaceprefix_ , eol_))
        if self.state_or_province is not None:
            namespaceprefix_ = self.state_or_province_nsprefix_ + ':' if (UseCapturedNS_ and self.state_or_province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate_or_province>%s</%sstate_or_province>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.state_or_province), input_name='state_or_province')), namespaceprefix_ , eol_))
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
        if self.post_or_zip_code is not None:
            namespaceprefix_ = self.post_or_zip_code_nsprefix_ + ':' if (UseCapturedNS_ and self.post_or_zip_code_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spost_or_zip_code>%s</%spost_or_zip_code>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.post_or_zip_code), input_name='post_or_zip_code')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.telephone is not None:
            namespaceprefix_ = self.telephone_nsprefix_ + ':' if (UseCapturedNS_ and self.telephone_nsprefix_) else ''
            self.telephone.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telephone', pretty_print=pretty_print)
        if self.fax is not None:
            namespaceprefix_ = self.fax_nsprefix_ + ':' if (UseCapturedNS_ and self.fax_nsprefix_) else ''
            self.fax.export(outfile, level, namespaceprefix_, namespacedef_='', name_='fax', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'role':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'role')
            value_ = self.gds_validate_string(value_, node, 'role')
            self.role = value_
            self.role_nsprefix_ = child_.prefix
            # validate type roleType
            self.validate_roleType(self.role)
        elif nodeName_ == 'title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
            # validate type titleType
            self.validate_titleType(self.title)
        elif nodeName_ == 'first_name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'first_name')
            value_ = self.gds_validate_string(value_, node, 'first_name')
            self.first_name = value_
            self.first_name_nsprefix_ = child_.prefix
        elif nodeName_ == 'middle_name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'middle_name')
            value_ = self.gds_validate_string(value_, node, 'middle_name')
            self.middle_name = value_
            self.middle_name_nsprefix_ = child_.prefix
            # validate type middle_nameType
            self.validate_middle_nameType(self.middle_name)
        elif nodeName_ == 'last_name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'last_name')
            value_ = self.gds_validate_string(value_, node, 'last_name')
            self.last_name = value_
            self.last_name_nsprefix_ = child_.prefix
        elif nodeName_ == 'organization':
            obj_ = organizationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organization = obj_
            obj_.original_tagname_ = 'organization'
        elif nodeName_ == 'street':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'street')
            value_ = self.gds_validate_string(value_, node, 'street')
            self.street = value_
            self.street_nsprefix_ = child_.prefix
        elif nodeName_ == 'town_or_city':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'town_or_city')
            value_ = self.gds_validate_string(value_, node, 'town_or_city')
            self.town_or_city = value_
            self.town_or_city_nsprefix_ = child_.prefix
        elif nodeName_ == 'state_or_province':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'state_or_province')
            value_ = self.gds_validate_string(value_, node, 'state_or_province')
            self.state_or_province = value_
            self.state_or_province_nsprefix_ = child_.prefix
        elif nodeName_ == 'country':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == 'post_or_zip_code':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'post_or_zip_code')
            value_ = self.gds_validate_string(value_, node, 'post_or_zip_code')
            self.post_or_zip_code = value_
            self.post_or_zip_code_nsprefix_ = child_.prefix
        elif nodeName_ == 'email':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
            # validate type emailType
            self.validate_emailType(self.email)
        elif nodeName_ == 'telephone':
            obj_ = telephone_number_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telephone = obj_
            obj_.original_tagname_ = 'telephone'
        elif nodeName_ == 'fax':
            obj_ = telephone_number_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fax = obj_
            obj_.original_tagname_ = 'fax'
# end class contact_details_type


class telephone_number_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, country=None, area=None, local=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.country = country
        self.validate_countryType1(self.country)
        self.country_nsprefix_ = None
        self.area = area
        self.validate_areaType(self.area)
        self.area_nsprefix_ = None
        self.local = local
        self.validate_localType(self.local)
        self.local_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, telephone_number_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if telephone_number_type.subclass:
            return telephone_number_type.subclass(*args_, **kwargs_)
        else:
            return telephone_number_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_area(self):
        return self.area
    def set_area(self, area):
        self.area = area
    def get_local(self):
        return self.local
    def set_local(self, local):
        self.local = local
    def validate_countryType1(self, value):
        result = True
        # Validate type countryType1, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_countryType1_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_countryType1_patterns_, ))
                result = False
        return result
    validate_countryType1_patterns_ = [['^(\\d{1,3})$']]
    def validate_areaType(self, value):
        result = True
        # Validate type areaType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_areaType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_areaType_patterns_, ))
                result = False
        return result
    validate_areaType_patterns_ = [['^(\\d{2,5})$']]
    def validate_localType(self, value):
        result = True
        # Validate type localType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_localType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_localType_patterns_, ))
                result = False
        return result
    validate_localType_patterns_ = [['^(\\d+( ext. \\d+)?)$']]
    def has__content(self):
        if (
            self.country is not None or
            self.area is not None or
            self.local is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='telephone_number_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('telephone_number_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'telephone_number_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='telephone_number_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='telephone_number_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='telephone_number_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='telephone_number_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
        if self.area is not None:
            namespaceprefix_ = self.area_nsprefix_ + ':' if (UseCapturedNS_ and self.area_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarea>%s</%sarea>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.area), input_name='area')), namespaceprefix_ , eol_))
        if self.local is not None:
            namespaceprefix_ = self.local_nsprefix_ + ':' if (UseCapturedNS_ and self.local_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocal>%s</%slocal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.local), input_name='local')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'country':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
            # validate type countryType1
            self.validate_countryType1(self.country)
        elif nodeName_ == 'area':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'area')
            value_ = self.gds_validate_string(value_, node, 'area')
            self.area = value_
            self.area_nsprefix_ = child_.prefix
            # validate type areaType
            self.validate_areaType(self.area)
        elif nodeName_ == 'local':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'local')
            value_ = self.gds_validate_string(value_, node, 'local')
            self.local = value_
            self.local_nsprefix_ = child_.prefix
            # validate type localType
            self.validate_localType(self.local)
# end class telephone_number_type


class author_ORCID_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ORCID=None, valueOf_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ORCID = _cast(None, ORCID)
        self.ORCID_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, author_ORCID_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if author_ORCID_type.subclass:
            return author_ORCID_type.subclass(*args_, **kwargs_)
        else:
            return author_ORCID_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ORCID(self):
        return self.ORCID
    def set_ORCID(self, ORCID):
        self.ORCID = ORCID
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_author_type(self, value):
        result = True
        # Validate type author_type, a restriction on xs:token.
        pass
        return result
    def validate_ORCID_type(self, value):
        # Validate type ORCID_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_ORCID_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ORCID_type_patterns_, ))
    validate_ORCID_type_patterns_ = [['^([0-9]{4}-[0-9]{4}-[0-9]{4}-([0-9]{3}X|[0-9]{4}))$']]
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='author_ORCID_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('author_ORCID_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'author_ORCID_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='author_ORCID_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='author_ORCID_type'):
        if self.ORCID is not None and 'ORCID' not in already_processed:
            already_processed.add('ORCID')
            outfile.write(' ORCID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ORCID), input_name='ORCID')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='author_ORCID_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ORCID', node)
        if value is not None and 'ORCID' not in already_processed:
            already_processed.add('ORCID')
            self.ORCID = value
            self.ORCID = ' '.join(self.ORCID.split())
            self.validate_ORCID_type(self.ORCID)    # validate type ORCID_type
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class author_ORCID_type


class author_order_type(author_ORCID_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = author_ORCID_type
    def __init__(self, ORCID=None, order=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("author_order_type"), self).__init__(ORCID, valueOf_,  **kwargs_)
        self.order = _cast(int, order)
        self.order_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, author_order_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if author_order_type.subclass:
            return author_order_type.subclass(*args_, **kwargs_)
        else:
            return author_order_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_order(self):
        return self.order
    def set_order(self, order):
        self.order = order
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(author_order_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='author_order_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('author_order_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'author_order_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='author_order_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='author_order_type'):
        super(author_order_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='author_order_type')
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='author_order_type', fromsubclass_=False, pretty_print=True):
        super(author_order_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = self.gds_parse_integer(value, node, 'order')
            if self.order <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(author_order_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class author_order_type


class crossreferences_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, citation_list=None, emdb_list=None, pdb_list=None, other_db_list=None, auxiliary_link_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.citation_list = citation_list
        self.citation_list_nsprefix_ = None
        self.emdb_list = emdb_list
        self.emdb_list_nsprefix_ = None
        self.pdb_list = pdb_list
        self.pdb_list_nsprefix_ = None
        self.other_db_list = other_db_list
        self.other_db_list_nsprefix_ = None
        self.auxiliary_link_list = auxiliary_link_list
        self.auxiliary_link_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crossreferences_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crossreferences_type.subclass:
            return crossreferences_type.subclass(*args_, **kwargs_)
        else:
            return crossreferences_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_citation_list(self):
        return self.citation_list
    def set_citation_list(self, citation_list):
        self.citation_list = citation_list
    def get_emdb_list(self):
        return self.emdb_list
    def set_emdb_list(self, emdb_list):
        self.emdb_list = emdb_list
    def get_pdb_list(self):
        return self.pdb_list
    def set_pdb_list(self, pdb_list):
        self.pdb_list = pdb_list
    def get_other_db_list(self):
        return self.other_db_list
    def set_other_db_list(self, other_db_list):
        self.other_db_list = other_db_list
    def get_auxiliary_link_list(self):
        return self.auxiliary_link_list
    def set_auxiliary_link_list(self, auxiliary_link_list):
        self.auxiliary_link_list = auxiliary_link_list
    def has__content(self):
        if (
            self.citation_list is not None or
            self.emdb_list is not None or
            self.pdb_list is not None or
            self.other_db_list is not None or
            self.auxiliary_link_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crossreferences_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crossreferences_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crossreferences_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crossreferences_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crossreferences_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crossreferences_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crossreferences_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.citation_list is not None:
            namespaceprefix_ = self.citation_list_nsprefix_ + ':' if (UseCapturedNS_ and self.citation_list_nsprefix_) else ''
            self.citation_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='citation_list', pretty_print=pretty_print)
        if self.emdb_list is not None:
            namespaceprefix_ = self.emdb_list_nsprefix_ + ':' if (UseCapturedNS_ and self.emdb_list_nsprefix_) else ''
            self.emdb_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emdb_list', pretty_print=pretty_print)
        if self.pdb_list is not None:
            namespaceprefix_ = self.pdb_list_nsprefix_ + ':' if (UseCapturedNS_ and self.pdb_list_nsprefix_) else ''
            self.pdb_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pdb_list', pretty_print=pretty_print)
        if self.other_db_list is not None:
            namespaceprefix_ = self.other_db_list_nsprefix_ + ':' if (UseCapturedNS_ and self.other_db_list_nsprefix_) else ''
            self.other_db_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='other_db_list', pretty_print=pretty_print)
        if self.auxiliary_link_list is not None:
            namespaceprefix_ = self.auxiliary_link_list_nsprefix_ + ':' if (UseCapturedNS_ and self.auxiliary_link_list_nsprefix_) else ''
            self.auxiliary_link_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='auxiliary_link_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'citation_list':
            obj_ = citation_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.citation_list = obj_
            obj_.original_tagname_ = 'citation_list'
        elif nodeName_ == 'emdb_list':
            obj_ = emdb_cross_reference_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.emdb_list = obj_
            obj_.original_tagname_ = 'emdb_list'
        elif nodeName_ == 'pdb_list':
            obj_ = pdb_cross_reference_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pdb_list = obj_
            obj_.original_tagname_ = 'pdb_list'
        elif nodeName_ == 'other_db_list':
            obj_ = other_db_cross_reference_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.other_db_list = obj_
            obj_.original_tagname_ = 'other_db_list'
        elif nodeName_ == 'auxiliary_link_list':
            obj_ = auxiliary_link_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.auxiliary_link_list = obj_
            obj_.original_tagname_ = 'auxiliary_link_list'
# end class crossreferences_type


class citation_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, citation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if citation_type.subclass:
            return citation_type.subclass(*args_, **kwargs_)
        else:
            return citation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='citation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('citation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'citation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='citation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='citation_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='citation_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='citation_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class citation_type


class journal_citation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, title=None, journal=None, journal_abbreviation=None, country=None, issue=None, volume=None, first_page=None, last_page=None, year=None, language=None, external_references=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.published = _cast(bool, published)
        self.published_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.journal = journal
        self.journal_nsprefix_ = None
        self.journal_abbreviation = journal_abbreviation
        self.journal_abbreviation_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.issue = issue
        self.issue_nsprefix_ = None
        self.volume = volume
        self.volume_nsprefix_ = None
        self.first_page = first_page
        self.validate_page_type(self.first_page)
        self.first_page_nsprefix_ = None
        self.last_page = last_page
        self.validate_page_type(self.last_page)
        self.last_page_nsprefix_ = None
        self.year = year
        self.validate_yearType(self.year)
        self.year_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.external_references_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, journal_citation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if journal_citation.subclass:
            return journal_citation.subclass(*args_, **kwargs_)
        else:
            return journal_citation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_journal(self):
        return self.journal
    def set_journal(self, journal):
        self.journal = journal
    def get_journal_abbreviation(self):
        return self.journal_abbreviation
    def set_journal_abbreviation(self, journal_abbreviation):
        self.journal_abbreviation = journal_abbreviation
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_issue(self):
        return self.issue
    def set_issue(self, issue):
        self.issue = issue
    def get_volume(self):
        return self.volume
    def set_volume(self, volume):
        self.volume = volume
    def get_first_page(self):
        return self.first_page
    def set_first_page(self, first_page):
        self.first_page = first_page
    def get_last_page(self):
        return self.last_page
    def set_last_page(self, last_page):
        self.last_page = last_page
    def get_year(self):
        return self.year
    def set_year(self, year):
        self.year = year
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def add_external_references(self, value):
        self.external_references.append(value)
    def insert_external_references_at(self, index, value):
        self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value):
        self.external_references[index] = value
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_published(self):
        return self.published
    def set_published(self, published):
        self.published = published
    def validate_page_type(self, value):
        result = True
        # Validate type page_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def validate_yearType(self, value):
        result = True
        # Validate type yearType, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if value < '1900':
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on yearType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.author or
            self.title is not None or
            self.journal is not None or
            self.journal_abbreviation is not None or
            self.country is not None or
            self.issue is not None or
            self.volume is not None or
            self.first_page is not None or
            self.last_page is not None or
            self.year is not None or
            self.language is not None or
            self.external_references or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='journal_citation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('journal_citation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'journal_citation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='journal_citation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='journal_citation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='journal_citation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='journal_citation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        if self.journal is not None:
            namespaceprefix_ = self.journal_nsprefix_ + ':' if (UseCapturedNS_ and self.journal_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjournal>%s</%sjournal>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.journal), input_name='journal')), namespaceprefix_ , eol_))
        if self.journal_abbreviation is not None:
            namespaceprefix_ = self.journal_abbreviation_nsprefix_ + ':' if (UseCapturedNS_ and self.journal_abbreviation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjournal_abbreviation>%s</%sjournal_abbreviation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.journal_abbreviation), input_name='journal_abbreviation')), namespaceprefix_ , eol_))
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), namespaceprefix_ , eol_))
        if self.issue is not None:
            namespaceprefix_ = self.issue_nsprefix_ + ':' if (UseCapturedNS_ and self.issue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sissue>%s</%sissue>%s' % (namespaceprefix_ , self.gds_format_integer(self.issue, input_name='issue'), namespaceprefix_ , eol_))
        if self.volume is not None:
            namespaceprefix_ = self.volume_nsprefix_ + ':' if (UseCapturedNS_ and self.volume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), namespaceprefix_ , eol_))
        if self.first_page is not None:
            namespaceprefix_ = self.first_page_nsprefix_ + ':' if (UseCapturedNS_ and self.first_page_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirst_page>%s</%sfirst_page>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.first_page), input_name='first_page')), namespaceprefix_ , eol_))
        if self.last_page is not None:
            namespaceprefix_ = self.last_page_nsprefix_ + ':' if (UseCapturedNS_ and self.last_page_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slast_page>%s</%slast_page>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.last_page), input_name='last_page')), namespaceprefix_ , eol_))
        if self.year is not None:
            namespaceprefix_ = self.year_nsprefix_ + ':' if (UseCapturedNS_ and self.year_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%syear>%s</%syear>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slanguage>%s</%slanguage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), namespaceprefix_ , eol_))
        for external_references_ in self.external_references:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            external_references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'author':
            obj_ = author_order_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'journal':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'journal')
            value_ = self.gds_validate_string(value_, node, 'journal')
            self.journal = value_
            self.journal_nsprefix_ = child_.prefix
        elif nodeName_ == 'journal_abbreviation':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'journal_abbreviation')
            value_ = self.gds_validate_string(value_, node, 'journal_abbreviation')
            self.journal_abbreviation = value_
            self.journal_abbreviation_nsprefix_ = child_.prefix
        elif nodeName_ == 'country':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'country')
            value_ = self.gds_validate_string(value_, node, 'country')
            self.country = value_
            self.country_nsprefix_ = child_.prefix
        elif nodeName_ == 'issue' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'issue')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'issue')
            self.issue = ival_
            self.issue_nsprefix_ = child_.prefix
        elif nodeName_ == 'volume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'volume')
            value_ = self.gds_validate_string(value_, node, 'volume')
            self.volume = value_
            self.volume_nsprefix_ = child_.prefix
        elif nodeName_ == 'first_page':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'first_page')
            value_ = self.gds_validate_string(value_, node, 'first_page')
            self.first_page = value_
            self.first_page_nsprefix_ = child_.prefix
            # validate type page_type
            self.validate_page_type(self.first_page)
        elif nodeName_ == 'last_page':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'last_page')
            value_ = self.gds_validate_string(value_, node, 'last_page')
            self.last_page = value_
            self.last_page_nsprefix_ = child_.prefix
            # validate type page_type
            self.validate_page_type(self.last_page)
        elif nodeName_ == 'year':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'year')
            value_ = self.gds_validate_string(value_, node, 'year')
            self.year = value_
            self.year_nsprefix_ = child_.prefix
            # validate type yearType
            self.validate_yearType(self.year)
        elif nodeName_ == 'language':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'language')
            value_ = self.gds_validate_string(value_, node, 'language')
            self.language = value_
            self.language_nsprefix_ = child_.prefix
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class journal_citation


class non_journal_citation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, editor=None, title=None, thesis_title=None, chapter_title=None, volume=None, publisher=None, publisher_location=None, first_page=None, last_page=None, year=None, language=None, external_references=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.published = _cast(bool, published)
        self.published_nsprefix_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
        self.author_nsprefix_ = None
        if editor is None:
            self.editor = []
        else:
            self.editor = editor
        self.editor_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.thesis_title = thesis_title
        self.thesis_title_nsprefix_ = None
        self.chapter_title = chapter_title
        self.chapter_title_nsprefix_ = None
        self.volume = volume
        self.volume_nsprefix_ = None
        self.publisher = publisher
        self.publisher_nsprefix_ = None
        self.publisher_location = publisher_location
        self.publisher_location_nsprefix_ = None
        self.first_page = first_page
        self.validate_page_type(self.first_page)
        self.first_page_nsprefix_ = None
        self.last_page = last_page
        self.validate_page_type(self.last_page)
        self.last_page_nsprefix_ = None
        self.year = year
        self.validate_yearType3(self.year)
        self.year_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.external_references_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, non_journal_citation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if non_journal_citation.subclass:
            return non_journal_citation.subclass(*args_, **kwargs_)
        else:
            return non_journal_citation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_author(self):
        return self.author
    def set_author(self, author):
        self.author = author
    def add_author(self, value):
        self.author.append(value)
    def insert_author_at(self, index, value):
        self.author.insert(index, value)
    def replace_author_at(self, index, value):
        self.author[index] = value
    def get_editor(self):
        return self.editor
    def set_editor(self, editor):
        self.editor = editor
    def add_editor(self, value):
        self.editor.append(value)
    def insert_editor_at(self, index, value):
        self.editor.insert(index, value)
    def replace_editor_at(self, index, value):
        self.editor[index] = value
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_thesis_title(self):
        return self.thesis_title
    def set_thesis_title(self, thesis_title):
        self.thesis_title = thesis_title
    def get_chapter_title(self):
        return self.chapter_title
    def set_chapter_title(self, chapter_title):
        self.chapter_title = chapter_title
    def get_volume(self):
        return self.volume
    def set_volume(self, volume):
        self.volume = volume
    def get_publisher(self):
        return self.publisher
    def set_publisher(self, publisher):
        self.publisher = publisher
    def get_publisher_location(self):
        return self.publisher_location
    def set_publisher_location(self, publisher_location):
        self.publisher_location = publisher_location
    def get_first_page(self):
        return self.first_page
    def set_first_page(self, first_page):
        self.first_page = first_page
    def get_last_page(self):
        return self.last_page
    def set_last_page(self, last_page):
        self.last_page = last_page
    def get_year(self):
        return self.year
    def set_year(self, year):
        self.year = year
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def add_external_references(self, value):
        self.external_references.append(value)
    def insert_external_references_at(self, index, value):
        self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value):
        self.external_references[index] = value
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_published(self):
        return self.published
    def set_published(self, published):
        self.published = published
    def validate_page_type(self, value):
        result = True
        # Validate type page_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def validate_yearType3(self, value):
        result = True
        # Validate type yearType3, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if value < '1900':
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on yearType3' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.author or
            self.editor or
            self.title is not None or
            self.thesis_title is not None or
            self.chapter_title is not None or
            self.volume is not None or
            self.publisher is not None or
            self.publisher_location is not None or
            self.first_page is not None or
            self.last_page is not None or
            self.year is not None or
            self.language is not None or
            self.external_references or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='non_journal_citation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('non_journal_citation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'non_journal_citation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='non_journal_citation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='non_journal_citation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='non_journal_citation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='non_journal_citation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            namespaceprefix_ = self.author_nsprefix_ + ':' if (UseCapturedNS_ and self.author_nsprefix_) else ''
            author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='author', pretty_print=pretty_print)
        for editor_ in self.editor:
            namespaceprefix_ = self.editor_nsprefix_ + ':' if (UseCapturedNS_ and self.editor_nsprefix_) else ''
            editor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='editor', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        if self.thesis_title is not None:
            namespaceprefix_ = self.thesis_title_nsprefix_ + ':' if (UseCapturedNS_ and self.thesis_title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthesis_title>%s</%sthesis_title>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.thesis_title), input_name='thesis_title')), namespaceprefix_ , eol_))
        if self.chapter_title is not None:
            namespaceprefix_ = self.chapter_title_nsprefix_ + ':' if (UseCapturedNS_ and self.chapter_title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schapter_title>%s</%schapter_title>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chapter_title), input_name='chapter_title')), namespaceprefix_ , eol_))
        if self.volume is not None:
            namespaceprefix_ = self.volume_nsprefix_ + ':' if (UseCapturedNS_ and self.volume_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), namespaceprefix_ , eol_))
        if self.publisher is not None:
            namespaceprefix_ = self.publisher_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublisher>%s</%spublisher>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publisher), input_name='publisher')), namespaceprefix_ , eol_))
        if self.publisher_location is not None:
            namespaceprefix_ = self.publisher_location_nsprefix_ + ':' if (UseCapturedNS_ and self.publisher_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublisher_location>%s</%spublisher_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.publisher_location), input_name='publisher_location')), namespaceprefix_ , eol_))
        if self.first_page is not None:
            namespaceprefix_ = self.first_page_nsprefix_ + ':' if (UseCapturedNS_ and self.first_page_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirst_page>%s</%sfirst_page>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.first_page), input_name='first_page')), namespaceprefix_ , eol_))
        if self.last_page is not None:
            namespaceprefix_ = self.last_page_nsprefix_ + ':' if (UseCapturedNS_ and self.last_page_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slast_page>%s</%slast_page>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.last_page), input_name='last_page')), namespaceprefix_ , eol_))
        if self.year is not None:
            namespaceprefix_ = self.year_nsprefix_ + ':' if (UseCapturedNS_ and self.year_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%syear>%s</%syear>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), namespaceprefix_ , eol_))
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slanguage>%s</%slanguage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), namespaceprefix_ , eol_))
        for external_references_ in self.external_references:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            external_references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'author':
            obj_ = author_order_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'editor':
            obj_ = author_order_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.editor.append(obj_)
            obj_.original_tagname_ = 'editor'
        elif nodeName_ == 'title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'thesis_title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'thesis_title')
            value_ = self.gds_validate_string(value_, node, 'thesis_title')
            self.thesis_title = value_
            self.thesis_title_nsprefix_ = child_.prefix
        elif nodeName_ == 'chapter_title':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'chapter_title')
            value_ = self.gds_validate_string(value_, node, 'chapter_title')
            self.chapter_title = value_
            self.chapter_title_nsprefix_ = child_.prefix
        elif nodeName_ == 'volume':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'volume')
            value_ = self.gds_validate_string(value_, node, 'volume')
            self.volume = value_
            self.volume_nsprefix_ = child_.prefix
        elif nodeName_ == 'publisher':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'publisher')
            value_ = self.gds_validate_string(value_, node, 'publisher')
            self.publisher = value_
            self.publisher_nsprefix_ = child_.prefix
        elif nodeName_ == 'publisher_location':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'publisher_location')
            value_ = self.gds_validate_string(value_, node, 'publisher_location')
            self.publisher_location = value_
            self.publisher_location_nsprefix_ = child_.prefix
        elif nodeName_ == 'first_page':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'first_page')
            value_ = self.gds_validate_string(value_, node, 'first_page')
            self.first_page = value_
            self.first_page_nsprefix_ = child_.prefix
            # validate type page_type
            self.validate_page_type(self.first_page)
        elif nodeName_ == 'last_page':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'last_page')
            value_ = self.gds_validate_string(value_, node, 'last_page')
            self.last_page = value_
            self.last_page_nsprefix_ = child_.prefix
            # validate type page_type
            self.validate_page_type(self.last_page)
        elif nodeName_ == 'year':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'year')
            value_ = self.gds_validate_string(value_, node, 'year')
            self.year = value_
            self.year_nsprefix_ = child_.prefix
            # validate type yearType3
            self.validate_yearType3(self.year)
        elif nodeName_ == 'language':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'language')
            value_ = self.gds_validate_string(value_, node, 'language')
            self.language = value_
            self.language_nsprefix_ = child_.prefix
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType4.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class non_journal_citation


class emdb_cross_reference_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, emdb_reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if emdb_reference is None:
            self.emdb_reference = []
        else:
            self.emdb_reference = emdb_reference
        self.emdb_reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emdb_cross_reference_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emdb_cross_reference_list_type.subclass:
            return emdb_cross_reference_list_type.subclass(*args_, **kwargs_)
        else:
            return emdb_cross_reference_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_emdb_reference(self):
        return self.emdb_reference
    def set_emdb_reference(self, emdb_reference):
        self.emdb_reference = emdb_reference
    def add_emdb_reference(self, value):
        self.emdb_reference.append(value)
    def insert_emdb_reference_at(self, index, value):
        self.emdb_reference.insert(index, value)
    def replace_emdb_reference_at(self, index, value):
        self.emdb_reference[index] = value
    def has__content(self):
        if (
            self.emdb_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emdb_cross_reference_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emdb_cross_reference_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'emdb_cross_reference_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='emdb_cross_reference_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='emdb_cross_reference_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='emdb_cross_reference_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emdb_cross_reference_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for emdb_reference_ in self.emdb_reference:
            namespaceprefix_ = self.emdb_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.emdb_reference_nsprefix_) else ''
            emdb_reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emdb_reference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'emdb_reference':
            obj_ = emdb_cross_reference_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.emdb_reference.append(obj_)
            obj_.original_tagname_ = 'emdb_reference'
# end class emdb_cross_reference_list_type


class emdb_cross_reference_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, emdb_id=None, relationship=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.emdb_id = emdb_id
        self.validate_emdb_id_type(self.emdb_id)
        self.emdb_id_nsprefix_ = None
        self.relationship = relationship
        self.relationship_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, emdb_cross_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if emdb_cross_reference_type.subclass:
            return emdb_cross_reference_type.subclass(*args_, **kwargs_)
        else:
            return emdb_cross_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_emdb_id(self):
        return self.emdb_id
    def set_emdb_id(self, emdb_id):
        self.emdb_id = emdb_id
    def get_relationship(self):
        return self.relationship
    def set_relationship(self, relationship):
        self.relationship = relationship
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_emdb_id_type(self, value):
        result = True
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emdb_id_type_patterns_, ))
                result = False
        return result
    validate_emdb_id_type_patterns_ = [['^(EMD-\\d{4,})$']]
    def has__content(self):
        if (
            self.emdb_id is not None or
            self.relationship is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emdb_cross_reference_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('emdb_cross_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'emdb_cross_reference_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='emdb_cross_reference_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='emdb_cross_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='emdb_cross_reference_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='emdb_cross_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.emdb_id is not None:
            namespaceprefix_ = self.emdb_id_nsprefix_ + ':' if (UseCapturedNS_ and self.emdb_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semdb_id>%s</%semdb_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.emdb_id), input_name='emdb_id')), namespaceprefix_ , eol_))
        if self.relationship is not None:
            namespaceprefix_ = self.relationship_nsprefix_ + ':' if (UseCapturedNS_ and self.relationship_nsprefix_) else ''
            self.relationship.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relationship', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'emdb_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'emdb_id')
            value_ = self.gds_validate_string(value_, node, 'emdb_id')
            self.emdb_id = value_
            self.emdb_id_nsprefix_ = child_.prefix
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.emdb_id)
        elif nodeName_ == 'relationship':
            obj_ = relationshipType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relationship = obj_
            obj_.original_tagname_ = 'relationship'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class emdb_cross_reference_type


class pdb_cross_reference_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, pdb_reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if pdb_reference is None:
            self.pdb_reference = []
        else:
            self.pdb_reference = pdb_reference
        self.pdb_reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_cross_reference_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_cross_reference_list_type.subclass:
            return pdb_cross_reference_list_type.subclass(*args_, **kwargs_)
        else:
            return pdb_cross_reference_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_pdb_reference(self):
        return self.pdb_reference
    def set_pdb_reference(self, pdb_reference):
        self.pdb_reference = pdb_reference
    def add_pdb_reference(self, value):
        self.pdb_reference.append(value)
    def insert_pdb_reference_at(self, index, value):
        self.pdb_reference.insert(index, value)
    def replace_pdb_reference_at(self, index, value):
        self.pdb_reference[index] = value
    def has__content(self):
        if (
            self.pdb_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_cross_reference_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_cross_reference_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pdb_cross_reference_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pdb_cross_reference_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='pdb_cross_reference_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='pdb_cross_reference_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_cross_reference_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pdb_reference_ in self.pdb_reference:
            namespaceprefix_ = self.pdb_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.pdb_reference_nsprefix_) else ''
            pdb_reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pdb_reference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'pdb_reference':
            obj_ = pdb_cross_reference_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pdb_reference.append(obj_)
            obj_.original_tagname_ = 'pdb_reference'
# end class pdb_cross_reference_list_type


class pdb_cross_reference_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, pdb_id=None, relationship=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.pdb_id = pdb_id
        self.validate_pdb_code_type(self.pdb_id)
        self.pdb_id_nsprefix_ = None
        self.relationship = relationship
        self.relationship_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_cross_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_cross_reference_type.subclass:
            return pdb_cross_reference_type.subclass(*args_, **kwargs_)
        else:
            return pdb_cross_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_pdb_id(self):
        return self.pdb_id
    def set_pdb_id(self, pdb_id):
        self.pdb_id = pdb_id
    def get_relationship(self):
        return self.relationship
    def set_relationship(self, relationship):
        self.relationship = relationship
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_pdb_code_type(self, value):
        result = True
        # Validate type pdb_code_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_pdb_code_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pdb_code_type_patterns_, ))
                result = False
        return result
    validate_pdb_code_type_patterns_ = [['^(\\d[\\dA-Za-z]{3}|pdb_\\d{5}[\\dA-Za-z]{3})$']]
    def has__content(self):
        if (
            self.pdb_id is not None or
            self.relationship is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_cross_reference_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_cross_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pdb_cross_reference_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pdb_cross_reference_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='pdb_cross_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='pdb_cross_reference_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_cross_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pdb_id is not None:
            namespaceprefix_ = self.pdb_id_nsprefix_ + ':' if (UseCapturedNS_ and self.pdb_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spdb_id>%s</%spdb_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pdb_id), input_name='pdb_id')), namespaceprefix_ , eol_))
        if self.relationship is not None:
            namespaceprefix_ = self.relationship_nsprefix_ + ':' if (UseCapturedNS_ and self.relationship_nsprefix_) else ''
            self.relationship.export(outfile, level, namespaceprefix_, namespacedef_='', name_='relationship', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'pdb_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'pdb_id')
            value_ = self.gds_validate_string(value_, node, 'pdb_id')
            self.pdb_id = value_
            self.pdb_id_nsprefix_ = child_.prefix
            # validate type pdb_code_type
            self.validate_pdb_code_type(self.pdb_id)
        elif nodeName_ == 'relationship':
            obj_ = relationshipType6.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.relationship = obj_
            obj_.original_tagname_ = 'relationship'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class pdb_cross_reference_type


class other_db_cross_reference_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, db_reference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if db_reference is None:
            self.db_reference = []
        else:
            self.db_reference = db_reference
        self.db_reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, other_db_cross_reference_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if other_db_cross_reference_list_type.subclass:
            return other_db_cross_reference_list_type.subclass(*args_, **kwargs_)
        else:
            return other_db_cross_reference_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_db_reference(self):
        return self.db_reference
    def set_db_reference(self, db_reference):
        self.db_reference = db_reference
    def add_db_reference(self, value):
        self.db_reference.append(value)
    def insert_db_reference_at(self, index, value):
        self.db_reference.insert(index, value)
    def replace_db_reference_at(self, index, value):
        self.db_reference[index] = value
    def has__content(self):
        if (
            self.db_reference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_db_cross_reference_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('other_db_cross_reference_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'other_db_cross_reference_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='other_db_cross_reference_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='other_db_cross_reference_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='other_db_cross_reference_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_db_cross_reference_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for db_reference_ in self.db_reference:
            namespaceprefix_ = self.db_reference_nsprefix_ + ':' if (UseCapturedNS_ and self.db_reference_nsprefix_) else ''
            db_reference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='db_reference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'db_reference':
            obj_ = other_db_cross_reference_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.db_reference.append(obj_)
            obj_.original_tagname_ = 'db_reference'
# end class other_db_cross_reference_list_type


class other_db_cross_reference_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, db_name=None, accession_id=None, content_type=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.db_name = db_name
        self.db_name_nsprefix_ = None
        self.accession_id = accession_id
        self.accession_id_nsprefix_ = None
        self.content_type = content_type
        self.content_type_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, other_db_cross_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if other_db_cross_reference_type.subclass:
            return other_db_cross_reference_type.subclass(*args_, **kwargs_)
        else:
            return other_db_cross_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_db_name(self):
        return self.db_name
    def set_db_name(self, db_name):
        self.db_name = db_name
    def get_accession_id(self):
        return self.accession_id
    def set_accession_id(self, accession_id):
        self.accession_id = accession_id
    def get_content_type(self):
        return self.content_type
    def set_content_type(self, content_type):
        self.content_type = content_type
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def has__content(self):
        if (
            self.db_name is not None or
            self.accession_id is not None or
            self.content_type is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_db_cross_reference_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('other_db_cross_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'other_db_cross_reference_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='other_db_cross_reference_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='other_db_cross_reference_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='other_db_cross_reference_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_db_cross_reference_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.db_name is not None:
            namespaceprefix_ = self.db_name_nsprefix_ + ':' if (UseCapturedNS_ and self.db_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdb_name>%s</%sdb_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.db_name), input_name='db_name')), namespaceprefix_ , eol_))
        if self.accession_id is not None:
            namespaceprefix_ = self.accession_id_nsprefix_ + ':' if (UseCapturedNS_ and self.accession_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccession_id>%s</%saccession_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.accession_id), input_name='accession_id')), namespaceprefix_ , eol_))
        if self.content_type is not None:
            namespaceprefix_ = self.content_type_nsprefix_ + ':' if (UseCapturedNS_ and self.content_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontent_type>%s</%scontent_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.content_type), input_name='content_type')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'db_name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'db_name')
            value_ = self.gds_validate_string(value_, node, 'db_name')
            self.db_name = value_
            self.db_name_nsprefix_ = child_.prefix
        elif nodeName_ == 'accession_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'accession_id')
            value_ = self.gds_validate_string(value_, node, 'accession_id')
            self.accession_id = value_
            self.accession_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'content_type':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'content_type')
            value_ = self.gds_validate_string(value_, node, 'content_type')
            self.content_type = value_
            self.content_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class other_db_cross_reference_type


class auxiliary_link_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, type_=None, link=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_ = type_
        self.validate_typeType8(self.type_)
        self.type__nsprefix_ = None
        self.link = link
        self.validate_linkType(self.link)
        self.link_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, auxiliary_link_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if auxiliary_link_type.subclass:
            return auxiliary_link_type.subclass(*args_, **kwargs_)
        else:
            return auxiliary_link_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_link(self):
        return self.link
    def set_link(self, link):
        self.link = link
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_typeType8(self, value):
        result = True
        # Validate type typeType8, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['2D EM DATA', 'CORRELATIVE LIGHT MICROSCOPY']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on typeType8' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_linkType(self, value):
        result = True
        # Validate type linkType, a restriction on xs:anyURI.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_linkType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_linkType_patterns_, ))
                result = False
        return result
    validate_linkType_patterns_ = [['^((https?|ftp)://.*)$']]
    def has__content(self):
        if (
            self.type_ is not None or
            self.link is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='auxiliary_link_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('auxiliary_link_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'auxiliary_link_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='auxiliary_link_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='auxiliary_link_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='auxiliary_link_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='auxiliary_link_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
        if self.link is not None:
            namespaceprefix_ = self.link_nsprefix_ + ':' if (UseCapturedNS_ and self.link_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slink>%s</%slink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.link), input_name='link')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
            # validate type typeType8
            self.validate_typeType8(self.type_)
        elif nodeName_ == 'link':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'link')
            value_ = self.gds_validate_string(value_, node, 'link')
            self.link = value_
            self.link_nsprefix_ = child_.prefix
            # validate type linkType
            self.validate_linkType(self.link)
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class auxiliary_link_type


class sample_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, supramolecule_list=None, macromolecule_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.supramolecule_list = supramolecule_list
        self.supramolecule_list_nsprefix_ = None
        self.macromolecule_list = macromolecule_list
        self.macromolecule_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_type.subclass:
            return sample_type.subclass(*args_, **kwargs_)
        else:
            return sample_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_supramolecule_list(self):
        return self.supramolecule_list
    def set_supramolecule_list(self, supramolecule_list):
        self.supramolecule_list = supramolecule_list
    def get_macromolecule_list(self):
        return self.macromolecule_list
    def set_macromolecule_list(self, macromolecule_list):
        self.macromolecule_list = macromolecule_list
    def has__content(self):
        if (
            self.name is not None or
            self.supramolecule_list is not None or
            self.macromolecule_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sample_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sample_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sample_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sample_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.supramolecule_list is not None:
            namespaceprefix_ = self.supramolecule_list_nsprefix_ + ':' if (UseCapturedNS_ and self.supramolecule_list_nsprefix_) else ''
            self.supramolecule_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='supramolecule_list', pretty_print=pretty_print)
        if self.macromolecule_list is not None:
            namespaceprefix_ = self.macromolecule_list_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecule_list_nsprefix_) else ''
            self.macromolecule_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='macromolecule_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'supramolecule_list':
            obj_ = supramolecule_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.supramolecule_list = obj_
            obj_.original_tagname_ = 'supramolecule_list'
        elif nodeName_ == 'macromolecule_list':
            obj_ = macromolecule_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule_list = obj_
            obj_.original_tagname_ = 'macromolecule_list'
# end class sample_type


class sci_name_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, synonym=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.synonym = _cast(None, synonym)
        self.synonym_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sci_name_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sci_name_type.subclass:
            return sci_name_type.subclass(*args_, **kwargs_)
        else:
            return sci_name_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_synonym(self):
        return self.synonym
    def set_synonym(self, synonym):
        self.synonym = synonym
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sci_name_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sci_name_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sci_name_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sci_name_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sci_name_type'):
        if self.synonym is not None and 'synonym' not in already_processed:
            already_processed.add('synonym')
            outfile.write(' synonym=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.synonym), input_name='synonym')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sci_name_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('synonym', node)
        if value is not None and 'synonym' not in already_processed:
            already_processed.add('synonym')
            self.synonym = value
            self.synonym = ' '.join(self.synonym.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class sci_name_type


class base_supramolecule_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.supramolecule_id = _cast(int, supramolecule_id)
        self.supramolecule_id_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.category = category
        self.category_nsprefix_ = None
        self.parent = parent
        self.parent_nsprefix_ = None
        self.macromolecule_list = macromolecule_list
        self.macromolecule_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.number_of_copies = number_of_copies
        self.validate_pos_int_or_string_type(self.number_of_copies)
        self.number_of_copies_nsprefix_ = None
        self.oligomeric_state = oligomeric_state
        self.validate_pos_int_or_string_type(self.oligomeric_state)
        self.oligomeric_state_nsprefix_ = None
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.external_references_nsprefix_ = None
        self.recombinant_exp_flag = recombinant_exp_flag
        self.recombinant_exp_flag_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_supramolecule_type.subclass:
            return base_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return base_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_category(self):
        return self.category
    def set_category(self, category):
        self.category = category
    def get_parent(self):
        return self.parent
    def set_parent(self, parent):
        self.parent = parent
    def get_macromolecule_list(self):
        return self.macromolecule_list
    def set_macromolecule_list(self, macromolecule_list):
        self.macromolecule_list = macromolecule_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_number_of_copies(self):
        return self.number_of_copies
    def set_number_of_copies(self, number_of_copies):
        self.number_of_copies = number_of_copies
    def get_oligomeric_state(self):
        return self.oligomeric_state
    def set_oligomeric_state(self, oligomeric_state):
        self.oligomeric_state = oligomeric_state
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def add_external_references(self, value):
        self.external_references.append(value)
    def insert_external_references_at(self, index, value):
        self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value):
        self.external_references[index] = value
    def get_recombinant_exp_flag(self):
        return self.recombinant_exp_flag
    def set_recombinant_exp_flag(self, recombinant_exp_flag):
        self.recombinant_exp_flag = recombinant_exp_flag
    def get_supramolecule_id(self):
        return self.supramolecule_id
    def set_supramolecule_id(self, supramolecule_id):
        self.supramolecule_id = supramolecule_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_pos_int_or_string_type(self, value):
        result = True
        # Validate type pos_int_or_string_type, a restriction on None.
        pass
        return result
    def has__content(self):
        if (
            self.name is not None or
            self.category is not None or
            self.parent is not None or
            self.macromolecule_list is not None or
            self.details is not None or
            self.number_of_copies is not None or
            self.oligomeric_state is not None or
            self.external_references or
            self.recombinant_exp_flag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_supramolecule_type'):
        if self.supramolecule_id is not None and 'supramolecule_id' not in already_processed:
            already_processed.add('supramolecule_id')
            outfile.write(' supramolecule_id="%s"' % self.gds_format_integer(self.supramolecule_id, input_name='supramolecule_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_supramolecule_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.category is not None:
            namespaceprefix_ = self.category_nsprefix_ + ':' if (UseCapturedNS_ and self.category_nsprefix_) else ''
            self.category.export(outfile, level, namespaceprefix_, namespacedef_='', name_='category', pretty_print=pretty_print)
        if self.parent is not None:
            namespaceprefix_ = self.parent_nsprefix_ + ':' if (UseCapturedNS_ and self.parent_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparent>%s</%sparent>%s' % (namespaceprefix_ , self.gds_format_integer(self.parent, input_name='parent'), namespaceprefix_ , eol_))
        if self.macromolecule_list is not None:
            namespaceprefix_ = self.macromolecule_list_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecule_list_nsprefix_) else ''
            self.macromolecule_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='macromolecule_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
        if self.number_of_copies is not None:
            namespaceprefix_ = self.number_of_copies_nsprefix_ + ':' if (UseCapturedNS_ and self.number_of_copies_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_of_copies>%s</%snumber_of_copies>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.number_of_copies), input_name='number_of_copies')), namespaceprefix_ , eol_))
        if self.oligomeric_state is not None:
            namespaceprefix_ = self.oligomeric_state_nsprefix_ + ':' if (UseCapturedNS_ and self.oligomeric_state_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomeric_state>%s</%soligomeric_state>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.oligomeric_state), input_name='oligomeric_state')), namespaceprefix_ , eol_))
        for external_references_ in self.external_references:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            external_references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
        if self.recombinant_exp_flag is not None:
            namespaceprefix_ = self.recombinant_exp_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_exp_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_exp_flag>%s</%srecombinant_exp_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.recombinant_exp_flag, input_name='recombinant_exp_flag'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('supramolecule_id', node)
        if value is not None and 'supramolecule_id' not in already_processed:
            already_processed.add('supramolecule_id')
            self.supramolecule_id = self.gds_parse_integer(value, node, 'supramolecule_id')
            if self.supramolecule_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'category':
            obj_ = categoryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.category = obj_
            obj_.original_tagname_ = 'category'
        elif nodeName_ == 'parent' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'parent')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'parent')
            self.parent = ival_
            self.parent_nsprefix_ = child_.prefix
        elif nodeName_ == 'macromolecule_list':
            obj_ = macromolecule_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule_list = obj_
            obj_.original_tagname_ = 'macromolecule_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
        elif nodeName_ == 'number_of_copies':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'number_of_copies')
            value_ = self.gds_validate_string(value_, node, 'number_of_copies')
            self.number_of_copies = value_
            self.number_of_copies_nsprefix_ = child_.prefix
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.number_of_copies)
        elif nodeName_ == 'oligomeric_state':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'oligomeric_state')
            value_ = self.gds_validate_string(value_, node, 'oligomeric_state')
            self.oligomeric_state = value_
            self.oligomeric_state_nsprefix_ = child_.prefix
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.oligomeric_state)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType10.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'recombinant_exp_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'recombinant_exp_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinant_exp_flag')
            self.recombinant_exp_flag = ival_
            self.recombinant_exp_flag_nsprefix_ = child_.prefix
# end class base_supramolecule_type


class cell_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("cell_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_supramolecule_type.subclass:
            return cell_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return cell_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def add_natural_source(self, value):
        self.natural_source.append(value)
    def insert_natural_source_at(self, index, value):
        self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value):
        self.natural_source[index] = value
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value):
        self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value):
        self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value):
        self.synthetic_source[index] = value
    def has__content(self):
        if (
            self.natural_source or
            self.synthetic_source or
            super(cell_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cell_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cell_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cell_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cell_supramolecule_type'):
        super(cell_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cell_supramolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(cell_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            natural_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            synthetic_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(cell_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'natural_source':
            obj_ = cell_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = cell_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        super(cell_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class cell_supramolecule_type


class base_source_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.database = _cast(None, database)
        self.database_nsprefix_ = None
        self.synthetically_produced = _cast(bool, synthetically_produced)
        self.synthetically_produced_nsprefix_ = None
        self.organism = organism
        self.organism_nsprefix_ = None
        self.strain = strain
        self.strain_nsprefix_ = None
        self.synonym_organism = synonym_organism
        self.synonym_organism_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_source_type.subclass:
            return base_source_type.subclass(*args_, **kwargs_)
        else:
            return base_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organism(self):
        return self.organism
    def set_organism(self, organism):
        self.organism = organism
    def get_strain(self):
        return self.strain
    def set_strain(self, strain):
        self.strain = strain
    def get_synonym_organism(self):
        return self.synonym_organism
    def set_synonym_organism(self, synonym_organism):
        self.synonym_organism = synonym_organism
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_database(self):
        return self.database
    def set_database(self, database):
        self.database = database
    def get_synthetically_produced(self):
        return self.synthetically_produced
    def set_synthetically_produced(self, synthetically_produced):
        self.synthetically_produced = synthetically_produced
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_databaseType(self, value):
        # Validate type databaseType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['NCBI']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on databaseType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.organism is not None or
            self.strain is not None or
            self.synonym_organism is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_source_type'):
        if self.database is not None and 'database' not in already_processed:
            already_processed.add('database')
            outfile.write(' database=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.database), input_name='database')), ))
        if self.synthetically_produced is not None and 'synthetically_produced' not in already_processed:
            already_processed.add('synthetically_produced')
            outfile.write(' synthetically_produced="%s"' % self.gds_format_boolean(self.synthetically_produced, input_name='synthetically_produced'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_source_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organism is not None:
            namespaceprefix_ = self.organism_nsprefix_ + ':' if (UseCapturedNS_ and self.organism_nsprefix_) else ''
            self.organism.export(outfile, level, namespaceprefix_, namespacedef_='', name_='organism', pretty_print=pretty_print)
        if self.strain is not None:
            namespaceprefix_ = self.strain_nsprefix_ + ':' if (UseCapturedNS_ and self.strain_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstrain>%s</%sstrain>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.strain), input_name='strain')), namespaceprefix_ , eol_))
        if self.synonym_organism is not None:
            namespaceprefix_ = self.synonym_organism_nsprefix_ + ':' if (UseCapturedNS_ and self.synonym_organism_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynonym_organism>%s</%ssynonym_organism>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.synonym_organism), input_name='synonym_organism')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('database', node)
        if value is not None and 'database' not in already_processed:
            already_processed.add('database')
            self.database = value
            self.database = ' '.join(self.database.split())
            self.validate_databaseType(self.database)    # validate type databaseType
        value = find_attr_value_('synthetically_produced', node)
        if value is not None and 'synthetically_produced' not in already_processed:
            already_processed.add('synthetically_produced')
            if value in ('true', '1'):
                self.synthetically_produced = True
            elif value in ('false', '0'):
                self.synthetically_produced = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organism':
            obj_ = organism_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.organism = obj_
            obj_.original_tagname_ = 'organism'
        elif nodeName_ == 'strain':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'strain')
            value_ = self.gds_validate_string(value_, node, 'strain')
            self.strain = value_
            self.strain_nsprefix_ = child_.prefix
        elif nodeName_ == 'synonym_organism':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'synonym_organism')
            value_ = self.gds_validate_string(value_, node, 'synonym_organism')
            self.synonym_organism = value_
            self.synonym_organism_nsprefix_ = child_.prefix
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class base_source_type


class organism_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ncbi=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ncbi = _cast(int, ncbi)
        self.ncbi_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organism_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organism_type.subclass:
            return organism_type.subclass(*args_, **kwargs_)
        else:
            return organism_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ncbi(self):
        return self.ncbi
    def set_ncbi(self, ncbi):
        self.ncbi = ncbi
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organism_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organism_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'organism_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='organism_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='organism_type'):
        if self.ncbi is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            outfile.write(' ncbi="%s"' % self.gds_format_integer(self.ncbi, input_name='ncbi'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organism_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ncbi', node)
        if value is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            self.ncbi = self.gds_parse_integer(value, node, 'ncbi')
            if self.ncbi <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class organism_type


class complex_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, chimera=True, natural_source=None, synthetic_source=None, recombinant_expression=None, molecular_weight=None, ribosome_details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("complex_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        self.chimera = _cast(bool, chimera)
        self.chimera_nsprefix_ = None
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
        if recombinant_expression is None:
            self.recombinant_expression = []
        else:
            self.recombinant_expression = recombinant_expression
        self.recombinant_expression_nsprefix_ = None
        self.molecular_weight = molecular_weight
        self.molecular_weight_nsprefix_ = None
        self.ribosome_details = ribosome_details
        self.ribosome_details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complex_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complex_supramolecule_type.subclass:
            return complex_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return complex_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def add_natural_source(self, value):
        self.natural_source.append(value)
    def insert_natural_source_at(self, index, value):
        self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value):
        self.natural_source[index] = value
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value):
        self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value):
        self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value):
        self.synthetic_source[index] = value
    def get_recombinant_expression(self):
        return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression):
        self.recombinant_expression = recombinant_expression
    def add_recombinant_expression(self, value):
        self.recombinant_expression.append(value)
    def insert_recombinant_expression_at(self, index, value):
        self.recombinant_expression.insert(index, value)
    def replace_recombinant_expression_at(self, index, value):
        self.recombinant_expression[index] = value
    def get_molecular_weight(self):
        return self.molecular_weight
    def set_molecular_weight(self, molecular_weight):
        self.molecular_weight = molecular_weight
    def get_ribosome_details(self):
        return self.ribosome_details
    def set_ribosome_details(self, ribosome_details):
        self.ribosome_details = ribosome_details
    def get_chimera(self):
        return self.chimera
    def set_chimera(self, chimera):
        self.chimera = chimera
    def has__content(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.recombinant_expression or
            self.molecular_weight is not None or
            self.ribosome_details is not None or
            super(complex_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complex_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'complex_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complex_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complex_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='complex_supramolecule_type'):
        super(complex_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complex_supramolecule_type')
        if not self.chimera and 'chimera' not in already_processed:
            already_processed.add('chimera')
            outfile.write(' chimera="%s"' % self.gds_format_boolean(self.chimera, input_name='chimera'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(complex_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            natural_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            synthetic_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
        for recombinant_expression_ in self.recombinant_expression:
            namespaceprefix_ = self.recombinant_expression_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_expression_nsprefix_) else ''
            recombinant_expression_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_expression', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            namespaceprefix_ = self.molecular_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_weight_nsprefix_) else ''
            self.molecular_weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_weight', pretty_print=pretty_print)
        if self.ribosome_details is not None:
            namespaceprefix_ = self.ribosome_details_nsprefix_ + ':' if (UseCapturedNS_ and self.ribosome_details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sribosome-details>%s</%sribosome-details>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ribosome_details), input_name='ribosome-details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('chimera', node)
        if value is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            if value in ('true', '1'):
                self.chimera = True
            elif value in ('false', '0'):
                self.chimera = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(complex_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'natural_source':
            obj_ = complex_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = complex_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_expression.append(obj_)
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'ribosome-details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ribosome_details')
            value_ = self.gds_validate_string(value_, node, 'ribosome_details')
            self.ribosome_details = value_
            self.ribosome_details_nsprefix_ = child_.prefix
        super(complex_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class complex_supramolecule_type


class complex_source_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("complex_source_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
        self.organ = organ
        self.organ_nsprefix_ = None
        self.tissue = tissue
        self.tissue_nsprefix_ = None
        self.cell = cell
        self.cell_nsprefix_ = None
        self.organelle = organelle
        self.organelle_nsprefix_ = None
        self.cellular_location = cellular_location
        self.cellular_location_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complex_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complex_source_type.subclass:
            return complex_source_type.subclass(*args_, **kwargs_)
        else:
            return complex_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organ(self):
        return self.organ
    def set_organ(self, organ):
        self.organ = organ
    def get_tissue(self):
        return self.tissue
    def set_tissue(self, tissue):
        self.tissue = tissue
    def get_cell(self):
        return self.cell
    def set_cell(self, cell):
        self.cell = cell
    def get_organelle(self):
        return self.organelle
    def set_organelle(self, organelle):
        self.organelle = organelle
    def get_cellular_location(self):
        return self.cellular_location
    def set_cellular_location(self, cellular_location):
        self.cellular_location = cellular_location
    def has__content(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(complex_source_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complex_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'complex_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complex_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complex_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='complex_source_type'):
        super(complex_source_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complex_source_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_source_type', fromsubclass_=False, pretty_print=True):
        super(complex_source_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            namespaceprefix_ = self.organ_nsprefix_ + ':' if (UseCapturedNS_ and self.organ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgan>%s</%sorgan>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), namespaceprefix_ , eol_))
        if self.tissue is not None:
            namespaceprefix_ = self.tissue_nsprefix_ + ':' if (UseCapturedNS_ and self.tissue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stissue>%s</%stissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), namespaceprefix_ , eol_))
        if self.cell is not None:
            namespaceprefix_ = self.cell_nsprefix_ + ':' if (UseCapturedNS_ and self.cell_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scell>%s</%scell>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), namespaceprefix_ , eol_))
        if self.organelle is not None:
            namespaceprefix_ = self.organelle_nsprefix_ + ':' if (UseCapturedNS_ and self.organelle_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganelle>%s</%sorganelle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), namespaceprefix_ , eol_))
        if self.cellular_location is not None:
            namespaceprefix_ = self.cellular_location_nsprefix_ + ':' if (UseCapturedNS_ and self.cellular_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scellular_location>%s</%scellular_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(complex_source_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organ':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organ')
            value_ = self.gds_validate_string(value_, node, 'organ')
            self.organ = value_
            self.organ_nsprefix_ = child_.prefix
        elif nodeName_ == 'tissue':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'tissue')
            value_ = self.gds_validate_string(value_, node, 'tissue')
            self.tissue = value_
            self.tissue_nsprefix_ = child_.prefix
        elif nodeName_ == 'cell':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cell')
            value_ = self.gds_validate_string(value_, node, 'cell')
            self.cell = value_
            self.cell_nsprefix_ = child_.prefix
        elif nodeName_ == 'organelle':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organelle')
            value_ = self.gds_validate_string(value_, node, 'organelle')
            self.organelle = value_
            self.organelle_nsprefix_ = child_.prefix
        elif nodeName_ == 'cellular_location':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cellular_location')
            value_ = self.gds_validate_string(value_, node, 'cellular_location')
            self.cellular_location = value_
            self.cellular_location_nsprefix_ = child_.prefix
        super(complex_source_type, self)._buildChildren(child_, node, nodeName_, True)
# end class complex_source_type


class recombinant_source_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, database=None, recombinant_organism=None, recombinant_strain=None, recombinant_cell=None, recombinant_plasmid=None, recombinant_synonym_organism=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.database = _cast(None, database)
        self.database_nsprefix_ = None
        self.recombinant_organism = recombinant_organism
        self.recombinant_organism_nsprefix_ = None
        self.recombinant_strain = recombinant_strain
        self.recombinant_strain_nsprefix_ = None
        self.recombinant_cell = recombinant_cell
        self.recombinant_cell_nsprefix_ = None
        self.recombinant_plasmid = recombinant_plasmid
        self.recombinant_plasmid_nsprefix_ = None
        self.recombinant_synonym_organism = recombinant_synonym_organism
        self.recombinant_synonym_organism_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, recombinant_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if recombinant_source_type.subclass:
            return recombinant_source_type.subclass(*args_, **kwargs_)
        else:
            return recombinant_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_recombinant_organism(self):
        return self.recombinant_organism
    def set_recombinant_organism(self, recombinant_organism):
        self.recombinant_organism = recombinant_organism
    def get_recombinant_strain(self):
        return self.recombinant_strain
    def set_recombinant_strain(self, recombinant_strain):
        self.recombinant_strain = recombinant_strain
    def get_recombinant_cell(self):
        return self.recombinant_cell
    def set_recombinant_cell(self, recombinant_cell):
        self.recombinant_cell = recombinant_cell
    def get_recombinant_plasmid(self):
        return self.recombinant_plasmid
    def set_recombinant_plasmid(self, recombinant_plasmid):
        self.recombinant_plasmid = recombinant_plasmid
    def get_recombinant_synonym_organism(self):
        return self.recombinant_synonym_organism
    def set_recombinant_synonym_organism(self, recombinant_synonym_organism):
        self.recombinant_synonym_organism = recombinant_synonym_organism
    def get_database(self):
        return self.database
    def set_database(self, database):
        self.database = database
    def validate_databaseType12(self, value):
        # Validate type databaseType12, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['NCBI']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on databaseType12' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.recombinant_organism is not None or
            self.recombinant_strain is not None or
            self.recombinant_cell is not None or
            self.recombinant_plasmid is not None or
            self.recombinant_synonym_organism is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='recombinant_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('recombinant_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'recombinant_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='recombinant_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='recombinant_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='recombinant_source_type'):
        if self.database is not None and 'database' not in already_processed:
            already_processed.add('database')
            outfile.write(' database=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.database), input_name='database')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='recombinant_source_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.recombinant_organism is not None:
            namespaceprefix_ = self.recombinant_organism_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_organism_nsprefix_) else ''
            self.recombinant_organism.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_organism', pretty_print=pretty_print)
        if self.recombinant_strain is not None:
            namespaceprefix_ = self.recombinant_strain_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_strain_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_strain>%s</%srecombinant_strain>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_strain), input_name='recombinant_strain')), namespaceprefix_ , eol_))
        if self.recombinant_cell is not None:
            namespaceprefix_ = self.recombinant_cell_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_cell_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_cell>%s</%srecombinant_cell>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_cell), input_name='recombinant_cell')), namespaceprefix_ , eol_))
        if self.recombinant_plasmid is not None:
            namespaceprefix_ = self.recombinant_plasmid_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_plasmid_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_plasmid>%s</%srecombinant_plasmid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_plasmid), input_name='recombinant_plasmid')), namespaceprefix_ , eol_))
        if self.recombinant_synonym_organism is not None:
            namespaceprefix_ = self.recombinant_synonym_organism_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_synonym_organism_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_synonym_organism>%s</%srecombinant_synonym_organism>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.recombinant_synonym_organism), input_name='recombinant_synonym_organism')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('database', node)
        if value is not None and 'database' not in already_processed:
            already_processed.add('database')
            self.database = value
            self.database = ' '.join(self.database.split())
            self.validate_databaseType12(self.database)    # validate type databaseType12
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'recombinant_organism':
            obj_ = organism_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_organism = obj_
            obj_.original_tagname_ = 'recombinant_organism'
        elif nodeName_ == 'recombinant_strain':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'recombinant_strain')
            value_ = self.gds_validate_string(value_, node, 'recombinant_strain')
            self.recombinant_strain = value_
            self.recombinant_strain_nsprefix_ = child_.prefix
        elif nodeName_ == 'recombinant_cell':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'recombinant_cell')
            value_ = self.gds_validate_string(value_, node, 'recombinant_cell')
            self.recombinant_cell = value_
            self.recombinant_cell_nsprefix_ = child_.prefix
        elif nodeName_ == 'recombinant_plasmid':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'recombinant_plasmid')
            value_ = self.gds_validate_string(value_, node, 'recombinant_plasmid')
            self.recombinant_plasmid = value_
            self.recombinant_plasmid_nsprefix_ = child_.prefix
        elif nodeName_ == 'recombinant_synonym_organism':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'recombinant_synonym_organism')
            value_ = self.gds_validate_string(value_, node, 'recombinant_synonym_organism')
            self.recombinant_synonym_organism = value_
            self.recombinant_synonym_organism_nsprefix_ = child_.prefix
# end class recombinant_source_type


class molecular_weight_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, experimental=None, theoretical=None, method=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.experimental = experimental
        self.experimental_nsprefix_ = None
        self.theoretical = theoretical
        self.theoretical_nsprefix_ = None
        self.method = method
        self.method_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, molecular_weight_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if molecular_weight_type.subclass:
            return molecular_weight_type.subclass(*args_, **kwargs_)
        else:
            return molecular_weight_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_experimental(self):
        return self.experimental
    def set_experimental(self, experimental):
        self.experimental = experimental
    def get_theoretical(self):
        return self.theoretical
    def set_theoretical(self, theoretical):
        self.theoretical = theoretical
    def get_method(self):
        return self.method
    def set_method(self, method):
        self.method = method
    def has__content(self):
        if (
            self.experimental is not None or
            self.theoretical is not None or
            self.method is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='molecular_weight_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('molecular_weight_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'molecular_weight_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='molecular_weight_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='molecular_weight_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='molecular_weight_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='molecular_weight_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.experimental is not None:
            namespaceprefix_ = self.experimental_nsprefix_ + ':' if (UseCapturedNS_ and self.experimental_nsprefix_) else ''
            self.experimental.export(outfile, level, namespaceprefix_, namespacedef_='', name_='experimental', pretty_print=pretty_print)
        if self.theoretical is not None:
            namespaceprefix_ = self.theoretical_nsprefix_ + ':' if (UseCapturedNS_ and self.theoretical_nsprefix_) else ''
            self.theoretical.export(outfile, level, namespaceprefix_, namespacedef_='', name_='theoretical', pretty_print=pretty_print)
        if self.method is not None:
            namespaceprefix_ = self.method_nsprefix_ + ':' if (UseCapturedNS_ and self.method_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethod>%s</%smethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'experimental':
            obj_ = experimentalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.experimental = obj_
            obj_.original_tagname_ = 'experimental'
        elif nodeName_ == 'theoretical':
            obj_ = theoreticalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.theoretical = obj_
            obj_.original_tagname_ = 'theoretical'
        elif nodeName_ == 'method':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'method')
            value_ = self.gds_validate_string(value_, node, 'method')
            self.method = value_
            self.method_nsprefix_ = child_.prefix
# end class molecular_weight_type


class organelle_or_cellular_component_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None, molecular_weight=None, recombinant_expression=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("organelle_or_cellular_component_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
        self.molecular_weight = molecular_weight
        self.molecular_weight_nsprefix_ = None
        self.recombinant_expression = recombinant_expression
        self.recombinant_expression_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organelle_or_cellular_component_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organelle_or_cellular_component_supramolecule_type.subclass:
            return organelle_or_cellular_component_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return organelle_or_cellular_component_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def add_natural_source(self, value):
        self.natural_source.append(value)
    def insert_natural_source_at(self, index, value):
        self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value):
        self.natural_source[index] = value
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value):
        self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value):
        self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value):
        self.synthetic_source[index] = value
    def get_molecular_weight(self):
        return self.molecular_weight
    def set_molecular_weight(self, molecular_weight):
        self.molecular_weight = molecular_weight
    def get_recombinant_expression(self):
        return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression):
        self.recombinant_expression = recombinant_expression
    def has__content(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.molecular_weight is not None or
            self.recombinant_expression is not None or
            super(organelle_or_cellular_component_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organelle_or_cellular_component_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organelle_or_cellular_component_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'organelle_or_cellular_component_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='organelle_or_cellular_component_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='organelle_or_cellular_component_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='organelle_or_cellular_component_supramolecule_type'):
        super(organelle_or_cellular_component_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='organelle_or_cellular_component_supramolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organelle_or_cellular_component_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(organelle_or_cellular_component_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            natural_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            synthetic_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            namespaceprefix_ = self.molecular_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_weight_nsprefix_) else ''
            self.molecular_weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_weight', pretty_print=pretty_print)
        if self.recombinant_expression is not None:
            namespaceprefix_ = self.recombinant_expression_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_expression_nsprefix_) else ''
            self.recombinant_expression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_expression', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(organelle_or_cellular_component_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'natural_source':
            obj_ = organelle_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = organelle_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        super(organelle_or_cellular_component_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class organelle_or_cellular_component_supramolecule_type


class organelle_source_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("organelle_source_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
        self.organ = organ
        self.organ_nsprefix_ = None
        self.tissue = tissue
        self.tissue_nsprefix_ = None
        self.cell = cell
        self.cell_nsprefix_ = None
        self.organelle = organelle
        self.organelle_nsprefix_ = None
        self.cellular_location = cellular_location
        self.cellular_location_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organelle_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organelle_source_type.subclass:
            return organelle_source_type.subclass(*args_, **kwargs_)
        else:
            return organelle_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organ(self):
        return self.organ
    def set_organ(self, organ):
        self.organ = organ
    def get_tissue(self):
        return self.tissue
    def set_tissue(self, tissue):
        self.tissue = tissue
    def get_cell(self):
        return self.cell
    def set_cell(self, cell):
        self.cell = cell
    def get_organelle(self):
        return self.organelle
    def set_organelle(self, organelle):
        self.organelle = organelle
    def get_cellular_location(self):
        return self.cellular_location
    def set_cellular_location(self, cellular_location):
        self.cellular_location = cellular_location
    def has__content(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(organelle_source_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organelle_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organelle_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'organelle_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='organelle_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='organelle_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='organelle_source_type'):
        super(organelle_source_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='organelle_source_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='organelle_source_type', fromsubclass_=False, pretty_print=True):
        super(organelle_source_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            namespaceprefix_ = self.organ_nsprefix_ + ':' if (UseCapturedNS_ and self.organ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgan>%s</%sorgan>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), namespaceprefix_ , eol_))
        if self.tissue is not None:
            namespaceprefix_ = self.tissue_nsprefix_ + ':' if (UseCapturedNS_ and self.tissue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stissue>%s</%stissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), namespaceprefix_ , eol_))
        if self.cell is not None:
            namespaceprefix_ = self.cell_nsprefix_ + ':' if (UseCapturedNS_ and self.cell_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scell>%s</%scell>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), namespaceprefix_ , eol_))
        if self.organelle is not None:
            namespaceprefix_ = self.organelle_nsprefix_ + ':' if (UseCapturedNS_ and self.organelle_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganelle>%s</%sorganelle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), namespaceprefix_ , eol_))
        if self.cellular_location is not None:
            namespaceprefix_ = self.cellular_location_nsprefix_ + ':' if (UseCapturedNS_ and self.cellular_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scellular_location>%s</%scellular_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(organelle_source_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organ':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organ')
            value_ = self.gds_validate_string(value_, node, 'organ')
            self.organ = value_
            self.organ_nsprefix_ = child_.prefix
        elif nodeName_ == 'tissue':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'tissue')
            value_ = self.gds_validate_string(value_, node, 'tissue')
            self.tissue = value_
            self.tissue_nsprefix_ = child_.prefix
        elif nodeName_ == 'cell':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cell')
            value_ = self.gds_validate_string(value_, node, 'cell')
            self.cell = value_
            self.cell_nsprefix_ = child_.prefix
        elif nodeName_ == 'organelle':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organelle')
            value_ = self.gds_validate_string(value_, node, 'organelle')
            self.organelle = value_
            self.organelle_nsprefix_ = child_.prefix
        elif nodeName_ == 'cellular_location':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cellular_location')
            value_ = self.gds_validate_string(value_, node, 'cellular_location')
            self.cellular_location = value_
            self.cellular_location_nsprefix_ = child_.prefix
        super(organelle_source_type, self)._buildChildren(child_, node, nodeName_, True)
# end class organelle_source_type


class sample_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, synthetic_source=None, number_unique_components=None, molecular_weight=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("sample_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        if synthetic_source is None:
            self.synthetic_source = []
        else:
            self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
        self.number_unique_components = number_unique_components
        self.number_unique_components_nsprefix_ = None
        self.molecular_weight = molecular_weight
        self.molecular_weight_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_supramolecule_type.subclass:
            return sample_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return sample_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def add_natural_source(self, value):
        self.natural_source.append(value)
    def insert_natural_source_at(self, index, value):
        self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value):
        self.natural_source[index] = value
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def add_synthetic_source(self, value):
        self.synthetic_source.append(value)
    def insert_synthetic_source_at(self, index, value):
        self.synthetic_source.insert(index, value)
    def replace_synthetic_source_at(self, index, value):
        self.synthetic_source[index] = value
    def get_number_unique_components(self):
        return self.number_unique_components
    def set_number_unique_components(self, number_unique_components):
        self.number_unique_components = number_unique_components
    def get_molecular_weight(self):
        return self.molecular_weight
    def set_molecular_weight(self, molecular_weight):
        self.molecular_weight = molecular_weight
    def has__content(self):
        if (
            self.natural_source or
            self.synthetic_source or
            self.number_unique_components is not None or
            self.molecular_weight is not None or
            super(sample_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sample_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sample_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sample_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sample_supramolecule_type'):
        super(sample_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sample_supramolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(sample_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            natural_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        for synthetic_source_ in self.synthetic_source:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            synthetic_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
        if self.number_unique_components is not None:
            namespaceprefix_ = self.number_unique_components_nsprefix_ + ':' if (UseCapturedNS_ and self.number_unique_components_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_unique_components>%s</%snumber_unique_components>%s' % (namespaceprefix_ , self.gds_format_integer(self.number_unique_components, input_name='number_unique_components'), namespaceprefix_ , eol_))
        if self.molecular_weight is not None:
            namespaceprefix_ = self.molecular_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_weight_nsprefix_) else ''
            self.molecular_weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_weight', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(sample_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'natural_source':
            obj_ = sample_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'synthetic_source':
            obj_ = sample_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source.append(obj_)
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'number_unique_components' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'number_unique_components')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_unique_components')
            self.number_unique_components = ival_
            self.number_unique_components_nsprefix_ = child_.prefix
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        super(sample_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class sample_supramolecule_type


class sample_source_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, organ=None, tissue=None, cell=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("sample_source_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
        self.organ = organ
        self.organ_nsprefix_ = None
        self.tissue = tissue
        self.tissue_nsprefix_ = None
        self.cell = cell
        self.cell_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sample_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sample_source_type.subclass:
            return sample_source_type.subclass(*args_, **kwargs_)
        else:
            return sample_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organ(self):
        return self.organ
    def set_organ(self, organ):
        self.organ = organ
    def get_tissue(self):
        return self.tissue
    def set_tissue(self, tissue):
        self.tissue = tissue
    def get_cell(self):
        return self.cell
    def set_cell(self, cell):
        self.cell = cell
    def has__content(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            super(sample_source_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sample_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sample_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sample_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sample_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sample_source_type'):
        super(sample_source_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sample_source_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sample_source_type', fromsubclass_=False, pretty_print=True):
        super(sample_source_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            namespaceprefix_ = self.organ_nsprefix_ + ':' if (UseCapturedNS_ and self.organ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgan>%s</%sorgan>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), namespaceprefix_ , eol_))
        if self.tissue is not None:
            namespaceprefix_ = self.tissue_nsprefix_ + ':' if (UseCapturedNS_ and self.tissue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stissue>%s</%stissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), namespaceprefix_ , eol_))
        if self.cell is not None:
            namespaceprefix_ = self.cell_nsprefix_ + ':' if (UseCapturedNS_ and self.cell_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scell>%s</%scell>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(sample_source_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organ':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organ')
            value_ = self.gds_validate_string(value_, node, 'organ')
            self.organ = value_
            self.organ_nsprefix_ = child_.prefix
        elif nodeName_ == 'tissue':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'tissue')
            value_ = self.gds_validate_string(value_, node, 'tissue')
            self.tissue = value_
            self.tissue_nsprefix_ = child_.prefix
        elif nodeName_ == 'cell':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cell')
            value_ = self.gds_validate_string(value_, node, 'cell')
            self.cell = value_
            self.cell_nsprefix_ = child_.prefix
        super(sample_source_type, self)._buildChildren(child_, node, nodeName_, True)
# end class sample_source_type


class tissue_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, natural_source=None, sythetic_source=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("tissue_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        if natural_source is None:
            self.natural_source = []
        else:
            self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        if sythetic_source is None:
            self.sythetic_source = []
        else:
            self.sythetic_source = sythetic_source
        self.sythetic_source_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tissue_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tissue_supramolecule_type.subclass:
            return tissue_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return tissue_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def add_natural_source(self, value):
        self.natural_source.append(value)
    def insert_natural_source_at(self, index, value):
        self.natural_source.insert(index, value)
    def replace_natural_source_at(self, index, value):
        self.natural_source[index] = value
    def get_sythetic_source(self):
        return self.sythetic_source
    def set_sythetic_source(self, sythetic_source):
        self.sythetic_source = sythetic_source
    def add_sythetic_source(self, value):
        self.sythetic_source.append(value)
    def insert_sythetic_source_at(self, index, value):
        self.sythetic_source.insert(index, value)
    def replace_sythetic_source_at(self, index, value):
        self.sythetic_source[index] = value
    def has__content(self):
        if (
            self.natural_source or
            self.sythetic_source or
            super(tissue_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tissue_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tissue_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'tissue_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tissue_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='tissue_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='tissue_supramolecule_type'):
        super(tissue_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tissue_supramolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tissue_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(tissue_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for natural_source_ in self.natural_source:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            natural_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        for sythetic_source_ in self.sythetic_source:
            namespaceprefix_ = self.sythetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.sythetic_source_nsprefix_) else ''
            sythetic_source_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sythetic_source', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(tissue_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'natural_source':
            obj_ = tissue_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source.append(obj_)
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'sythetic_source':
            obj_ = tissue_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sythetic_source.append(obj_)
            obj_.original_tagname_ = 'sythetic_source'
        super(tissue_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class tissue_supramolecule_type


class tissue_source_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, organ=None, tissue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("tissue_source_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
        self.organ = organ
        self.organ_nsprefix_ = None
        self.tissue = tissue
        self.tissue_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tissue_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tissue_source_type.subclass:
            return tissue_source_type.subclass(*args_, **kwargs_)
        else:
            return tissue_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organ(self):
        return self.organ
    def set_organ(self, organ):
        self.organ = organ
    def get_tissue(self):
        return self.tissue
    def set_tissue(self, tissue):
        self.tissue = tissue
    def has__content(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            super(tissue_source_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tissue_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tissue_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'tissue_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tissue_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='tissue_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='tissue_source_type'):
        super(tissue_source_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tissue_source_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tissue_source_type', fromsubclass_=False, pretty_print=True):
        super(tissue_source_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            namespaceprefix_ = self.organ_nsprefix_ + ':' if (UseCapturedNS_ and self.organ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgan>%s</%sorgan>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), namespaceprefix_ , eol_))
        if self.tissue is not None:
            namespaceprefix_ = self.tissue_nsprefix_ + ':' if (UseCapturedNS_ and self.tissue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stissue>%s</%stissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(tissue_source_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organ':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organ')
            value_ = self.gds_validate_string(value_, node, 'organ')
            self.organ = value_
            self.organ_nsprefix_ = child_.prefix
        elif nodeName_ == 'tissue':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'tissue')
            value_ = self.gds_validate_string(value_, node, 'tissue')
            self.tissue = value_
            self.tissue_nsprefix_ = child_.prefix
        super(tissue_source_type, self)._buildChildren(child_, node, nodeName_, True)
# end class tissue_source_type


class virus_supramolecule_type(base_supramolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_supramolecule_type
    def __init__(self, supramolecule_id=None, name=None, category=None, parent=None, macromolecule_list=None, details=None, number_of_copies=None, oligomeric_state=None, external_references=None, recombinant_exp_flag=None, sci_species_name=None, sci_species_strain=None, natural_host=None, synthetic_host=None, host_system=None, molecular_weight=None, virus_shell=None, virus_type=None, virus_isolate=None, virus_enveloped=None, virus_empty=None, syn_species_name=None, sci_species_serotype=None, sci_species_serocomplex=None, sci_species_subspecies=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("virus_supramolecule_type"), self).__init__(supramolecule_id, name, category, parent, macromolecule_list, details, number_of_copies, oligomeric_state, external_references, recombinant_exp_flag,  **kwargs_)
        self.sci_species_name = sci_species_name
        self.sci_species_name_nsprefix_ = None
        self.sci_species_strain = sci_species_strain
        self.sci_species_strain_nsprefix_ = None
        if natural_host is None:
            self.natural_host = []
        else:
            self.natural_host = natural_host
        self.natural_host_nsprefix_ = None
        if synthetic_host is None:
            self.synthetic_host = []
        else:
            self.synthetic_host = synthetic_host
        self.synthetic_host_nsprefix_ = None
        self.host_system = host_system
        self.host_system_nsprefix_ = None
        self.molecular_weight = molecular_weight
        self.molecular_weight_nsprefix_ = None
        if virus_shell is None:
            self.virus_shell = []
        else:
            self.virus_shell = virus_shell
        self.virus_shell_nsprefix_ = None
        self.virus_type = virus_type
        self.validate_virus_typeType(self.virus_type)
        self.virus_type_nsprefix_ = None
        self.virus_isolate = virus_isolate
        self.validate_virus_isolateType(self.virus_isolate)
        self.virus_isolate_nsprefix_ = None
        self.virus_enveloped = virus_enveloped
        self.virus_enveloped_nsprefix_ = None
        self.virus_empty = virus_empty
        self.virus_empty_nsprefix_ = None
        self.syn_species_name = syn_species_name
        self.syn_species_name_nsprefix_ = None
        self.sci_species_serotype = sci_species_serotype
        self.sci_species_serotype_nsprefix_ = None
        self.sci_species_serocomplex = sci_species_serocomplex
        self.sci_species_serocomplex_nsprefix_ = None
        self.sci_species_subspecies = sci_species_subspecies
        self.sci_species_subspecies_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_supramolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_supramolecule_type.subclass:
            return virus_supramolecule_type.subclass(*args_, **kwargs_)
        else:
            return virus_supramolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_sci_species_name(self):
        return self.sci_species_name
    def set_sci_species_name(self, sci_species_name):
        self.sci_species_name = sci_species_name
    def get_sci_species_strain(self):
        return self.sci_species_strain
    def set_sci_species_strain(self, sci_species_strain):
        self.sci_species_strain = sci_species_strain
    def get_natural_host(self):
        return self.natural_host
    def set_natural_host(self, natural_host):
        self.natural_host = natural_host
    def add_natural_host(self, value):
        self.natural_host.append(value)
    def insert_natural_host_at(self, index, value):
        self.natural_host.insert(index, value)
    def replace_natural_host_at(self, index, value):
        self.natural_host[index] = value
    def get_synthetic_host(self):
        return self.synthetic_host
    def set_synthetic_host(self, synthetic_host):
        self.synthetic_host = synthetic_host
    def add_synthetic_host(self, value):
        self.synthetic_host.append(value)
    def insert_synthetic_host_at(self, index, value):
        self.synthetic_host.insert(index, value)
    def replace_synthetic_host_at(self, index, value):
        self.synthetic_host[index] = value
    def get_host_system(self):
        return self.host_system
    def set_host_system(self, host_system):
        self.host_system = host_system
    def get_molecular_weight(self):
        return self.molecular_weight
    def set_molecular_weight(self, molecular_weight):
        self.molecular_weight = molecular_weight
    def get_virus_shell(self):
        return self.virus_shell
    def set_virus_shell(self, virus_shell):
        self.virus_shell = virus_shell
    def add_virus_shell(self, value):
        self.virus_shell.append(value)
    def insert_virus_shell_at(self, index, value):
        self.virus_shell.insert(index, value)
    def replace_virus_shell_at(self, index, value):
        self.virus_shell[index] = value
    def get_virus_type(self):
        return self.virus_type
    def set_virus_type(self, virus_type):
        self.virus_type = virus_type
    def get_virus_isolate(self):
        return self.virus_isolate
    def set_virus_isolate(self, virus_isolate):
        self.virus_isolate = virus_isolate
    def get_virus_enveloped(self):
        return self.virus_enveloped
    def set_virus_enveloped(self, virus_enveloped):
        self.virus_enveloped = virus_enveloped
    def get_virus_empty(self):
        return self.virus_empty
    def set_virus_empty(self, virus_empty):
        self.virus_empty = virus_empty
    def get_syn_species_name(self):
        return self.syn_species_name
    def set_syn_species_name(self, syn_species_name):
        self.syn_species_name = syn_species_name
    def get_sci_species_serotype(self):
        return self.sci_species_serotype
    def set_sci_species_serotype(self, sci_species_serotype):
        self.sci_species_serotype = sci_species_serotype
    def get_sci_species_serocomplex(self):
        return self.sci_species_serocomplex
    def set_sci_species_serocomplex(self, sci_species_serocomplex):
        self.sci_species_serocomplex = sci_species_serocomplex
    def get_sci_species_subspecies(self):
        return self.sci_species_subspecies
    def set_sci_species_subspecies(self, sci_species_subspecies):
        self.sci_species_subspecies = sci_species_subspecies
    def validate_virus_typeType(self, value):
        result = True
        # Validate type virus_typeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PRION', 'SATELLITE', 'VIRION', 'VIROID', 'VIRUS-LIKE PARTICLE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on virus_typeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_virus_isolateType(self, value):
        result = True
        # Validate type virus_isolateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['OTHER', 'SEROCOMPLEX', 'SEROTYPE', 'SPECIES', 'STRAIN', 'SUBSPECIES']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on virus_isolateType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.sci_species_name is not None or
            self.sci_species_strain is not None or
            self.natural_host or
            self.synthetic_host or
            self.host_system is not None or
            self.molecular_weight is not None or
            self.virus_shell or
            self.virus_type is not None or
            self.virus_isolate is not None or
            self.virus_enveloped is not None or
            self.virus_empty is not None or
            self.syn_species_name is not None or
            self.sci_species_serotype is not None or
            self.sci_species_serocomplex is not None or
            self.sci_species_subspecies is not None or
            super(virus_supramolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_supramolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_supramolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'virus_supramolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='virus_supramolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='virus_supramolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='virus_supramolecule_type'):
        super(virus_supramolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='virus_supramolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_supramolecule_type', fromsubclass_=False, pretty_print=True):
        super(virus_supramolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sci_species_name is not None:
            namespaceprefix_ = self.sci_species_name_nsprefix_ + ':' if (UseCapturedNS_ and self.sci_species_name_nsprefix_) else ''
            self.sci_species_name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sci_species_name', pretty_print=pretty_print)
        if self.sci_species_strain is not None:
            namespaceprefix_ = self.sci_species_strain_nsprefix_ + ':' if (UseCapturedNS_ and self.sci_species_strain_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssci_species_strain>%s</%ssci_species_strain>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_strain), input_name='sci_species_strain')), namespaceprefix_ , eol_))
        for natural_host_ in self.natural_host:
            namespaceprefix_ = self.natural_host_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_host_nsprefix_) else ''
            natural_host_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_host', pretty_print=pretty_print)
        for synthetic_host_ in self.synthetic_host:
            namespaceprefix_ = self.synthetic_host_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_host_nsprefix_) else ''
            synthetic_host_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_host', pretty_print=pretty_print)
        if self.host_system is not None:
            namespaceprefix_ = self.host_system_nsprefix_ + ':' if (UseCapturedNS_ and self.host_system_nsprefix_) else ''
            self.host_system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='host_system', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            namespaceprefix_ = self.molecular_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_weight_nsprefix_) else ''
            self.molecular_weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_weight', pretty_print=pretty_print)
        for virus_shell_ in self.virus_shell:
            namespaceprefix_ = self.virus_shell_nsprefix_ + ':' if (UseCapturedNS_ and self.virus_shell_nsprefix_) else ''
            virus_shell_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='virus_shell', pretty_print=pretty_print)
        if self.virus_type is not None:
            namespaceprefix_ = self.virus_type_nsprefix_ + ':' if (UseCapturedNS_ and self.virus_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirus_type>%s</%svirus_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.virus_type), input_name='virus_type')), namespaceprefix_ , eol_))
        if self.virus_isolate is not None:
            namespaceprefix_ = self.virus_isolate_nsprefix_ + ':' if (UseCapturedNS_ and self.virus_isolate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirus_isolate>%s</%svirus_isolate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.virus_isolate), input_name='virus_isolate')), namespaceprefix_ , eol_))
        if self.virus_enveloped is not None:
            namespaceprefix_ = self.virus_enveloped_nsprefix_ + ':' if (UseCapturedNS_ and self.virus_enveloped_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirus_enveloped>%s</%svirus_enveloped>%s' % (namespaceprefix_ , self.gds_format_boolean(self.virus_enveloped, input_name='virus_enveloped'), namespaceprefix_ , eol_))
        if self.virus_empty is not None:
            namespaceprefix_ = self.virus_empty_nsprefix_ + ':' if (UseCapturedNS_ and self.virus_empty_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svirus_empty>%s</%svirus_empty>%s' % (namespaceprefix_ , self.gds_format_boolean(self.virus_empty, input_name='virus_empty'), namespaceprefix_ , eol_))
        if self.syn_species_name is not None:
            namespaceprefix_ = self.syn_species_name_nsprefix_ + ':' if (UseCapturedNS_ and self.syn_species_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssyn_species_name>%s</%ssyn_species_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.syn_species_name), input_name='syn_species_name')), namespaceprefix_ , eol_))
        if self.sci_species_serotype is not None:
            namespaceprefix_ = self.sci_species_serotype_nsprefix_ + ':' if (UseCapturedNS_ and self.sci_species_serotype_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssci_species_serotype>%s</%ssci_species_serotype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_serotype), input_name='sci_species_serotype')), namespaceprefix_ , eol_))
        if self.sci_species_serocomplex is not None:
            namespaceprefix_ = self.sci_species_serocomplex_nsprefix_ + ':' if (UseCapturedNS_ and self.sci_species_serocomplex_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssci_species_serocomplex>%s</%ssci_species_serocomplex>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_serocomplex), input_name='sci_species_serocomplex')), namespaceprefix_ , eol_))
        if self.sci_species_subspecies is not None:
            namespaceprefix_ = self.sci_species_subspecies_nsprefix_ + ':' if (UseCapturedNS_ and self.sci_species_subspecies_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssci_species_subspecies>%s</%ssci_species_subspecies>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sci_species_subspecies), input_name='sci_species_subspecies')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(virus_supramolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'sci_species_name':
            obj_ = virus_species_name_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sci_species_name = obj_
            obj_.original_tagname_ = 'sci_species_name'
        elif nodeName_ == 'sci_species_strain':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sci_species_strain')
            value_ = self.gds_validate_string(value_, node, 'sci_species_strain')
            self.sci_species_strain = value_
            self.sci_species_strain_nsprefix_ = child_.prefix
        elif nodeName_ == 'natural_host':
            obj_ = virus_host_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_host.append(obj_)
            obj_.original_tagname_ = 'natural_host'
        elif nodeName_ == 'synthetic_host':
            obj_ = virus_host_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_host.append(obj_)
            obj_.original_tagname_ = 'synthetic_host'
        elif nodeName_ == 'host_system':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.host_system = obj_
            obj_.original_tagname_ = 'host_system'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'virus_shell':
            obj_ = virus_shellType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.virus_shell.append(obj_)
            obj_.original_tagname_ = 'virus_shell'
        elif nodeName_ == 'virus_type':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'virus_type')
            value_ = self.gds_validate_string(value_, node, 'virus_type')
            self.virus_type = value_
            self.virus_type_nsprefix_ = child_.prefix
            # validate type virus_typeType
            self.validate_virus_typeType(self.virus_type)
        elif nodeName_ == 'virus_isolate':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'virus_isolate')
            value_ = self.gds_validate_string(value_, node, 'virus_isolate')
            self.virus_isolate = value_
            self.virus_isolate_nsprefix_ = child_.prefix
            # validate type virus_isolateType
            self.validate_virus_isolateType(self.virus_isolate)
        elif nodeName_ == 'virus_enveloped':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'virus_enveloped')
            ival_ = self.gds_validate_boolean(ival_, node, 'virus_enveloped')
            self.virus_enveloped = ival_
            self.virus_enveloped_nsprefix_ = child_.prefix
        elif nodeName_ == 'virus_empty':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'virus_empty')
            ival_ = self.gds_validate_boolean(ival_, node, 'virus_empty')
            self.virus_empty = ival_
            self.virus_empty_nsprefix_ = child_.prefix
        elif nodeName_ == 'syn_species_name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'syn_species_name')
            value_ = self.gds_validate_string(value_, node, 'syn_species_name')
            self.syn_species_name = value_
            self.syn_species_name_nsprefix_ = child_.prefix
        elif nodeName_ == 'sci_species_serotype':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sci_species_serotype')
            value_ = self.gds_validate_string(value_, node, 'sci_species_serotype')
            self.sci_species_serotype = value_
            self.sci_species_serotype_nsprefix_ = child_.prefix
        elif nodeName_ == 'sci_species_serocomplex':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sci_species_serocomplex')
            value_ = self.gds_validate_string(value_, node, 'sci_species_serocomplex')
            self.sci_species_serocomplex = value_
            self.sci_species_serocomplex_nsprefix_ = child_.prefix
        elif nodeName_ == 'sci_species_subspecies':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'sci_species_subspecies')
            value_ = self.gds_validate_string(value_, node, 'sci_species_subspecies')
            self.sci_species_subspecies = value_
            self.sci_species_subspecies_nsprefix_ = child_.prefix
        super(virus_supramolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class virus_supramolecule_type


class virus_species_name_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ncbi=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ncbi = _cast(int, ncbi)
        self.ncbi_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_species_name_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_species_name_type.subclass:
            return virus_species_name_type.subclass(*args_, **kwargs_)
        else:
            return virus_species_name_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ncbi(self):
        return self.ncbi
    def set_ncbi(self, ncbi):
        self.ncbi = ncbi
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_species_name_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_species_name_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'virus_species_name_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='virus_species_name_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='virus_species_name_type'):
        if self.ncbi is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            outfile.write(' ncbi="%s"' % self.gds_format_integer(self.ncbi, input_name='ncbi'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_species_name_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ncbi', node)
        if value is not None and 'ncbi' not in already_processed:
            already_processed.add('ncbi')
            self.ncbi = self.gds_parse_integer(value, node, 'ncbi')
            if self.ncbi <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class virus_species_name_type


class virus_host_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("virus_host_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, virus_host_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if virus_host_type.subclass:
            return virus_host_type.subclass(*args_, **kwargs_)
        else:
            return virus_host_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(virus_host_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_host_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('virus_host_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'virus_host_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='virus_host_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='virus_host_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='virus_host_type'):
        super(virus_host_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='virus_host_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='virus_host_type', fromsubclass_=False, pretty_print=True):
        super(virus_host_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(virus_host_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(virus_host_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class virus_host_type


class macromolecule_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, macromolecule=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if macromolecule is None:
            self.macromolecule = []
        else:
            self.macromolecule = macromolecule
        self.macromolecule_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_list_type.subclass:
            return macromolecule_list_type.subclass(*args_, **kwargs_)
        else:
            return macromolecule_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_macromolecule(self):
        return self.macromolecule
    def set_macromolecule(self, macromolecule):
        self.macromolecule = macromolecule
    def add_macromolecule(self, value):
        self.macromolecule.append(value)
    def insert_macromolecule_at(self, index, value):
        self.macromolecule.insert(index, value)
    def replace_macromolecule_at(self, index, value):
        self.macromolecule[index] = value
    def has__content(self):
        if (
            self.macromolecule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'macromolecule_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='macromolecule_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='macromolecule_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='macromolecule_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_ in self.macromolecule:
            macromolecule_.export(outfile, level, namespaceprefix_, namespacedef_='', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'macromolecule':
            class_obj_ = self.get_class_obj_(child_, base_macromolecule_type)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'macromolecule'
        elif nodeName_ == 'dna':
            obj_ = dna_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'dna'
        elif nodeName_ == 'em_label':
            obj_ = em_label_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'em_label'
        elif nodeName_ == 'ligand':
            obj_ = ligand_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'ligand'
        elif nodeName_ == 'other_macromolecule':
            obj_ = other_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'other_macromolecule'
        elif nodeName_ == 'protein_or_peptide':
            obj_ = protein_or_peptide_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'protein_or_peptide'
        elif nodeName_ == 'rna':
            obj_ = rna_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'rna'
        elif nodeName_ == 'saccharide':
            obj_ = saccharide_macromolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'saccharide'
# end class macromolecule_list_type


class base_macromolecule_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.macromolecule_id = _cast(int, macromolecule_id)
        self.macromolecule_id_nsprefix_ = None
        self.mutant = _cast(bool, mutant)
        self.mutant_nsprefix_ = None
        self.chimera = _cast(bool, chimera)
        self.chimera_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.natural_source = natural_source
        self.natural_source_nsprefix_ = None
        self.molecular_weight = molecular_weight
        self.molecular_weight_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.number_of_copies = number_of_copies
        self.validate_pos_int_or_string_type(self.number_of_copies)
        self.number_of_copies_nsprefix_ = None
        self.oligomeric_state = oligomeric_state
        self.validate_pos_int_or_string_type(self.oligomeric_state)
        self.oligomeric_state_nsprefix_ = None
        self.recombinant_exp_flag = recombinant_exp_flag
        self.recombinant_exp_flag_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_macromolecule_type.subclass:
            return base_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return base_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_natural_source(self):
        return self.natural_source
    def set_natural_source(self, natural_source):
        self.natural_source = natural_source
    def get_molecular_weight(self):
        return self.molecular_weight
    def set_molecular_weight(self, molecular_weight):
        self.molecular_weight = molecular_weight
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_number_of_copies(self):
        return self.number_of_copies
    def set_number_of_copies(self, number_of_copies):
        self.number_of_copies = number_of_copies
    def get_oligomeric_state(self):
        return self.oligomeric_state
    def set_oligomeric_state(self, oligomeric_state):
        self.oligomeric_state = oligomeric_state
    def get_recombinant_exp_flag(self):
        return self.recombinant_exp_flag
    def set_recombinant_exp_flag(self, recombinant_exp_flag):
        self.recombinant_exp_flag = recombinant_exp_flag
    def get_macromolecule_id(self):
        return self.macromolecule_id
    def set_macromolecule_id(self, macromolecule_id):
        self.macromolecule_id = macromolecule_id
    def get_mutant(self):
        return self.mutant
    def set_mutant(self, mutant):
        self.mutant = mutant
    def get_chimera(self):
        return self.chimera
    def set_chimera(self, chimera):
        self.chimera = chimera
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_pos_int_or_string_type(self, value):
        result = True
        # Validate type pos_int_or_string_type, a restriction on None.
        pass
        return result
    def has__content(self):
        if (
            self.name is not None or
            self.natural_source is not None or
            self.molecular_weight is not None or
            self.details is not None or
            self.number_of_copies is not None or
            self.oligomeric_state is not None or
            self.recombinant_exp_flag is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_macromolecule_type'):
        if self.macromolecule_id is not None and 'macromolecule_id' not in already_processed:
            already_processed.add('macromolecule_id')
            outfile.write(' macromolecule_id="%s"' % self.gds_format_integer(self.macromolecule_id, input_name='macromolecule_id'))
        if self.mutant is not None and 'mutant' not in already_processed:
            already_processed.add('mutant')
            outfile.write(' mutant="%s"' % self.gds_format_boolean(self.mutant, input_name='mutant'))
        if self.chimera is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            outfile.write(' chimera="%s"' % self.gds_format_boolean(self.chimera, input_name='chimera'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_macromolecule_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.natural_source is not None:
            namespaceprefix_ = self.natural_source_nsprefix_ + ':' if (UseCapturedNS_ and self.natural_source_nsprefix_) else ''
            self.natural_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='natural_source', pretty_print=pretty_print)
        if self.molecular_weight is not None:
            namespaceprefix_ = self.molecular_weight_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_weight_nsprefix_) else ''
            self.molecular_weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_weight', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
        if self.number_of_copies is not None:
            namespaceprefix_ = self.number_of_copies_nsprefix_ + ':' if (UseCapturedNS_ and self.number_of_copies_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_of_copies>%s</%snumber_of_copies>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.number_of_copies), input_name='number_of_copies')), namespaceprefix_ , eol_))
        if self.oligomeric_state is not None:
            namespaceprefix_ = self.oligomeric_state_nsprefix_ + ':' if (UseCapturedNS_ and self.oligomeric_state_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomeric_state>%s</%soligomeric_state>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.oligomeric_state), input_name='oligomeric_state')), namespaceprefix_ , eol_))
        if self.recombinant_exp_flag is not None:
            namespaceprefix_ = self.recombinant_exp_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_exp_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinant_exp_flag>%s</%srecombinant_exp_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.recombinant_exp_flag, input_name='recombinant_exp_flag'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('macromolecule_id', node)
        if value is not None and 'macromolecule_id' not in already_processed:
            already_processed.add('macromolecule_id')
            self.macromolecule_id = self.gds_parse_integer(value, node, 'macromolecule_id')
            if self.macromolecule_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('mutant', node)
        if value is not None and 'mutant' not in already_processed:
            already_processed.add('mutant')
            if value in ('true', '1'):
                self.mutant = True
            elif value in ('false', '0'):
                self.mutant = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('chimera', node)
        if value is not None and 'chimera' not in already_processed:
            already_processed.add('chimera')
            if value in ('true', '1'):
                self.chimera = True
            elif value in ('false', '0'):
                self.chimera = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = sci_name_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'natural_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.natural_source = obj_
            obj_.original_tagname_ = 'natural_source'
        elif nodeName_ == 'molecular_weight':
            obj_ = molecular_weight_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_weight = obj_
            obj_.original_tagname_ = 'molecular_weight'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
        elif nodeName_ == 'number_of_copies':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'number_of_copies')
            value_ = self.gds_validate_string(value_, node, 'number_of_copies')
            self.number_of_copies = value_
            self.number_of_copies_nsprefix_ = child_.prefix
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.number_of_copies)
        elif nodeName_ == 'oligomeric_state':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'oligomeric_state')
            value_ = self.gds_validate_string(value_, node, 'oligomeric_state')
            self.oligomeric_state = value_
            self.oligomeric_state_nsprefix_ = child_.prefix
            # validate type pos_int_or_string_type
            self.validate_pos_int_or_string_type(self.oligomeric_state)
        elif nodeName_ == 'recombinant_exp_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'recombinant_exp_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinant_exp_flag')
            self.recombinant_exp_flag = ival_
            self.recombinant_exp_flag_nsprefix_ = child_.prefix
# end class base_macromolecule_type


class macromolecule_source_type(base_source_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_source_type
    def __init__(self, database=None, synthetically_produced=None, organism=None, strain=None, synonym_organism=None, details=None, organ=None, tissue=None, cell=None, organelle=None, cellular_location=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("macromolecule_source_type"), self).__init__(database, synthetically_produced, organism, strain, synonym_organism, details,  **kwargs_)
        self.organ = organ
        self.organ_nsprefix_ = None
        self.tissue = tissue
        self.tissue_nsprefix_ = None
        self.cell = cell
        self.cell_nsprefix_ = None
        self.organelle = organelle
        self.organelle_nsprefix_ = None
        self.cellular_location = cellular_location
        self.cellular_location_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_source_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_source_type.subclass:
            return macromolecule_source_type.subclass(*args_, **kwargs_)
        else:
            return macromolecule_source_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_organ(self):
        return self.organ
    def set_organ(self, organ):
        self.organ = organ
    def get_tissue(self):
        return self.tissue
    def set_tissue(self, tissue):
        self.tissue = tissue
    def get_cell(self):
        return self.cell
    def set_cell(self, cell):
        self.cell = cell
    def get_organelle(self):
        return self.organelle
    def set_organelle(self, organelle):
        self.organelle = organelle
    def get_cellular_location(self):
        return self.cellular_location
    def set_cellular_location(self, cellular_location):
        self.cellular_location = cellular_location
    def has__content(self):
        if (
            self.organ is not None or
            self.tissue is not None or
            self.cell is not None or
            self.organelle is not None or
            self.cellular_location is not None or
            super(macromolecule_source_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_source_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_source_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'macromolecule_source_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='macromolecule_source_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='macromolecule_source_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='macromolecule_source_type'):
        super(macromolecule_source_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='macromolecule_source_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_source_type', fromsubclass_=False, pretty_print=True):
        super(macromolecule_source_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.organ is not None:
            namespaceprefix_ = self.organ_nsprefix_ + ':' if (UseCapturedNS_ and self.organ_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgan>%s</%sorgan>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organ), input_name='organ')), namespaceprefix_ , eol_))
        if self.tissue is not None:
            namespaceprefix_ = self.tissue_nsprefix_ + ':' if (UseCapturedNS_ and self.tissue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stissue>%s</%stissue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tissue), input_name='tissue')), namespaceprefix_ , eol_))
        if self.cell is not None:
            namespaceprefix_ = self.cell_nsprefix_ + ':' if (UseCapturedNS_ and self.cell_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scell>%s</%scell>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cell), input_name='cell')), namespaceprefix_ , eol_))
        if self.organelle is not None:
            namespaceprefix_ = self.organelle_nsprefix_ + ':' if (UseCapturedNS_ and self.organelle_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganelle>%s</%sorganelle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.organelle), input_name='organelle')), namespaceprefix_ , eol_))
        if self.cellular_location is not None:
            namespaceprefix_ = self.cellular_location_nsprefix_ + ':' if (UseCapturedNS_ and self.cellular_location_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scellular_location>%s</%scellular_location>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cellular_location), input_name='cellular_location')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(macromolecule_source_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'organ':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organ')
            value_ = self.gds_validate_string(value_, node, 'organ')
            self.organ = value_
            self.organ_nsprefix_ = child_.prefix
        elif nodeName_ == 'tissue':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'tissue')
            value_ = self.gds_validate_string(value_, node, 'tissue')
            self.tissue = value_
            self.tissue_nsprefix_ = child_.prefix
        elif nodeName_ == 'cell':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cell')
            value_ = self.gds_validate_string(value_, node, 'cell')
            self.cell = value_
            self.cell_nsprefix_ = child_.prefix
        elif nodeName_ == 'organelle':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'organelle')
            value_ = self.gds_validate_string(value_, node, 'organelle')
            self.organelle = value_
            self.organelle_nsprefix_ = child_.prefix
        elif nodeName_ == 'cellular_location':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cellular_location')
            value_ = self.gds_validate_string(value_, node, 'cellular_location')
            self.cellular_location = value_
            self.cellular_location_nsprefix_ = child_.prefix
        super(macromolecule_source_type, self)._buildChildren(child_, node, nodeName_, True)
# end class macromolecule_source_type


class dna_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, structure=None, synthetic_flag=None, synthetic_source=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("dna_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.sequence = sequence
        self.sequence_nsprefix_ = None
        self.classification = classification
        self.validate_classificationType(self.classification)
        self.classification_nsprefix_ = None
        self.structure = structure
        self.structure_nsprefix_ = None
        self.synthetic_flag = synthetic_flag
        self.synthetic_flag_nsprefix_ = None
        self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dna_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dna_macromolecule_type.subclass:
            return dna_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return dna_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_sequence(self):
        return self.sequence
    def set_sequence(self, sequence):
        self.sequence = sequence
    def get_classification(self):
        return self.classification
    def set_classification(self, classification):
        self.classification = classification
    def get_structure(self):
        return self.structure
    def set_structure(self, structure):
        self.structure = structure
    def get_synthetic_flag(self):
        return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag):
        self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def validate_classificationType(self, value):
        result = True
        # Validate type classificationType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DNA']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on classificationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            super(dna_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='dna_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dna_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'dna_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dna_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='dna_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='dna_macromolecule_type'):
        super(dna_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='dna_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='dna_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(dna_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            namespaceprefix_ = self.sequence_nsprefix_ + ':' if (UseCapturedNS_ and self.sequence_nsprefix_) else ''
            self.sequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            namespaceprefix_ = self.classification_nsprefix_ + ':' if (UseCapturedNS_ and self.classification_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclassification>%s</%sclassification>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), namespaceprefix_ , eol_))
        if self.structure is not None:
            namespaceprefix_ = self.structure_nsprefix_ + ':' if (UseCapturedNS_ and self.structure_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstructure>%s</%sstructure>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), namespaceprefix_ , eol_))
        if self.synthetic_flag is not None:
            namespaceprefix_ = self.synthetic_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynthetic_flag>%s</%ssynthetic_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), namespaceprefix_ , eol_))
        if self.synthetic_source is not None:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            self.synthetic_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(dna_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'sequence':
            obj_ = sequenceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'classification')
            value_ = self.gds_validate_string(value_, node, 'classification')
            self.classification = value_
            self.classification_nsprefix_ = child_.prefix
            # validate type classificationType
            self.validate_classificationType(self.classification)
        elif nodeName_ == 'structure':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'structure')
            value_ = self.gds_validate_string(value_, node, 'structure')
            self.structure = value_
            self.structure_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'synthetic_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
            self.synthetic_flag_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(dna_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class dna_macromolecule_type


class em_label_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, formula=None, synthetic_source=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("em_label_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.formula_nsprefix_ = None
        self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, em_label_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if em_label_macromolecule_type.subclass:
            return em_label_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return em_label_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def validate_formula_type(self, value):
        result = True
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def has__content(self):
        if (
            self.formula is not None or
            self.synthetic_source is not None or
            super(em_label_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='em_label_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('em_label_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'em_label_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='em_label_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='em_label_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='em_label_macromolecule_type'):
        super(em_label_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='em_label_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='em_label_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(em_label_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.formula is not None:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformula>%s</%sformula>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), namespaceprefix_ , eol_))
        if self.synthetic_source is not None:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            self.synthetic_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(em_label_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'formula':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'formula')
            value_ = self.gds_validate_string(value_, node, 'formula')
            self.formula = value_
            self.formula_nsprefix_ = child_.prefix
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(em_label_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class em_label_macromolecule_type


class ligand_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, formula=None, external_references=None, recombinant_expression=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ligand_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.formula_nsprefix_ = None
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.external_references_nsprefix_ = None
        self.recombinant_expression = recombinant_expression
        self.recombinant_expression_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ligand_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ligand_macromolecule_type.subclass:
            return ligand_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return ligand_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def add_external_references(self, value):
        self.external_references.append(value)
    def insert_external_references_at(self, index, value):
        self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value):
        self.external_references[index] = value
    def get_recombinant_expression(self):
        return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression):
        self.recombinant_expression = recombinant_expression
    def validate_formula_type(self, value):
        result = True
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def has__content(self):
        if (
            self.formula is not None or
            self.external_references or
            self.recombinant_expression is not None or
            super(ligand_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ligand_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ligand_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ligand_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ligand_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ligand_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ligand_macromolecule_type'):
        super(ligand_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ligand_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ligand_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(ligand_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.formula is not None:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformula>%s</%sformula>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), namespaceprefix_ , eol_))
        for external_references_ in self.external_references:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            external_references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
        if self.recombinant_expression is not None:
            namespaceprefix_ = self.recombinant_expression_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_expression_nsprefix_) else ''
            self.recombinant_expression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_expression', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(ligand_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'formula':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'formula')
            value_ = self.gds_validate_string(value_, node, 'formula')
            self.formula = value_
            self.formula_nsprefix_ = child_.prefix
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType16.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        super(ligand_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class ligand_macromolecule_type


class other_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, recombinant_expression=None, structure=None, synthetic_flag=None, synthetic_source=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("other_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.sequence = sequence
        self.sequence_nsprefix_ = None
        self.classification = classification
        self.classification_nsprefix_ = None
        self.recombinant_expression = recombinant_expression
        self.recombinant_expression_nsprefix_ = None
        self.structure = structure
        self.structure_nsprefix_ = None
        self.synthetic_flag = synthetic_flag
        self.synthetic_flag_nsprefix_ = None
        self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, other_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if other_macromolecule_type.subclass:
            return other_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return other_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_sequence(self):
        return self.sequence
    def set_sequence(self, sequence):
        self.sequence = sequence
    def get_classification(self):
        return self.classification
    def set_classification(self, classification):
        self.classification = classification
    def get_recombinant_expression(self):
        return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression):
        self.recombinant_expression = recombinant_expression
    def get_structure(self):
        return self.structure
    def set_structure(self, structure):
        self.structure = structure
    def get_synthetic_flag(self):
        return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag):
        self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def has__content(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.recombinant_expression is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            super(other_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('other_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'other_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='other_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='other_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='other_macromolecule_type'):
        super(other_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='other_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='other_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(other_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            namespaceprefix_ = self.sequence_nsprefix_ + ':' if (UseCapturedNS_ and self.sequence_nsprefix_) else ''
            self.sequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            namespaceprefix_ = self.classification_nsprefix_ + ':' if (UseCapturedNS_ and self.classification_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclassification>%s</%sclassification>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), namespaceprefix_ , eol_))
        if self.recombinant_expression is not None:
            namespaceprefix_ = self.recombinant_expression_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_expression_nsprefix_) else ''
            self.recombinant_expression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_expression', pretty_print=pretty_print)
        if self.structure is not None:
            namespaceprefix_ = self.structure_nsprefix_ + ':' if (UseCapturedNS_ and self.structure_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstructure>%s</%sstructure>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), namespaceprefix_ , eol_))
        if self.synthetic_flag is not None:
            namespaceprefix_ = self.synthetic_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynthetic_flag>%s</%ssynthetic_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), namespaceprefix_ , eol_))
        if self.synthetic_source is not None:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            self.synthetic_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(other_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'sequence':
            obj_ = sequenceType18.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'classification')
            value_ = self.gds_validate_string(value_, node, 'classification')
            self.classification = value_
            self.classification_nsprefix_ = child_.prefix
        elif nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'structure':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'structure')
            value_ = self.gds_validate_string(value_, node, 'structure')
            self.structure = value_
            self.structure_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'synthetic_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
            self.synthetic_flag_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        super(other_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class other_macromolecule_type


class protein_or_peptide_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, recombinant_expression=None, synthetic_source=None, enantiomer=None, sequence=None, ec_number=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("protein_or_peptide_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.recombinant_expression = recombinant_expression
        self.recombinant_expression_nsprefix_ = None
        self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
        self.enantiomer = enantiomer
        self.validate_enantiomerType(self.enantiomer)
        self.enantiomer_nsprefix_ = None
        self.sequence = sequence
        self.sequence_nsprefix_ = None
        if ec_number is None:
            self.ec_number = []
        else:
            self.ec_number = ec_number
        self.ec_number_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, protein_or_peptide_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if protein_or_peptide_macromolecule_type.subclass:
            return protein_or_peptide_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return protein_or_peptide_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_recombinant_expression(self):
        return self.recombinant_expression
    def set_recombinant_expression(self, recombinant_expression):
        self.recombinant_expression = recombinant_expression
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def get_enantiomer(self):
        return self.enantiomer
    def set_enantiomer(self, enantiomer):
        self.enantiomer = enantiomer
    def get_sequence(self):
        return self.sequence
    def set_sequence(self, sequence):
        self.sequence = sequence
    def get_ec_number(self):
        return self.ec_number
    def set_ec_number(self, ec_number):
        self.ec_number = ec_number
    def add_ec_number(self, value):
        self.ec_number.append(value)
    def insert_ec_number_at(self, index, value):
        self.ec_number.insert(index, value)
    def replace_ec_number_at(self, index, value):
        self.ec_number[index] = value
    def validate_enantiomerType(self, value):
        result = True
        # Validate type enantiomerType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['LEVO', 'DEXTRO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on enantiomerType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ec_numberType(self, value):
        result = True
        # Validate type ec_numberType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_ec_numberType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ec_numberType_patterns_, ))
                result = False
        return result
    validate_ec_numberType_patterns_ = [['^(([1-7]((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?[0-9]?)|(.-)))(([ ]*,[ ]*)([1-6]((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?)|(.-))((.[1-9][0-9]?[0-9]?)|(.-))))*)$']]
    def has__content(self):
        if (
            self.recombinant_expression is not None or
            self.synthetic_source is not None or
            self.enantiomer is not None or
            self.sequence is not None or
            self.ec_number or
            super(protein_or_peptide_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='protein_or_peptide_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('protein_or_peptide_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'protein_or_peptide_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='protein_or_peptide_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='protein_or_peptide_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='protein_or_peptide_macromolecule_type'):
        super(protein_or_peptide_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='protein_or_peptide_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='protein_or_peptide_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(protein_or_peptide_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.recombinant_expression is not None:
            namespaceprefix_ = self.recombinant_expression_nsprefix_ + ':' if (UseCapturedNS_ and self.recombinant_expression_nsprefix_) else ''
            self.recombinant_expression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='recombinant_expression', pretty_print=pretty_print)
        if self.synthetic_source is not None:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            self.synthetic_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
        if self.enantiomer is not None:
            namespaceprefix_ = self.enantiomer_nsprefix_ + ':' if (UseCapturedNS_ and self.enantiomer_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senantiomer>%s</%senantiomer>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.enantiomer), input_name='enantiomer')), namespaceprefix_ , eol_))
        if self.sequence is not None:
            namespaceprefix_ = self.sequence_nsprefix_ + ':' if (UseCapturedNS_ and self.sequence_nsprefix_) else ''
            self.sequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequence', pretty_print=pretty_print)
        for ec_number_ in self.ec_number:
            namespaceprefix_ = self.ec_number_nsprefix_ + ':' if (UseCapturedNS_ and self.ec_number_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sec_number>%s</%sec_number>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ec_number_), input_name='ec_number')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(protein_or_peptide_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'recombinant_expression':
            obj_ = recombinant_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.recombinant_expression = obj_
            obj_.original_tagname_ = 'recombinant_expression'
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'enantiomer':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'enantiomer')
            value_ = self.gds_validate_string(value_, node, 'enantiomer')
            self.enantiomer = value_
            self.enantiomer_nsprefix_ = child_.prefix
            # validate type enantiomerType
            self.validate_enantiomerType(self.enantiomer)
        elif nodeName_ == 'sequence':
            obj_ = sequenceType22.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'ec_number':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'ec_number')
            value_ = self.gds_validate_string(value_, node, 'ec_number')
            self.ec_number.append(value_)
            self.ec_number_nsprefix_ = child_.prefix
            # validate type ec_numberType
            self.validate_ec_numberType(self.ec_number[-1])
        super(protein_or_peptide_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class protein_or_peptide_macromolecule_type


class rna_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, sequence=None, classification=None, structure=None, synthetic_flag=None, synthetic_source=None, ec_number=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("rna_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.sequence = sequence
        self.sequence_nsprefix_ = None
        self.classification = classification
        self.validate_classificationType32(self.classification)
        self.classification_nsprefix_ = None
        self.structure = structure
        self.structure_nsprefix_ = None
        self.synthetic_flag = synthetic_flag
        self.synthetic_flag_nsprefix_ = None
        self.synthetic_source = synthetic_source
        self.synthetic_source_nsprefix_ = None
        if ec_number is None:
            self.ec_number = []
        else:
            self.ec_number = ec_number
        self.ec_number_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, rna_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if rna_macromolecule_type.subclass:
            return rna_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return rna_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_sequence(self):
        return self.sequence
    def set_sequence(self, sequence):
        self.sequence = sequence
    def get_classification(self):
        return self.classification
    def set_classification(self, classification):
        self.classification = classification
    def get_structure(self):
        return self.structure
    def set_structure(self, structure):
        self.structure = structure
    def get_synthetic_flag(self):
        return self.synthetic_flag
    def set_synthetic_flag(self, synthetic_flag):
        self.synthetic_flag = synthetic_flag
    def get_synthetic_source(self):
        return self.synthetic_source
    def set_synthetic_source(self, synthetic_source):
        self.synthetic_source = synthetic_source
    def get_ec_number(self):
        return self.ec_number
    def set_ec_number(self, ec_number):
        self.ec_number = ec_number
    def add_ec_number(self, value):
        self.ec_number.append(value)
    def insert_ec_number_at(self, index, value):
        self.ec_number.insert(index, value)
    def replace_ec_number_at(self, index, value):
        self.ec_number[index] = value
    def validate_classificationType32(self, value):
        result = True
        # Validate type classificationType32, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['MESSENGER', 'TRANSFER', 'RIBOSOMAL', 'NON-CODING', 'INTERFERENCE', 'SMALL INTERFERENCE', 'GENOMIC', 'PRE-MESSENGER', 'SMALL NUCLEOLAR', 'TRANSFER-MESSENGER', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on classificationType32' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ec_numberType33(self, value):
        result = True
        # Validate type ec_numberType33, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_ec_numberType33_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ec_numberType33_patterns_, ))
                result = False
        return result
    validate_ec_numberType33_patterns_ = [['^(\\d+(\\.(\\d+|\\-)){3})$']]
    def has__content(self):
        if (
            self.sequence is not None or
            self.classification is not None or
            self.structure is not None or
            self.synthetic_flag is not None or
            self.synthetic_source is not None or
            self.ec_number or
            super(rna_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rna_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('rna_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'rna_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='rna_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='rna_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='rna_macromolecule_type'):
        super(rna_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='rna_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rna_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(rna_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sequence is not None:
            namespaceprefix_ = self.sequence_nsprefix_ + ':' if (UseCapturedNS_ and self.sequence_nsprefix_) else ''
            self.sequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sequence', pretty_print=pretty_print)
        if self.classification is not None:
            namespaceprefix_ = self.classification_nsprefix_ + ':' if (UseCapturedNS_ and self.classification_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclassification>%s</%sclassification>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.classification), input_name='classification')), namespaceprefix_ , eol_))
        if self.structure is not None:
            namespaceprefix_ = self.structure_nsprefix_ + ':' if (UseCapturedNS_ and self.structure_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstructure>%s</%sstructure>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.structure), input_name='structure')), namespaceprefix_ , eol_))
        if self.synthetic_flag is not None:
            namespaceprefix_ = self.synthetic_flag_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_flag_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynthetic_flag>%s</%ssynthetic_flag>%s' % (namespaceprefix_ , self.gds_format_boolean(self.synthetic_flag, input_name='synthetic_flag'), namespaceprefix_ , eol_))
        if self.synthetic_source is not None:
            namespaceprefix_ = self.synthetic_source_nsprefix_ + ':' if (UseCapturedNS_ and self.synthetic_source_nsprefix_) else ''
            self.synthetic_source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='synthetic_source', pretty_print=pretty_print)
        for ec_number_ in self.ec_number:
            namespaceprefix_ = self.ec_number_nsprefix_ + ':' if (UseCapturedNS_ and self.ec_number_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sec_number>%s</%sec_number>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ec_number_), input_name='ec_number')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(rna_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'sequence':
            obj_ = sequenceType27.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sequence = obj_
            obj_.original_tagname_ = 'sequence'
        elif nodeName_ == 'classification':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'classification')
            value_ = self.gds_validate_string(value_, node, 'classification')
            self.classification = value_
            self.classification_nsprefix_ = child_.prefix
            # validate type classificationType32
            self.validate_classificationType32(self.classification)
        elif nodeName_ == 'structure':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'structure')
            value_ = self.gds_validate_string(value_, node, 'structure')
            self.structure = value_
            self.structure_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_flag':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'synthetic_flag')
            ival_ = self.gds_validate_boolean(ival_, node, 'synthetic_flag')
            self.synthetic_flag = ival_
            self.synthetic_flag_nsprefix_ = child_.prefix
        elif nodeName_ == 'synthetic_source':
            obj_ = macromolecule_source_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synthetic_source = obj_
            obj_.original_tagname_ = 'synthetic_source'
        elif nodeName_ == 'ec_number':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'ec_number')
            value_ = self.gds_validate_string(value_, node, 'ec_number')
            self.ec_number.append(value_)
            self.ec_number_nsprefix_ = child_.prefix
            # validate type ec_numberType33
            self.validate_ec_numberType33(self.ec_number[-1])
        super(rna_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class rna_macromolecule_type


class saccharide_macromolecule_type(base_macromolecule_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_macromolecule_type
    def __init__(self, macromolecule_id=None, mutant=None, chimera=None, name=None, natural_source=None, molecular_weight=None, details=None, number_of_copies=None, oligomeric_state=None, recombinant_exp_flag=None, enantiomer=None, formula=None, external_references=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("saccharide_macromolecule_type"), self).__init__(macromolecule_id, mutant, chimera, name, natural_source, molecular_weight, details, number_of_copies, oligomeric_state, recombinant_exp_flag,  **kwargs_)
        self.enantiomer = enantiomer
        self.validate_enantiomerType34(self.enantiomer)
        self.enantiomer_nsprefix_ = None
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.formula_nsprefix_ = None
        if external_references is None:
            self.external_references = []
        else:
            self.external_references = external_references
        self.external_references_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, saccharide_macromolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if saccharide_macromolecule_type.subclass:
            return saccharide_macromolecule_type.subclass(*args_, **kwargs_)
        else:
            return saccharide_macromolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_enantiomer(self):
        return self.enantiomer
    def set_enantiomer(self, enantiomer):
        self.enantiomer = enantiomer
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def add_external_references(self, value):
        self.external_references.append(value)
    def insert_external_references_at(self, index, value):
        self.external_references.insert(index, value)
    def replace_external_references_at(self, index, value):
        self.external_references[index] = value
    def validate_enantiomerType34(self, value):
        result = True
        # Validate type enantiomerType34, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['LEVO', 'DEXTRO']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on enantiomerType34' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_formula_type(self, value):
        result = True
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def has__content(self):
        if (
            self.enantiomer is not None or
            self.formula is not None or
            self.external_references or
            super(saccharide_macromolecule_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saccharide_macromolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('saccharide_macromolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'saccharide_macromolecule_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saccharide_macromolecule_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='saccharide_macromolecule_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='saccharide_macromolecule_type'):
        super(saccharide_macromolecule_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='saccharide_macromolecule_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='saccharide_macromolecule_type', fromsubclass_=False, pretty_print=True):
        super(saccharide_macromolecule_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enantiomer is not None:
            namespaceprefix_ = self.enantiomer_nsprefix_ + ':' if (UseCapturedNS_ and self.enantiomer_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senantiomer>%s</%senantiomer>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.enantiomer), input_name='enantiomer')), namespaceprefix_ , eol_))
        if self.formula is not None:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformula>%s</%sformula>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), namespaceprefix_ , eol_))
        for external_references_ in self.external_references:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            external_references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(saccharide_macromolecule_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'enantiomer':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'enantiomer')
            value_ = self.gds_validate_string(value_, node, 'enantiomer')
            self.enantiomer = value_
            self.enantiomer_nsprefix_ = child_.prefix
            # validate type enantiomerType34
            self.validate_enantiomerType34(self.enantiomer)
        elif nodeName_ == 'formula':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'formula')
            value_ = self.gds_validate_string(value_, node, 'formula')
            self.formula = value_
            self.formula_nsprefix_ = child_.prefix
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType35.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references.append(obj_)
            obj_.original_tagname_ = 'external_references'
        super(saccharide_macromolecule_type, self)._buildChildren(child_, node, nodeName_, True)
# end class saccharide_macromolecule_type


class structure_determination_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, structure_determination_id=None, method=None, aggregation_state=None, macromolecules_and_complexes=None, specimen_preparation_list=None, microscopy_list=None, image_processing=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.structure_determination_id = _cast(int, structure_determination_id)
        self.structure_determination_id_nsprefix_ = None
        self.method = method
        self.validate_methodType(self.method)
        self.method_nsprefix_ = None
        self.aggregation_state = aggregation_state
        self.validate_aggregation_stateType(self.aggregation_state)
        self.aggregation_state_nsprefix_ = None
        self.macromolecules_and_complexes = macromolecules_and_complexes
        self.macromolecules_and_complexes_nsprefix_ = None
        self.specimen_preparation_list = specimen_preparation_list
        self.specimen_preparation_list_nsprefix_ = None
        self.microscopy_list = microscopy_list
        self.microscopy_list_nsprefix_ = None
        if image_processing is None:
            self.image_processing = []
        else:
            self.image_processing = image_processing
        self.image_processing_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, structure_determination_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if structure_determination_type.subclass:
            return structure_determination_type.subclass(*args_, **kwargs_)
        else:
            return structure_determination_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_method(self):
        return self.method
    def set_method(self, method):
        self.method = method
    def get_aggregation_state(self):
        return self.aggregation_state
    def set_aggregation_state(self, aggregation_state):
        self.aggregation_state = aggregation_state
    def get_macromolecules_and_complexes(self):
        return self.macromolecules_and_complexes
    def set_macromolecules_and_complexes(self, macromolecules_and_complexes):
        self.macromolecules_and_complexes = macromolecules_and_complexes
    def get_specimen_preparation_list(self):
        return self.specimen_preparation_list
    def set_specimen_preparation_list(self, specimen_preparation_list):
        self.specimen_preparation_list = specimen_preparation_list
    def get_microscopy_list(self):
        return self.microscopy_list
    def set_microscopy_list(self, microscopy_list):
        self.microscopy_list = microscopy_list
    def get_image_processing(self):
        return self.image_processing
    def set_image_processing(self, image_processing):
        self.image_processing = image_processing
    def add_image_processing(self, value):
        self.image_processing.append(value)
    def insert_image_processing_at(self, index, value):
        self.image_processing.insert(index, value)
    def replace_image_processing_at(self, index, value):
        self.image_processing[index] = value
    def get_structure_determination_id(self):
        return self.structure_determination_id
    def set_structure_determination_id(self, structure_determination_id):
        self.structure_determination_id = structure_determination_id
    def validate_methodType(self, value):
        result = True
        # Validate type methodType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['singleParticle', 'subtomogramAveraging', 'tomography', 'electronCrystallography', 'helical']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on methodType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_aggregation_stateType(self, value):
        result = True
        # Validate type aggregation_stateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['particle', 'filament', 'twoDArray', 'threeDArray', 'helicalArray', 'cell', 'tissue']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on aggregation_stateType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.method is not None or
            self.aggregation_state is not None or
            self.macromolecules_and_complexes is not None or
            self.specimen_preparation_list is not None or
            self.microscopy_list is not None or
            self.image_processing
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='structure_determination_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('structure_determination_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'structure_determination_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='structure_determination_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='structure_determination_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='structure_determination_type'):
        if self.structure_determination_id is not None and 'structure_determination_id' not in already_processed:
            already_processed.add('structure_determination_id')
            outfile.write(' structure_determination_id="%s"' % self.gds_format_integer(self.structure_determination_id, input_name='structure_determination_id'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='structure_determination_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.method is not None:
            namespaceprefix_ = self.method_nsprefix_ + ':' if (UseCapturedNS_ and self.method_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethod>%s</%smethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), namespaceprefix_ , eol_))
        if self.aggregation_state is not None:
            namespaceprefix_ = self.aggregation_state_nsprefix_ + ':' if (UseCapturedNS_ and self.aggregation_state_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saggregation_state>%s</%saggregation_state>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.aggregation_state), input_name='aggregation_state')), namespaceprefix_ , eol_))
        if self.macromolecules_and_complexes is not None:
            namespaceprefix_ = self.macromolecules_and_complexes_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecules_and_complexes_nsprefix_) else ''
            self.macromolecules_and_complexes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='macromolecules_and_complexes', pretty_print=pretty_print)
        if self.specimen_preparation_list is not None:
            namespaceprefix_ = self.specimen_preparation_list_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_preparation_list_nsprefix_) else ''
            self.specimen_preparation_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen_preparation_list', pretty_print=pretty_print)
        if self.microscopy_list is not None:
            namespaceprefix_ = self.microscopy_list_nsprefix_ + ':' if (UseCapturedNS_ and self.microscopy_list_nsprefix_) else ''
            self.microscopy_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='microscopy_list', pretty_print=pretty_print)
        for image_processing_ in self.image_processing:
            image_processing_.export(outfile, level, namespaceprefix_, namespacedef_='', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('structure_determination_id', node)
        if value is not None and 'structure_determination_id' not in already_processed:
            already_processed.add('structure_determination_id')
            self.structure_determination_id = self.gds_parse_integer(value, node, 'structure_determination_id')
            if self.structure_determination_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'method':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'method')
            value_ = self.gds_validate_string(value_, node, 'method')
            self.method = value_
            self.method_nsprefix_ = child_.prefix
            # validate type methodType
            self.validate_methodType(self.method)
        elif nodeName_ == 'aggregation_state':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'aggregation_state')
            value_ = self.gds_validate_string(value_, node, 'aggregation_state')
            self.aggregation_state = value_
            self.aggregation_state_nsprefix_ = child_.prefix
            # validate type aggregation_stateType
            self.validate_aggregation_stateType(self.aggregation_state)
        elif nodeName_ == 'macromolecules_and_complexes':
            obj_ = macromolecules_and_complexes_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecules_and_complexes = obj_
            obj_.original_tagname_ = 'macromolecules_and_complexes'
        elif nodeName_ == 'specimen_preparation_list':
            obj_ = specimen_preparation_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen_preparation_list = obj_
            obj_.original_tagname_ = 'specimen_preparation_list'
        elif nodeName_ == 'microscopy_list':
            obj_ = microscopy_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.microscopy_list = obj_
            obj_.original_tagname_ = 'microscopy_list'
        elif nodeName_ == 'image_processing':
            class_obj_ = self.get_class_obj_(child_, base_image_processing_type)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'image_processing'
        elif nodeName_ == 'crystallography_processing':
            obj_ = crystallography_processing_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'crystallography_processing'
        elif nodeName_ == 'helical_processing':
            obj_ = helical_processing_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'helical_processing'
        elif nodeName_ == 'singleparticle_processing':
            obj_ = singleparticle_processing_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'singleparticle_processing'
        elif nodeName_ == 'subtomogram_averaging_processing':
            obj_ = subtomogram_averaging_processing_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'subtomogram_averaging_processing'
        elif nodeName_ == 'tomography_processing':
            obj_ = tomography_processing_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_processing.append(obj_)
            obj_.original_tagname_ = 'tomography_processing'
# end class structure_determination_type


class macromolecules_and_complexes_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, macromolecule_id=None, complex_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if macromolecule_id is None:
            self.macromolecule_id = []
        else:
            self.macromolecule_id = macromolecule_id
        self.macromolecule_id_nsprefix_ = None
        if complex_id is None:
            self.complex_id = []
        else:
            self.complex_id = complex_id
        self.complex_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecules_and_complexes_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecules_and_complexes_type.subclass:
            return macromolecules_and_complexes_type.subclass(*args_, **kwargs_)
        else:
            return macromolecules_and_complexes_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_macromolecule_id(self):
        return self.macromolecule_id
    def set_macromolecule_id(self, macromolecule_id):
        self.macromolecule_id = macromolecule_id
    def add_macromolecule_id(self, value):
        self.macromolecule_id.append(value)
    def insert_macromolecule_id_at(self, index, value):
        self.macromolecule_id.insert(index, value)
    def replace_macromolecule_id_at(self, index, value):
        self.macromolecule_id[index] = value
    def get_complex_id(self):
        return self.complex_id
    def set_complex_id(self, complex_id):
        self.complex_id = complex_id
    def add_complex_id(self, value):
        self.complex_id.append(value)
    def insert_complex_id_at(self, index, value):
        self.complex_id.insert(index, value)
    def replace_complex_id_at(self, index, value):
        self.complex_id[index] = value
    def has__content(self):
        if (
            self.macromolecule_id or
            self.complex_id
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecules_and_complexes_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecules_and_complexes_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'macromolecules_and_complexes_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='macromolecules_and_complexes_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='macromolecules_and_complexes_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='macromolecules_and_complexes_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecules_and_complexes_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_id_ in self.macromolecule_id:
            namespaceprefix_ = self.macromolecule_id_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecule_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smacromolecule_id>%s</%smacromolecule_id>%s' % (namespaceprefix_ , self.gds_format_integer(macromolecule_id_, input_name='macromolecule_id'), namespaceprefix_ , eol_))
        for complex_id_ in self.complex_id:
            namespaceprefix_ = self.complex_id_nsprefix_ + ':' if (UseCapturedNS_ and self.complex_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomplex_id>%s</%scomplex_id>%s' % (namespaceprefix_ , self.gds_format_integer(complex_id_, input_name='complex_id'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'macromolecule_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'macromolecule_id')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'macromolecule_id')
            self.macromolecule_id.append(ival_)
            self.macromolecule_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'complex_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'complex_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'complex_id')
            self.complex_id.append(ival_)
            self.complex_id_nsprefix_ = child_.prefix
# end class macromolecules_and_complexes_type


class base_preparation_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.preparation_id = _cast(int, preparation_id)
        self.preparation_id_nsprefix_ = None
        self.concentration = concentration
        self.concentration_nsprefix_ = None
        self.buffer = buffer
        self.buffer_nsprefix_ = None
        self.staining = staining
        self.staining_nsprefix_ = None
        self.sugar_embedding = sugar_embedding
        self.sugar_embedding_nsprefix_ = None
        self.shadowing = shadowing
        self.shadowing_nsprefix_ = None
        self.grid = grid
        self.grid_nsprefix_ = None
        self.vitrification = vitrification
        self.vitrification_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_preparation_type.subclass:
            return base_preparation_type.subclass(*args_, **kwargs_)
        else:
            return base_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_concentration(self):
        return self.concentration
    def set_concentration(self, concentration):
        self.concentration = concentration
    def get_buffer(self):
        return self.buffer
    def set_buffer(self, buffer):
        self.buffer = buffer
    def get_staining(self):
        return self.staining
    def set_staining(self, staining):
        self.staining = staining
    def get_sugar_embedding(self):
        return self.sugar_embedding
    def set_sugar_embedding(self, sugar_embedding):
        self.sugar_embedding = sugar_embedding
    def get_shadowing(self):
        return self.shadowing
    def set_shadowing(self, shadowing):
        self.shadowing = shadowing
    def get_grid(self):
        return self.grid
    def set_grid(self, grid):
        self.grid = grid
    def get_vitrification(self):
        return self.vitrification
    def set_vitrification(self, vitrification):
        self.vitrification = vitrification
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_preparation_id(self):
        return self.preparation_id
    def set_preparation_id(self, preparation_id):
        self.preparation_id = preparation_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.concentration is not None or
            self.buffer is not None or
            self.staining is not None or
            self.sugar_embedding is not None or
            self.shadowing is not None or
            self.grid is not None or
            self.vitrification is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_preparation_type'):
        if self.preparation_id is not None and 'preparation_id' not in already_processed:
            already_processed.add('preparation_id')
            outfile.write(' preparation_id="%s"' % self.gds_format_integer(self.preparation_id, input_name='preparation_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_preparation_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.concentration is not None:
            namespaceprefix_ = self.concentration_nsprefix_ + ':' if (UseCapturedNS_ and self.concentration_nsprefix_) else ''
            self.concentration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='concentration', pretty_print=pretty_print)
        if self.buffer is not None:
            namespaceprefix_ = self.buffer_nsprefix_ + ':' if (UseCapturedNS_ and self.buffer_nsprefix_) else ''
            self.buffer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='buffer', pretty_print=pretty_print)
        if self.staining is not None:
            namespaceprefix_ = self.staining_nsprefix_ + ':' if (UseCapturedNS_ and self.staining_nsprefix_) else ''
            self.staining.export(outfile, level, namespaceprefix_, namespacedef_='', name_='staining', pretty_print=pretty_print)
        if self.sugar_embedding is not None:
            namespaceprefix_ = self.sugar_embedding_nsprefix_ + ':' if (UseCapturedNS_ and self.sugar_embedding_nsprefix_) else ''
            self.sugar_embedding.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sugar_embedding', pretty_print=pretty_print)
        if self.shadowing is not None:
            namespaceprefix_ = self.shadowing_nsprefix_ + ':' if (UseCapturedNS_ and self.shadowing_nsprefix_) else ''
            self.shadowing.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shadowing', pretty_print=pretty_print)
        if self.grid is not None:
            namespaceprefix_ = self.grid_nsprefix_ + ':' if (UseCapturedNS_ and self.grid_nsprefix_) else ''
            self.grid.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grid', pretty_print=pretty_print)
        if self.vitrification is not None:
            namespaceprefix_ = self.vitrification_nsprefix_ + ':' if (UseCapturedNS_ and self.vitrification_nsprefix_) else ''
            self.vitrification.export(outfile, level, namespaceprefix_, namespacedef_='', name_='vitrification', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preparation_id', node)
        if value is not None and 'preparation_id' not in already_processed:
            already_processed.add('preparation_id')
            self.preparation_id = self.gds_parse_integer(value, node, 'preparation_id')
            if self.preparation_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'concentration':
            obj_ = concentrationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.concentration = obj_
            obj_.original_tagname_ = 'concentration'
        elif nodeName_ == 'buffer':
            obj_ = buffer_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.buffer = obj_
            obj_.original_tagname_ = 'buffer'
        elif nodeName_ == 'staining':
            obj_ = stainingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.staining = obj_
            obj_.original_tagname_ = 'staining'
        elif nodeName_ == 'sugar_embedding':
            obj_ = sugar_embeddingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sugar_embedding = obj_
            obj_.original_tagname_ = 'sugar_embedding'
        elif nodeName_ == 'shadowing':
            obj_ = shadowingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shadowing = obj_
            obj_.original_tagname_ = 'shadowing'
        elif nodeName_ == 'grid':
            obj_ = grid_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.grid = obj_
            obj_.original_tagname_ = 'grid'
        elif nodeName_ == 'vitrification':
            obj_ = vitrification_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vitrification = obj_
            obj_.original_tagname_ = 'vitrification'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class base_preparation_type


class buffer_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ph=None, component=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ph = ph
        self.validate_phType(self.ph)
        self.ph_nsprefix_ = None
        if component is None:
            self.component = []
        else:
            self.component = component
        self.component_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, buffer_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if buffer_type.subclass:
            return buffer_type.subclass(*args_, **kwargs_)
        else:
            return buffer_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ph(self):
        return self.ph
    def set_ph(self, ph):
        self.ph = ph
    def get_component(self):
        return self.component
    def set_component(self, component):
        self.component = component
    def add_component(self, value):
        self.component.append(value)
    def insert_component_at(self, index, value):
        self.component.insert(index, value)
    def replace_component_at(self, index, value):
        self.component[index] = value
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_phType(self, value):
        result = True
        # Validate type phType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on phType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 14:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on phType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.ph is not None or
            self.component or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='buffer_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('buffer_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'buffer_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='buffer_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='buffer_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='buffer_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='buffer_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ph is not None:
            namespaceprefix_ = self.ph_nsprefix_ + ':' if (UseCapturedNS_ and self.ph_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sph>%s</%sph>%s' % (namespaceprefix_ , self.gds_format_float(self.ph, input_name='ph'), namespaceprefix_ , eol_))
        for component_ in self.component:
            namespaceprefix_ = self.component_nsprefix_ + ':' if (UseCapturedNS_ and self.component_nsprefix_) else ''
            component_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='component', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ph' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'ph')
            fval_ = self.gds_validate_float(fval_, node, 'ph')
            self.ph = fval_
            self.ph_nsprefix_ = child_.prefix
            # validate type phType
            self.validate_phType(self.ph)
        elif nodeName_ == 'component':
            obj_ = buffer_component_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.component.append(obj_)
            obj_.original_tagname_ = 'component'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class buffer_type


class buffer_component_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, concentration=None, formula=None, name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.concentration = concentration
        self.concentration_nsprefix_ = None
        self.formula = formula
        self.validate_formula_type(self.formula)
        self.formula_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, buffer_component_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if buffer_component_type.subclass:
            return buffer_component_type.subclass(*args_, **kwargs_)
        else:
            return buffer_component_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_concentration(self):
        return self.concentration
    def set_concentration(self, concentration):
        self.concentration = concentration
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def validate_formula_type(self, value):
        result = True
        # Validate type formula_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def has__content(self):
        if (
            self.concentration is not None or
            self.formula is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='buffer_component_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('buffer_component_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'buffer_component_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='buffer_component_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='buffer_component_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='buffer_component_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='buffer_component_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.concentration is not None:
            namespaceprefix_ = self.concentration_nsprefix_ + ':' if (UseCapturedNS_ and self.concentration_nsprefix_) else ''
            self.concentration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='concentration', pretty_print=pretty_print)
        if self.formula is not None:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformula>%s</%sformula>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.formula), input_name='formula')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'concentration':
            obj_ = concentrationType39.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.concentration = obj_
            obj_.original_tagname_ = 'concentration'
        elif nodeName_ == 'formula':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'formula')
            value_ = self.gds_validate_string(value_, node, 'formula')
            self.formula = value_
            self.formula_nsprefix_ = child_.prefix
            # validate type formula_type
            self.validate_formula_type(self.formula)
        elif nodeName_ == 'name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
# end class buffer_component_type


class grid_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, model=None, material=None, mesh=None, support_film=None, pretreatment=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.model = model
        self.model_nsprefix_ = None
        self.material = material
        self.validate_materialType(self.material)
        self.material_nsprefix_ = None
        self.mesh = mesh
        self.mesh_nsprefix_ = None
        if support_film is None:
            self.support_film = []
        else:
            self.support_film = support_film
        self.support_film_nsprefix_ = None
        self.pretreatment = pretreatment
        self.pretreatment_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grid_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grid_type.subclass:
            return grid_type.subclass(*args_, **kwargs_)
        else:
            return grid_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_model(self):
        return self.model
    def set_model(self, model):
        self.model = model
    def get_material(self):
        return self.material
    def set_material(self, material):
        self.material = material
    def get_mesh(self):
        return self.mesh
    def set_mesh(self, mesh):
        self.mesh = mesh
    def get_support_film(self):
        return self.support_film
    def set_support_film(self, support_film):
        self.support_film = support_film
    def add_support_film(self, value):
        self.support_film.append(value)
    def insert_support_film_at(self, index, value):
        self.support_film.insert(index, value)
    def replace_support_film_at(self, index, value):
        self.support_film[index] = value
    def get_pretreatment(self):
        return self.pretreatment
    def set_pretreatment(self, pretreatment):
        self.pretreatment = pretreatment
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_materialType(self, value):
        result = True
        # Validate type materialType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COPPER', 'COPPER/PALLADIUM', 'COPPER/RHODIUM', 'GOLD', 'GRAPHENE OXIDE', 'MOLYBDENUM', 'NICKEL', 'NICKEL/TITANIUM', 'PLATINUM', 'SILICON NITRIDE', 'TITANIUM', 'TUNGSTEN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on materialType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.model is not None or
            self.material is not None or
            self.mesh is not None or
            self.support_film or
            self.pretreatment is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grid_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grid_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'grid_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='grid_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='grid_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='grid_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grid_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.model is not None:
            namespaceprefix_ = self.model_nsprefix_ + ':' if (UseCapturedNS_ and self.model_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodel>%s</%smodel>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.model), input_name='model')), namespaceprefix_ , eol_))
        if self.material is not None:
            namespaceprefix_ = self.material_nsprefix_ + ':' if (UseCapturedNS_ and self.material_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaterial>%s</%smaterial>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.material), input_name='material')), namespaceprefix_ , eol_))
        if self.mesh is not None:
            namespaceprefix_ = self.mesh_nsprefix_ + ':' if (UseCapturedNS_ and self.mesh_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smesh>%s</%smesh>%s' % (namespaceprefix_ , self.gds_format_integer(self.mesh, input_name='mesh'), namespaceprefix_ , eol_))
        for support_film_ in self.support_film:
            namespaceprefix_ = self.support_film_nsprefix_ + ':' if (UseCapturedNS_ and self.support_film_nsprefix_) else ''
            support_film_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='support_film', pretty_print=pretty_print)
        if self.pretreatment is not None:
            namespaceprefix_ = self.pretreatment_nsprefix_ + ':' if (UseCapturedNS_ and self.pretreatment_nsprefix_) else ''
            self.pretreatment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pretreatment', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'model':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'model')
            value_ = self.gds_validate_string(value_, node, 'model')
            self.model = value_
            self.model_nsprefix_ = child_.prefix
        elif nodeName_ == 'material':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'material')
            value_ = self.gds_validate_string(value_, node, 'material')
            self.material = value_
            self.material_nsprefix_ = child_.prefix
            # validate type materialType
            self.validate_materialType(self.material)
        elif nodeName_ == 'mesh' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'mesh')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'mesh')
            self.mesh = ival_
            self.mesh_nsprefix_ = child_.prefix
        elif nodeName_ == 'support_film':
            obj_ = film_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.support_film.append(obj_)
            obj_.original_tagname_ = 'support_film'
        elif nodeName_ == 'pretreatment':
            obj_ = grid_pretreatment_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pretreatment = obj_
            obj_.original_tagname_ = 'pretreatment'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class grid_type


class film_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, film_type_id=None, film_material=None, film_topology=None, film_thickness=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.film_type_id = _cast(int, film_type_id)
        self.film_type_id_nsprefix_ = None
        self.film_material = film_material
        self.validate_film_materialType(self.film_material)
        self.film_material_nsprefix_ = None
        self.film_topology = film_topology
        self.validate_film_topologyType(self.film_topology)
        self.film_topology_nsprefix_ = None
        self.film_thickness = film_thickness
        self.film_thickness_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, film_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if film_type.subclass:
            return film_type.subclass(*args_, **kwargs_)
        else:
            return film_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_film_material(self):
        return self.film_material
    def set_film_material(self, film_material):
        self.film_material = film_material
    def get_film_topology(self):
        return self.film_topology
    def set_film_topology(self, film_topology):
        self.film_topology = film_topology
    def get_film_thickness(self):
        return self.film_thickness
    def set_film_thickness(self, film_thickness):
        self.film_thickness = film_thickness
    def get_film_type_id(self):
        return self.film_type_id
    def set_film_type_id(self, film_type_id):
        self.film_type_id = film_type_id
    def validate_film_materialType(self, value):
        result = True
        # Validate type film_materialType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['CARBON', 'CELLULOSE ACETATE', 'FORMVAR', 'GOLD', 'GRAPHENE', 'GRAPHENE OXIDE', 'PARLODION']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on film_materialType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_film_topologyType(self, value):
        result = True
        # Validate type film_topologyType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['CONTINUOUS', 'HOLEY', 'HOLEY ARRAY', 'LACEY']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on film_topologyType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.film_material is not None or
            self.film_topology is not None or
            self.film_thickness is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='film_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('film_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'film_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='film_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='film_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='film_type'):
        if self.film_type_id is not None and 'film_type_id' not in already_processed:
            already_processed.add('film_type_id')
            outfile.write(' film_type_id="%s"' % self.gds_format_integer(self.film_type_id, input_name='film_type_id'))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='film_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.film_material is not None:
            namespaceprefix_ = self.film_material_nsprefix_ + ':' if (UseCapturedNS_ and self.film_material_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilm_material>%s</%sfilm_material>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.film_material), input_name='film_material')), namespaceprefix_ , eol_))
        if self.film_topology is not None:
            namespaceprefix_ = self.film_topology_nsprefix_ + ':' if (UseCapturedNS_ and self.film_topology_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilm_topology>%s</%sfilm_topology>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.film_topology), input_name='film_topology')), namespaceprefix_ , eol_))
        if self.film_thickness is not None:
            namespaceprefix_ = self.film_thickness_nsprefix_ + ':' if (UseCapturedNS_ and self.film_thickness_nsprefix_) else ''
            self.film_thickness.export(outfile, level, namespaceprefix_, namespacedef_='', name_='film_thickness', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('film_type_id', node)
        if value is not None and 'film_type_id' not in already_processed:
            already_processed.add('film_type_id')
            self.film_type_id = self.gds_parse_integer(value, node, 'film_type_id')
            if self.film_type_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'film_material':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'film_material')
            value_ = self.gds_validate_string(value_, node, 'film_material')
            self.film_material = value_
            self.film_material_nsprefix_ = child_.prefix
            # validate type film_materialType
            self.validate_film_materialType(self.film_material)
        elif nodeName_ == 'film_topology':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'film_topology')
            value_ = self.gds_validate_string(value_, node, 'film_topology')
            self.film_topology = value_
            self.film_topology_nsprefix_ = child_.prefix
            # validate type film_topologyType
            self.validate_film_topologyType(self.film_topology)
        elif nodeName_ == 'film_thickness':
            obj_ = film_thicknessType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.film_thickness = obj_
            obj_.original_tagname_ = 'film_thickness'
# end class film_type


class grid_pretreatment_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, type_=None, time=None, atmosphere=None, pressure=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.atmosphere = atmosphere
        self.validate_atmosphereType(self.atmosphere)
        self.atmosphere_nsprefix_ = None
        self.pressure = pressure
        self.pressure_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grid_pretreatment_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grid_pretreatment_type.subclass:
            return grid_pretreatment_type.subclass(*args_, **kwargs_)
        else:
            return grid_pretreatment_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_atmosphere(self):
        return self.atmosphere
    def set_atmosphere(self, atmosphere):
        self.atmosphere = atmosphere
    def get_pressure(self):
        return self.pressure
    def set_pressure(self, pressure):
        self.pressure = pressure
    def validate_atmosphereType(self, value):
        result = True
        # Validate type atmosphereType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['AIR', 'AMYLAMINE', 'NITROGEN', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on atmosphereType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.type_ is not None or
            self.time is not None or
            self.atmosphere is not None or
            self.pressure is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grid_pretreatment_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grid_pretreatment_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'grid_pretreatment_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='grid_pretreatment_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='grid_pretreatment_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='grid_pretreatment_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='grid_pretreatment_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.type_), input_name='type')), namespaceprefix_ , eol_))
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.atmosphere is not None:
            namespaceprefix_ = self.atmosphere_nsprefix_ + ':' if (UseCapturedNS_ and self.atmosphere_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%satmosphere>%s</%satmosphere>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.atmosphere), input_name='atmosphere')), namespaceprefix_ , eol_))
        if self.pressure is not None:
            namespaceprefix_ = self.pressure_nsprefix_ + ':' if (UseCapturedNS_ and self.pressure_nsprefix_) else ''
            self.pressure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pressure', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'type')
            value_ = self.gds_validate_string(value_, node, 'type')
            self.type_ = value_
            self.type_nsprefix_ = child_.prefix
        elif nodeName_ == 'time':
            obj_ = timeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'atmosphere':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'atmosphere')
            value_ = self.gds_validate_string(value_, node, 'atmosphere')
            self.atmosphere = value_
            self.atmosphere_nsprefix_ = child_.prefix
            # validate type atmosphereType
            self.validate_atmosphereType(self.atmosphere)
        elif nodeName_ == 'pressure':
            obj_ = pressureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pressure = obj_
            obj_.original_tagname_ = 'pressure'
# end class grid_pretreatment_type


class vitrification_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, cryogen_name=None, chamber_humidity=None, chamber_temperature=None, instrument=None, details=None, timed_resolved_state=None, method=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cryogen_name = cryogen_name
        self.validate_cryogen_nameType(self.cryogen_name)
        self.cryogen_name_nsprefix_ = None
        self.chamber_humidity = chamber_humidity
        self.chamber_humidity_nsprefix_ = None
        self.chamber_temperature = chamber_temperature
        self.chamber_temperature_nsprefix_ = None
        self.instrument = instrument
        self.validate_instrumentType(self.instrument)
        self.instrument_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.timed_resolved_state = timed_resolved_state
        self.timed_resolved_state_nsprefix_ = None
        self.method = method
        self.method_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vitrification_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vitrification_type.subclass:
            return vitrification_type.subclass(*args_, **kwargs_)
        else:
            return vitrification_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cryogen_name(self):
        return self.cryogen_name
    def set_cryogen_name(self, cryogen_name):
        self.cryogen_name = cryogen_name
    def get_chamber_humidity(self):
        return self.chamber_humidity
    def set_chamber_humidity(self, chamber_humidity):
        self.chamber_humidity = chamber_humidity
    def get_chamber_temperature(self):
        return self.chamber_temperature
    def set_chamber_temperature(self, chamber_temperature):
        self.chamber_temperature = chamber_temperature
    def get_instrument(self):
        return self.instrument
    def set_instrument(self, instrument):
        self.instrument = instrument
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_timed_resolved_state(self):
        return self.timed_resolved_state
    def set_timed_resolved_state(self, timed_resolved_state):
        self.timed_resolved_state = timed_resolved_state
    def get_method(self):
        return self.method
    def set_method(self, method):
        self.method = method
    def validate_cryogen_nameType(self, value):
        result = True
        # Validate type cryogen_nameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ETHANE', 'ETHANE-PROPANE', 'FREON 12', 'FREON 22', 'HELIUM', 'METHANE', 'NITROGEN', 'OTHER', 'PROPANE']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cryogen_nameType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_instrumentType(self, value):
        result = True
        # Validate type instrumentType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['EMS-002 RAPID IMMERSION FREEZER', 'FEI VITROBOT MARK I', 'FEI VITROBOT MARK II', 'FEI VITROBOT MARK III', 'FEI VITROBOT MARK IV', 'GATAN CRYOPLUNGE 3', 'HOMEMADE PLUNGER', 'LEICA EM CPC', 'LEICA EM GP', 'LEICA KF80', 'LEICA PLUNGER', 'REICHERT-JUNG PLUNGER', 'SPOTITON', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on instrumentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.cryogen_name is not None or
            self.chamber_humidity is not None or
            self.chamber_temperature is not None or
            self.instrument is not None or
            self.details is not None or
            self.timed_resolved_state is not None or
            self.method is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vitrification_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vitrification_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'vitrification_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vitrification_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vitrification_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='vitrification_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vitrification_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cryogen_name is not None:
            namespaceprefix_ = self.cryogen_name_nsprefix_ + ':' if (UseCapturedNS_ and self.cryogen_name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scryogen_name>%s</%scryogen_name>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cryogen_name), input_name='cryogen_name')), namespaceprefix_ , eol_))
        if self.chamber_humidity is not None:
            namespaceprefix_ = self.chamber_humidity_nsprefix_ + ':' if (UseCapturedNS_ and self.chamber_humidity_nsprefix_) else ''
            self.chamber_humidity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chamber_humidity', pretty_print=pretty_print)
        if self.chamber_temperature is not None:
            namespaceprefix_ = self.chamber_temperature_nsprefix_ + ':' if (UseCapturedNS_ and self.chamber_temperature_nsprefix_) else ''
            self.chamber_temperature.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chamber_temperature', pretty_print=pretty_print)
        if self.instrument is not None:
            namespaceprefix_ = self.instrument_nsprefix_ + ':' if (UseCapturedNS_ and self.instrument_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstrument>%s</%sinstrument>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.instrument), input_name='instrument')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
        if self.timed_resolved_state is not None:
            namespaceprefix_ = self.timed_resolved_state_nsprefix_ + ':' if (UseCapturedNS_ and self.timed_resolved_state_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimed_resolved_state>%s</%stimed_resolved_state>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.timed_resolved_state), input_name='timed_resolved_state')), namespaceprefix_ , eol_))
        if self.method is not None:
            namespaceprefix_ = self.method_nsprefix_ + ':' if (UseCapturedNS_ and self.method_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethod>%s</%smethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.method), input_name='method')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cryogen_name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cryogen_name')
            value_ = self.gds_validate_string(value_, node, 'cryogen_name')
            self.cryogen_name = value_
            self.cryogen_name_nsprefix_ = child_.prefix
            # validate type cryogen_nameType
            self.validate_cryogen_nameType(self.cryogen_name)
        elif nodeName_ == 'chamber_humidity':
            obj_ = chamber_humidityType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.chamber_humidity = obj_
            obj_.original_tagname_ = 'chamber_humidity'
        elif nodeName_ == 'chamber_temperature':
            obj_ = chamber_temperatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.chamber_temperature = obj_
            obj_.original_tagname_ = 'chamber_temperature'
        elif nodeName_ == 'instrument':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'instrument')
            value_ = self.gds_validate_string(value_, node, 'instrument')
            self.instrument = value_
            self.instrument_nsprefix_ = child_.prefix
            # validate type instrumentType
            self.validate_instrumentType(self.instrument)
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
        elif nodeName_ == 'timed_resolved_state':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'timed_resolved_state')
            value_ = self.gds_validate_string(value_, node, 'timed_resolved_state')
            self.timed_resolved_state = value_
            self.timed_resolved_state_nsprefix_ = child_.prefix
        elif nodeName_ == 'method':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'method')
            value_ = self.gds_validate_string(value_, node, 'method')
            self.method = value_
            self.method_nsprefix_ = child_.prefix
# end class vitrification_type


class crystallography_preparation_type(base_preparation_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, crystal_formation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("crystallography_preparation_type"), self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details,  **kwargs_)
        self.crystal_formation = crystal_formation
        self.crystal_formation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_preparation_type.subclass:
            return crystallography_preparation_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_crystal_formation(self):
        return self.crystal_formation
    def set_crystal_formation(self, crystal_formation):
        self.crystal_formation = crystal_formation
    def has__content(self):
        if (
            self.crystal_formation is not None or
            super(crystallography_preparation_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystallography_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crystallography_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystallography_preparation_type'):
        super(crystallography_preparation_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_preparation_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_preparation_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_preparation_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.crystal_formation is not None:
            namespaceprefix_ = self.crystal_formation_nsprefix_ + ':' if (UseCapturedNS_ and self.crystal_formation_nsprefix_) else ''
            self.crystal_formation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='crystal_formation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(crystallography_preparation_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'crystal_formation':
            obj_ = crystal_formationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.crystal_formation = obj_
            obj_.original_tagname_ = 'crystal_formation'
        super(crystallography_preparation_type, self)._buildChildren(child_, node, nodeName_, True)
# end class crystallography_preparation_type


class crystal_formation_temperature_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='K', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_formation_temperature_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_formation_temperature_type.subclass:
            return crystal_formation_temperature_type.subclass(*args_, **kwargs_)
        else:
            return crystal_formation_temperature_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_crystal_formation_temperature_type(self, value):
        result = True
        # Validate type allowed_crystal_formation_temperature_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 270:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_crystal_formation_temperature_type' % {"value": value, "lineno": lineno} )
                result = False
            if value > 343:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_crystal_formation_temperature_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_formation_temperature_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_formation_temperature_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystal_formation_temperature_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystal_formation_temperature_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystal_formation_temperature_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_formation_temperature_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class crystal_formation_temperature_type


class crystal_formation_time_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_formation_time_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_formation_time_type.subclass:
            return crystal_formation_time_type.subclass(*args_, **kwargs_)
        else:
            return crystal_formation_time_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_non_zero_float(self, value):
        result = True
        # Validate type non_zero_float, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on non_zero_float' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_unitsType40(self, value):
        # Validate type unitsType40, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['MINUTE', 'HOUR', 'DAY']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on unitsType40' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_formation_time_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_formation_time_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystal_formation_time_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystal_formation_time_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystal_formation_time_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_formation_time_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
            self.validate_unitsType40(self.units)    # validate type unitsType40
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class crystal_formation_time_type


class helical_preparation_type(base_preparation_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("helical_preparation_type"), self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_preparation_type.subclass:
            return helical_preparation_type.subclass(*args_, **kwargs_)
        else:
            return helical_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(helical_preparation_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'helical_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='helical_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='helical_preparation_type'):
        super(helical_preparation_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_preparation_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_preparation_type', fromsubclass_=False, pretty_print=True):
        super(helical_preparation_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(helical_preparation_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(helical_preparation_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class helical_preparation_type


class single_particle_preparation_type(base_preparation_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("single_particle_preparation_type"), self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, single_particle_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if single_particle_preparation_type.subclass:
            return single_particle_preparation_type.subclass(*args_, **kwargs_)
        else:
            return single_particle_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(single_particle_preparation_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='single_particle_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('single_particle_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'single_particle_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='single_particle_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='single_particle_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='single_particle_preparation_type'):
        super(single_particle_preparation_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='single_particle_preparation_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='single_particle_preparation_type', fromsubclass_=False, pretty_print=True):
        super(single_particle_preparation_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(single_particle_preparation_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(single_particle_preparation_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class single_particle_preparation_type


class subtomogram_averaging_preparation_type(base_preparation_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("subtomogram_averaging_preparation_type"), self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, subtomogram_averaging_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if subtomogram_averaging_preparation_type.subclass:
            return subtomogram_averaging_preparation_type.subclass(*args_, **kwargs_)
        else:
            return subtomogram_averaging_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(subtomogram_averaging_preparation_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='subtomogram_averaging_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('subtomogram_averaging_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'subtomogram_averaging_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='subtomogram_averaging_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='subtomogram_averaging_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='subtomogram_averaging_preparation_type'):
        super(subtomogram_averaging_preparation_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='subtomogram_averaging_preparation_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='subtomogram_averaging_preparation_type', fromsubclass_=False, pretty_print=True):
        super(subtomogram_averaging_preparation_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(subtomogram_averaging_preparation_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(subtomogram_averaging_preparation_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class subtomogram_averaging_preparation_type


class tomography_preparation_type(base_preparation_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_preparation_type
    def __init__(self, preparation_id=None, concentration=None, buffer=None, staining=None, sugar_embedding=None, shadowing=None, grid=None, vitrification=None, details=None, fiducial_markers_list=None, high_pressure_freezing=None, embedding_material=None, cryo_protectant=None, sectioning=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("tomography_preparation_type"), self).__init__(preparation_id, concentration, buffer, staining, sugar_embedding, shadowing, grid, vitrification, details,  **kwargs_)
        self.fiducial_markers_list = fiducial_markers_list
        self.fiducial_markers_list_nsprefix_ = None
        self.high_pressure_freezing = high_pressure_freezing
        self.high_pressure_freezing_nsprefix_ = None
        self.embedding_material = embedding_material
        self.embedding_material_nsprefix_ = None
        self.cryo_protectant = cryo_protectant
        self.cryo_protectant_nsprefix_ = None
        self.sectioning = sectioning
        self.sectioning_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tomography_preparation_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tomography_preparation_type.subclass:
            return tomography_preparation_type.subclass(*args_, **kwargs_)
        else:
            return tomography_preparation_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_fiducial_markers_list(self):
        return self.fiducial_markers_list
    def set_fiducial_markers_list(self, fiducial_markers_list):
        self.fiducial_markers_list = fiducial_markers_list
    def get_high_pressure_freezing(self):
        return self.high_pressure_freezing
    def set_high_pressure_freezing(self, high_pressure_freezing):
        self.high_pressure_freezing = high_pressure_freezing
    def get_embedding_material(self):
        return self.embedding_material
    def set_embedding_material(self, embedding_material):
        self.embedding_material = embedding_material
    def get_cryo_protectant(self):
        return self.cryo_protectant
    def set_cryo_protectant(self, cryo_protectant):
        self.cryo_protectant = cryo_protectant
    def get_sectioning(self):
        return self.sectioning
    def set_sectioning(self, sectioning):
        self.sectioning = sectioning
    def has__content(self):
        if (
            self.fiducial_markers_list is not None or
            self.high_pressure_freezing is not None or
            self.embedding_material is not None or
            self.cryo_protectant is not None or
            self.sectioning is not None or
            super(tomography_preparation_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tomography_preparation_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tomography_preparation_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'tomography_preparation_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tomography_preparation_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='tomography_preparation_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='tomography_preparation_type'):
        super(tomography_preparation_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tomography_preparation_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tomography_preparation_type', fromsubclass_=False, pretty_print=True):
        super(tomography_preparation_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fiducial_markers_list is not None:
            namespaceprefix_ = self.fiducial_markers_list_nsprefix_ + ':' if (UseCapturedNS_ and self.fiducial_markers_list_nsprefix_) else ''
            self.fiducial_markers_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='fiducial_markers_list', pretty_print=pretty_print)
        if self.high_pressure_freezing is not None:
            namespaceprefix_ = self.high_pressure_freezing_nsprefix_ + ':' if (UseCapturedNS_ and self.high_pressure_freezing_nsprefix_) else ''
            self.high_pressure_freezing.export(outfile, level, namespaceprefix_, namespacedef_='', name_='high_pressure_freezing', pretty_print=pretty_print)
        if self.embedding_material is not None:
            namespaceprefix_ = self.embedding_material_nsprefix_ + ':' if (UseCapturedNS_ and self.embedding_material_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sembedding_material>%s</%sembedding_material>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.embedding_material), input_name='embedding_material')), namespaceprefix_ , eol_))
        if self.cryo_protectant is not None:
            namespaceprefix_ = self.cryo_protectant_nsprefix_ + ':' if (UseCapturedNS_ and self.cryo_protectant_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scryo_protectant>%s</%scryo_protectant>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cryo_protectant), input_name='cryo_protectant')), namespaceprefix_ , eol_))
        if self.sectioning is not None:
            namespaceprefix_ = self.sectioning_nsprefix_ + ':' if (UseCapturedNS_ and self.sectioning_nsprefix_) else ''
            self.sectioning.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sectioning', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(tomography_preparation_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'fiducial_markers_list':
            obj_ = fiducial_markers_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.fiducial_markers_list = obj_
            obj_.original_tagname_ = 'fiducial_markers_list'
        elif nodeName_ == 'high_pressure_freezing':
            obj_ = high_pressure_freezingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.high_pressure_freezing = obj_
            obj_.original_tagname_ = 'high_pressure_freezing'
        elif nodeName_ == 'embedding_material':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'embedding_material')
            value_ = self.gds_validate_string(value_, node, 'embedding_material')
            self.embedding_material = value_
            self.embedding_material_nsprefix_ = child_.prefix
        elif nodeName_ == 'cryo_protectant':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cryo_protectant')
            value_ = self.gds_validate_string(value_, node, 'cryo_protectant')
            self.cryo_protectant = value_
            self.cryo_protectant_nsprefix_ = child_.prefix
        elif nodeName_ == 'sectioning':
            obj_ = sectioningType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sectioning = obj_
            obj_.original_tagname_ = 'sectioning'
        super(tomography_preparation_type, self)._buildChildren(child_, node, nodeName_, True)
# end class tomography_preparation_type


class fiducial_marker_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, fiducial_type=None, manufacturer=None, diameter=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.fiducial_type = fiducial_type
        self.fiducial_type_nsprefix_ = None
        self.manufacturer = manufacturer
        self.manufacturer_nsprefix_ = None
        self.diameter = diameter
        self.diameter_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fiducial_marker_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fiducial_marker_type.subclass:
            return fiducial_marker_type.subclass(*args_, **kwargs_)
        else:
            return fiducial_marker_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_fiducial_type(self):
        return self.fiducial_type
    def set_fiducial_type(self, fiducial_type):
        self.fiducial_type = fiducial_type
    def get_manufacturer(self):
        return self.manufacturer
    def set_manufacturer(self, manufacturer):
        self.manufacturer = manufacturer
    def get_diameter(self):
        return self.diameter
    def set_diameter(self, diameter):
        self.diameter = diameter
    def has__content(self):
        if (
            self.fiducial_type is not None or
            self.manufacturer is not None or
            self.diameter is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fiducial_marker_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fiducial_marker_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fiducial_marker_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fiducial_marker_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='fiducial_marker_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fiducial_marker_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fiducial_marker_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fiducial_type is not None:
            namespaceprefix_ = self.fiducial_type_nsprefix_ + ':' if (UseCapturedNS_ and self.fiducial_type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfiducial_type>%s</%sfiducial_type>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.fiducial_type), input_name='fiducial_type')), namespaceprefix_ , eol_))
        if self.manufacturer is not None:
            namespaceprefix_ = self.manufacturer_nsprefix_ + ':' if (UseCapturedNS_ and self.manufacturer_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanufacturer>%s</%smanufacturer>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.manufacturer), input_name='manufacturer')), namespaceprefix_ , eol_))
        if self.diameter is not None:
            namespaceprefix_ = self.diameter_nsprefix_ + ':' if (UseCapturedNS_ and self.diameter_nsprefix_) else ''
            self.diameter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='diameter', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'fiducial_type':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'fiducial_type')
            value_ = self.gds_validate_string(value_, node, 'fiducial_type')
            self.fiducial_type = value_
            self.fiducial_type_nsprefix_ = child_.prefix
        elif nodeName_ == 'manufacturer':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'manufacturer')
            value_ = self.gds_validate_string(value_, node, 'manufacturer')
            self.manufacturer = value_
            self.manufacturer_nsprefix_ = child_.prefix
        elif nodeName_ == 'diameter':
            obj_ = fiducial_marker_diameter_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.diameter = obj_
            obj_.original_tagname_ = 'diameter'
# end class fiducial_marker_type


class fiducial_marker_diameter_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='nanometer', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fiducial_marker_diameter_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fiducial_marker_diameter_type.subclass:
            return fiducial_marker_diameter_type.subclass(*args_, **kwargs_)
        else:
            return fiducial_marker_diameter_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_diameter_colloidal_gold(self, value):
        result = True
        # Validate type allowed_diameter_colloidal_gold, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_diameter_colloidal_gold' % {"value": value, "lineno": lineno} )
                result = False
            if value > 100:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_diameter_colloidal_gold' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fiducial_marker_diameter_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fiducial_marker_diameter_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fiducial_marker_diameter_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fiducial_marker_diameter_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fiducial_marker_diameter_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fiducial_marker_diameter_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fiducial_marker_diameter_type


class temperature_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='K', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, temperature_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if temperature_type.subclass:
            return temperature_type.subclass(*args_, **kwargs_)
        else:
            return temperature_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_temperature(self, value):
        result = True
        # Validate type allowed_temperature, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value > 310:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_temperature' % {"value": value, "lineno": lineno} )
                result = False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on allowed_temperature' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='temperature_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('temperature_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'temperature_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='temperature_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='temperature_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='temperature_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class temperature_type


class ultramicrotomy_final_thickness_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ultramicrotomy_final_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ultramicrotomy_final_thickness_type.subclass:
            return ultramicrotomy_final_thickness_type.subclass(*args_, **kwargs_)
        else:
            return ultramicrotomy_final_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_microtome_thickness(self, value):
        result = True
        # Validate type allowed_microtome_thickness, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_microtome_thickness' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ultramicrotomy_final_thickness_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ultramicrotomy_final_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ultramicrotomy_final_thickness_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ultramicrotomy_final_thickness_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ultramicrotomy_final_thickness_type'):
        if self.units != "nm" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ultramicrotomy_final_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class ultramicrotomy_final_thickness_type


class fib_voltage_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='kV', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_voltage_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_voltage_type.subclass:
            return fib_voltage_type.subclass(*args_, **kwargs_)
        else:
            return fib_voltage_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_focus_ion_voltage(self, value):
        result = True
        # Validate type allowed_focus_ion_voltage, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_focus_ion_voltage' % {"value": value, "lineno": lineno} )
                result = False
            if value > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_focus_ion_voltage' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_voltage_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_voltage_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_voltage_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_voltage_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_voltage_type'):
        if self.units != "kV" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_voltage_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_voltage_type


class fib_current_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='nA', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_current_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_current_type.subclass:
            return fib_current_type.subclass(*args_, **kwargs_)
        else:
            return fib_current_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_focus_ion_current(self, value):
        result = True
        # Validate type allowed_focus_ion_current, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.001:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_focus_ion_current' % {"value": value, "lineno": lineno} )
                result = False
            if value > 200:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_focus_ion_current' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_current_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_current_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_current_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_current_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_current_type'):
        if self.units != "nA" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_current_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_current_type


class fib_dose_rate_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='ions/(cm^2*s)', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_dose_rate_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_dose_rate_type.subclass:
            return fib_dose_rate_type.subclass(*args_, **kwargs_)
        else:
            return fib_dose_rate_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_focus_ion_dose_rate(self, value):
        result = True
        # Validate type allowed_focus_ion_dose_rate, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on allowed_focus_ion_dose_rate' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_dose_rate_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_dose_rate_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_dose_rate_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_dose_rate_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_dose_rate_type'):
        if self.units != "ions/(cm^2*s)" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_dose_rate_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_dose_rate_type


class fib_duration_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='s', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_duration_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_duration_type.subclass:
            return fib_duration_type.subclass(*args_, **kwargs_)
        else:
            return fib_duration_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_duration_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_duration_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_duration_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_duration_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_duration_type'):
        if self.units != "s" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_duration_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_duration_type


class fib_initial_thickness_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_initial_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_initial_thickness_type.subclass:
            return fib_initial_thickness_type.subclass(*args_, **kwargs_)
        else:
            return fib_initial_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_focus_ion_initial_thickness(self, value):
        result = True
        # Validate type allowed_focus_ion_initial_thickness, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_focus_ion_initial_thickness' % {"value": value, "lineno": lineno} )
                result = False
            if value > 100000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_focus_ion_initial_thickness' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_initial_thickness_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_initial_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_initial_thickness_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_initial_thickness_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_initial_thickness_type'):
        if self.units != "nm" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_initial_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_initial_thickness_type


class fib_final_thickness_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='nm', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, fib_final_thickness_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if fib_final_thickness_type.subclass:
            return fib_final_thickness_type.subclass(*args_, **kwargs_)
        else:
            return fib_final_thickness_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_focus_ion_final_thickness(self, value):
        result = True
        # Validate type allowed_focus_ion_final_thickness, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_focus_ion_final_thickness' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_final_thickness_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('fib_final_thickness_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'fib_final_thickness_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='fib_final_thickness_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='fib_final_thickness_type'):
        if self.units != "nm" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='fib_final_thickness_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class fib_final_thickness_type


class base_microscopy_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.microscopy_id = _cast(int, microscopy_id)
        self.microscopy_id_nsprefix_ = None
        self.specimen_preparations = specimen_preparations
        self.specimen_preparations_nsprefix_ = None
        self.microscope = microscope
        self.validate_microscopeType(self.microscope)
        self.microscope_nsprefix_ = None
        self.illumination_mode = illumination_mode
        self.validate_illumination_modeType(self.illumination_mode)
        self.illumination_mode_nsprefix_ = None
        self.imaging_mode = imaging_mode
        self.validate_imaging_modeType(self.imaging_mode)
        self.imaging_mode_nsprefix_ = None
        self.electron_source = electron_source
        self.validate_electron_sourceType(self.electron_source)
        self.electron_source_nsprefix_ = None
        self.acceleration_voltage = acceleration_voltage
        self.acceleration_voltage_nsprefix_ = None
        self.c2_aperture_diameter = c2_aperture_diameter
        self.c2_aperture_diameter_nsprefix_ = None
        self.nominal_cs = nominal_cs
        self.nominal_cs_nsprefix_ = None
        self.nominal_defocus_min = nominal_defocus_min
        self.nominal_defocus_min_nsprefix_ = None
        self.calibrated_defocus_min = calibrated_defocus_min
        self.calibrated_defocus_min_nsprefix_ = None
        self.nominal_defocus_max = nominal_defocus_max
        self.nominal_defocus_max_nsprefix_ = None
        self.calibrated_defocus_max = calibrated_defocus_max
        self.calibrated_defocus_max_nsprefix_ = None
        self.nominal_magnification = nominal_magnification
        self.validate_allowed_magnification(self.nominal_magnification)
        self.nominal_magnification_nsprefix_ = None
        self.calibrated_magnification = calibrated_magnification
        self.validate_allowed_magnification(self.calibrated_magnification)
        self.calibrated_magnification_nsprefix_ = None
        self.specimen_holder_model = specimen_holder_model
        self.validate_specimen_holder_modelType(self.specimen_holder_model)
        self.specimen_holder_model_nsprefix_ = None
        self.cooling_holder_cryogen = cooling_holder_cryogen
        self.validate_cooling_holder_cryogenType(self.cooling_holder_cryogen)
        self.cooling_holder_cryogen_nsprefix_ = None
        self.temperature = temperature
        self.temperature_nsprefix_ = None
        self.alignment_procedure = alignment_procedure
        self.alignment_procedure_nsprefix_ = None
        self.specialist_optics = specialist_optics
        self.specialist_optics_nsprefix_ = None
        self.software_list = software_list
        self.software_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.date_nsprefix_ = None
        self.image_recording_list = image_recording_list
        self.image_recording_list_nsprefix_ = None
        self.specimen_holder = specimen_holder
        self.specimen_holder_nsprefix_ = None
        self.tilt_angle_min = tilt_angle_min
        self.tilt_angle_min_nsprefix_ = None
        self.tilt_angle_max = tilt_angle_max
        self.tilt_angle_max_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_microscopy_type.subclass:
            return base_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return base_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_specimen_preparations(self):
        return self.specimen_preparations
    def set_specimen_preparations(self, specimen_preparations):
        self.specimen_preparations = specimen_preparations
    def get_microscope(self):
        return self.microscope
    def set_microscope(self, microscope):
        self.microscope = microscope
    def get_illumination_mode(self):
        return self.illumination_mode
    def set_illumination_mode(self, illumination_mode):
        self.illumination_mode = illumination_mode
    def get_imaging_mode(self):
        return self.imaging_mode
    def set_imaging_mode(self, imaging_mode):
        self.imaging_mode = imaging_mode
    def get_electron_source(self):
        return self.electron_source
    def set_electron_source(self, electron_source):
        self.electron_source = electron_source
    def get_acceleration_voltage(self):
        return self.acceleration_voltage
    def set_acceleration_voltage(self, acceleration_voltage):
        self.acceleration_voltage = acceleration_voltage
    def get_c2_aperture_diameter(self):
        return self.c2_aperture_diameter
    def set_c2_aperture_diameter(self, c2_aperture_diameter):
        self.c2_aperture_diameter = c2_aperture_diameter
    def get_nominal_cs(self):
        return self.nominal_cs
    def set_nominal_cs(self, nominal_cs):
        self.nominal_cs = nominal_cs
    def get_nominal_defocus_min(self):
        return self.nominal_defocus_min
    def set_nominal_defocus_min(self, nominal_defocus_min):
        self.nominal_defocus_min = nominal_defocus_min
    def get_calibrated_defocus_min(self):
        return self.calibrated_defocus_min
    def set_calibrated_defocus_min(self, calibrated_defocus_min):
        self.calibrated_defocus_min = calibrated_defocus_min
    def get_nominal_defocus_max(self):
        return self.nominal_defocus_max
    def set_nominal_defocus_max(self, nominal_defocus_max):
        self.nominal_defocus_max = nominal_defocus_max
    def get_calibrated_defocus_max(self):
        return self.calibrated_defocus_max
    def set_calibrated_defocus_max(self, calibrated_defocus_max):
        self.calibrated_defocus_max = calibrated_defocus_max
    def get_nominal_magnification(self):
        return self.nominal_magnification
    def set_nominal_magnification(self, nominal_magnification):
        self.nominal_magnification = nominal_magnification
    def get_calibrated_magnification(self):
        return self.calibrated_magnification
    def set_calibrated_magnification(self, calibrated_magnification):
        self.calibrated_magnification = calibrated_magnification
    def get_specimen_holder_model(self):
        return self.specimen_holder_model
    def set_specimen_holder_model(self, specimen_holder_model):
        self.specimen_holder_model = specimen_holder_model
    def get_cooling_holder_cryogen(self):
        return self.cooling_holder_cryogen
    def set_cooling_holder_cryogen(self, cooling_holder_cryogen):
        self.cooling_holder_cryogen = cooling_holder_cryogen
    def get_temperature(self):
        return self.temperature
    def set_temperature(self, temperature):
        self.temperature = temperature
    def get_alignment_procedure(self):
        return self.alignment_procedure
    def set_alignment_procedure(self, alignment_procedure):
        self.alignment_procedure = alignment_procedure
    def get_specialist_optics(self):
        return self.specialist_optics
    def set_specialist_optics(self, specialist_optics):
        self.specialist_optics = specialist_optics
    def get_software_list(self):
        return self.software_list
    def set_software_list(self, software_list):
        self.software_list = software_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_date(self):
        return self.date
    def set_date(self, date):
        self.date = date
    def get_image_recording_list(self):
        return self.image_recording_list
    def set_image_recording_list(self, image_recording_list):
        self.image_recording_list = image_recording_list
    def get_specimen_holder(self):
        return self.specimen_holder
    def set_specimen_holder(self, specimen_holder):
        self.specimen_holder = specimen_holder
    def get_tilt_angle_min(self):
        return self.tilt_angle_min
    def set_tilt_angle_min(self, tilt_angle_min):
        self.tilt_angle_min = tilt_angle_min
    def get_tilt_angle_max(self):
        return self.tilt_angle_max
    def set_tilt_angle_max(self, tilt_angle_max):
        self.tilt_angle_max = tilt_angle_max
    def get_microscopy_id(self):
        return self.microscopy_id
    def set_microscopy_id(self, microscopy_id):
        self.microscopy_id = microscopy_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_microscopeType(self, value):
        result = True
        # Validate type microscopeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FEI MORGAGNI', 'FEI POLARA 300', 'FEI TALOS ARCTICA', 'FEI TECNAI 10', 'FEI TECNAI 12', 'FEI TECNAI 20', 'FEI TECNAI ARCTICA', 'FEI TECNAI F20', 'FEI TECNAI F30', 'FEI TECNAI SPHERA', 'FEI TECNAI SPIRIT', 'FEI TITAN', 'FEI TITAN KRIOS', 'FEI/PHILIPS CM10', 'FEI/PHILIPS CM12', 'FEI/PHILIPS CM120T', 'FEI/PHILIPS CM200FEG', 'FEI/PHILIPS CM200FEG/SOPHIE', 'FEI/PHILIPS CM200FEG/ST', 'FEI/PHILIPS CM200FEG/UT', 'FEI/PHILIPS CM200T', 'FEI/PHILIPS CM300FEG/HE', 'FEI/PHILIPS CM300FEG/ST', 'FEI/PHILIPS CM300FEG/T', 'FEI/PHILIPS EM400', 'FEI/PHILIPS EM420', 'HITACHI EF2000', 'HITACHI H-9500SD', 'HITACHI H3000 UHVEM', 'HITACHI H7600', 'HITACHI HF2000', 'HITACHI HF3000', 'JEOL 100CX', 'JEOL 1000EES', 'JEOL 1010', 'JEOL 1200', 'JEOL 1200EX', 'JEOL 1200EXII', 'JEOL 1230', 'JEOL 1400', 'JEOL 1400/HR + YPS FEG', 'JEOL 2000EX', 'JEOL 2000EXII', 'JEOL 2010', 'JEOL 2010F', 'JEOL 2010HC', 'JEOL 2010HT', 'JEOL 2010UHR', 'JEOL 2011', 'JEOL 2100', 'JEOL 2100F', 'JEOL 2200FS', 'JEOL 2200FSC', 'JEOL 3000SFF', 'JEOL 3100FEF', 'JEOL 3100FFC', 'JEOL 3200FS', 'JEOL 3200FSC', 'JEOL 4000', 'JEOL 4000EX', 'JEOL CRYO ARM 200', 'JEOL CRYO ARM 300', 'JEOL KYOTO-3000SFF', 'TFS GLACIOS', 'TFS KRIOS', 'TFS TALOS', 'TFS TALOS L120C', 'TFS TALOS F200C', 'TFS TUNDRA', 'ZEISS LEO912', 'ZEISS LIBRA120PLUS']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on microscopeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_illumination_modeType(self, value):
        result = True
        # Validate type illumination_modeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FLOOD BEAM', 'SPOT SCAN', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on illumination_modeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_imaging_modeType(self, value):
        result = True
        # Validate type imaging_modeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['BRIGHT FIELD', 'DARK FIELD', 'DIFFRACTION', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on imaging_modeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_electron_sourceType(self, value):
        result = True
        # Validate type electron_sourceType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['TUNGSTEN HAIRPIN', 'LAB6', 'OTHER', 'FIELD EMISSION GUN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on electron_sourceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_allowed_magnification(self, value):
        result = True
        # Validate type allowed_magnification, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 1000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on allowed_magnification' % {"value": value, "lineno": lineno} )
                result = False
            if value > 500000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on allowed_magnification' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_specimen_holder_modelType(self, value):
        result = True
        # Validate type specimen_holder_modelType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FISCHIONE 2550', 'FISCHIONE INSTRUMENTS DUAL AXIS TOMOGRAPHY HOLDER', 'FEI TITAN KRIOS AUTOGRID HOLDER', 'GATAN 626 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN 910 MULTI-SPECIMEN SINGLE TILT CRYO TRANSFER HOLDER', 'GATAN 914 HIGH TILT LIQUID NITROGEN CRYO TRANSFER TOMOGRAPHY HOLDER', 'GATAN 915 DOUBLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN CHDT 3504 DOUBLE TILT HIGH RESOLUTION NITROGEN COOLING HOLDER', 'GATAN CT3500 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN CT3500TR SINGLE TILT ROTATION LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN ELSA 698 SINGLE TILT LIQUID NITROGEN CRYO TRANSFER HOLDER', 'GATAN HC 3500 SINGLE TILT HEATING/NITROGEN COOLING HOLDER', 'GATAN HCHDT 3010 DOUBLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER', 'GATAN HCHST 3008 SINGLE TILT HIGH RESOLUTION HELIUM COOLING HOLDER', 'GATAN HELIUM', 'GATAN LIQUID NITROGEN', 'GATAN UHRST 3500 SINGLE TILT ULTRA HIGH RESOLUTION NITROGEN COOLING HOLDER', 'GATAN ULTDT ULTRA LOW TEMPERATURE DOUBLE TILT HELIUM COOLING HOLDER', 'GATAN ULTST ULTRA LOW TEMPERATURE SINGLE TILT HELIUM COOLING HOLDER', 'HOME BUILD', 'JEOL', 'JEOL 3200FSC CRYOHOLDER', 'OTHER', 'PHILIPS ROTATION HOLDER', 'SIDE ENTRY, EUCENTRIC', 'JEOL CRYOSPECPORTER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on specimen_holder_modelType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_cooling_holder_cryogenType(self, value):
        result = True
        # Validate type cooling_holder_cryogenType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['HELIUM', 'NITROGEN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on cooling_holder_cryogenType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.specimen_preparations is not None or
            self.microscope is not None or
            self.illumination_mode is not None or
            self.imaging_mode is not None or
            self.electron_source is not None or
            self.acceleration_voltage is not None or
            self.c2_aperture_diameter is not None or
            self.nominal_cs is not None or
            self.nominal_defocus_min is not None or
            self.calibrated_defocus_min is not None or
            self.nominal_defocus_max is not None or
            self.calibrated_defocus_max is not None or
            self.nominal_magnification is not None or
            self.calibrated_magnification is not None or
            self.specimen_holder_model is not None or
            self.cooling_holder_cryogen is not None or
            self.temperature is not None or
            self.alignment_procedure is not None or
            self.specialist_optics is not None or
            self.software_list is not None or
            self.details is not None or
            self.date is not None or
            self.image_recording_list is not None or
            self.specimen_holder is not None or
            self.tilt_angle_min is not None or
            self.tilt_angle_max is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_microscopy_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_microscopy_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_microscopy_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_microscopy_type'):
        if self.microscopy_id is not None and 'microscopy_id' not in already_processed:
            already_processed.add('microscopy_id')
            outfile.write(' microscopy_id="%s"' % self.gds_format_integer(self.microscopy_id, input_name='microscopy_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_microscopy_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specimen_preparations is not None:
            namespaceprefix_ = self.specimen_preparations_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_preparations_nsprefix_) else ''
            self.specimen_preparations.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specimen_preparations', pretty_print=pretty_print)
        if self.microscope is not None:
            namespaceprefix_ = self.microscope_nsprefix_ + ':' if (UseCapturedNS_ and self.microscope_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smicroscope>%s</%smicroscope>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.microscope), input_name='microscope')), namespaceprefix_ , eol_))
        if self.illumination_mode is not None:
            namespaceprefix_ = self.illumination_mode_nsprefix_ + ':' if (UseCapturedNS_ and self.illumination_mode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sillumination_mode>%s</%sillumination_mode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.illumination_mode), input_name='illumination_mode')), namespaceprefix_ , eol_))
        if self.imaging_mode is not None:
            namespaceprefix_ = self.imaging_mode_nsprefix_ + ':' if (UseCapturedNS_ and self.imaging_mode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simaging_mode>%s</%simaging_mode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.imaging_mode), input_name='imaging_mode')), namespaceprefix_ , eol_))
        if self.electron_source is not None:
            namespaceprefix_ = self.electron_source_nsprefix_ + ':' if (UseCapturedNS_ and self.electron_source_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selectron_source>%s</%selectron_source>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.electron_source), input_name='electron_source')), namespaceprefix_ , eol_))
        if self.acceleration_voltage is not None:
            namespaceprefix_ = self.acceleration_voltage_nsprefix_ + ':' if (UseCapturedNS_ and self.acceleration_voltage_nsprefix_) else ''
            self.acceleration_voltage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acceleration_voltage', pretty_print=pretty_print)
        if self.c2_aperture_diameter is not None:
            namespaceprefix_ = self.c2_aperture_diameter_nsprefix_ + ':' if (UseCapturedNS_ and self.c2_aperture_diameter_nsprefix_) else ''
            self.c2_aperture_diameter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='c2_aperture_diameter', pretty_print=pretty_print)
        if self.nominal_cs is not None:
            namespaceprefix_ = self.nominal_cs_nsprefix_ + ':' if (UseCapturedNS_ and self.nominal_cs_nsprefix_) else ''
            self.nominal_cs.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nominal_cs', pretty_print=pretty_print)
        if self.nominal_defocus_min is not None:
            namespaceprefix_ = self.nominal_defocus_min_nsprefix_ + ':' if (UseCapturedNS_ and self.nominal_defocus_min_nsprefix_) else ''
            self.nominal_defocus_min.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nominal_defocus_min', pretty_print=pretty_print)
        if self.calibrated_defocus_min is not None:
            namespaceprefix_ = self.calibrated_defocus_min_nsprefix_ + ':' if (UseCapturedNS_ and self.calibrated_defocus_min_nsprefix_) else ''
            self.calibrated_defocus_min.export(outfile, level, namespaceprefix_, namespacedef_='', name_='calibrated_defocus_min', pretty_print=pretty_print)
        if self.nominal_defocus_max is not None:
            namespaceprefix_ = self.nominal_defocus_max_nsprefix_ + ':' if (UseCapturedNS_ and self.nominal_defocus_max_nsprefix_) else ''
            self.nominal_defocus_max.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nominal_defocus_max', pretty_print=pretty_print)
        if self.calibrated_defocus_max is not None:
            namespaceprefix_ = self.calibrated_defocus_max_nsprefix_ + ':' if (UseCapturedNS_ and self.calibrated_defocus_max_nsprefix_) else ''
            self.calibrated_defocus_max.export(outfile, level, namespaceprefix_, namespacedef_='', name_='calibrated_defocus_max', pretty_print=pretty_print)
        if self.nominal_magnification is not None:
            namespaceprefix_ = self.nominal_magnification_nsprefix_ + ':' if (UseCapturedNS_ and self.nominal_magnification_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snominal_magnification>%s</%snominal_magnification>%s' % (namespaceprefix_ , self.gds_format_float(self.nominal_magnification, input_name='nominal_magnification'), namespaceprefix_ , eol_))
        if self.calibrated_magnification is not None:
            namespaceprefix_ = self.calibrated_magnification_nsprefix_ + ':' if (UseCapturedNS_ and self.calibrated_magnification_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scalibrated_magnification>%s</%scalibrated_magnification>%s' % (namespaceprefix_ , self.gds_format_float(self.calibrated_magnification, input_name='calibrated_magnification'), namespaceprefix_ , eol_))
        if self.specimen_holder_model is not None:
            namespaceprefix_ = self.specimen_holder_model_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_holder_model_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimen_holder_model>%s</%sspecimen_holder_model>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.specimen_holder_model), input_name='specimen_holder_model')), namespaceprefix_ , eol_))
        if self.cooling_holder_cryogen is not None:
            namespaceprefix_ = self.cooling_holder_cryogen_nsprefix_ + ':' if (UseCapturedNS_ and self.cooling_holder_cryogen_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scooling_holder_cryogen>%s</%scooling_holder_cryogen>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.cooling_holder_cryogen), input_name='cooling_holder_cryogen')), namespaceprefix_ , eol_))
        if self.temperature is not None:
            namespaceprefix_ = self.temperature_nsprefix_ + ':' if (UseCapturedNS_ and self.temperature_nsprefix_) else ''
            self.temperature.export(outfile, level, namespaceprefix_, namespacedef_='', name_='temperature', pretty_print=pretty_print)
        if self.alignment_procedure is not None:
            namespaceprefix_ = self.alignment_procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.alignment_procedure_nsprefix_) else ''
            self.alignment_procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alignment_procedure', pretty_print=pretty_print)
        if self.specialist_optics is not None:
            namespaceprefix_ = self.specialist_optics_nsprefix_ + ':' if (UseCapturedNS_ and self.specialist_optics_nsprefix_) else ''
            self.specialist_optics.export(outfile, level, namespaceprefix_, namespacedef_='', name_='specialist_optics', pretty_print=pretty_print)
        if self.software_list is not None:
            namespaceprefix_ = self.software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.software_list_nsprefix_) else ''
            self.software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
        if self.date is not None:
            namespaceprefix_ = self.date_nsprefix_ + ':' if (UseCapturedNS_ and self.date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespaceprefix_ , self.gds_format_date(self.date, input_name='date'), namespaceprefix_ , eol_))
        if self.image_recording_list is not None:
            namespaceprefix_ = self.image_recording_list_nsprefix_ + ':' if (UseCapturedNS_ and self.image_recording_list_nsprefix_) else ''
            self.image_recording_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='image_recording_list', pretty_print=pretty_print)
        if self.specimen_holder is not None:
            namespaceprefix_ = self.specimen_holder_nsprefix_ + ':' if (UseCapturedNS_ and self.specimen_holder_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimen_holder>%s</%sspecimen_holder>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.specimen_holder), input_name='specimen_holder')), namespaceprefix_ , eol_))
        if self.tilt_angle_min is not None:
            namespaceprefix_ = self.tilt_angle_min_nsprefix_ + ':' if (UseCapturedNS_ and self.tilt_angle_min_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stilt_angle_min>%s</%stilt_angle_min>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tilt_angle_min), input_name='tilt_angle_min')), namespaceprefix_ , eol_))
        if self.tilt_angle_max is not None:
            namespaceprefix_ = self.tilt_angle_max_nsprefix_ + ':' if (UseCapturedNS_ and self.tilt_angle_max_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stilt_angle_max>%s</%stilt_angle_max>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.tilt_angle_max), input_name='tilt_angle_max')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('microscopy_id', node)
        if value is not None and 'microscopy_id' not in already_processed:
            already_processed.add('microscopy_id')
            self.microscopy_id = self.gds_parse_integer(value, node, 'microscopy_id')
            if self.microscopy_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'specimen_preparations':
            obj_ = specimen_preparationsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specimen_preparations = obj_
            obj_.original_tagname_ = 'specimen_preparations'
        elif nodeName_ == 'microscope':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'microscope')
            value_ = self.gds_validate_string(value_, node, 'microscope')
            self.microscope = value_
            self.microscope_nsprefix_ = child_.prefix
            # validate type microscopeType
            self.validate_microscopeType(self.microscope)
        elif nodeName_ == 'illumination_mode':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'illumination_mode')
            value_ = self.gds_validate_string(value_, node, 'illumination_mode')
            self.illumination_mode = value_
            self.illumination_mode_nsprefix_ = child_.prefix
            # validate type illumination_modeType
            self.validate_illumination_modeType(self.illumination_mode)
        elif nodeName_ == 'imaging_mode':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'imaging_mode')
            value_ = self.gds_validate_string(value_, node, 'imaging_mode')
            self.imaging_mode = value_
            self.imaging_mode_nsprefix_ = child_.prefix
            # validate type imaging_modeType
            self.validate_imaging_modeType(self.imaging_mode)
        elif nodeName_ == 'electron_source':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'electron_source')
            value_ = self.gds_validate_string(value_, node, 'electron_source')
            self.electron_source = value_
            self.electron_source_nsprefix_ = child_.prefix
            # validate type electron_sourceType
            self.validate_electron_sourceType(self.electron_source)
        elif nodeName_ == 'acceleration_voltage':
            obj_ = acceleration_voltageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.acceleration_voltage = obj_
            obj_.original_tagname_ = 'acceleration_voltage'
        elif nodeName_ == 'c2_aperture_diameter':
            obj_ = c2_aperture_diameterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.c2_aperture_diameter = obj_
            obj_.original_tagname_ = 'c2_aperture_diameter'
        elif nodeName_ == 'nominal_cs':
            obj_ = nominal_csType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.nominal_cs = obj_
            obj_.original_tagname_ = 'nominal_cs'
        elif nodeName_ == 'nominal_defocus_min':
            obj_ = nominal_defocus_minType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.nominal_defocus_min = obj_
            obj_.original_tagname_ = 'nominal_defocus_min'
        elif nodeName_ == 'calibrated_defocus_min':
            obj_ = calibrated_defocus_minType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.calibrated_defocus_min = obj_
            obj_.original_tagname_ = 'calibrated_defocus_min'
        elif nodeName_ == 'nominal_defocus_max':
            obj_ = nominal_defocus_maxType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.nominal_defocus_max = obj_
            obj_.original_tagname_ = 'nominal_defocus_max'
        elif nodeName_ == 'calibrated_defocus_max':
            obj_ = calibrated_defocus_maxType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.calibrated_defocus_max = obj_
            obj_.original_tagname_ = 'calibrated_defocus_max'
        elif nodeName_ == 'nominal_magnification' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'nominal_magnification')
            fval_ = self.gds_validate_float(fval_, node, 'nominal_magnification')
            self.nominal_magnification = fval_
            self.nominal_magnification_nsprefix_ = child_.prefix
            # validate type allowed_magnification
            self.validate_allowed_magnification(self.nominal_magnification)
        elif nodeName_ == 'calibrated_magnification' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'calibrated_magnification')
            fval_ = self.gds_validate_float(fval_, node, 'calibrated_magnification')
            self.calibrated_magnification = fval_
            self.calibrated_magnification_nsprefix_ = child_.prefix
            # validate type allowed_magnification
            self.validate_allowed_magnification(self.calibrated_magnification)
        elif nodeName_ == 'specimen_holder_model':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'specimen_holder_model')
            value_ = self.gds_validate_string(value_, node, 'specimen_holder_model')
            self.specimen_holder_model = value_
            self.specimen_holder_model_nsprefix_ = child_.prefix
            # validate type specimen_holder_modelType
            self.validate_specimen_holder_modelType(self.specimen_holder_model)
        elif nodeName_ == 'cooling_holder_cryogen':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'cooling_holder_cryogen')
            value_ = self.gds_validate_string(value_, node, 'cooling_holder_cryogen')
            self.cooling_holder_cryogen = value_
            self.cooling_holder_cryogen_nsprefix_ = child_.prefix
            # validate type cooling_holder_cryogenType
            self.validate_cooling_holder_cryogenType(self.cooling_holder_cryogen)
        elif nodeName_ == 'temperature':
            obj_ = temperatureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.temperature = obj_
            obj_.original_tagname_ = 'temperature'
        elif nodeName_ == 'alignment_procedure':
            obj_ = alignment_procedureType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alignment_procedure = obj_
            obj_.original_tagname_ = 'alignment_procedure'
        elif nodeName_ == 'specialist_optics':
            obj_ = specialist_optics_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specialist_optics = obj_
            obj_.original_tagname_ = 'specialist_optics'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
        elif nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
            self.date_nsprefix_ = child_.prefix
        elif nodeName_ == 'image_recording_list':
            obj_ = image_recording_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.image_recording_list = obj_
            obj_.original_tagname_ = 'image_recording_list'
        elif nodeName_ == 'specimen_holder':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'specimen_holder')
            value_ = self.gds_validate_string(value_, node, 'specimen_holder')
            self.specimen_holder = value_
            self.specimen_holder_nsprefix_ = child_.prefix
        elif nodeName_ == 'tilt_angle_min':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tilt_angle_min')
            value_ = self.gds_validate_string(value_, node, 'tilt_angle_min')
            self.tilt_angle_min = value_
            self.tilt_angle_min_nsprefix_ = child_.prefix
        elif nodeName_ == 'tilt_angle_max':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'tilt_angle_max')
            value_ = self.gds_validate_string(value_, node, 'tilt_angle_max')
            self.tilt_angle_max = value_
            self.tilt_angle_max_nsprefix_ = child_.prefix
# end class base_microscopy_type


class residual_tilt_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='mrad', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, residual_tilt_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if residual_tilt_type.subclass:
            return residual_tilt_type.subclass(*args_, **kwargs_)
        else:
            return residual_tilt_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='residual_tilt_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('residual_tilt_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'residual_tilt_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='residual_tilt_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='residual_tilt_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='residual_tilt_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class residual_tilt_type


class specialist_optics_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, phase_plate=None, sph_aberration_corrector=None, chr_aberration_corrector=None, energy_filter=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.phase_plate = phase_plate
        self.validate_phase_plateType(self.phase_plate)
        self.phase_plate_nsprefix_ = None
        self.sph_aberration_corrector = sph_aberration_corrector
        self.sph_aberration_corrector_nsprefix_ = None
        self.chr_aberration_corrector = chr_aberration_corrector
        self.chr_aberration_corrector_nsprefix_ = None
        self.energy_filter = energy_filter
        self.energy_filter_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, specialist_optics_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if specialist_optics_type.subclass:
            return specialist_optics_type.subclass(*args_, **kwargs_)
        else:
            return specialist_optics_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_phase_plate(self):
        return self.phase_plate
    def set_phase_plate(self, phase_plate):
        self.phase_plate = phase_plate
    def get_sph_aberration_corrector(self):
        return self.sph_aberration_corrector
    def set_sph_aberration_corrector(self, sph_aberration_corrector):
        self.sph_aberration_corrector = sph_aberration_corrector
    def get_chr_aberration_corrector(self):
        return self.chr_aberration_corrector
    def set_chr_aberration_corrector(self, chr_aberration_corrector):
        self.chr_aberration_corrector = chr_aberration_corrector
    def get_energy_filter(self):
        return self.energy_filter
    def set_energy_filter(self, energy_filter):
        self.energy_filter = energy_filter
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_phase_plateType(self, value):
        result = True
        # Validate type phase_plateType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ZERNIKE PHASE PLATE', 'VOLTA PHASE PLATE', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on phase_plateType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.phase_plate is not None or
            self.sph_aberration_corrector is not None or
            self.chr_aberration_corrector is not None or
            self.energy_filter is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='specialist_optics_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('specialist_optics_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'specialist_optics_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='specialist_optics_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='specialist_optics_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='specialist_optics_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='specialist_optics_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phase_plate is not None:
            namespaceprefix_ = self.phase_plate_nsprefix_ + ':' if (UseCapturedNS_ and self.phase_plate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphase_plate>%s</%sphase_plate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.phase_plate), input_name='phase_plate')), namespaceprefix_ , eol_))
        if self.sph_aberration_corrector is not None:
            namespaceprefix_ = self.sph_aberration_corrector_nsprefix_ + ':' if (UseCapturedNS_ and self.sph_aberration_corrector_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssph_aberration_corrector>%s</%ssph_aberration_corrector>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.sph_aberration_corrector), input_name='sph_aberration_corrector')), namespaceprefix_ , eol_))
        if self.chr_aberration_corrector is not None:
            namespaceprefix_ = self.chr_aberration_corrector_nsprefix_ + ':' if (UseCapturedNS_ and self.chr_aberration_corrector_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schr_aberration_corrector>%s</%schr_aberration_corrector>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.chr_aberration_corrector), input_name='chr_aberration_corrector')), namespaceprefix_ , eol_))
        if self.energy_filter is not None:
            namespaceprefix_ = self.energy_filter_nsprefix_ + ':' if (UseCapturedNS_ and self.energy_filter_nsprefix_) else ''
            self.energy_filter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='energy_filter', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'phase_plate':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'phase_plate')
            value_ = self.gds_validate_string(value_, node, 'phase_plate')
            self.phase_plate = value_
            self.phase_plate_nsprefix_ = child_.prefix
            # validate type phase_plateType
            self.validate_phase_plateType(self.phase_plate)
        elif nodeName_ == 'sph_aberration_corrector':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'sph_aberration_corrector')
            value_ = self.gds_validate_string(value_, node, 'sph_aberration_corrector')
            self.sph_aberration_corrector = value_
            self.sph_aberration_corrector_nsprefix_ = child_.prefix
        elif nodeName_ == 'chr_aberration_corrector':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'chr_aberration_corrector')
            value_ = self.gds_validate_string(value_, node, 'chr_aberration_corrector')
            self.chr_aberration_corrector = value_
            self.chr_aberration_corrector_nsprefix_ = child_.prefix
        elif nodeName_ == 'energy_filter':
            obj_ = energy_filterType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.energy_filter = obj_
            obj_.original_tagname_ = 'energy_filter'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class specialist_optics_type


class software_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, software=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if software is None:
            self.software = []
        else:
            self.software = software
        self.software_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_list_type.subclass:
            return software_list_type.subclass(*args_, **kwargs_)
        else:
            return software_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_software(self):
        return self.software
    def set_software(self, software):
        self.software = software
    def add_software(self, value):
        self.software.append(value)
    def insert_software_at(self, index, value):
        self.software.insert(index, value)
    def replace_software_at(self, index, value):
        self.software[index] = value
    def has__content(self):
        if (
            self.software
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'software_list_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='software_list_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='software_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='software_list_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for software_ in self.software:
            namespaceprefix_ = self.software_nsprefix_ + ':' if (UseCapturedNS_ and self.software_nsprefix_) else ''
            software_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'software':
            obj_ = software_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software.append(obj_)
            obj_.original_tagname_ = 'software'
# end class software_list_type


class software_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, version=None, processing_details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
        self.processing_details = processing_details
        self.processing_details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_type.subclass:
            return software_type.subclass(*args_, **kwargs_)
        else:
            return software_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_processing_details(self):
        return self.processing_details
    def set_processing_details(self, processing_details):
        self.processing_details = processing_details
    def has__content(self):
        if (
            self.name is not None or
            self.version is not None or
            self.processing_details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'software_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='software_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='software_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='software_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.processing_details is not None:
            namespaceprefix_ = self.processing_details_nsprefix_ + ':' if (UseCapturedNS_ and self.processing_details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocessing_details>%s</%sprocessing_details>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.processing_details), input_name='processing_details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'processing_details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'processing_details')
            value_ = self.gds_validate_string(value_, node, 'processing_details')
            self.processing_details = value_
            self.processing_details_nsprefix_ = child_.prefix
# end class software_type


class crystallography_microscopy_type(base_microscopy_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, camera_length=None, tilt_list=None, tilt_series=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("crystallography_microscopy_type"), self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max,  **kwargs_)
        self.camera_length = camera_length
        self.camera_length_nsprefix_ = None
        self.tilt_list = tilt_list
        self.tilt_list_nsprefix_ = None
        if tilt_series is None:
            self.tilt_series = []
        else:
            self.tilt_series = tilt_series
        self.tilt_series_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_microscopy_type.subclass:
            return crystallography_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_camera_length(self):
        return self.camera_length
    def set_camera_length(self, camera_length):
        self.camera_length = camera_length
    def get_tilt_list(self):
        return self.tilt_list
    def set_tilt_list(self, tilt_list):
        self.tilt_list = tilt_list
    def get_tilt_series(self):
        return self.tilt_series
    def set_tilt_series(self, tilt_series):
        self.tilt_series = tilt_series
    def add_tilt_series(self, value):
        self.tilt_series.append(value)
    def insert_tilt_series_at(self, index, value):
        self.tilt_series.insert(index, value)
    def replace_tilt_series_at(self, index, value):
        self.tilt_series[index] = value
    def has__content(self):
        if (
            self.camera_length is not None or
            self.tilt_list is not None or
            self.tilt_series or
            super(crystallography_microscopy_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_microscopy_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystallography_microscopy_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_microscopy_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crystallography_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystallography_microscopy_type'):
        super(crystallography_microscopy_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_microscopy_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_microscopy_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.camera_length is not None:
            namespaceprefix_ = self.camera_length_nsprefix_ + ':' if (UseCapturedNS_ and self.camera_length_nsprefix_) else ''
            self.camera_length.export(outfile, level, namespaceprefix_, namespacedef_='', name_='camera_length', pretty_print=pretty_print)
        if self.tilt_list is not None:
            namespaceprefix_ = self.tilt_list_nsprefix_ + ':' if (UseCapturedNS_ and self.tilt_list_nsprefix_) else ''
            self.tilt_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilt_list', pretty_print=pretty_print)
        for tilt_series_ in self.tilt_series:
            namespaceprefix_ = self.tilt_series_nsprefix_ + ':' if (UseCapturedNS_ and self.tilt_series_nsprefix_) else ''
            tilt_series_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilt_series', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(crystallography_microscopy_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'camera_length':
            obj_ = camera_lengthType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.camera_length = obj_
            obj_.original_tagname_ = 'camera_length'
        elif nodeName_ == 'tilt_list':
            obj_ = tilt_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.tilt_list = obj_
            obj_.original_tagname_ = 'tilt_list'
        elif nodeName_ == 'tilt_series':
            obj_ = tilt_series_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.tilt_series.append(obj_)
            obj_.original_tagname_ = 'tilt_series'
        super(crystallography_microscopy_type, self)._buildChildren(child_, node, nodeName_, True)
# end class crystallography_microscopy_type


class tilt_series_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, axis1=None, axis2=None, axis_rotation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.axis1 = axis1
        self.axis1_nsprefix_ = None
        self.axis2 = axis2
        self.axis2_nsprefix_ = None
        self.axis_rotation = axis_rotation
        self.axis_rotation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tilt_series_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tilt_series_type.subclass:
            return tilt_series_type.subclass(*args_, **kwargs_)
        else:
            return tilt_series_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_axis1(self):
        return self.axis1
    def set_axis1(self, axis1):
        self.axis1 = axis1
    def get_axis2(self):
        return self.axis2
    def set_axis2(self, axis2):
        self.axis2 = axis2
    def get_axis_rotation(self):
        return self.axis_rotation
    def set_axis_rotation(self, axis_rotation):
        self.axis_rotation = axis_rotation
    def has__content(self):
        if (
            self.axis1 is not None or
            self.axis2 is not None or
            self.axis_rotation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tilt_series_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tilt_series_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'tilt_series_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tilt_series_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='tilt_series_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='tilt_series_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tilt_series_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.axis1 is not None:
            namespaceprefix_ = self.axis1_nsprefix_ + ':' if (UseCapturedNS_ and self.axis1_nsprefix_) else ''
            self.axis1.export(outfile, level, namespaceprefix_, namespacedef_='', name_='axis1', pretty_print=pretty_print)
        if self.axis2 is not None:
            namespaceprefix_ = self.axis2_nsprefix_ + ':' if (UseCapturedNS_ and self.axis2_nsprefix_) else ''
            self.axis2.export(outfile, level, namespaceprefix_, namespacedef_='', name_='axis2', pretty_print=pretty_print)
        if self.axis_rotation is not None:
            namespaceprefix_ = self.axis_rotation_nsprefix_ + ':' if (UseCapturedNS_ and self.axis_rotation_nsprefix_) else ''
            self.axis_rotation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='axis_rotation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'axis1':
            class_obj_ = self.get_class_obj_(child_, axis_type)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.axis1 = obj_
            obj_.original_tagname_ = 'axis1'
        elif nodeName_ == 'axis2':
            obj_ = axis2Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.axis2 = obj_
            obj_.original_tagname_ = 'axis2'
        elif nodeName_ == 'axis_rotation':
            obj_ = axis_rotationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.axis_rotation = obj_
            obj_.original_tagname_ = 'axis_rotation'
# end class tilt_series_type


class axis_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, min_angle=None, max_angle=None, angle_increment=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.min_angle = min_angle
        self.min_angle_nsprefix_ = None
        self.max_angle = max_angle
        self.max_angle_nsprefix_ = None
        self.angle_increment = angle_increment
        self.angle_increment_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, axis_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if axis_type.subclass:
            return axis_type.subclass(*args_, **kwargs_)
        else:
            return axis_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_min_angle(self):
        return self.min_angle
    def set_min_angle(self, min_angle):
        self.min_angle = min_angle
    def get_max_angle(self):
        return self.max_angle
    def set_max_angle(self, max_angle):
        self.max_angle = max_angle
    def get_angle_increment(self):
        return self.angle_increment
    def set_angle_increment(self, angle_increment):
        self.angle_increment = angle_increment
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.min_angle is not None or
            self.max_angle is not None or
            self.angle_increment is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='axis_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('axis_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'axis_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='axis_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='axis_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='axis_type'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='axis_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.min_angle is not None:
            namespaceprefix_ = self.min_angle_nsprefix_ + ':' if (UseCapturedNS_ and self.min_angle_nsprefix_) else ''
            self.min_angle.export(outfile, level, namespaceprefix_, namespacedef_='', name_='min_angle', pretty_print=pretty_print)
        if self.max_angle is not None:
            namespaceprefix_ = self.max_angle_nsprefix_ + ':' if (UseCapturedNS_ and self.max_angle_nsprefix_) else ''
            self.max_angle.export(outfile, level, namespaceprefix_, namespacedef_='', name_='max_angle', pretty_print=pretty_print)
        if self.angle_increment is not None:
            namespaceprefix_ = self.angle_increment_nsprefix_ + ':' if (UseCapturedNS_ and self.angle_increment_nsprefix_) else ''
            self.angle_increment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='angle_increment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'min_angle':
            obj_ = min_angleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.min_angle = obj_
            obj_.original_tagname_ = 'min_angle'
        elif nodeName_ == 'max_angle':
            obj_ = max_angleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.max_angle = obj_
            obj_.original_tagname_ = 'max_angle'
        elif nodeName_ == 'angle_increment':
            obj_ = angle_incrementType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.angle_increment = obj_
            obj_.original_tagname_ = 'angle_increment'
# end class axis_type


class helical_microscopy_type(base_microscopy_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("helical_microscopy_type"), self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_microscopy_type.subclass:
            return helical_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return helical_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(helical_microscopy_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_microscopy_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'helical_microscopy_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_microscopy_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='helical_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='helical_microscopy_type'):
        super(helical_microscopy_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_microscopy_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(helical_microscopy_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(helical_microscopy_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(helical_microscopy_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class helical_microscopy_type


class single_particle_microscopy_type(base_microscopy_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("single_particle_microscopy_type"), self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, single_particle_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if single_particle_microscopy_type.subclass:
            return single_particle_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return single_particle_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(single_particle_microscopy_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='single_particle_microscopy_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('single_particle_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'single_particle_microscopy_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='single_particle_microscopy_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='single_particle_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='single_particle_microscopy_type'):
        super(single_particle_microscopy_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='single_particle_microscopy_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='single_particle_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(single_particle_microscopy_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(single_particle_microscopy_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(single_particle_microscopy_type, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class single_particle_microscopy_type


class tomography_microscopy_type(base_microscopy_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_microscopy_type
    def __init__(self, microscopy_id=None, specimen_preparations=None, microscope=None, illumination_mode=None, imaging_mode=None, electron_source=None, acceleration_voltage=None, c2_aperture_diameter=None, nominal_cs=None, nominal_defocus_min=None, calibrated_defocus_min=None, nominal_defocus_max=None, calibrated_defocus_max=None, nominal_magnification=None, calibrated_magnification=None, specimen_holder_model=None, cooling_holder_cryogen=None, temperature=None, alignment_procedure=None, specialist_optics=None, software_list=None, details=None, date=None, image_recording_list=None, specimen_holder=None, tilt_angle_min=None, tilt_angle_max=None, tilt_series=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("tomography_microscopy_type"), self).__init__(microscopy_id, specimen_preparations, microscope, illumination_mode, imaging_mode, electron_source, acceleration_voltage, c2_aperture_diameter, nominal_cs, nominal_defocus_min, calibrated_defocus_min, nominal_defocus_max, calibrated_defocus_max, nominal_magnification, calibrated_magnification, specimen_holder_model, cooling_holder_cryogen, temperature, alignment_procedure, specialist_optics, software_list, details, date, image_recording_list, specimen_holder, tilt_angle_min, tilt_angle_max,  **kwargs_)
        if tilt_series is None:
            self.tilt_series = []
        else:
            self.tilt_series = tilt_series
        self.tilt_series_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, tomography_microscopy_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tomography_microscopy_type.subclass:
            return tomography_microscopy_type.subclass(*args_, **kwargs_)
        else:
            return tomography_microscopy_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_tilt_series(self):
        return self.tilt_series
    def set_tilt_series(self, tilt_series):
        self.tilt_series = tilt_series
    def add_tilt_series(self, value):
        self.tilt_series.append(value)
    def insert_tilt_series_at(self, index, value):
        self.tilt_series.insert(index, value)
    def replace_tilt_series_at(self, index, value):
        self.tilt_series[index] = value
    def has__content(self):
        if (
            self.tilt_series or
            super(tomography_microscopy_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tomography_microscopy_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('tomography_microscopy_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'tomography_microscopy_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tomography_microscopy_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='tomography_microscopy_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='tomography_microscopy_type'):
        super(tomography_microscopy_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='tomography_microscopy_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='tomography_microscopy_type', fromsubclass_=False, pretty_print=True):
        super(tomography_microscopy_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for tilt_series_ in self.tilt_series:
            namespaceprefix_ = self.tilt_series_nsprefix_ + ':' if (UseCapturedNS_ and self.tilt_series_nsprefix_) else ''
            tilt_series_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilt_series', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(tomography_microscopy_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'tilt_series':
            obj_ = tilt_series_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.tilt_series.append(obj_)
            obj_.original_tagname_ = 'tilt_series'
        super(tomography_microscopy_type, self)._buildChildren(child_, node, nodeName_, True)
# end class tomography_microscopy_type


class base_image_processing_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.image_processing_id = _cast(int, image_processing_id)
        self.image_processing_id_nsprefix_ = None
        self.image_recording_id = image_recording_id
        self.image_recording_id_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, base_image_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if base_image_processing_type.subclass:
            return base_image_processing_type.subclass(*args_, **kwargs_)
        else:
            return base_image_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_image_recording_id(self):
        return self.image_recording_id
    def set_image_recording_id(self, image_recording_id):
        self.image_recording_id = image_recording_id
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_image_processing_id(self):
        return self.image_processing_id
    def set_image_processing_id(self, image_processing_id):
        self.image_processing_id = image_processing_id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.image_recording_id is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_image_processing_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('base_image_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'base_image_processing_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='base_image_processing_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='base_image_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='base_image_processing_type'):
        if self.image_processing_id is not None and 'image_processing_id' not in already_processed:
            already_processed.add('image_processing_id')
            outfile.write(' image_processing_id="%s"' % self.gds_format_integer(self.image_processing_id, input_name='image_processing_id'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='base_image_processing_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.image_recording_id is not None:
            namespaceprefix_ = self.image_recording_id_nsprefix_ + ':' if (UseCapturedNS_ and self.image_recording_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simage_recording_id>%s</%simage_recording_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.image_recording_id, input_name='image_recording_id'), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('image_processing_id', node)
        if value is not None and 'image_processing_id' not in already_processed:
            already_processed.add('image_processing_id')
            self.image_processing_id = self.gds_parse_integer(value, node, 'image_processing_id')
            if self.image_processing_id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'image_recording_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'image_recording_id')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'image_recording_id')
            self.image_recording_id = ival_
            self.image_recording_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'details':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class base_image_processing_type


class crystallography_processing_type(base_image_processing_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, crystal_parameters=None, startup_model=None, ctf_correction=None, molecular_replacement=None, lattice_distortion_correction_software_list=None, symmetry_determination_software_list=None, merging_software_list=None, crystallography_statistics=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("crystallography_processing_type"), self).__init__(image_processing_id, image_recording_id, details,  **kwargs_)
        self.final_reconstruction = final_reconstruction
        self.final_reconstruction_nsprefix_ = None
        self.crystal_parameters = crystal_parameters
        self.crystal_parameters_nsprefix_ = None
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        self.startup_model_nsprefix_ = None
        self.ctf_correction = ctf_correction
        self.ctf_correction_nsprefix_ = None
        self.molecular_replacement = molecular_replacement
        self.molecular_replacement_nsprefix_ = None
        self.lattice_distortion_correction_software_list = lattice_distortion_correction_software_list
        self.lattice_distortion_correction_software_list_nsprefix_ = None
        self.symmetry_determination_software_list = symmetry_determination_software_list
        self.symmetry_determination_software_list_nsprefix_ = None
        self.merging_software_list = merging_software_list
        self.merging_software_list_nsprefix_ = None
        self.crystallography_statistics = crystallography_statistics
        self.crystallography_statistics_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_processing_type.subclass:
            return crystallography_processing_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_final_reconstruction(self):
        return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction):
        self.final_reconstruction = final_reconstruction
    def get_crystal_parameters(self):
        return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters):
        self.crystal_parameters = crystal_parameters
    def get_startup_model(self):
        return self.startup_model
    def set_startup_model(self, startup_model):
        self.startup_model = startup_model
    def add_startup_model(self, value):
        self.startup_model.append(value)
    def insert_startup_model_at(self, index, value):
        self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value):
        self.startup_model[index] = value
    def get_ctf_correction(self):
        return self.ctf_correction
    def set_ctf_correction(self, ctf_correction):
        self.ctf_correction = ctf_correction
    def get_molecular_replacement(self):
        return self.molecular_replacement
    def set_molecular_replacement(self, molecular_replacement):
        self.molecular_replacement = molecular_replacement
    def get_lattice_distortion_correction_software_list(self):
        return self.lattice_distortion_correction_software_list
    def set_lattice_distortion_correction_software_list(self, lattice_distortion_correction_software_list):
        self.lattice_distortion_correction_software_list = lattice_distortion_correction_software_list
    def get_symmetry_determination_software_list(self):
        return self.symmetry_determination_software_list
    def set_symmetry_determination_software_list(self, symmetry_determination_software_list):
        self.symmetry_determination_software_list = symmetry_determination_software_list
    def get_merging_software_list(self):
        return self.merging_software_list
    def set_merging_software_list(self, merging_software_list):
        self.merging_software_list = merging_software_list
    def get_crystallography_statistics(self):
        return self.crystallography_statistics
    def set_crystallography_statistics(self, crystallography_statistics):
        self.crystallography_statistics = crystallography_statistics
    def has__content(self):
        if (
            self.final_reconstruction is not None or
            self.crystal_parameters is not None or
            self.startup_model or
            self.ctf_correction is not None or
            self.molecular_replacement is not None or
            self.lattice_distortion_correction_software_list is not None or
            self.symmetry_determination_software_list is not None or
            self.merging_software_list is not None or
            self.crystallography_statistics is not None or
            super(crystallography_processing_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_processing_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystallography_processing_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_processing_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crystallography_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystallography_processing_type'):
        super(crystallography_processing_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_processing_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_processing_type', fromsubclass_=False, pretty_print=True):
        super(crystallography_processing_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            namespaceprefix_ = self.final_reconstruction_nsprefix_ + ':' if (UseCapturedNS_ and self.final_reconstruction_nsprefix_) else ''
            self.final_reconstruction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='final_reconstruction', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            namespaceprefix_ = self.crystal_parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.crystal_parameters_nsprefix_) else ''
            self.crystal_parameters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='crystal_parameters', pretty_print=pretty_print)
        for startup_model_ in self.startup_model:
            namespaceprefix_ = self.startup_model_nsprefix_ + ':' if (UseCapturedNS_ and self.startup_model_nsprefix_) else ''
            startup_model_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='startup_model', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            namespaceprefix_ = self.ctf_correction_nsprefix_ + ':' if (UseCapturedNS_ and self.ctf_correction_nsprefix_) else ''
            self.ctf_correction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ctf_correction', pretty_print=pretty_print)
        if self.molecular_replacement is not None:
            namespaceprefix_ = self.molecular_replacement_nsprefix_ + ':' if (UseCapturedNS_ and self.molecular_replacement_nsprefix_) else ''
            self.molecular_replacement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='molecular_replacement', pretty_print=pretty_print)
        if self.lattice_distortion_correction_software_list is not None:
            namespaceprefix_ = self.lattice_distortion_correction_software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.lattice_distortion_correction_software_list_nsprefix_) else ''
            self.lattice_distortion_correction_software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lattice_distortion_correction_software_list', pretty_print=pretty_print)
        if self.symmetry_determination_software_list is not None:
            namespaceprefix_ = self.symmetry_determination_software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.symmetry_determination_software_list_nsprefix_) else ''
            self.symmetry_determination_software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='symmetry_determination_software_list', pretty_print=pretty_print)
        if self.merging_software_list is not None:
            namespaceprefix_ = self.merging_software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.merging_software_list_nsprefix_) else ''
            self.merging_software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='merging_software_list', pretty_print=pretty_print)
        if self.crystallography_statistics is not None:
            namespaceprefix_ = self.crystallography_statistics_nsprefix_ + ':' if (UseCapturedNS_ and self.crystallography_statistics_nsprefix_) else ''
            self.crystallography_statistics.export(outfile, level, namespaceprefix_, namespacedef_='', name_='crystallography_statistics', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(crystallography_processing_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'crystal_parameters':
            obj_ = crystal_parameters_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.crystal_parameters = obj_
            obj_.original_tagname_ = 'crystal_parameters'
        elif nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'molecular_replacement':
            obj_ = molecular_replacement_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.molecular_replacement = obj_
            obj_.original_tagname_ = 'molecular_replacement'
        elif nodeName_ == 'lattice_distortion_correction_software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lattice_distortion_correction_software_list = obj_
            obj_.original_tagname_ = 'lattice_distortion_correction_software_list'
        elif nodeName_ == 'symmetry_determination_software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.symmetry_determination_software_list = obj_
            obj_.original_tagname_ = 'symmetry_determination_software_list'
        elif nodeName_ == 'merging_software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.merging_software_list = obj_
            obj_.original_tagname_ = 'merging_software_list'
        elif nodeName_ == 'crystallography_statistics':
            obj_ = crystallography_statistics_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.crystallography_statistics = obj_
            obj_.original_tagname_ = 'crystallography_statistics'
        super(crystallography_processing_type, self)._buildChildren(child_, node, nodeName_, True)
# end class crystallography_processing_type


class applied_symmetry_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, space_group=None, point_group=None, helical_parameters=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.space_group = space_group
        self.space_group_nsprefix_ = None
        self.point_group = point_group
        self.validate_point_groupType(self.point_group)
        self.point_group_nsprefix_ = None
        self.helical_parameters = helical_parameters
        self.helical_parameters_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, applied_symmetry_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if applied_symmetry_type.subclass:
            return applied_symmetry_type.subclass(*args_, **kwargs_)
        else:
            return applied_symmetry_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_space_group(self):
        return self.space_group
    def set_space_group(self, space_group):
        self.space_group = space_group
    def get_point_group(self):
        return self.point_group
    def set_point_group(self, point_group):
        self.point_group = point_group
    def get_helical_parameters(self):
        return self.helical_parameters
    def set_helical_parameters(self, helical_parameters):
        self.helical_parameters = helical_parameters
    def validate_point_groupType(self, value):
        result = True
        # Validate type point_groupType, a restriction on point_group_symmetry_type.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_point_groupType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_point_groupType_patterns_, ))
                result = False
        return result
    validate_point_groupType_patterns_ = [['^(C\\d+|D\\d+|O|T|I)$'], ['^(C\\d+|D\\d+|O|T|I)$']]
    def has__content(self):
        if (
            self.space_group is not None or
            self.point_group is not None or
            self.helical_parameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='applied_symmetry_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('applied_symmetry_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'applied_symmetry_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='applied_symmetry_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='applied_symmetry_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='applied_symmetry_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='applied_symmetry_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.space_group is not None:
            namespaceprefix_ = self.space_group_nsprefix_ + ':' if (UseCapturedNS_ and self.space_group_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspace_group>%s</%sspace_group>%s' % (namespaceprefix_ , self.gds_format_integer(self.space_group, input_name='space_group'), namespaceprefix_ , eol_))
        if self.point_group is not None:
            namespaceprefix_ = self.point_group_nsprefix_ + ':' if (UseCapturedNS_ and self.point_group_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spoint_group>%s</%spoint_group>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.point_group), input_name='point_group')), namespaceprefix_ , eol_))
        if self.helical_parameters is not None:
            namespaceprefix_ = self.helical_parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.helical_parameters_nsprefix_) else ''
            self.helical_parameters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='helical_parameters', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'space_group' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'space_group')
            ival_ = self.gds_validate_integer(ival_, node, 'space_group')
            self.space_group = ival_
            self.space_group_nsprefix_ = child_.prefix
        elif nodeName_ == 'point_group':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'point_group')
            value_ = self.gds_validate_string(value_, node, 'point_group')
            self.point_group = value_
            self.point_group_nsprefix_ = child_.prefix
            # validate type point_groupType
            self.validate_point_groupType(self.point_group)
        elif nodeName_ == 'helical_parameters':
            obj_ = helical_parameters_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.helical_parameters = obj_
            obj_.original_tagname_ = 'helical_parameters'
# end class applied_symmetry_type


class helical_parameters_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, delta_z=None, delta_phi=None, axial_symmetry=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.delta_z = delta_z
        self.delta_z_nsprefix_ = None
        self.delta_phi = delta_phi
        self.delta_phi_nsprefix_ = None
        self.axial_symmetry = axial_symmetry
        self.validate_axial_symmetryType(self.axial_symmetry)
        self.axial_symmetry_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_parameters_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_parameters_type.subclass:
            return helical_parameters_type.subclass(*args_, **kwargs_)
        else:
            return helical_parameters_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_delta_z(self):
        return self.delta_z
    def set_delta_z(self, delta_z):
        self.delta_z = delta_z
    def get_delta_phi(self):
        return self.delta_phi
    def set_delta_phi(self, delta_phi):
        self.delta_phi = delta_phi
    def get_axial_symmetry(self):
        return self.axial_symmetry
    def set_axial_symmetry(self, axial_symmetry):
        self.axial_symmetry = axial_symmetry
    def validate_axial_symmetryType(self, value):
        result = True
        # Validate type axial_symmetryType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_axial_symmetryType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_axial_symmetryType_patterns_, ))
                result = False
        return result
    validate_axial_symmetryType_patterns_ = [['^([C|D][1-9][0-9]*)$']]
    def has__content(self):
        if (
            self.delta_z is not None or
            self.delta_phi is not None or
            self.axial_symmetry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_parameters_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_parameters_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'helical_parameters_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_parameters_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='helical_parameters_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='helical_parameters_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_parameters_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.delta_z is not None:
            namespaceprefix_ = self.delta_z_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_z_nsprefix_) else ''
            self.delta_z.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta_z', pretty_print=pretty_print)
        if self.delta_phi is not None:
            namespaceprefix_ = self.delta_phi_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_phi_nsprefix_) else ''
            self.delta_phi.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta_phi', pretty_print=pretty_print)
        if self.axial_symmetry is not None:
            namespaceprefix_ = self.axial_symmetry_nsprefix_ + ':' if (UseCapturedNS_ and self.axial_symmetry_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saxial_symmetry>%s</%saxial_symmetry>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.axial_symmetry), input_name='axial_symmetry')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'delta_z':
            obj_ = delta_zType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.delta_z = obj_
            obj_.original_tagname_ = 'delta_z'
        elif nodeName_ == 'delta_phi':
            obj_ = delta_phiType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.delta_phi = obj_
            obj_.original_tagname_ = 'delta_phi'
        elif nodeName_ == 'axial_symmetry':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'axial_symmetry')
            value_ = self.gds_validate_string(value_, node, 'axial_symmetry')
            self.axial_symmetry = value_
            self.axial_symmetry_nsprefix_ = child_.prefix
            # validate type axial_symmetryType
            self.validate_axial_symmetryType(self.axial_symmetry)
# end class helical_parameters_type


class reconstruction_filtering_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, background_masked=None, spatial_filtering=None, sharpening=None, b_factorSharpening=None, other=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.background_masked = background_masked
        self.background_masked_nsprefix_ = None
        self.spatial_filtering = spatial_filtering
        self.spatial_filtering_nsprefix_ = None
        self.sharpening = sharpening
        self.sharpening_nsprefix_ = None
        self.b_factorSharpening = b_factorSharpening
        self.b_factorSharpening_nsprefix_ = None
        self.other = other
        self.other_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, reconstruction_filtering_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if reconstruction_filtering_type.subclass:
            return reconstruction_filtering_type.subclass(*args_, **kwargs_)
        else:
            return reconstruction_filtering_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_background_masked(self):
        return self.background_masked
    def set_background_masked(self, background_masked):
        self.background_masked = background_masked
    def get_spatial_filtering(self):
        return self.spatial_filtering
    def set_spatial_filtering(self, spatial_filtering):
        self.spatial_filtering = spatial_filtering
    def get_sharpening(self):
        return self.sharpening
    def set_sharpening(self, sharpening):
        self.sharpening = sharpening
    def get_b_factorSharpening(self):
        return self.b_factorSharpening
    def set_b_factorSharpening(self, b_factorSharpening):
        self.b_factorSharpening = b_factorSharpening
    def get_other(self):
        return self.other
    def set_other(self, other):
        self.other = other
    def has__content(self):
        if (
            self.background_masked is not None or
            self.spatial_filtering is not None or
            self.sharpening is not None or
            self.b_factorSharpening is not None or
            self.other is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='reconstruction_filtering_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('reconstruction_filtering_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'reconstruction_filtering_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='reconstruction_filtering_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='reconstruction_filtering_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='reconstruction_filtering_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='reconstruction_filtering_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.background_masked is not None:
            namespaceprefix_ = self.background_masked_nsprefix_ + ':' if (UseCapturedNS_ and self.background_masked_nsprefix_) else ''
            self.background_masked.export(outfile, level, namespaceprefix_, namespacedef_='', name_='background_masked', pretty_print=pretty_print)
        if self.spatial_filtering is not None:
            namespaceprefix_ = self.spatial_filtering_nsprefix_ + ':' if (UseCapturedNS_ and self.spatial_filtering_nsprefix_) else ''
            self.spatial_filtering.export(outfile, level, namespaceprefix_, namespacedef_='', name_='spatial_filtering', pretty_print=pretty_print)
        if self.sharpening is not None:
            namespaceprefix_ = self.sharpening_nsprefix_ + ':' if (UseCapturedNS_ and self.sharpening_nsprefix_) else ''
            self.sharpening.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sharpening', pretty_print=pretty_print)
        if self.b_factorSharpening is not None:
            namespaceprefix_ = self.b_factorSharpening_nsprefix_ + ':' if (UseCapturedNS_ and self.b_factorSharpening_nsprefix_) else ''
            self.b_factorSharpening.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b-factorSharpening', pretty_print=pretty_print)
        if self.other is not None:
            namespaceprefix_ = self.other_nsprefix_ + ':' if (UseCapturedNS_ and self.other_nsprefix_) else ''
            self.other.export(outfile, level, namespaceprefix_, namespacedef_='', name_='other', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'background_masked':
            obj_ = background_masked_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.background_masked = obj_
            obj_.original_tagname_ = 'background_masked'
        elif nodeName_ == 'spatial_filtering':
            obj_ = spatial_filteringType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spatial_filtering = obj_
            obj_.original_tagname_ = 'spatial_filtering'
        elif nodeName_ == 'sharpening':
            obj_ = sharpeningType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sharpening = obj_
            obj_.original_tagname_ = 'sharpening'
        elif nodeName_ == 'b-factorSharpening':
            obj_ = b_factorSharpeningType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.b_factorSharpening = obj_
            obj_.original_tagname_ = 'b-factorSharpening'
        elif nodeName_ == 'other':
            obj_ = otherType45.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.other = obj_
            obj_.original_tagname_ = 'other'
# end class reconstruction_filtering_type


class background_masked_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, geometrical_shape=None, dimensions=None, software_list=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.geometrical_shape = geometrical_shape
        self.validate_geometrical_shapeType(self.geometrical_shape)
        self.geometrical_shape_nsprefix_ = None
        self.dimensions = dimensions
        self.dimensions_nsprefix_ = None
        self.software_list = software_list
        self.software_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, background_masked_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if background_masked_type.subclass:
            return background_masked_type.subclass(*args_, **kwargs_)
        else:
            return background_masked_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_geometrical_shape(self):
        return self.geometrical_shape
    def set_geometrical_shape(self, geometrical_shape):
        self.geometrical_shape = geometrical_shape
    def get_dimensions(self):
        return self.dimensions
    def set_dimensions(self, dimensions):
        self.dimensions = dimensions
    def get_software_list(self):
        return self.software_list
    def set_software_list(self, software_list):
        self.software_list = software_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_geometrical_shapeType(self, value):
        result = True
        # Validate type geometrical_shapeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['SPHERE', 'SOFT SPHERE', 'GAUSSIAN', 'CIRCLE', 'RECTANGLE', 'CYLINDER', 'OTHER']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on geometrical_shapeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.geometrical_shape is not None or
            self.dimensions is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='background_masked_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('background_masked_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'background_masked_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='background_masked_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='background_masked_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='background_masked_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='background_masked_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.geometrical_shape is not None:
            namespaceprefix_ = self.geometrical_shape_nsprefix_ + ':' if (UseCapturedNS_ and self.geometrical_shape_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeometrical_shape>%s</%sgeometrical_shape>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.geometrical_shape), input_name='geometrical_shape')), namespaceprefix_ , eol_))
        if self.dimensions is not None:
            namespaceprefix_ = self.dimensions_nsprefix_ + ':' if (UseCapturedNS_ and self.dimensions_nsprefix_) else ''
            self.dimensions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dimensions', pretty_print=pretty_print)
        if self.software_list is not None:
            namespaceprefix_ = self.software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.software_list_nsprefix_) else ''
            self.software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'geometrical_shape':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'geometrical_shape')
            value_ = self.gds_validate_string(value_, node, 'geometrical_shape')
            self.geometrical_shape = value_
            self.geometrical_shape_nsprefix_ = child_.prefix
            # validate type geometrical_shapeType
            self.validate_geometrical_shapeType(self.geometrical_shape)
        elif nodeName_ == 'dimensions':
            obj_ = dimensionsType46.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class background_masked_type


class crystal_parameters_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, unit_cell=None, plane_group=None, space_group=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.unit_cell = unit_cell
        self.unit_cell_nsprefix_ = None
        self.plane_group = plane_group
        self.validate_plane_groupType(self.plane_group)
        self.plane_group_nsprefix_ = None
        self.space_group = space_group
        self.space_group_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystal_parameters_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystal_parameters_type.subclass:
            return crystal_parameters_type.subclass(*args_, **kwargs_)
        else:
            return crystal_parameters_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_unit_cell(self):
        return self.unit_cell
    def set_unit_cell(self, unit_cell):
        self.unit_cell = unit_cell
    def get_plane_group(self):
        return self.plane_group
    def set_plane_group(self, plane_group):
        self.plane_group = plane_group
    def get_space_group(self):
        return self.space_group
    def set_space_group(self, space_group):
        self.space_group = space_group
    def validate_plane_groupType(self, value):
        result = True
        # Validate type plane_groupType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['C 1 2', 'C 2 2 2', 'P 1', 'P 1 2', 'P 1 21', 'P 2', 'P 2 2 2', 'P 2 2 21', 'P 2 21 21', 'P 3', 'P 3 1 2', 'P 3 2 1', 'P 4', 'P 4 2 2', 'P 4 21 2', 'P 6', 'P 6 2 2']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on plane_groupType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.unit_cell is not None or
            self.plane_group is not None or
            self.space_group is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_parameters_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystal_parameters_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystal_parameters_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystal_parameters_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crystal_parameters_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystal_parameters_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystal_parameters_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.unit_cell is not None:
            namespaceprefix_ = self.unit_cell_nsprefix_ + ':' if (UseCapturedNS_ and self.unit_cell_nsprefix_) else ''
            self.unit_cell.export(outfile, level, namespaceprefix_, namespacedef_='', name_='unit_cell', pretty_print=pretty_print)
        if self.plane_group is not None:
            namespaceprefix_ = self.plane_group_nsprefix_ + ':' if (UseCapturedNS_ and self.plane_group_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splane_group>%s</%splane_group>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.plane_group), input_name='plane_group')), namespaceprefix_ , eol_))
        if self.space_group is not None:
            namespaceprefix_ = self.space_group_nsprefix_ + ':' if (UseCapturedNS_ and self.space_group_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspace_group>%s</%sspace_group>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.space_group), input_name='space_group')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'unit_cell':
            obj_ = unit_cell_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.unit_cell = obj_
            obj_.original_tagname_ = 'unit_cell'
        elif nodeName_ == 'plane_group':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'plane_group')
            value_ = self.gds_validate_string(value_, node, 'plane_group')
            self.plane_group = value_
            self.plane_group_nsprefix_ = child_.prefix
            # validate type plane_groupType
            self.validate_plane_groupType(self.plane_group)
        elif nodeName_ == 'space_group':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'space_group')
            value_ = self.gds_validate_string(value_, node, 'space_group')
            self.space_group = value_
            self.space_group_nsprefix_ = child_.prefix
# end class crystal_parameters_type


class unit_cell_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, a=None, b=None, c=None, c_sampling_length=None, gamma=None, alpha=None, beta=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.a = a
        self.a_nsprefix_ = None
        self.b = b
        self.b_nsprefix_ = None
        self.c = c
        self.c_nsprefix_ = None
        self.c_sampling_length = c_sampling_length
        self.c_sampling_length_nsprefix_ = None
        self.gamma = gamma
        self.gamma_nsprefix_ = None
        self.alpha = alpha
        self.alpha_nsprefix_ = None
        self.beta = beta
        self.beta_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, unit_cell_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if unit_cell_type.subclass:
            return unit_cell_type.subclass(*args_, **kwargs_)
        else:
            return unit_cell_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_a(self):
        return self.a
    def set_a(self, a):
        self.a = a
    def get_b(self):
        return self.b
    def set_b(self, b):
        self.b = b
    def get_c(self):
        return self.c
    def set_c(self, c):
        self.c = c
    def get_c_sampling_length(self):
        return self.c_sampling_length
    def set_c_sampling_length(self, c_sampling_length):
        self.c_sampling_length = c_sampling_length
    def get_gamma(self):
        return self.gamma
    def set_gamma(self, gamma):
        self.gamma = gamma
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def get_beta(self):
        return self.beta
    def set_beta(self, beta):
        self.beta = beta
    def has__content(self):
        if (
            self.a is not None or
            self.b is not None or
            self.c is not None or
            self.c_sampling_length is not None or
            self.gamma is not None or
            self.alpha is not None or
            self.beta is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='unit_cell_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('unit_cell_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'unit_cell_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='unit_cell_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='unit_cell_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='unit_cell_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='unit_cell_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.a is not None:
            namespaceprefix_ = self.a_nsprefix_ + ':' if (UseCapturedNS_ and self.a_nsprefix_) else ''
            self.a.export(outfile, level, namespaceprefix_, namespacedef_='', name_='a', pretty_print=pretty_print)
        if self.b is not None:
            namespaceprefix_ = self.b_nsprefix_ + ':' if (UseCapturedNS_ and self.b_nsprefix_) else ''
            self.b.export(outfile, level, namespaceprefix_, namespacedef_='', name_='b', pretty_print=pretty_print)
        if self.c is not None:
            namespaceprefix_ = self.c_nsprefix_ + ':' if (UseCapturedNS_ and self.c_nsprefix_) else ''
            self.c.export(outfile, level, namespaceprefix_, namespacedef_='', name_='c', pretty_print=pretty_print)
        if self.c_sampling_length is not None:
            namespaceprefix_ = self.c_sampling_length_nsprefix_ + ':' if (UseCapturedNS_ and self.c_sampling_length_nsprefix_) else ''
            self.c_sampling_length.export(outfile, level, namespaceprefix_, namespacedef_='', name_='c_sampling_length', pretty_print=pretty_print)
        if self.gamma is not None:
            namespaceprefix_ = self.gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.gamma_nsprefix_) else ''
            self.gamma.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gamma', pretty_print=pretty_print)
        if self.alpha is not None:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            self.alpha.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alpha', pretty_print=pretty_print)
        if self.beta is not None:
            namespaceprefix_ = self.beta_nsprefix_ + ':' if (UseCapturedNS_ and self.beta_nsprefix_) else ''
            self.beta.export(outfile, level, namespaceprefix_, namespacedef_='', name_='beta', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'a':
            obj_ = cell_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.a = obj_
            obj_.original_tagname_ = 'a'
        elif nodeName_ == 'b':
            obj_ = cell_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.b = obj_
            obj_.original_tagname_ = 'b'
        elif nodeName_ == 'c':
            obj_ = cell_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.c = obj_
            obj_.original_tagname_ = 'c'
        elif nodeName_ == 'c_sampling_length':
            obj_ = cell_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.c_sampling_length = obj_
            obj_.original_tagname_ = 'c_sampling_length'
        elif nodeName_ == 'gamma':
            obj_ = cell_angle_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.gamma = obj_
            obj_.original_tagname_ = 'gamma'
        elif nodeName_ == 'alpha':
            obj_ = cell_angle_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.alpha = obj_
            obj_.original_tagname_ = 'alpha'
        elif nodeName_ == 'beta':
            obj_ = cell_angle_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.beta = obj_
            obj_.original_tagname_ = 'beta'
# end class unit_cell_type


class cell_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='Å', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_type.subclass:
            return cell_type.subclass(*args_, **kwargs_)
        else:
            return cell_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_cell_dim(self, value):
        result = True
        # Validate type allowed_cell_dim, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value <= 0.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on allowed_cell_dim' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cell_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cell_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cell_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class cell_type


class cell_angle_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, units='deg', valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.units = _cast(None, units)
        self.units_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cell_angle_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cell_angle_type.subclass:
            return cell_angle_type.subclass(*args_, **kwargs_)
        else:
            return cell_angle_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_units(self):
        return self.units
    def set_units(self, units):
        self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_allowed_cell_angle(self, value):
        result = True
        # Validate type allowed_cell_angle, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value <= 0.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on allowed_cell_angle' % {"value": value, "lineno": lineno} )
                result = False
            if value >= 180.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxExclusive restriction on allowed_cell_angle' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_angle_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cell_angle_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'cell_angle_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cell_angle_type')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cell_angle_type'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cell_angle_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
            self.units = ' '.join(self.units.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class cell_angle_type


class starting_map_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, type_of_model=None, random_conical_tilt=None, orthogonal_tilt=None, emdb_id=None, pdb_model=None, insilico_model=None, other=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_of_model = _cast(None, type_of_model)
        self.type_of_model_nsprefix_ = None
        self.random_conical_tilt = random_conical_tilt
        self.random_conical_tilt_nsprefix_ = None
        self.orthogonal_tilt = orthogonal_tilt
        self.orthogonal_tilt_nsprefix_ = None
        self.emdb_id = emdb_id
        self.validate_emdb_id_type(self.emdb_id)
        self.emdb_id_nsprefix_ = None
        self.pdb_model = pdb_model
        self.pdb_model_nsprefix_ = None
        self.insilico_model = insilico_model
        self.insilico_model_nsprefix_ = None
        self.other = other
        self.other_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, starting_map_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if starting_map_type.subclass:
            return starting_map_type.subclass(*args_, **kwargs_)
        else:
            return starting_map_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_random_conical_tilt(self):
        return self.random_conical_tilt
    def set_random_conical_tilt(self, random_conical_tilt):
        self.random_conical_tilt = random_conical_tilt
    def get_orthogonal_tilt(self):
        return self.orthogonal_tilt
    def set_orthogonal_tilt(self, orthogonal_tilt):
        self.orthogonal_tilt = orthogonal_tilt
    def get_emdb_id(self):
        return self.emdb_id
    def set_emdb_id(self, emdb_id):
        self.emdb_id = emdb_id
    def get_pdb_model(self):
        return self.pdb_model
    def set_pdb_model(self, pdb_model):
        self.pdb_model = pdb_model
    def get_insilico_model(self):
        return self.insilico_model
    def set_insilico_model(self, insilico_model):
        self.insilico_model = insilico_model
    def get_other(self):
        return self.other
    def set_other(self, other):
        self.other = other
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_type_of_model(self):
        return self.type_of_model
    def set_type_of_model(self, type_of_model):
        self.type_of_model = type_of_model
    def validate_emdb_id_type(self, value):
        result = True
        # Validate type emdb_id_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_emdb_id_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_emdb_id_type_patterns_, ))
                result = False
        return result
    validate_emdb_id_type_patterns_ = [['^(EMD-\\d{4,})$']]
    def has__content(self):
        if (
            self.random_conical_tilt is not None or
            self.orthogonal_tilt is not None or
            self.emdb_id is not None or
            self.pdb_model is not None or
            self.insilico_model is not None or
            self.other is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='starting_map_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('starting_map_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'starting_map_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='starting_map_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='starting_map_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='starting_map_type'):
        if self.type_of_model is not None and 'type_of_model' not in already_processed:
            already_processed.add('type_of_model')
            outfile.write(' type_of_model=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_of_model), input_name='type_of_model')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='starting_map_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.random_conical_tilt is not None:
            namespaceprefix_ = self.random_conical_tilt_nsprefix_ + ':' if (UseCapturedNS_ and self.random_conical_tilt_nsprefix_) else ''
            self.random_conical_tilt.export(outfile, level, namespaceprefix_, namespacedef_='', name_='random_conical_tilt', pretty_print=pretty_print)
        if self.orthogonal_tilt is not None:
            namespaceprefix_ = self.orthogonal_tilt_nsprefix_ + ':' if (UseCapturedNS_ and self.orthogonal_tilt_nsprefix_) else ''
            self.orthogonal_tilt.export(outfile, level, namespaceprefix_, namespacedef_='', name_='orthogonal_tilt', pretty_print=pretty_print)
        if self.emdb_id is not None:
            namespaceprefix_ = self.emdb_id_nsprefix_ + ':' if (UseCapturedNS_ and self.emdb_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semdb_id>%s</%semdb_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.emdb_id), input_name='emdb_id')), namespaceprefix_ , eol_))
        if self.pdb_model is not None:
            namespaceprefix_ = self.pdb_model_nsprefix_ + ':' if (UseCapturedNS_ and self.pdb_model_nsprefix_) else ''
            self.pdb_model.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pdb_model', pretty_print=pretty_print)
        if self.insilico_model is not None:
            namespaceprefix_ = self.insilico_model_nsprefix_ + ':' if (UseCapturedNS_ and self.insilico_model_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinsilico_model>%s</%sinsilico_model>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.insilico_model), input_name='insilico_model')), namespaceprefix_ , eol_))
        if self.other is not None:
            namespaceprefix_ = self.other_nsprefix_ + ':' if (UseCapturedNS_ and self.other_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sother>%s</%sother>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.other), input_name='other')), namespaceprefix_ , eol_))
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type_of_model', node)
        if value is not None and 'type_of_model' not in already_processed:
            already_processed.add('type_of_model')
            self.type_of_model = value
            self.type_of_model = ' '.join(self.type_of_model.split())
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'random_conical_tilt':
            obj_ = random_conical_tiltType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.random_conical_tilt = obj_
            obj_.original_tagname_ = 'random_conical_tilt'
        elif nodeName_ == 'orthogonal_tilt':
            obj_ = orthogonal_tiltType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.orthogonal_tilt = obj_
            obj_.original_tagname_ = 'orthogonal_tilt'
        elif nodeName_ == 'emdb_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'emdb_id')
            value_ = self.gds_validate_string(value_, node, 'emdb_id')
            self.emdb_id = value_
            self.emdb_id_nsprefix_ = child_.prefix
            # validate type emdb_id_type
            self.validate_emdb_id_type(self.emdb_id)
        elif nodeName_ == 'pdb_model':
            obj_ = pdb_model_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pdb_model = obj_
            obj_.original_tagname_ = 'pdb_model'
        elif nodeName_ == 'insilico_model':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'insilico_model')
            value_ = self.gds_validate_string(value_, node, 'insilico_model')
            self.insilico_model = value_
            self.insilico_model_nsprefix_ = child_.prefix
        elif nodeName_ == 'other':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'other')
            value_ = self.gds_validate_string(value_, node, 'other')
            self.other = value_
            self.other_nsprefix_ = child_.prefix
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class starting_map_type


class pdb_model_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, pdb_id=None, chain_id_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.pdb_id = pdb_id
        self.validate_pdb_code_type(self.pdb_id)
        self.pdb_id_nsprefix_ = None
        self.chain_id_list = chain_id_list
        self.chain_id_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pdb_model_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pdb_model_type.subclass:
            return pdb_model_type.subclass(*args_, **kwargs_)
        else:
            return pdb_model_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_pdb_id(self):
        return self.pdb_id
    def set_pdb_id(self, pdb_id):
        self.pdb_id = pdb_id
    def get_chain_id_list(self):
        return self.chain_id_list
    def set_chain_id_list(self, chain_id_list):
        self.chain_id_list = chain_id_list
    def validate_pdb_code_type(self, value):
        result = True
        # Validate type pdb_code_type, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_pdb_code_type_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_pdb_code_type_patterns_, ))
                result = False
        return result
    validate_pdb_code_type_patterns_ = [['^(\\d[\\dA-Za-z]{3}|pdb_\\d{5}[\\dA-Za-z]{3})$']]
    def has__content(self):
        if (
            self.pdb_id is not None or
            self.chain_id_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_model_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pdb_model_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'pdb_model_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='pdb_model_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='pdb_model_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='pdb_model_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='pdb_model_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pdb_id is not None:
            namespaceprefix_ = self.pdb_id_nsprefix_ + ':' if (UseCapturedNS_ and self.pdb_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spdb_id>%s</%spdb_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.pdb_id), input_name='pdb_id')), namespaceprefix_ , eol_))
        if self.chain_id_list is not None:
            namespaceprefix_ = self.chain_id_list_nsprefix_ + ':' if (UseCapturedNS_ and self.chain_id_list_nsprefix_) else ''
            self.chain_id_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chain_id_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'pdb_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'pdb_id')
            value_ = self.gds_validate_string(value_, node, 'pdb_id')
            self.pdb_id = value_
            self.pdb_id_nsprefix_ = child_.prefix
            # validate type pdb_code_type
            self.validate_pdb_code_type(self.pdb_id)
        elif nodeName_ == 'chain_id_list':
            obj_ = chain_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.chain_id_list = obj_
            obj_.original_tagname_ = 'chain_id_list'
# end class pdb_model_type


class chain_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, chain_id=None, residue_range=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if chain_id is None:
            self.chain_id = []
        else:
            self.chain_id = chain_id
        self.chain_id_nsprefix_ = None
        self.residue_range = residue_range
        self.validate_residue_rangeType(self.residue_range)
        self.residue_range_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, chain_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if chain_type.subclass:
            return chain_type.subclass(*args_, **kwargs_)
        else:
            return chain_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_chain_id(self):
        return self.chain_id
    def set_chain_id(self, chain_id):
        self.chain_id = chain_id
    def add_chain_id(self, value):
        self.chain_id.append(value)
    def insert_chain_id_at(self, index, value):
        self.chain_id.insert(index, value)
    def replace_chain_id_at(self, index, value):
        self.chain_id[index] = value
    def get_residue_range(self):
        return self.residue_range
    def set_residue_range(self, residue_range):
        self.residue_range = residue_range
    def validate_chain_pdb_id(self, value):
        result = True
        # Validate type chain_pdb_id, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_chain_pdb_id_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_chain_pdb_id_patterns_, ))
                result = False
        return result
    validate_chain_pdb_id_patterns_ = [['^(\\d|[A-Za-z]{1,2})$']]
    def validate_residue_rangeType(self, value):
        result = True
        # Validate type residue_rangeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_residue_rangeType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_residue_rangeType_patterns_, ))
                result = False
        return result
    validate_residue_rangeType_patterns_ = [['^(\\d+-\\d+)$']]
    def has__content(self):
        if (
            self.chain_id or
            self.residue_range is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='chain_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('chain_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'chain_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='chain_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='chain_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='chain_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='chain_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for chain_id_ in self.chain_id:
            namespaceprefix_ = self.chain_id_nsprefix_ + ':' if (UseCapturedNS_ and self.chain_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schain_id>%s</%schain_id>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(chain_id_), input_name='chain_id')), namespaceprefix_ , eol_))
        if self.residue_range is not None:
            namespaceprefix_ = self.residue_range_nsprefix_ + ':' if (UseCapturedNS_ and self.residue_range_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresidue_range>%s</%sresidue_range>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.residue_range), input_name='residue_range')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'chain_id':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'chain_id')
            value_ = self.gds_validate_string(value_, node, 'chain_id')
            self.chain_id.append(value_)
            self.chain_id_nsprefix_ = child_.prefix
            # validate type chain_pdb_id
            self.validate_chain_pdb_id(self.chain_id[-1])
        elif nodeName_ == 'residue_range':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'residue_range')
            value_ = self.gds_validate_string(value_, node, 'residue_range')
            self.residue_range = value_
            self.residue_range_nsprefix_ = child_.prefix
            # validate type residue_rangeType
            self.validate_residue_rangeType(self.residue_range)
# end class chain_type


class ctf_correction_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, phase_reversal=None, amplitude_correction=None, correction_operation=None, software_list=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.phase_reversal = phase_reversal
        self.phase_reversal_nsprefix_ = None
        self.amplitude_correction = amplitude_correction
        self.amplitude_correction_nsprefix_ = None
        self.correction_operation = correction_operation
        self.validate_correction_operationType(self.correction_operation)
        self.correction_operation_nsprefix_ = None
        self.software_list = software_list
        self.software_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ctf_correction_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ctf_correction_type.subclass:
            return ctf_correction_type.subclass(*args_, **kwargs_)
        else:
            return ctf_correction_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_phase_reversal(self):
        return self.phase_reversal
    def set_phase_reversal(self, phase_reversal):
        self.phase_reversal = phase_reversal
    def get_amplitude_correction(self):
        return self.amplitude_correction
    def set_amplitude_correction(self, amplitude_correction):
        self.amplitude_correction = amplitude_correction
    def get_correction_operation(self):
        return self.correction_operation
    def set_correction_operation(self, correction_operation):
        self.correction_operation = correction_operation
    def get_software_list(self):
        return self.software_list
    def set_software_list(self, software_list):
        self.software_list = software_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def validate_correction_operationType(self, value):
        result = True
        # Validate type correction_operationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['MULTIPLICATION', 'DIVISION']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on correction_operationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def has__content(self):
        if (
            self.phase_reversal is not None or
            self.amplitude_correction is not None or
            self.correction_operation is not None or
            self.software_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ctf_correction_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ctf_correction_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ctf_correction_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ctf_correction_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ctf_correction_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ctf_correction_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ctf_correction_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phase_reversal is not None:
            namespaceprefix_ = self.phase_reversal_nsprefix_ + ':' if (UseCapturedNS_ and self.phase_reversal_nsprefix_) else ''
            self.phase_reversal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phase_reversal', pretty_print=pretty_print)
        if self.amplitude_correction is not None:
            namespaceprefix_ = self.amplitude_correction_nsprefix_ + ':' if (UseCapturedNS_ and self.amplitude_correction_nsprefix_) else ''
            self.amplitude_correction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='amplitude_correction', pretty_print=pretty_print)
        if self.correction_operation is not None:
            namespaceprefix_ = self.correction_operation_nsprefix_ + ':' if (UseCapturedNS_ and self.correction_operation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scorrection_operation>%s</%scorrection_operation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.correction_operation), input_name='correction_operation')), namespaceprefix_ , eol_))
        if self.software_list is not None:
            namespaceprefix_ = self.software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.software_list_nsprefix_) else ''
            self.software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'phase_reversal':
            obj_ = phase_reversalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.phase_reversal = obj_
            obj_.original_tagname_ = 'phase_reversal'
        elif nodeName_ == 'amplitude_correction':
            obj_ = amplitude_correctionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.amplitude_correction = obj_
            obj_.original_tagname_ = 'amplitude_correction'
        elif nodeName_ == 'correction_operation':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'correction_operation')
            value_ = self.gds_validate_string(value_, node, 'correction_operation')
            self.correction_operation = value_
            self.correction_operation_nsprefix_ = child_.prefix
            # validate type correction_operationType
            self.validate_correction_operationType(self.correction_operation)
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class ctf_correction_type


class molecular_replacement_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, starting_model=None, resolution_range=None, software_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if starting_model is None:
            self.starting_model = []
        else:
            self.starting_model = starting_model
        self.starting_model_nsprefix_ = None
        self.resolution_range = resolution_range
        self.resolution_range_nsprefix_ = None
        self.software_list = software_list
        self.software_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, molecular_replacement_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if molecular_replacement_type.subclass:
            return molecular_replacement_type.subclass(*args_, **kwargs_)
        else:
            return molecular_replacement_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_starting_model(self):
        return self.starting_model
    def set_starting_model(self, starting_model):
        self.starting_model = starting_model
    def add_starting_model(self, value):
        self.starting_model.append(value)
    def insert_starting_model_at(self, index, value):
        self.starting_model.insert(index, value)
    def replace_starting_model_at(self, index, value):
        self.starting_model[index] = value
    def get_resolution_range(self):
        return self.resolution_range
    def set_resolution_range(self, resolution_range):
        self.resolution_range = resolution_range
    def get_software_list(self):
        return self.software_list
    def set_software_list(self, software_list):
        self.software_list = software_list
    def has__content(self):
        if (
            self.starting_model or
            self.resolution_range is not None or
            self.software_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='molecular_replacement_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('molecular_replacement_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'molecular_replacement_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='molecular_replacement_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='molecular_replacement_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='molecular_replacement_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='molecular_replacement_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for starting_model_ in self.starting_model:
            namespaceprefix_ = self.starting_model_nsprefix_ + ':' if (UseCapturedNS_ and self.starting_model_nsprefix_) else ''
            starting_model_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='starting_model', pretty_print=pretty_print)
        if self.resolution_range is not None:
            namespaceprefix_ = self.resolution_range_nsprefix_ + ':' if (UseCapturedNS_ and self.resolution_range_nsprefix_) else ''
            self.resolution_range.export(outfile, level, namespaceprefix_, namespacedef_='', name_='resolution_range', pretty_print=pretty_print)
        if self.software_list is not None:
            namespaceprefix_ = self.software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.software_list_nsprefix_) else ''
            self.software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'starting_model':
            obj_ = starting_modelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.starting_model.append(obj_)
            obj_.original_tagname_ = 'starting_model'
        elif nodeName_ == 'resolution_range':
            obj_ = resolution_rangeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.resolution_range = obj_
            obj_.original_tagname_ = 'resolution_range'
        elif nodeName_ == 'software_list':
            obj_ = software_list_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
# end class molecular_replacement_type


class crystallography_statistics_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, number_intensities_measured=None, number_structure_factors=None, fourier_space_coverage=None, r_sym=None, r_merge=None, overall_phase_error=None, overall_phase_residual=None, phase_error_rejection_criteria=None, high_resolution=None, shell_list=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.number_intensities_measured = number_intensities_measured
        self.number_intensities_measured_nsprefix_ = None
        self.number_structure_factors = number_structure_factors
        self.number_structure_factors_nsprefix_ = None
        self.fourier_space_coverage = fourier_space_coverage
        self.fourier_space_coverage_nsprefix_ = None
        self.r_sym = r_sym
        self.r_sym_nsprefix_ = None
        self.r_merge = r_merge
        self.r_merge_nsprefix_ = None
        self.overall_phase_error = overall_phase_error
        self.overall_phase_error_nsprefix_ = None
        self.overall_phase_residual = overall_phase_residual
        self.overall_phase_residual_nsprefix_ = None
        self.phase_error_rejection_criteria = phase_error_rejection_criteria
        self.phase_error_rejection_criteria_nsprefix_ = None
        self.high_resolution = high_resolution
        self.high_resolution_nsprefix_ = None
        self.shell_list = shell_list
        self.shell_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crystallography_statistics_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crystallography_statistics_type.subclass:
            return crystallography_statistics_type.subclass(*args_, **kwargs_)
        else:
            return crystallography_statistics_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_number_intensities_measured(self):
        return self.number_intensities_measured
    def set_number_intensities_measured(self, number_intensities_measured):
        self.number_intensities_measured = number_intensities_measured
    def get_number_structure_factors(self):
        return self.number_structure_factors
    def set_number_structure_factors(self, number_structure_factors):
        self.number_structure_factors = number_structure_factors
    def get_fourier_space_coverage(self):
        return self.fourier_space_coverage
    def set_fourier_space_coverage(self, fourier_space_coverage):
        self.fourier_space_coverage = fourier_space_coverage
    def get_r_sym(self):
        return self.r_sym
    def set_r_sym(self, r_sym):
        self.r_sym = r_sym
    def get_r_merge(self):
        return self.r_merge
    def set_r_merge(self, r_merge):
        self.r_merge = r_merge
    def get_overall_phase_error(self):
        return self.overall_phase_error
    def set_overall_phase_error(self, overall_phase_error):
        self.overall_phase_error = overall_phase_error
    def get_overall_phase_residual(self):
        return self.overall_phase_residual
    def set_overall_phase_residual(self, overall_phase_residual):
        self.overall_phase_residual = overall_phase_residual
    def get_phase_error_rejection_criteria(self):
        return self.phase_error_rejection_criteria
    def set_phase_error_rejection_criteria(self, phase_error_rejection_criteria):
        self.phase_error_rejection_criteria = phase_error_rejection_criteria
    def get_high_resolution(self):
        return self.high_resolution
    def set_high_resolution(self, high_resolution):
        self.high_resolution = high_resolution
    def get_shell_list(self):
        return self.shell_list
    def set_shell_list(self, shell_list):
        self.shell_list = shell_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def has__content(self):
        if (
            self.number_intensities_measured is not None or
            self.number_structure_factors is not None or
            self.fourier_space_coverage is not None or
            self.r_sym is not None or
            self.r_merge is not None or
            self.overall_phase_error is not None or
            self.overall_phase_residual is not None or
            self.phase_error_rejection_criteria is not None or
            self.high_resolution is not None or
            self.shell_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_statistics_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crystallography_statistics_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'crystallography_statistics_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='crystallography_statistics_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='crystallography_statistics_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='crystallography_statistics_type'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='crystallography_statistics_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.number_intensities_measured is not None:
            namespaceprefix_ = self.number_intensities_measured_nsprefix_ + ':' if (UseCapturedNS_ and self.number_intensities_measured_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_intensities_measured>%s</%snumber_intensities_measured>%s' % (namespaceprefix_ , self.gds_format_integer(self.number_intensities_measured, input_name='number_intensities_measured'), namespaceprefix_ , eol_))
        if self.number_structure_factors is not None:
            namespaceprefix_ = self.number_structure_factors_nsprefix_ + ':' if (UseCapturedNS_ and self.number_structure_factors_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_structure_factors>%s</%snumber_structure_factors>%s' % (namespaceprefix_ , self.gds_format_integer(self.number_structure_factors, input_name='number_structure_factors'), namespaceprefix_ , eol_))
        if self.fourier_space_coverage is not None:
            namespaceprefix_ = self.fourier_space_coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.fourier_space_coverage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfourier_space_coverage>%s</%sfourier_space_coverage>%s' % (namespaceprefix_ , self.gds_format_float(self.fourier_space_coverage, input_name='fourier_space_coverage'), namespaceprefix_ , eol_))
        if self.r_sym is not None:
            namespaceprefix_ = self.r_sym_nsprefix_ + ':' if (UseCapturedNS_ and self.r_sym_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sr_sym>%s</%sr_sym>%s' % (namespaceprefix_ , self.gds_format_float(self.r_sym, input_name='r_sym'), namespaceprefix_ , eol_))
        if self.r_merge is not None:
            namespaceprefix_ = self.r_merge_nsprefix_ + ':' if (UseCapturedNS_ and self.r_merge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sr_merge>%s</%sr_merge>%s' % (namespaceprefix_ , self.gds_format_float(self.r_merge, input_name='r_merge'), namespaceprefix_ , eol_))
        if self.overall_phase_error is not None:
            namespaceprefix_ = self.overall_phase_error_nsprefix_ + ':' if (UseCapturedNS_ and self.overall_phase_error_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverall_phase_error>%s</%soverall_phase_error>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.overall_phase_error), input_name='overall_phase_error')), namespaceprefix_ , eol_))
        if self.overall_phase_residual is not None:
            namespaceprefix_ = self.overall_phase_residual_nsprefix_ + ':' if (UseCapturedNS_ and self.overall_phase_residual_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverall_phase_residual>%s</%soverall_phase_residual>%s' % (namespaceprefix_ , self.gds_format_float(self.overall_phase_residual, input_name='overall_phase_residual'), namespaceprefix_ , eol_))
        if self.phase_error_rejection_criteria is not None:
            namespaceprefix_ = self.phase_error_rejection_criteria_nsprefix_ + ':' if (UseCapturedNS_ and self.phase_error_rejection_criteria_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphase_error_rejection_criteria>%s</%sphase_error_rejection_criteria>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.phase_error_rejection_criteria), input_name='phase_error_rejection_criteria')), namespaceprefix_ , eol_))
        if self.high_resolution is not None:
            namespaceprefix_ = self.high_resolution_nsprefix_ + ':' if (UseCapturedNS_ and self.high_resolution_nsprefix_) else ''
            self.high_resolution.export(outfile, level, namespaceprefix_, namespacedef_='', name_='high_resolution', pretty_print=pretty_print)
        if self.shell_list is not None:
            namespaceprefix_ = self.shell_list_nsprefix_ + ':' if (UseCapturedNS_ and self.shell_list_nsprefix_) else ''
            self.shell_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shell_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'number_intensities_measured' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'number_intensities_measured')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_intensities_measured')
            self.number_intensities_measured = ival_
            self.number_intensities_measured_nsprefix_ = child_.prefix
        elif nodeName_ == 'number_structure_factors' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'number_structure_factors')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_structure_factors')
            self.number_structure_factors = ival_
            self.number_structure_factors_nsprefix_ = child_.prefix
        elif nodeName_ == 'fourier_space_coverage' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'fourier_space_coverage')
            fval_ = self.gds_validate_float(fval_, node, 'fourier_space_coverage')
            self.fourier_space_coverage = fval_
            self.fourier_space_coverage_nsprefix_ = child_.prefix
        elif nodeName_ == 'r_sym' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'r_sym')
            fval_ = self.gds_validate_float(fval_, node, 'r_sym')
            self.r_sym = fval_
            self.r_sym_nsprefix_ = child_.prefix
        elif nodeName_ == 'r_merge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'r_merge')
            fval_ = self.gds_validate_float(fval_, node, 'r_merge')
            self.r_merge = fval_
            self.r_merge_nsprefix_ = child_.prefix
        elif nodeName_ == 'overall_phase_error':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'overall_phase_error')
            value_ = self.gds_validate_string(value_, node, 'overall_phase_error')
            self.overall_phase_error = value_
            self.overall_phase_error_nsprefix_ = child_.prefix
        elif nodeName_ == 'overall_phase_residual' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'overall_phase_residual')
            fval_ = self.gds_validate_float(fval_, node, 'overall_phase_residual')
            self.overall_phase_residual = fval_
            self.overall_phase_residual_nsprefix_ = child_.prefix
        elif nodeName_ == 'phase_error_rejection_criteria':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'phase_error_rejection_criteria')
            value_ = self.gds_validate_string(value_, node, 'phase_error_rejection_criteria')
            self.phase_error_rejection_criteria = value_
            self.phase_error_rejection_criteria_nsprefix_ = child_.prefix
        elif nodeName_ == 'high_resolution':
            obj_ = high_resolutionType53.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.high_resolution = obj_
            obj_.original_tagname_ = 'high_resolution'
        elif nodeName_ == 'shell_list':
            obj_ = shell_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shell_list = obj_
            obj_.original_tagname_ = 'shell_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class crystallography_statistics_type


class helical_processing_type(base_image_processing_type):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = base_image_processing_type
    def __init__(self, image_processing_id=None, image_recording_id=None, details=None, final_reconstruction=None, ctf_correction=None, segment_selection=None, refinement=None, startup_model=None, helical_layer_lines=None, initial_angle_assignment=None, final_angle_assignment=None, crystal_parameters=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("helical_processing_type"), self).__init__(image_processing_id, image_recording_id, details,  **kwargs_)
        self.final_reconstruction = final_reconstruction
        self.final_reconstruction_nsprefix_ = None
        self.ctf_correction = ctf_correction
        self.ctf_correction_nsprefix_ = None
        if segment_selection is None:
            self.segment_selection = []
        else:
            self.segment_selection = segment_selection
        self.segment_selection_nsprefix_ = None
        self.refinement = refinement
        self.refinement_nsprefix_ = None
        if startup_model is None:
            self.startup_model = []
        else:
            self.startup_model = startup_model
        self.startup_model_nsprefix_ = None
        self.helical_layer_lines = helical_layer_lines
        self.helical_layer_lines_nsprefix_ = None
        self.initial_angle_assignment = initial_angle_assignment
        self.initial_angle_assignment_nsprefix_ = None
        self.final_angle_assignment = final_angle_assignment
        self.final_angle_assignment_nsprefix_ = None
        self.crystal_parameters = crystal_parameters
        self.crystal_parameters_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, helical_processing_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if helical_processing_type.subclass:
            return helical_processing_type.subclass(*args_, **kwargs_)
        else:
            return helical_processing_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_final_reconstruction(self):
        return self.final_reconstruction
    def set_final_reconstruction(self, final_reconstruction):
        self.final_reconstruction = final_reconstruction
    def get_ctf_correction(self):
        return self.ctf_correction
    def set_ctf_correction(self, ctf_correction):
        self.ctf_correction = ctf_correction
    def get_segment_selection(self):
        return self.segment_selection
    def set_segment_selection(self, segment_selection):
        self.segment_selection = segment_selection
    def add_segment_selection(self, value):
        self.segment_selection.append(value)
    def insert_segment_selection_at(self, index, value):
        self.segment_selection.insert(index, value)
    def replace_segment_selection_at(self, index, value):
        self.segment_selection[index] = value
    def get_refinement(self):
        return self.refinement
    def set_refinement(self, refinement):
        self.refinement = refinement
    def get_startup_model(self):
        return self.startup_model
    def set_startup_model(self, startup_model):
        self.startup_model = startup_model
    def add_startup_model(self, value):
        self.startup_model.append(value)
    def insert_startup_model_at(self, index, value):
        self.startup_model.insert(index, value)
    def replace_startup_model_at(self, index, value):
        self.startup_model[index] = value
    def get_helical_layer_lines(self):
        return self.helical_layer_lines
    def set_helical_layer_lines(self, helical_layer_lines):
        self.helical_layer_lines = helical_layer_lines
    def get_initial_angle_assignment(self):
        return self.initial_angle_assignment
    def set_initial_angle_assignment(self, initial_angle_assignment):
        self.initial_angle_assignment = initial_angle_assignment
    def get_final_angle_assignment(self):
        return self.final_angle_assignment
    def set_final_angle_assignment(self, final_angle_assignment):
        self.final_angle_assignment = final_angle_assignment
    def get_crystal_parameters(self):
        return self.crystal_parameters
    def set_crystal_parameters(self, crystal_parameters):
        self.crystal_parameters = crystal_parameters
    def has__content(self):
        if (
            self.final_reconstruction is not None or
            self.ctf_correction is not None or
            self.segment_selection or
            self.refinement is not None or
            self.startup_model or
            self.helical_layer_lines is not None or
            self.initial_angle_assignment is not None or
            self.final_angle_assignment is not None or
            self.crystal_parameters is not None or
            super(helical_processing_type, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_processing_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('helical_processing_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'helical_processing_type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_processing_type')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='helical_processing_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='helical_processing_type'):
        super(helical_processing_type, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='helical_processing_type')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='helical_processing_type', fromsubclass_=False, pretty_print=True):
        super(helical_processing_type, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.final_reconstruction is not None:
            namespaceprefix_ = self.final_reconstruction_nsprefix_ + ':' if (UseCapturedNS_ and self.final_reconstruction_nsprefix_) else ''
            self.final_reconstruction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='final_reconstruction', pretty_print=pretty_print)
        if self.ctf_correction is not None:
            namespaceprefix_ = self.ctf_correction_nsprefix_ + ':' if (UseCapturedNS_ and self.ctf_correction_nsprefix_) else ''
            self.ctf_correction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ctf_correction', pretty_print=pretty_print)
        for segment_selection_ in self.segment_selection:
            namespaceprefix_ = self.segment_selection_nsprefix_ + ':' if (UseCapturedNS_ and self.segment_selection_nsprefix_) else ''
            segment_selection_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='segment_selection', pretty_print=pretty_print)
        if self.refinement is not None:
            namespaceprefix_ = self.refinement_nsprefix_ + ':' if (UseCapturedNS_ and self.refinement_nsprefix_) else ''
            self.refinement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='refinement', pretty_print=pretty_print)
        for startup_model_ in self.startup_model:
            namespaceprefix_ = self.startup_model_nsprefix_ + ':' if (UseCapturedNS_ and self.startup_model_nsprefix_) else ''
            startup_model_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='startup_model', pretty_print=pretty_print)
        if self.helical_layer_lines is not None:
            namespaceprefix_ = self.helical_layer_lines_nsprefix_ + ':' if (UseCapturedNS_ and self.helical_layer_lines_nsprefix_) else ''
            self.helical_layer_lines.export(outfile, level, namespaceprefix_, namespacedef_='', name_='helical_layer_lines', pretty_print=pretty_print)
        if self.initial_angle_assignment is not None:
            namespaceprefix_ = self.initial_angle_assignment_nsprefix_ + ':' if (UseCapturedNS_ and self.initial_angle_assignment_nsprefix_) else ''
            self.initial_angle_assignment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='initial_angle_assignment', pretty_print=pretty_print)
        if self.final_angle_assignment is not None:
            namespaceprefix_ = self.final_angle_assignment_nsprefix_ + ':' if (UseCapturedNS_ and self.final_angle_assignment_nsprefix_) else ''
            self.final_angle_assignment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='final_angle_assignment', pretty_print=pretty_print)
        if self.crystal_parameters is not None:
            namespaceprefix_ = self.crystal_parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.crystal_parameters_nsprefix_) else ''
            self.crystal_parameters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='crystal_parameters', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(helical_processing_type, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'final_reconstruction':
            obj_ = non_subtom_final_reconstruction_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.final_reconstruction = obj_
            obj_.original_tagname_ = 'final_reconstruction'
        elif nodeName_ == 'ctf_correction':
            obj_ = ctf_correction_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ctf_correction = obj_
            obj_.original_tagname_ = 'ctf_correction'
        elif nodeName_ == 'segment_selection':
            obj_ = segment_selection_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.segment_selection.append(obj_)
            obj_.original_tagname_ = 'segment_selection'
        elif nodeName_ == 'refinement':
            obj_ = refinement_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.refinement = obj_
            obj_.original_tagname_ = 'refinement'
        elif nodeName_ == 'startup_model':
            obj_ = starting_map_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.startup_model.append(obj_)
            obj_.original_tagname_ = 'startup_model'
        elif nodeName_ == 'helical_layer_lines':
            obj_ = layer_lines_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.helical_layer_lines = obj_
            obj_.original_tagname_ = 'helical_layer_lines'
        elif nodeName_ == 'initial_angle_assignment'