#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.app.megacli',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20211031',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    ('Command line tool to inspect and manipulate LSI MegaRAID adapters, such as '    
 'used in IBM ServeRAID systems and Dell PowerEdge RAID Controller (PERC).'),
  long_description =
    ('Command line tool to inspect and manipulate LSI MegaRAID adapters,\n'    
 'such as used in IBM ServeRAID systems and Dell PowerEdge RAID Controller '    
 '(PERC).\n'    
 '\n'    
 '*Latest release 20211031*:\n'    
 '* Update to Python 3, old Python 2 code recorded in cs.app.megacli2.\n'    
 '* Various interna updates while parsing Dell PERC output.\n'    
 '\n'    
 'Many IBM xSeries servers come with LSI Logic MegaRAID RAID controllers,\n'    
 'under the name IBM ServerRAID.\n'    
 'These controllers are also used by Dell as Dell PowerEdge RAID Controller '    
 '(PERC).\n'    
 '\n'    
 'These can be accessed during the machine boot process via the BIOS screens\n'    
 'using a conventional BIOS-like text interface or a ghastly and painful to '    
 'use\n'    
 'GUI interface. However, either of these requires the machine OS to be down.\n'    
 '\n'    
 'The RAID adapters can also be accessed while the machine OS is up.\n'    
 'For Linux, IBM offer a set of command line tools named MegaCLI_,\n'    
 'which are installed in `/opt/MegaRAID`.\n'    
 'Unfortunately, their MegaCLI executable is both fiddly to invoke\n'    
 'and, in its reporting mode, produces a barely human readable report\n'    
 'which is quite hostlie to machine parsing.\n'    
 'I would surmise that someone was told to dump the adapter data in text '    
 'form,\n'    
 'and did so with an ad hoc report; it is pages long and arduous to inspect by '    
 'eye.\n'    
 '\n'    
 'The situation was sufficiently painful that I wrote this module\n'    
 'which runs a couple of the report modes and parses their output.\n'    
 '\n'    
 'Report Mode\n'    
 '-----------\n'    
 '\n'    
 'The "report" mode then dumps a short summary report of relevant information\n'    
 'which can be eyeballed immediately;\n'    
 'RAID configuration and issues are immediately apparent.\n'    
 'Here is an example output\n'    
 '(the "+" tracing lines are on stderr\n'    
 'and recite the underlying MegaCLI commands used):\n'    
 '\n'    
 '    # mcli report\n'    
 '    + exec py26+ -m cs.app.megacli report\n'    
 '    + exec /opt/MegaRAID/MegaCli/MegaCli64 -CfgDsply -aAll\n'    
 '    + exec /opt/MegaRAID/MegaCli/MegaCli64 -PDlist -aAll\n'    
 '    Adapter 0 IBM ServeRAID-MR10i SAS/SATA Controller serial# Pnnnnnnnnn\n'    
 '      Virtual Drive 0\n'    
 '        2 drives, size = 278.464GB, raid = Primary-1, Secondary-0, RAID '    
 'Level Qualifier-0\n'    
 '          physical drive enc252.devid8 [252:0]\n'    
 '          physical drive enc252.devid7 [252:1]\n'    
 '      4 drives:\n'    
 '        enc252.devid7 [252:1]: VD 0, DG None: 42D0628 279.396 GB, Online, '    
 'Spun Up\n'    
 '        enc252.devid8 [252:0]: VD 0, DG None: 81Y9671 279.396 GB, Online, '    
 'Spun Up\n'    
 '        enc252.devid2 [252:2]: VD None, DG None: 42D0628 279.396 GB, '    
 'Unconfigured(good), Spun Up\n'    
 '        enc252.devid3 [252:3]: VD None, DG None: 42D0628 279.396 GB, '    
 'Unconfigured(good), Spun Up\n'    
 '\n'    
 'Status Mode\n'    
 '-----------\n'    
 '\n'    
 'The "status" mode recites the RAID status in a series of terse one line '    
 'summaries;\n'    
 'we use its output in our nagios monitoring.\n'    
 'Here is an example output (the "+" tracing lines are on stderr,\n'    
 'and recite the underlying MegaCLI commands used):\n'    
 '\n'    
 '    # mcli status\n'    
 '    + exec py26+ -m cs.app.megacli status\n'    
 '    + exec /opt/MegaRAID/MegaCli/MegaCli64 -CfgDsply -aAll\n'    
 '    + exec /opt/MegaRAID/MegaCli/MegaCli64 -PDlist -aAll\n'    
 '    OK A0\n'    
 '\n'    
 'Locate Mode\n'    
 '-----------\n'    
 '\n'    
 'The "locate" mode prints a MegaCLI command line\n'    
 'which can be used to activate or deactivate the location LED on a specific '    
 'drive.\n'    
 'Here is an example output:\n'    
 '\n'    
 '    # mcli locate 252:4\n'    
 '    /opt/MegaRAID/MegaCli/MegaCli64 -PdLocate -start -physdrv[252:4] -a0\n'    
 '\n'    
 '    # mcli locate 252:4 stop\n'    
 '    /opt/MegaRAID/MegaCli/MegaCli64 -PdLocate -stop -physdrv[252:4] -a0\n'    
 '\n'    
 'New_RAID Mode\n'    
 '-------------\n'    
 'The "new_raid" mode prints a MegaCLI command line\n'    
 'which can be used to instruct the adapter to assemble a new RAID set.\n'    
 '\n'    
 'MegaCLI class\n'    
 '-------------\n'    
 '\n'    
 'The module provides a MegaCLI class which embodies the parsed information\n'    
 'from the MegaCLI reporting modes.\n'    
 'This can be imported and used for special needs.\n'    
 '\n'    
 '.. _MegaCLI: '    
 'http://www-947.ibm.com/support/entry/portal/docdisplay?lndocid=migr-5082327\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20211031*:\n'    
 '* Update to Python 3, old Python 2 code recorded in cs.app.megacli2.\n'    
 '* Various interna updates while parsing Dell PERC output.\n'    
 '\n'    
 '*Release 20190729*:\n'    
 'A little more report line parsing flexibility.\n'    
 '\n'    
 '*Release 20160310*:\n'    
 'remove more external dependencies, mention operation with Dell PowerEdge '    
 'RAID Controller (PERC)\n'    
 '\n'    
 '*Release 20160226*:\n'    
 'cs.app.megacli: honour $MEGACLI for MegaCLI executable path, remove some '    
 'external script dependencies, note Dell PowerEdge RAID Controller (PERC) is '    
 'also a MegaRAID or compatible\n'    
 '\n'    
 '*Release 20160225*:\n'    
 'changes to remove dependencies on pythons newer than 2.4 and also other '    
 'modules; issue reported by desius@gmail.com\n'    
 '\n'    
 '*Release 20150801.1*:\n'    
 'Update README-megacli.rst documentation.\n'    
 '\n'    
 '*Release 20150801*:\n'    
 '* New commands "locate" and "offline".\n'    
 '* Report drive error counts.\n'    
 '\n'    
 '*Release 20150118.5*:\n'    
 'README: scrub adapter serial number from example, fix typo.\n'    
 '\n'    
 '*Release 20150118.4*:\n'    
 'example outputs in README\n'    
 '\n'    
 '*Release 20150118.3*:\n'    
 'mention MegaCLI class in README\n'    
 '\n'    
 '*Release 20150118.2*:\n'    
 'README fix\n'    
 '\n'    
 '*Release 20150118*:\n'    
 'Initial PyPI release.'),
  install_requires = ['cs.logutils', 'cs.pfx', 'cs.sh'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  entry_points = {'console_scripts': ['mcli = cs.app.megacli:main']},
  keywords = ['python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.app.megacli'],
)
