from setuptools import setup, find_packages

setup(
    name='yamlize',

    # Versions should comply with PEP440.  For a discussion on single-sourcing
    # the version across setup.py and the project code, see
    # https://packaging.python.org/en/latest/single_source_version.html
    version='0.7.0',

    description='yamlize, a package for Python object serialization and data validaiton.',
    long_description='see https://github.com/SimplyKnownAsG/yamlize/blob/master/README.rst',

    # The project's main homepage.
    url='https://github.com/SimplyKnownAsG/yamlize',

    author='g',
    author_email='gtmalmgren@gmail.com',

    # Choose your license
    license='Apache',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project?
        'Development Status :: 4 - Beta',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'Topic :: Software Development :: Build Tools',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: Apache Software License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
    ],

    # What does your project relate to?
    keywords='yaml serialization type checking validation',

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(exclude=['contrib', 'docs', 'tests']),

    # Alternatively, if you want to distribute just a my_module.py, uncomment
    # this:
    #   py_modules=["my_module"],

    # List run-time dependencies here.
    install_requires=['ruamel.yaml', 'six'],

    # List additional groups of dependencies here (e.g. development dependencies)
    extras_require={
        'dev': ['yaml', 'pytest', 'pycodestyle', 'sphinx', 'aenum', 'numpy'],
    },

    # # Data files
    # package_data={},

    # # Data files outside of your packages.
    # data_files=[],

    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    entry_points={},
)

