"""simple_openid_connect_django URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.urls import path

from simple_openid_connect_django import views

app_name = "simple_openid_connect_django"
urlpatterns = [
    path("login/", views.InitLoginView.as_view(), name="login"),
    path("login-callback/", views.LoginCallbackView.as_view(), name="login-callback"),
    path("logout/", views.LogoutView.as_view(), name="logout"),
    path("logout-notiy/", views.LogoutNotificationView.as_view(), name="logout-notify"),
]
