# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['jml']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['jml = jml.jml:main']}

setup_kwargs = {
    'name': 'jml',
    'version': '0.2.4',
    'description': 'Ein Tool um Projektversionen zu generieren',
    'long_description': '=======================\nJava Musterlösung (jml)\n=======================\n\nJava Musterlösung (kurz ``jml``) ist ein kleines Skript mit dem mehrere Projektversionen aus einer Musterlösung generiert werden können.\n\n``jml`` wurde ursprünglich für Java-Projekte entwickelt, kann aber durch diverse Optionen auch für andere Projekte genutzt werden.\n\nMotivation\n----------\n\nZur Differenzierung im Informatikunterricht erstelle ich gerne mehrere Projektversionen mit mehr oder weniger Hilfestellungen, um dem Leistungsstand der Schülerinnen und Schüler besser gerecht zu werden. Inklusive einer Musterlösung können so schnell drei bis vier Projektversionen entstehen, die parallel weiterentwickelt werden müssen.\n\nBefindet sich ein Fehler im Code, sollen die Aufgaben angepasst werden oder hat sich einfach ein Rechtschreibfehler in einen Kommentar eingeschlichen, müssen alle Projektversionen angepasst werden. Dabei habe ich schnell mal eine Version vergessen oder einen neuen Fehler eingebaut.\n\nVor einigen Jahren habe ich den Prozess mit ``jml`` vereinfacht. Das Skript generiert aus einer Basisversion, die mit Markierungen für Aufgaben und Lösungen versehen ist, die verschiedenen Projektversionen, die für den Unterricht nötig sind. Anpassungen sind nur noch im Basisprojekt notwendig.\n\nInstallation\n------------\n\nDie Installation wird wie gewohnt mit pypi durchgeführt:\n\n.. code-block:: console\n\n   $ pip3 install jml\n\nBei erfolgreicher Installation ist nun das ``jml`` Kommando verfügbar.\n\n.. code-block:: console\n\n   $ jml --version\n   jml, version 0.2.4\n\nManuelle Installation\n^^^^^^^^^^^^^^^^^^^^^\n\n``jml`` kann auch ohne ``pip`` einfach als Skriptdatei genutzt werden. Dazu die aktuelle Version der Datei `jml.py <https://github.com/jneug/jml/blob/main/src/jml/jml.py>`_ aus dem Repository kopieren und auf der Festplatte speichern. Das Skript kann dann mit Python 3 ausgeführt werden:\n\n.. code-block:: console\n\n   $ python3 jml.py --version\n   jml, version 0.2.4\n\n\nBenutzung\n---------\n\n``jml`` benötigt im einfachsten Fall den Pfad des Basisprojektes und den Pfad des Ausgabeordners:\n\n.. code-block:: console\n\n   $ jml pfad/zum/ProjektOrdner pfad/zum/ausgabeordner\n\nNach Ausführung befinden sich in ``pfad/zum/ausgabeordner`` die Musterlösung und die Projektversionen.\n\nDie Inhalte und Anzahl an Versionen werden durch die Inhalte der Dateien im Projektordner bestimmt.\n\nAngenommen in ``ProjektOrdner`` liegt eine Datei mit dem Namen ``Beispiel.java`` mit folgendem Inhalt:\n\n.. code-block:: java\n\n    class Example {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n    }\n\nDann erzeugt ``jml`` diese Ordnerstruktur in ``pfad/zum/ausgabeordner``::\n\n    pfad/zum/ausgabeordner/\n    ├── ProjektOrdner/\n    │   └── Beispiel.java\n    └── ProjektOrdner_ML/\n        └── Beispiel.java\n\nInhalt von ``ProjektOrdner_ML/Beispiel.java``:\n\n.. code-block:: java\n\n    class Example {\n        private int zahl;\n\n        public int add( int pAndereZahl ) {\n            return zahl + pAndereZahl;\n        }\n    }\n\nInhalt von ``ProjektOrdner/Beispiel.java``:\n\n.. code-block:: java\n\n    class Example {\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n\n        public int add( int pAndereZahl ) {\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pAndereZahl" zurück.\n            return 0;\n        }\n    }\n\n\nMehrere Versionen\n^^^^^^^^^^^^^^^^^\n\nAls Standard wird wie oben nur die Projektversion ``0`` erstellt. ``jml`` kann aber auch mehrere Projekte erstellen, wenn die Aufgaben-Markierungen mit einer entsprechenden Nummer versehen werden.\n\nAngenommen die ``Beispiel.java`` von oben sieht so aus:\n\n.. code-block:: java\n\n    class Example {\n        /*aufg*\n        // TODO: Erstelle eine Objektvariable "zahl" vom Typ int\n        *aufg*/\n        //ml*\n        private int zahl;\n        //*ml\n\n        public int add( int pAndereZahl ) {\n            /*aufg*\n            // TODO: Gib die Summe aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n            *aufg*/\n            //ml*\n            return zahl + pAndereZahl;\n            //*ml\n        }\n\n        /*aufg* 2\n        public int sub( int pAndereZahl ) {\n            // TODO: Gib die Differenz aus der Objektvariablen "zahl" und "pSummand" zurück.\n            return 0;\n        }\n        *aufg*/\n\n    }\n\nDann wird werden statt der Version ``0`` die Projektversionen ``1`` und ``2`` erzeugt, da im zweiten Aufgaben-Marker eine konkrete Versionsnummer angegeben wurde::\n\n    pfad/zum/ausgabeordner/\n    ├── ProjektOrdner_1/\n    │   └── Beispiel.java\n    ├── ProjektOrdner_2/\n    │   └── Beispiel.java\n    └── ProjektOrdner_ML/\n        └── Beispiel.java\n\nEs ist auch möglich eine Markierung für mehrere Projektversionen zu nutzen:\n\n.. code-block:: java\n\n    /*aufg* >1\n    // Taucht nur in Projektversionen nach Version 1 auf.\n    *aufg*/\n\n    /*aufg* !=2\n    // Taucht in allen Projektversionen außer 2 auf.\n    *aufg*/\n\n    /*aufg* <= 2\n    // Taucht nur in Projektversionen 1 und 2 auf.\n    *aufg*/\n\n\nOptionen\n--------\n\nDie Funktion von ``jml`` ist durch eine Vielzahl von Optionen anpassbar. Die Optionen können als Kommandozeilen-Argumente übergeben, oder in Konfigurationsdateien gespeichert werden.\n\nEine Übersicht der verfügbaren Kommandozeilen-Argumente ist mit ``-h`` abrufbar\n\n.. code-block:: console\n\n   $ jml -h\n\nAlle Optionen (und noch eine Handvoll mehr) lassen sich auch in einer von mehreren Konfigurationsdateien festlegen. ``jml`` sucht dazu bei jedem Start nach ``.jml`` Dateien im Basisprojekt, im Gruppenverzeichnis (``--project-root``) und im Home-Ordner des angemeldeten Nutzers (``~/.jml``).\n\nDie Konfigurationen werden dann in umgekehrter Reihenfolge geladen, die Einstellungen im Basisprojekt haben also die höchste Priorität. Sie werden nur noch von Kommandozeilen-Argumente überschrieben.\n\nFür das Beispiel oben könnte der Aufbau so aussehen::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/gruppe/\n    │   ├── .jml\n    │   └── ProjektOrdner/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner\n\nInhalt von ``~/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   opening tag=/*<aufgabe>\n   closing tag=</aufgabe>*/\n   opening ml tag=//<loesung>\n   closing ml tag=//</loesung>\n\nInhalt von ``~/pfad/zur/gruppe/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   zip = yes\n   ml suffix = Loesung\n   name format = {project}-{version}\n   include = *.java,*.txt\n\nInhalt von ``~/pfad/zur/gruppe/ProjektOrdner/.jml``:\n\n.. code-block:: ini\n\n   [settings]\n   opening tag=/*aufgabe*\n   closing tag=*aufgabe*/\n   encoding = iso-8859-1\n   name = Maeusekampf\n\nDer Aufruf von ``jml`` sieht dann so aus:\n\n.. code-block:: console\n\n   $ jml --project-root "~/pfad/zur/gruppe" "~/pfad/zur/gruppe/ProjektOrdner" "pfad/zum/ausgabeordner"\n\n``jml`` lädt nun zunächst ``~/.jml`` und setzt die Start- und Endmarkierungen auf eine XML-Variante.\n\nDanach wird ``~/pfad/zur/gruppe/.jml`` geladen, da dies per ``--project-root`` Argument als Gruppenverzeichnis gesetzt wurde. Für diese Projektgruppe werden ZIP-Dateien der Projektversionen erzeugt, außerdem wird das Suffix für die Musterlösung von ``ML`` auf ``Loesung`` geändert. Das Format der Projektnamen wird angepasst (``_`` durch ``-`` ersetzt) und es werden auch ``.txt`` Dateien nach den Aufgaben- und Lösungs-Markierungen durchsucht.\n\nAls drittes wird ``~/pfad/zur/gruppe/ProjektOrdner/.jml`` geladen. Hier werden speziell für dieses eine Projekt die Aufgaben-Marker erneut verändert und die Datei-Codierung auf ``iso-8859-1`` (statt ``utf-8``) festgelegt. Schließlich wird noch der Projektname auf ``Maeusekampf`` festgelgt, anstatt den Ordnernamen ``ProjektOrdner`` zu verwenden.\n\nDie Ausgabe sieht dann so aus (sofern die Aufgaben- und Lösungs-Markierungen in ``Beispiel.java`` angepasst wurden)::\n\n    ~/\n    ├── .jml\n    ├── pfad/zur/gruppe/\n    │   ├── .jml\n    │   └── ProjektOrdner/\n    │       ├── .jml\n    │       └── Beispiel.java\n    └── pfad/zum/ausgabeordner/\n        ├── Maeusekampf-Loesung/\n        │   └── Beispiel.java\n        ├── Maeusekampf-1/\n        │   └── Beispiel.java\n        ├── Maeusekampf-2/\n        │   └── Beispiel.java\n        ├── Maeusekampf-Loesung.zip\n        ├── Maeusekampf-1.zip\n        └── Maeusekampf-2.zip\n\n',
    'author': 'J. Neugebauer',
    'author_email': 'ngb@helmholtz-bi.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/jneug/jml',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
