"""
File that containes teh interface for the Eterna webiste as well
as papers associated with it
"""

from dataclasses import dataclass
from typing import List, Dict
import pandas as pd
from pandas import DataFrame
import os


#this is the stuff that is generated by Rhijus wet lab
@dataclass
class WetlabData:
    Sequence: str = ""
    Eterna_Score: float = -1
    Baseline_Subscore: float = -1
    Folding_Subscore: float = -1
    Switch_Subscore: float = -1
    NumberOfClusters1: int = -1
    FoldChange: float = -1
    FoldChange_err_factor: float = -1
    KDOFF: float = -1
    KDON: float = -1
    ddG: float = -1
    ddG_err: float = -1

#data commonly associated with secondary structures. written with alternate structures in mind
#class structureData(NamedTuple):
#    secondaryStructure: str
#    freeEnergy: float
#    deltaMfeEnergy: float  

#this is the data the generated by folding software and in this case it is nupack
@dataclass
class NupackFoldData():
    temperature: int
    doPknot: bool
    isPknot: bool
    #mfeInfo: structureData
    #alternateStructureList: List[structureData]
    pairprobsList: List[List[float]]
    #primaryPairsList:list
    #primaryPairsSortedList: list
    #secondaryPairsList: list
    #secondaryPairsSortedList: list

#class Oligos(NamedTuple):
#    oligoSequence: str
#    oligoSequenceLenght:str
#    OligoConcentration: str

@dataclass
class DesignInformation():
    Sequence: str = ''
    Sequence_Length: int = 0
    #oligosList: List[Oligos]
    DesignID: int = 0
    Design: str = ''
    Player: str = ''
    Puzzle_Name: str = ''

#entry point for each design in a puzzle/lab
class DesignPerformanceData(object):

    def __init__(self, DesignInfo: DesignInformation, wetlabResults: WetlabData) -> None:
        self._design_info = DesignInfo
        self._wetlab_results = wetlabResults

    @property
    def design_info(self):
        return self._design_info
    
    @property
    def wetlab_results(self):
        return self._wetlab_results
    #nupackFoldResults: NupackFoldData

#entry point to puzzle or lab as we call them
@dataclass
class puzzleData():
    Puzzle_Name: str
    designsList: List[DesignPerformanceData]
    designsDict: Dict[str, DesignPerformanceData]

class PNASAnalysisLogging():

    def __init__(self) -> None:
        pass

    def open_sublab_from_excel(self,path:str, sheet_name:str, sublab:str):
        sheet:DataFrame = pd.read_excel(path, sheet_name=sheet_name)
        sublab_sheet:DataFrame  = sheet[sheet['Puzzle_Name'] == sublab]
        return sublab_sheet
    
    def save_excel_sheet(self, df:DataFrame, excel_path:str, sheet_name:str):
        if not os.path.exists(excel_path):
            df.to_excel(excel_path, sheet_name=sheet_name, index=False)
        else:
            with pd.ExcelWriter(excel_path, engine='openpyxl', if_sheet_exists='overlay', mode='a') as writer:
                df.to_excel(writer, sheet_name=sheet_name, startrow=writer.sheets[sheet_name].max_row, header=None, index=False)

    def save_dataframe_to_excel(self, src_dataframe:DataFrame, dst_path:str, dst_sheet_name:str):
        with pd.ExcelWriter(dst_path) as writer:
            src_dataframe.to_excel(writer, sheet_name=dst_sheet_name)

    def add_new_named_collumn(self,src_datafrm:DataFrame, column_name:str, column_list:List[str]):
        src_datafrm[column_name]=column_list
        return src_datafrm

class LabInterface():
    
    def __init__(self) -> None:
        pass
    
    def GetNamesClass(self, className):
        variables = [i for i in vars(className).keys() if not callable(i) and not i.startswith('__') ]
        #variables = list(vars(className).keys())
        return variables

    def openExcelWetlab(self, path, designRoundSheet):
        #$designRound = "Round 7 (R101)"
        pnasPath = r'pnas.2112979119.sd01.xlsx'
        designRound = "Round 7 (R101)"
        roundData = ['DesignID', 'Design', 'Player', 'Puzzle_Name', 'Eterna_Score', 'FoldChange', 'Sequence']
        sheet = pd.read_excel(path, sheet_name=designRoundSheet).itertuples()
        return sheet
    """
    def GenerateNupackEntry(self, wetlabDataObject: WetlabData, temperature, doPknot):
        #now need to run each design through nupack
        #pairProbsList = List[List[float]]
        pairProbsList = nupackAPI.GetPairProbs2DArray(wetlabDataObject.Sequence, 'rna95-nupack3', temperature)
        
        isPknot=False
        if doPknot is False:
            isPknot=False
        else:
            doPknot=True
        
        nupackEntry = NupackFoldData(temperature=temperature, doPknot=doPknot, isPknot=isPknot, pairprobsList=pairProbsList)
     return nupackEntry
    """
    def GetSetValue(self, getObject, variableSeek, setObject):
        value = getattr(getObject, variableSeek)
        setattr(setObject, variableSeek, value)
        return setObject

    def GenerateWetlabEntry(self, row):
        wetlab = WetlabData()
        #this is a list of the variable names from the wetlab class
        variables = self.GetNamesClass(WetlabData)
        for variable in variables:
            #sourceValue = getattr(row, variable)
            #setattr(wetlab, variable, sourceValue)
            wetlab =  self.GetSetValue(row, variable, wetlab)
        #for name, value in WetlabData.__dict__().items():
        #    wetlab =  GetSetValue(row, name, wetlab)
        #all the contents of the wetlab excel should now be loaded into wetlabData object wetlab
        #return it then
        return wetlab


    def GenerateDesignInfo(self, row):
        designInfo = DesignInformation()
        #this is a list of the variable names from the wetlab class
        members = self.GetNamesClass(DesignInformation)
        for variable in members:
            self.GetSetValue(row, variable, designInfo)
        return designInfo
    
    def ProcessLab_PNAS(self, path, designRound_sheet, sublab_name) -> puzzleData:
                
        logging: PNASAnalysisLogging = PNASAnalysisLogging()
        sheet = logging.open_sublab_from_excel(path=path,
                                       sheet_name=designRound_sheet,
                                       sublab=sublab_name)
        #sheet = self.openExcelWetlab(path, designRound_sheet)
        #first do the Design entry stuff  

        designs: List[DesignPerformanceData] = []
        designsDict: Dict[str, DesignPerformanceData] = {}
        
        for row in sheet.itertuples():
            # this is a single line from teh file and representas a single design. load this into wetlabdata
            # and then do nupack. each row is in a namedtouple formate
            wetlabResults: WetlabData = self.GenerateWetlabEntry(row)
            #nupackRestuls = GenerateNupackEntry(wetlabResults, 37, False)
            desingInfo: DesignInformation = self.GenerateDesignInfo(row)
            DesingData:DesignPerformanceData = DesignPerformanceData(DesignInfo=desingInfo, wetlabResults=wetlabResults)
            designs.append(DesingData)
            designsDict[str(DesingData.design_info.DesignID)]=DesingData

        puzzlename = designs[0].design_info.Puzzle_Name
        #lets stop at puzzle data until this is fully gigure out and tested a bit
        puzzleInfo = puzzleData(Puzzle_Name=puzzlename, designsList=designs, designsDict=designsDict)    
        return puzzleInfo, sheet


