# create the class for holding all the data associated with each design. 
# use namedtuple for memory for for what is parsed from spreedsheets and 
# fold data generated by nupack as should not change
from decimal import Decimal
import string
from tokenize import Double
from turtle import st
from typing import Dict, NamedTuple, List, Optional
from unicodedata import decimal
import pandas as pd
import sys
import openpyxl
from dataclasses import dataclass
import pandas as pd
from collections import OrderedDict
from enum import Enum

#import serena.apps.original_weighted_analysis as nupackAPI
from serena.utilities.logging_serena import PNASAnalysisLogging

#this is the stuff that is generated by Rhijus wet lab
@dataclass
class WetlabData:
    Sequence: str = ""
    Eterna_Score: float = -1
    Baseline_Subscore: float = -1
    Folding_Subscore: float = -1
    Switch_Subscore: float = -1
    NumberOfClusters1: int = -1
    FoldChange: float = -1
    FoldChange_err_factor: float = -1
    KDOFF: float = -1
    KDON: float = -1
    ddG: float = -1
    ddG_err: float = -1

#data commonly associated with secondary structures. written with alternate structures in mind
#class structureData(NamedTuple):
#    secondaryStructure: str
#    freeEnergy: float
#    deltaMfeEnergy: float  

#this is the data the generated by folding software and in this case it is nupack
@dataclass
class NupackFoldData():
    temperature: int
    doPknot: bool
    isPknot: bool
    #mfeInfo: structureData
    #alternateStructureList: List[structureData]
    pairprobsList: List[List[float]]
    #primaryPairsList:list
    #primaryPairsSortedList: list
    #secondaryPairsList: list
    #secondaryPairsSortedList: list

#class Oligos(NamedTuple):
#    oligoSequence: str
#    oligoSequenceLenght:str
#    OligoConcentration: str

@dataclass
class DesignInformation():
    Sequence: str = ''
    Sequence_Length: int = 0
    #oligosList: List[Oligos]
    DesignID: int = 0
    Design: str = ''
    Player: str = ''
    Puzzle_Name: str = ''

#entry point for each design in a puzzle/lab
class DesignPerformanceData(object):

    def __init__(self, DesignInfo: DesignInformation, wetlabResults: WetlabData) -> None:
        self._design_info = DesignInfo
        self._wetlab_results = wetlabResults

    @property
    def design_info(self):
        return self._design_info
    
    @property
    def wetlab_results(self):
        return self._wetlab_results
    #nupackFoldResults: NupackFoldData

#entry point to puzzle or lab as we call them
@dataclass
class puzzleData():
    Puzzle_Name: str
    designsList: List[DesignPerformanceData]
    designsDict: Dict[str, DesignPerformanceData]


#class RoundData(NamedTuple):
#    roundName: str
#    roundID: int
#    puzzleLabList: List[puzzleData]

       

# for each design entry we make a DesignData object and add that to a Lst once that is done 
# we add it to a puzzleData object and once that is done for all the puzzles we then add it to a round data and wea re finished.
# I think round data should be changable
class Sara2API():

    def __init__(self) -> None:
        pass

    def GetNamesClass(self, className):
        variables = [i for i in vars(className).keys() if not callable(i) and not i.startswith('__') ]
        #variables = list(vars(className).keys())
        return variables

    def openExcelWetlab(self, path, designRoundSheet):
        #$designRound = "Round 7 (R101)"
        pnasPath = r'pnas.2112979119.sd01.xlsx'
        designRound = "Round 7 (R101)"
        roundData = ['DesignID', 'Design', 'Player', 'Puzzle_Name', 'Eterna_Score', 'FoldChange', 'Sequence']
        sheet = pd.read_excel(path, sheet_name=designRoundSheet).itertuples()
        return sheet
    """
    def GenerateNupackEntry(self, wetlabDataObject: WetlabData, temperature, doPknot):
        #now need to run each design through nupack
        #pairProbsList = List[List[float]]
        pairProbsList = nupackAPI.GetPairProbs2DArray(wetlabDataObject.Sequence, 'rna95-nupack3', temperature)
        
        isPknot=False
        if doPknot is False:
            isPknot=False
        else:
            doPknot=True
        
        nupackEntry = NupackFoldData(temperature=temperature, doPknot=doPknot, isPknot=isPknot, pairprobsList=pairProbsList)
     return nupackEntry
    """
    def GetSetValue(self, getObject, variableSeek, setObject):
        value = getattr(getObject, variableSeek)
        setattr(setObject, variableSeek, value)
        return setObject

    def GenerateWetlabEntry(self, row):
        wetlab = WetlabData()
        #this is a list of the variable names from the wetlab class
        variables = self.GetNamesClass(WetlabData)
        for variable in variables:
            #sourceValue = getattr(row, variable)
            #setattr(wetlab, variable, sourceValue)
            wetlab =  self.GetSetValue(row, variable, wetlab)
        #for name, value in WetlabData.__dict__().items():
        #    wetlab =  GetSetValue(row, name, wetlab)
        #all the contents of the wetlab excel should now be loaded into wetlabData object wetlab
        #return it then
        return wetlab


    def GenerateDesignInfo(self, row):
        designInfo = DesignInformation()
        #this is a list of the variable names from the wetlab class
        members = self.GetNamesClass(DesignInformation)
        for variable in members:
            self.GetSetValue(row, variable, designInfo)
        return designInfo
        

    def ProcessLab(self, path, designRound_sheet, sublab_name) -> puzzleData:
        logging: PNASAnalysisLogging = PNASAnalysisLogging()
        sheet = logging.open_sublab_from_excel(path=path,
                                       sheet_name=designRound_sheet,
                                       sublab=sublab_name)
        #sheet = self.openExcelWetlab(path, designRound_sheet)
        #first do the Design entry stuff  

        designs: List[DesignPerformanceData] = []
        designsDict: Dict[str, DesignPerformanceData] = {}
        
        for row in sheet.itertuples():
            # this is a single line from teh file and representas a single design. load this into wetlabdata
            # and then do nupack. each row is in a namedtouple formate
            wetlabResults: WetlabData = self.GenerateWetlabEntry(row)
            #nupackRestuls = GenerateNupackEntry(wetlabResults, 37, False)
            desingInfo: DesignInformation = self.GenerateDesignInfo(row)
            DesingData:DesignPerformanceData = DesignPerformanceData(DesignInfo=desingInfo, wetlabResults=wetlabResults)
            designs.append(DesingData)
            designsDict[str(DesingData.design_info.DesignID)]=DesingData

        puzzlename = designs[0].design_info.Puzzle_Name
        #lets stop at puzzle data until this is fully gigure out and tested a bit
        puzzleInfo = puzzleData(Puzzle_Name=puzzlename, designsList=designs, designsDict=designsDict)    
        return puzzleInfo, sheet


