# AstroTool #

A Python package for astronomical calculations in Python or on the command line.


## Installation ##

This package can be installed using `pip install astrotool`.  This should automatically install the dependency
packages `astroconst`, `colored_traceback` and `numpy` if they haven't been installed already.  If you are
installing by hand, you have to ensure these packages are installed as well.


## AstroTool pages ##

* [Pypi](https://pypi.org/project/astrotool/): AstroTool Python package
* [GitHub](https://github.com/MarcvdSluys/AstroTool): AstroTool source code
* [Read the Docs](https://astrotool.readthedocs.io): AstroTool documentation


## Author and licence ##

* Author: Marc van der Sluys
* Contact: http://astro.ru.nl/~sluys/
* Licence: [EUPL 1.2](https://www.eupl.eu/1.2/en/)


## See also ##

* [AstroConst](https://pypi.org/project/astroconst/): astronomical constants in Python
* SolTrack: a free, fast and accurate [Python](https://pypi.org/project/soltrack/) or
  [C/C++](http://soltrack.sourceforge.net/) routine to compute the position of the Sun
* [elp-mpp02](https://pypi.org/project/elp-mpp02/): accurate Moon positions using the lunar solution ELP/MPP02
  in Python
* [libTheSky](http://libthesky.sourceforge.net/): a Fortran library to compute the positions of celestial
  bodies (Sun, Moon, planets, stars, asteroids, comets) and events (e.g. lunar phases) with great accuracy.


## References ##

* Meeus, [Astronomical algorithms](https://www.willbell.com/math/MC1.HTM), 2nd Ed.
* [Celestial mechanics in a nutshell (CMiaNS)](https://cmians.sourceforge.io/)
* This Python code is being adapted from the Fortran implementation in
  [libTheSky](http://libthesky.sourceforge.net/)


<sub>Copyright (c) 2021-2022 Marc van der Sluys</sub>
