# Image Augmentations

This is a bounding box level image augmentation tool, it can perform 14 annotations. The important ones are rotation, affine, zooming in and out, noise, and blur. The augmentations were applied to a fraction of the data (40 - 50 percent of the images out of 100 can be augmented).When rotating or zooming in and out, the bounding box coordinates will also change as the image is rotated or zoomed.

### Create a folder first, inside that folder keep your image annotation folder.

### Create a virtual environment

```python

pip install virtualenv
#name your environment
python3 -m venv <your env name>

#activate the environment --> for linux user
source <your env name>/bin/activate

#activate the environment  --> for windows user
<your env name>/Source/activate.ps1

```

### Installation (for pip installation)

```python
pip install image_augs
```

## After installation

**create a .py script inside your created folder**

**This Script is for OBJECT DETECTION**

```python
#import these modules in your created <scriptname>.py file


from object_detection_aug.combined import main
from object_detection_aug.converter_for_txtToYolo import converter



annotation_folder = 'test_objectDetection'  # YOUR ANNOTATION FOLDER NAME
new_aug_saved_folder = 'test_object'        # AUGMENTATION SAVED FOLDER
resize_image = 640                          # REIZE IMAGE
test_split = 0.20                           # TEST SPLIT 



output = converter(annotation_folder,resize_im=resize_image)

# DO YOUR DESIRED AUGMENTATION
# IF BLUR TRUE AND BLUR_F SET TO 0.7 THEN IT WILL TAKE 50% OF YOUR TRAINNING DATA AND APPLY BLUR ON IT.
dicc = main(folder=new_aug_saved_folder,


    test_split=test_split,

    blurs=True, blur_f=0.7,

    noise=True, noise_f=0.6,

    NB=True, NB_f=0.5,

    hue=True, hue_f=0.5,

    sat=True, sat_f=0.5,

    bright=True, bright_f=0.7,

    contrast=True , contrast_f=0.5,

    rotation=True, rotation_f=0.5,

    zoom=True, zoom_f=0.5,

    affine=True, affine_f=0.5,

    translation=True, translation_f=0.5,

    vertical_flip=True, vertical_f=0.5)

#results will be saved in < your given folder >
```

**This Script is for INSTANCE SEGMENTATION**

```python
#import these modules in your created <scriptname>.py file
from instance_seg.json_reader_poly import PolygonAugmentation

annotation_folder = '<YOUR ANNOTATION FOLDER NAME>'    
new_aug_saved_folder = '< AUGMENTATION SAVED FOLDER>'
resize_image = 640
train_split = 0.80

im_aug_helper = PolygonAugmentation(aug_save_folder_name=new_aug_saved_folder,
                                    image_resize=resize_image)

im_aug_helper.Image_augmentation(annotation_folder,
                                 
                                 train_split=train_split,

                                    blur=True,  blur_f=0.8,

                                    rotate=True, rotate_f = 0.8, 

                                    noise=True, noise_f=0.8,

                                    perspective=True, perspective_f = 0.8,

                                    affine=True, affine_f=0.8,

                                    brightness=True, brightness_f=0.8,
                                    
                                    hue=True, hue_f=0.8,

                                    removesaturation=True, removesaturation_f=0.8,

                                    contrast=True, contrast_f=0.8,

                                    upflip=True, upflip_f=0.8,

                                    shear=True , shear_f=0.8, 

                                    rotate90=True, rotate90_f =0.8,

                                    blur_and_noise=True, blur_and_noise_f=0.8,

                                    image_cutout = True, image_cutout_f=0.8,
                                    
                                    mix_aug=True, mix_aug_f=0.8,
                                    
                                    temperature_change=True, temperature_change_f=0.8)
#results will be saved in < your given folder >
```

**This Script is for IMAGE CLASSIFICATION**

```python
#import these modules in your created <scriptname>.py file
from classification.classification_combined import ImageAugmentHelper


### PARAMS ###
source_folder = '<source folder>'
aug_saved_folder = '<augmentation saved folder>'
train_split = 0.5
image_height = 512
image_width = 512

classification_aug = ImageAugmentHelper(source_folder=source_folder,
                                        aug_save_folder_name=aug_saved_folder,
                                        train_split=train_split,
                                        height=image_height,
                                        width=image_width)


classification_aug.augmentations(

    save_raw_images=True,

    blur=True, blur_f=1.0,

    noise=True,noise_f=1.0,

    horizontalFlip=True, horizontalFlip_f=1.0,

    brightness=True, brightness_f=1.0,

    contrast=True, contrast_f=1.0,

    hue=True, hue_f=1.0,

    saturation=True, saturation_f=1.0,

    zoom=True, zoom_f=1.0,

    perspective=True, perspective_f=1.0,

    translation=True, translation_f=1.0,

    sharpen=True, sharpen_f=1.0,
    
    randomShadow=True, randomShadow_f=1.0
)


Use github to clone [image_augmentations](https://github.com/Souviksaha1998/Image_augmentations) repo.




## Contributing
Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.

## License
[MIT](https://choosealicense.com/licenses/mit/)


