[![Release](https://badgen.net/github/release/manjavacas/melkit)]() [![License](https://badgen.net/github/license/manjavacas/melkit)]() [![Contributors](https://badgen.net/github/contributors/manjavacas/melkit)]() [![Documentation Status](https://readthedocs.org/projects/melkit/badge/?version=latest)](https://melkit.readthedocs.io/en/latest/?badge=latest)

# MELKIT 🧰

A toolkit designed to facilitate the handling of MELCOR/MELGEN `1.8.6` files.

## ⚙️ Utilities

- Reading Control Volumes (`CVs`), Flow Paths (`FLs`), Control Functions (`CFs`) and converting them to objects.
- Writing, deleting and editing `CVs`, `FLs` and `CFs`.
- Plotting files generated by the `EDF` package (`PTF` support is planned!)
- Extraction of values printed by `EDF`.
- Obtaining the list of available/used IDs for different objects (`CVs`, `FLs`, `CFs`).
- Remove all comments from an input file.
- Search for objects by their ID.
- Search for duplicate objects in a given list.
- Get adjacent `CVs` and `FL` connections for a given `CV`.
- Get `CFs` associated with a given `FL`.
- Recursively extract inter-dependent `CFs`.
- Create submodels from a given `CV` (_beta_).

## 💻 How to use

You simply need to instantiate a `Toolkit` with the name of the MELGEN file to manipulate and call those functions. For example:

```python
from melkit.toolkit import Toolkit

toolkit = Toolkit(filename)

cvs = toolkit.read_cvs()
fls = toolkit.read_fls()
```

## ➕ Extensions

Includes **MELCOR Language Support** (`mls`): a MELCOR 1.8.6 syntax highlighter for Visual Studio Code.

Just copy the [`mls` folder](https://github.com/manjavacas/melkit/tree/main/vscode/mls) in `.vscode/extensions` for an improved MELCOR coding experience. 

You can find the Visual Studio Code installation folder in the following paths:

* **Windows**: `%USERPROFILE%\.vscode\extensions`
* **macOS**: `~/.vscode/extensions`
* **Linux**: `~/.vscode/extensions`

## 👐 Contributing

Feel free to contribute via _issues_ and _pull requests_.