import { IConstruct } from "constructs";
import { Manifest } from "./manifest";
import { Model } from "./model";
export interface ISynthesisSession {
    /**
     * The output directory for this synthesis session.
     */
    readonly outdir: string;
    readonly skipValidation?: boolean;
    readonly manifest: Manifest;
}
export interface IModelSynthesizer {
    /**
     * Synthesize the associated model to the session
     */
    synthesize(session: ISynthesisSession): void;
    addFileAsset(filePath: string): void;
}
export declare class ModelSynthesizer implements IModelSynthesizer {
    protected model: Model;
    private continueOnErrorAnnotations;
    private fileAssets;
    constructor(model: Model, continueOnErrorAnnotations?: boolean);
    addFileAsset(filePath: string): void;
    synthesize(session: ISynthesisSession): void;
}
/**
 * Invoke aspects on the given construct tree.
 *
 * originally from https://github.com/aws/aws-cdk/blob/dcae3eead0dbf9acb1ed80ba95bb104c64cb1bd7/packages/@aws-cdk/core/lib/private/synthesis.ts#L99-L137
 */
export declare function invokeAspects(root: IConstruct): void;
/**
 * Interface for constructs that want to do something custom during synthesis
 *
 * This feature is intended for use by cdktg only; 3rd party
 * library authors and CDK users should not use this function.
 */
export interface ICustomSynthesis {
    /**
     * Called when the construct is synthesized
     */
    onSynthesize(session: ISynthesisSession): void;
}
export declare function addCustomSynthesis(construct: IConstruct, synthesis: ICustomSynthesis): void;
