"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiskTrackingStatus = exports.RiskTracking = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class RiskTracking {
    constructor(id, props) {
        this.id = id;
        this.status = props.status ?? RiskTrackingStatus.UNCHECKED;
        this.justification = props.justification;
        this.ticket = props.ticket;
        this.date = props.date
            ? new Date(props.date).toISOString().split("T")[0]
            : undefined;
        this.checkedBy = props.checkedBy;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                status: this.status,
                justification: this.justification,
                ticket: this.ticket,
                date: this.date,
                checked_by: this.checkedBy,
            },
        };
    }
}
exports.RiskTracking = RiskTracking;
_a = JSII_RTTI_SYMBOL_1;
RiskTracking[_a] = { fqn: "cdktg.RiskTracking", version: "0.0.25" };
var RiskTrackingStatus;
(function (RiskTrackingStatus) {
    RiskTrackingStatus["UNCHECKED"] = "unchecked";
    RiskTrackingStatus["IN_DISCUSSION"] = "in-discussion";
    RiskTrackingStatus["ACCEPTED"] = "accepted";
    RiskTrackingStatus["IN_PROGRESS"] = "in-progress";
    RiskTrackingStatus["MITIGATED"] = "mitigated";
    RiskTrackingStatus["FALSE_POSITIVE"] = "false-positive";
})(RiskTrackingStatus = exports.RiskTrackingStatus || (exports.RiskTrackingStatus = {}));
//# sourceMappingURL=data:application/json;base64,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