import { Construct } from "constructs";
import { Manifest } from "./manifest";
export interface ProjectProps {
    /**
     * The directory to output the threadgile model.
     *
     * @default - .
     */
    readonly outdir?: string;
    /**
     * Whether to skip the validation during synthesis of the project
     *
     * @default - false
     */
    readonly skipValidation?: boolean;
}
export declare class Project extends Construct {
    /**
     * The output directory into which models will be synthesized.
     */
    readonly outdir: string;
    /**
     * Whether to skip the validation during synthesis of the app
     */
    readonly skipValidation?: boolean;
    readonly manifest: Manifest;
    constructor(props?: ProjectProps);
    /**
     * Synthesizes the model to the output directory
     */
    synth(): void;
}
