"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Overview = exports.Image = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const annotations_1 = require("./annotations");
const model_1 = require("./model");
class Image {
    constructor(filePath, title) {
        this.filePath = filePath;
        this.title = title;
        if (!fs.existsSync(this.filePath)) {
            throw new Error(`Image file "${this.filePath}" does not exist.`);
        }
        if (!fs.lstatSync(this.filePath).isFile()) {
            throw new Error(`File path "${this.filePath}" is not a file.`);
        }
    }
    /**
     * @internal
     */
    _bind(scope) {
        this.model = model_1.Model.of(scope);
        const extension = path.extname(this.filePath);
        if (![".jpeg", ".jpg", ".png", ".gif"].includes(extension)) {
            annotations_1.Annotations.of(scope).addWarning(`Unsupported file extension. Image "${this.filePath}" may be ignored.`);
        }
        this.model.synthesizer.addFileAsset(this.filePath);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.filePath]: this.title,
        };
    }
}
exports.Image = Image;
_a = JSII_RTTI_SYMBOL_1;
Image[_a] = { fqn: "cdktg.Image", version: "0.0.25" };
class Overview {
    constructor(props) {
        this.description = props.description;
        this.images = props.images;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            description: this.description,
            images: this.images?.map((i) => i._toThreagile()),
        };
    }
}
exports.Overview = Overview;
_b = JSII_RTTI_SYMBOL_1;
Overview[_b] = { fqn: "cdktg.Overview", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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