"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PingCommand = void 0;
const threagile_1 = require("../api/threagile");
class PingCommand {
    constructor() {
        this.command = "ping";
        this.describe = "ping the api";
        this.builder = (args) => {
            args.option("url", { type: "string", alias: "u", describe: "" });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            const api = new threagile_1.Threagile(url);
            const resp = await api.ping();
            if (resp.status === 200) {
                console.log(`✅  ${resp.data.message}\n`);
            }
            else {
                console.log("❌  Error\n");
            }
        };
    }
}
exports.PingCommand = PingCommand;
//# sourceMappingURL=data:application/json;base64,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