"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyzeCommand = void 0;
const path = require("path");
//import { Readable } from "stream";
const AdmZip = require("adm-zip");
const fs = require("fs-extra");
const threagile_1 = require("../api/threagile");
const manifest_1 = require("../manifest");
class AnalyzeCommand {
    constructor() {
        this.command = "analyze";
        this.describe = "analyze the models";
        this.builder = (args) => {
            args.option("url", {
                type: "string",
                alias: "u",
                describe: "URL of the threagile rest api",
            });
            args.option("output", {
                type: "string",
                alias: "o",
                describe: "",
                default: "dist",
            });
            return args;
        };
        this.handler = async (args) => {
            const url = args.url ?? process.env.CDKTG_THREAGILE_BASE_URL;
            fs.mkdirSync(args.output, { recursive: true });
            const api = new threagile_1.Threagile(url);
            const manifest = manifest_1.Manifest.fromPath(".cdktg.out");
            Object.keys(manifest.models).forEach(async (k) => {
                const modelManifest = manifest.models[k];
                const resp = await api.analyze(path.join(".cdktg.out", modelManifest.synthesizedModelPath));
                if (resp.status === 400) {
                    console.log(`Errors for model "${k}":`);
                    console.log(resp.data.error);
                    return;
                }
                const zip = new AdmZip(resp.data);
                zip.extractAllTo(path.join(args.output, modelManifest.sanitizedName));
            });
        };
    }
}
exports.AnalyzeCommand = AnalyzeCommand;
//# sourceMappingURL=data:application/json;base64,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