export interface CIATriadProps {
    readonly confidentiality: Confidentiality;
    readonly integrity: Integrity;
    readonly availability: Availability;
    readonly justification?: string;
}
export declare class CIATriad {
    readonly confidentiality: Confidentiality;
    readonly integrity: Integrity;
    readonly availability: Availability;
    readonly justification?: string;
    constructor(props: CIATriadProps);
    /**
     * @internal
     */
    _toThreagile(): {
        confidentiality: Confidentiality;
        integrity: Integrity;
        availability: Availability;
        justification_cia_rating: string | undefined;
    };
}
export declare enum Confidentiality {
    PUBLIC = "public",
    INTERNAL = "internal",
    RESTRICTED = "restricted",
    CONFIDENTIAL = "confidential",
    STRICTLY_CONFIDENTIAL = "strictly-confidential"
}
export declare enum Integrity {
    ARCHIVE = "archive",
    OPERATIONAL = "operational",
    IMPORTANT = "important",
    CRITICAL = "critical",
    MISSION_CRITICAL = "mission-critical"
}
export declare enum Availability {
    ARCHIVE = "archive",
    OPERATIONAL = "operational",
    IMPORTANT = "important",
    CRITICAL = "critical",
    MISSION_CRITICAL = "mission-critical"
}
