# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PDKNagApp <a name="PDKNagApp" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp"></a>

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagApp(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  policy_validation_beta1: typing.List[IPolicyValidationPluginBeta1] = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.analyticsReporting">analytics_reporting</a></code> | <code>bool</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.autoSynth">auto_synth</a></code> | <code>bool</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer">default_stack_synthesizer</a></code> | <code>aws_cdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.outdir">outdir</a></code> | <code>str</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.policyValidationBeta1">policy_validation_beta1</a></code> | <code>typing.List[aws_cdk.IPolicyValidationPluginBeta1]</code> | Validation plugins to run after synthesis. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.postCliContext">post_cli_context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.stackTraces">stack_traces</a></code> | <code>bool</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.treeMetadata">tree_metadata</a></code> | <code>bool</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnError">fail_on_error</a></code> | <code>bool</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnWarning">fail_on_warning</a></code> | <code>bool</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | Custom nag packs to execute. |

---

##### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.analyticsReporting"></a>

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.autoSynth"></a>

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.defaultStackSynthesizer"></a>

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.outdir"></a>

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `policy_validation_beta1`<sup>Optional</sup> <a name="policy_validation_beta1" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.policyValidationBeta1"></a>

- *Type:* typing.List[aws_cdk.IPolicyValidationPluginBeta1]
- *Default:* no validation plugins

Validation plugins to run after synthesis.

---

##### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.postCliContext"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.stackTraces"></a>

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.treeMetadata"></a>

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnError"></a>

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.failOnWarning"></a>

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.Initializer.parameter.nagPacks"></a>

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth">synth</a></code> | Synthesize this stage into a cloud assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult">add_nag_result</a></code> | *No description.* |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults">nag_results</a></code> | Returns a list of NagResult. |

---

##### `to_string` <a name="to_string" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `synth` <a name="synth" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth"></a>

```python
def synth(
  force: bool = None,
  skip_validation: bool = None,
  validate_on_synthesis: bool = None
) -> CloudAssembly
```

Synthesize this stage into a cloud assembly.

Once an assembly has been synthesized, it cannot be modified. Subsequent
calls will return the same assembly.

###### `force`<sup>Optional</sup> <a name="force" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth.parameter.force"></a>

- *Type:* bool
- *Default:* false

Force a re-synth, even if the stage has already been synthesized.

This is used by tests to allow for incremental verification of the output.
Do not use in production.

---

###### `skip_validation`<sup>Optional</sup> <a name="skip_validation" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth.parameter.skipValidation"></a>

- *Type:* bool
- *Default:* false

Should we skip construct validation.

---

###### `validate_on_synthesis`<sup>Optional</sup> <a name="validate_on_synthesis" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.synth.parameter.validateOnSynthesis"></a>

- *Type:* bool
- *Default:* false

Whether the stack should be validated after synthesis to check for error metadata.

---

##### `add_nag_result` <a name="add_nag_result" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult"></a>

```python
def add_nag_result(
  messages: typing.List[Message],
  resource: str
) -> None
```

###### `messages`<sup>Required</sup> <a name="messages" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult.parameter.messages"></a>

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>]

List of messages.

---

###### `resource`<sup>Required</sup> <a name="resource" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.addNagResult.parameter.resource"></a>

- *Type:* str

Resource which triggered the message.

---

##### `nag_results` <a name="nag_results" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.nagResults"></a>

```python
def nag_results() -> typing.List[NagResult]
```

Returns a list of NagResult.

Note: app.synth() must be called before this to retrieve results.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage">is_stage</a></code> | Test whether the given construct is a stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.of">of</a></code> | Return the stage this construct is contained with, if available. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp">is_app</a></code> | Checks if an object is an instance of the `App` class. |

---

##### `is_construct` <a name="is_construct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagApp.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_stage` <a name="is_stage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagApp.is_stage(
  x: typing.Any
)
```

Test whether the given construct is a stage.

###### `x`<sup>Required</sup> <a name="x" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isStage.parameter.x"></a>

- *Type:* typing.Any

---

##### `of` <a name="of" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagApp.of(
  construct: IConstruct
)
```

Return the stage this construct is contained with, if available.

If called
on a nested stage, returns its parent.

###### `construct`<sup>Required</sup> <a name="construct" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.of.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

##### `is_app` <a name="is_app" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagApp.is_app(
  obj: typing.Any
)
```

Checks if an object is an instance of the `App` class.

###### `obj`<sup>Required</sup> <a name="obj" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.isApp.parameter.obj"></a>

- *Type:* typing.Any

The object to evaluate.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId">artifact_id</a></code> | <code>str</code> | Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir">asset_outdir</a></code> | <code>str</code> | The cloud assembly asset output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir">outdir</a></code> | <code>str</code> | The cloud assembly output directory. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.policyValidationBeta1">policy_validation_beta1</a></code> | <code>typing.List[aws_cdk.IPolicyValidationPluginBeta1]</code> | Validation plugins to run during synthesis. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName">stage_name</a></code> | <code>str</code> | The name of the stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account">account</a></code> | <code>str</code> | The default account for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage">parent_stage</a></code> | <code>aws_cdk.Stage</code> | The parent stage or `undefined` if this is the app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region">region</a></code> | <code>str</code> | The default region for all resources defined within this stage. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `artifact_id`<sup>Required</sup> <a name="artifact_id" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.artifactId"></a>

```python
artifact_id: str
```

- *Type:* str

Artifact ID of the assembly if it is a nested stage. The root stage (app) will return an empty string.

Derived from the construct path.

---

##### `asset_outdir`<sup>Required</sup> <a name="asset_outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.assetOutdir"></a>

```python
asset_outdir: str
```

- *Type:* str

The cloud assembly asset output directory.

---

##### `outdir`<sup>Required</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.outdir"></a>

```python
outdir: str
```

- *Type:* str

The cloud assembly output directory.

---

##### `policy_validation_beta1`<sup>Required</sup> <a name="policy_validation_beta1" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.policyValidationBeta1"></a>

```python
policy_validation_beta1: typing.List[IPolicyValidationPluginBeta1]
```

- *Type:* typing.List[aws_cdk.IPolicyValidationPluginBeta1]
- *Default:* no validation plugins are used

Validation plugins to run during synthesis.

If any plugin reports any violation,
synthesis will be interrupted and the report displayed to the user.

---

##### `stage_name`<sup>Required</sup> <a name="stage_name" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.stageName"></a>

```python
stage_name: str
```

- *Type:* str

The name of the stage.

Based on names of the parent stages separated by
hypens.

---

##### `account`<sup>Optional</sup> <a name="account" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.account"></a>

```python
account: str
```

- *Type:* str

The default account for all resources defined within this stage.

---

##### `parent_stage`<sup>Optional</sup> <a name="parent_stage" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.parentStage"></a>

```python
parent_stage: Stage
```

- *Type:* aws_cdk.Stage

The parent stage or `undefined` if this is the app.

*

---

##### `region`<sup>Optional</sup> <a name="region" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.region"></a>

```python
region: str
```

- *Type:* str

The default region for all resources defined within this stage.

---

##### `nag_packs`<sup>Required</sup> <a name="nag_packs" id="@aws-prototyping-sdk/pdk-nag.PDKNagApp.property.nagPacks"></a>

```python
nag_packs: typing.List[NagPack]
```

- *Type:* typing.List[cdk_nag.NagPack]

---


## Structs <a name="Structs" id="Structs"></a>

### Message <a name="Message" id="@aws-prototyping-sdk/pdk-nag.Message"></a>

Message instance.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.Message.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.Message(
  message_description: str,
  message_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription">message_description</a></code> | <code>str</code> | Message description. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.Message.property.messageType">message_type</a></code> | <code>str</code> | Message type as returned from cdk-nag. |

---

##### `message_description`<sup>Required</sup> <a name="message_description" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageDescription"></a>

```python
message_description: str
```

- *Type:* str

Message description.

---

##### `message_type`<sup>Required</sup> <a name="message_type" id="@aws-prototyping-sdk/pdk-nag.Message.property.messageType"></a>

```python
message_type: str
```

- *Type:* str

Message type as returned from cdk-nag.

---

### NagResult <a name="NagResult" id="@aws-prototyping-sdk/pdk-nag.NagResult"></a>

Nag result.

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.NagResult.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.NagResult(
  messages: typing.List[Message],
  resource: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.messages">messages</a></code> | <code>typing.List[<a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>]</code> | List of messages. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.NagResult.property.resource">resource</a></code> | <code>str</code> | Resource which triggered the message. |

---

##### `messages`<sup>Required</sup> <a name="messages" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.messages"></a>

```python
messages: typing.List[Message]
```

- *Type:* typing.List[<a href="#@aws-prototyping-sdk/pdk-nag.Message">Message</a>]

List of messages.

---

##### `resource`<sup>Required</sup> <a name="resource" id="@aws-prototyping-sdk/pdk-nag.NagResult.property.resource"></a>

```python
resource: str
```

- *Type:* str

Resource which triggered the message.

---

### PDKNagAppProps <a name="PDKNagAppProps" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps"></a>

#### Initializer <a name="Initializer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNagAppProps(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  policy_validation_beta1: typing.List[IPolicyValidationPluginBeta1] = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting">analytics_reporting</a></code> | <code>bool</code> | Include runtime versioning information in the Stacks of this app. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth">auto_synth</a></code> | <code>bool</code> | Automatically call `synth()` before the program exits. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context">context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer">default_stack_synthesizer</a></code> | <code>aws_cdk.IReusableStackSynthesizer</code> | The stack synthesizer to use by default for all Stacks in the App. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir">outdir</a></code> | <code>str</code> | The output directory into which to emit synthesized artifacts. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.policyValidationBeta1">policy_validation_beta1</a></code> | <code>typing.List[aws_cdk.IPolicyValidationPluginBeta1]</code> | Validation plugins to run after synthesis. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext">post_cli_context</a></code> | <code>typing.Mapping[typing.Any]</code> | Additional context values for the application. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces">stack_traces</a></code> | <code>bool</code> | Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata">tree_metadata</a></code> | <code>bool</code> | Include construct tree metadata as part of the Cloud Assembly. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError">fail_on_error</a></code> | <code>bool</code> | Determines whether any errors encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning">fail_on_warning</a></code> | <code>bool</code> | Determines whether any warnings encountered should trigger a test failure. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks">nag_packs</a></code> | <code>typing.List[cdk_nag.NagPack]</code> | Custom nag packs to execute. |

---

##### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.analyticsReporting"></a>

```python
analytics_reporting: bool
```

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

##### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.autoSynth"></a>

```python
auto_synth: bool
```

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

##### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.context"></a>

```python
context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

##### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.defaultStackSynthesizer"></a>

```python
default_stack_synthesizer: IReusableStackSynthesizer
```

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

##### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.outdir"></a>

```python
outdir: str
```

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

##### `policy_validation_beta1`<sup>Optional</sup> <a name="policy_validation_beta1" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.policyValidationBeta1"></a>

```python
policy_validation_beta1: typing.List[IPolicyValidationPluginBeta1]
```

- *Type:* typing.List[aws_cdk.IPolicyValidationPluginBeta1]
- *Default:* no validation plugins

Validation plugins to run after synthesis.

---

##### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.postCliContext"></a>

```python
post_cli_context: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


##### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.stackTraces"></a>

```python
stack_traces: bool
```

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

##### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.treeMetadata"></a>

```python
tree_metadata: bool
```

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

##### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnError"></a>

```python
fail_on_error: bool
```

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

##### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.failOnWarning"></a>

```python
fail_on_warning: bool
```

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

##### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="@aws-prototyping-sdk/pdk-nag.PDKNagAppProps.property.nagPacks"></a>

```python
nag_packs: typing.List[NagPack]
```

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

## Classes <a name="Classes" id="Classes"></a>

### AwsPrototypingChecks <a name="AwsPrototypingChecks" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks"></a>

Check best practices for prototypes.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.AwsPrototypingChecks(
  additional_loggers: typing.List[INagLogger] = None,
  log_ignores: bool = None,
  report_formats: typing.List[NagReportFormat] = None,
  reports: bool = None,
  suppression_ignore_condition: INagSuppressionIgnore = None,
  verbose: bool = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.additionalLoggers">additional_loggers</a></code> | <code>typing.List[cdk_nag.INagLogger]</code> | Additional NagLoggers for logging rule validation outputs. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.logIgnores">log_ignores</a></code> | <code>bool</code> | Whether or not to log suppressed rule violations as informational messages (default: false). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reportFormats">report_formats</a></code> | <code>typing.List[cdk_nag.NagReportFormat]</code> | If reports are enabled, the output formats of compliance reports in the App's output directory (default: only CSV). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reports">reports</a></code> | <code>bool</code> | Whether or not to generate compliance reports for applied Stacks in the App's output directory (default: true). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition">suppression_ignore_condition</a></code> | <code>cdk_nag.INagSuppressionIgnore</code> | Conditionally prevent rules from being suppressed (default: no user provided condition). |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.verbose">verbose</a></code> | <code>bool</code> | Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false). |

---

##### `additional_loggers`<sup>Optional</sup> <a name="additional_loggers" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.additionalLoggers"></a>

- *Type:* typing.List[cdk_nag.INagLogger]

Additional NagLoggers for logging rule validation outputs.

---

##### `log_ignores`<sup>Optional</sup> <a name="log_ignores" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.logIgnores"></a>

- *Type:* bool

Whether or not to log suppressed rule violations as informational messages (default: false).

---

##### `report_formats`<sup>Optional</sup> <a name="report_formats" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reportFormats"></a>

- *Type:* typing.List[cdk_nag.NagReportFormat]

If reports are enabled, the output formats of compliance reports in the App's output directory (default: only CSV).

---

##### `reports`<sup>Optional</sup> <a name="reports" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.reports"></a>

- *Type:* bool

Whether or not to generate compliance reports for applied Stacks in the App's output directory (default: true).

---

##### `suppression_ignore_condition`<sup>Optional</sup> <a name="suppression_ignore_condition" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.suppressionIgnoreCondition"></a>

- *Type:* cdk_nag.INagSuppressionIgnore

Conditionally prevent rules from being suppressed (default: no user provided condition).

---

##### `verbose`<sup>Optional</sup> <a name="verbose" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.Initializer.parameter.verbose"></a>

- *Type:* bool

Whether or not to enable extended explanatory descriptions on warning, error, and logged ignore messages (default: false).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit">visit</a></code> | Check if CfnResource and apply rules. |

---

##### `visit` <a name="visit" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit"></a>

```python
def visit(
  node: IConstruct
) -> None
```

Check if CfnResource and apply rules.

###### `node`<sup>Required</sup> <a name="node" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.visit.parameter.node"></a>

- *Type:* constructs.IConstruct

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName">read_pack_name</a></code> | <code>str</code> | *No description.* |

---

##### `read_pack_name`<sup>Required</sup> <a name="read_pack_name" id="@aws-prototyping-sdk/pdk-nag.AwsPrototypingChecks.property.readPackName"></a>

```python
read_pack_name: str
```

- *Type:* str

---


### PDKNag <a name="PDKNag" id="@aws-prototyping-sdk/pdk-nag.PDKNag"></a>

Helper for create a Nag Enabled App.

#### Initializers <a name="Initializers" id="@aws-prototyping-sdk/pdk-nag.PDKNag.Initializer"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag()
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |

---


#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow">add_resource_suppressions_by_path_no_throw</a></code> | Wrapper around NagSuppressions which does not throw. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.app">app</a></code> | Returns an instance of an App with Nag enabled. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex">get_stack_account_regex</a></code> | Returns a stack account regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex">get_stack_partition_regex</a></code> | Returns a stack partition regex. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix">get_stack_prefix</a></code> | Returns a prefix comprising of a delimited set of Stack Ids. |
| <code><a href="#@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex">get_stack_region_regex</a></code> | Returns a stack region regex. |

---

##### `add_resource_suppressions_by_path_no_throw` <a name="add_resource_suppressions_by_path_no_throw" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.add_resource_suppressions_by_path_no_throw(
  stack: Stack,
  path: str,
  suppressions: typing.List[NagPackSuppression],
  apply_to_children: bool = None
)
```

Wrapper around NagSuppressions which does not throw.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

###### `path`<sup>Required</sup> <a name="path" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.path"></a>

- *Type:* str

resource path.

---

###### `suppressions`<sup>Required</sup> <a name="suppressions" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.suppressions"></a>

- *Type:* typing.List[cdk_nag.NagPackSuppression]

list of suppressions to apply.

---

###### `apply_to_children`<sup>Optional</sup> <a name="apply_to_children" id="@aws-prototyping-sdk/pdk-nag.PDKNag.addResourceSuppressionsByPathNoThrow.parameter.applyToChildren"></a>

- *Type:* bool

whether to apply to children.

---

##### `app` <a name="app" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.app(
  analytics_reporting: bool = None,
  auto_synth: bool = None,
  context: typing.Mapping[typing.Any] = None,
  default_stack_synthesizer: IReusableStackSynthesizer = None,
  outdir: str = None,
  policy_validation_beta1: typing.List[IPolicyValidationPluginBeta1] = None,
  post_cli_context: typing.Mapping[typing.Any] = None,
  stack_traces: bool = None,
  tree_metadata: bool = None,
  fail_on_error: bool = None,
  fail_on_warning: bool = None,
  nag_packs: typing.List[NagPack] = None
)
```

Returns an instance of an App with Nag enabled.

###### `analytics_reporting`<sup>Optional</sup> <a name="analytics_reporting" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.analyticsReporting"></a>

- *Type:* bool
- *Default:* Value of 'aws:cdk:version-reporting' context key

Include runtime versioning information in the Stacks of this app.

---

###### `auto_synth`<sup>Optional</sup> <a name="auto_synth" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.autoSynth"></a>

- *Type:* bool
- *Default:* true if running via CDK CLI (`CDK_OUTDIR` is set), `false` otherwise

Automatically call `synth()` before the program exits.

If you set this, you don't have to call `synth()` explicitly. Note that
this feature is only available for certain programming languages, and
calling `synth()` is still recommended.

---

###### `context`<sup>Optional</sup> <a name="context" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.context"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context set by the CLI or the `context` key in `cdk.json` has precedence.

Context can be read from any construct using `node.getContext(key)`.

---

###### `default_stack_synthesizer`<sup>Optional</sup> <a name="default_stack_synthesizer" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.defaultStackSynthesizer"></a>

- *Type:* aws_cdk.IReusableStackSynthesizer
- *Default:* A `DefaultStackSynthesizer` with default settings

The stack synthesizer to use by default for all Stacks in the App.

The Stack Synthesizer controls aspects of synthesis and deployment,
like how assets are referenced and what IAM roles to use. For more
information, see the README of the main CDK package.

---

###### `outdir`<sup>Optional</sup> <a name="outdir" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.outdir"></a>

- *Type:* str
- *Default:* If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.   If `CDK_OUTDIR` is not defined, uses a temp directory.

The output directory into which to emit synthesized artifacts.

You should never need to set this value. By default, the value you pass to
the CLI's `--output` flag will be used, and if you change it to a different
directory the CLI will fail to pick up the generated Cloud Assembly.

This property is intended for internal and testing use.

---

###### `policy_validation_beta1`<sup>Optional</sup> <a name="policy_validation_beta1" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.policyValidationBeta1"></a>

- *Type:* typing.List[aws_cdk.IPolicyValidationPluginBeta1]
- *Default:* no validation plugins

Validation plugins to run after synthesis.

---

###### `post_cli_context`<sup>Optional</sup> <a name="post_cli_context" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.postCliContext"></a>

- *Type:* typing.Mapping[typing.Any]
- *Default:* no additional context

Additional context values for the application.

Context provided here has precedence over context set by:

- The CLI via --context
- The `context` key in `cdk.json`
- The `AppProps.context` property

This property is recommended over the `AppProps.context` property since you
can make final decision over which context value to take in your app.

Context can be read from any construct using `node.getContext(key)`.

---

*Example*

```python
// context from the CLI and from `cdk.json` are stored in the
// CDK_CONTEXT env variable
const cliContext = JSON.parse(process.env.CDK_CONTEXT!);

// determine whether to take the context passed in the CLI or not
const determineValue = process.env.PROD ? cliContext.SOMEKEY : 'my-prod-value';
new App({
  postCliContext: {
    SOMEKEY: determineValue,
  },
});
```


###### `stack_traces`<sup>Optional</sup> <a name="stack_traces" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.stackTraces"></a>

- *Type:* bool
- *Default:* true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.

Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.

---

###### `tree_metadata`<sup>Optional</sup> <a name="tree_metadata" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.treeMetadata"></a>

- *Type:* bool
- *Default:* true

Include construct tree metadata as part of the Cloud Assembly.

---

###### `fail_on_error`<sup>Optional</sup> <a name="fail_on_error" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.failOnError"></a>

- *Type:* bool
- *Default:* false

Determines whether any errors encountered should trigger a test failure.

---

###### `fail_on_warning`<sup>Optional</sup> <a name="fail_on_warning" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.failOnWarning"></a>

- *Type:* bool
- *Default:* false

Determines whether any warnings encountered should trigger a test failure.

---

###### `nag_packs`<sup>Optional</sup> <a name="nag_packs" id="@aws-prototyping-sdk/pdk-nag.PDKNag.app.parameter.nagPacks"></a>

- *Type:* typing.List[cdk_nag.NagPack]
- *Default:* DEFAULT_NAG_PACKS

Custom nag packs to execute.

---

##### `get_stack_account_regex` <a name="get_stack_account_regex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.get_stack_account_regex(
  stack: Stack
)
```

Returns a stack account regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackAccountRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_partition_regex` <a name="get_stack_partition_regex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.get_stack_partition_regex(
  stack: Stack
)
```

Returns a stack partition regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPartitionRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_prefix` <a name="get_stack_prefix" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.get_stack_prefix(
  stack: Stack
)
```

Returns a prefix comprising of a delimited set of Stack Ids.

For example: StackA/NestedStackB/

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackPrefix.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---

##### `get_stack_region_regex` <a name="get_stack_region_regex" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex"></a>

```python
import aws_prototyping_sdk.pdk_nag

aws_prototyping_sdk.pdk_nag.PDKNag.get_stack_region_regex(
  stack: Stack
)
```

Returns a stack region regex.

###### `stack`<sup>Required</sup> <a name="stack" id="@aws-prototyping-sdk/pdk-nag.PDKNag.getStackRegionRegex.parameter.stack"></a>

- *Type:* aws_cdk.Stack

stack instance.

---




