/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.hash;

import com.carrotsearch.hppcrt.hash.MurmurHash3;
import com.carrotsearch.hppcrt.hash.PhiMix;

public final class BitMixer {
    private BitMixer() {
    }

    public static int mix(byte k) {
        return k * -1640531527;
    }

    public static int mix(byte k, int seed) {
        return (k ^ seed) * -1640531527;
    }

    public static int mix(short k) {
        return PhiMix.mix32(k);
    }

    public static int mix(short k, int seed) {
        return PhiMix.mix32(k ^ seed);
    }

    public static int mix(char k) {
        return PhiMix.mix32(k);
    }

    public static int mix(char k, int seed) {
        return PhiMix.mix32(k ^ seed);
    }

    public static int mix(int key) {
        return MurmurHash3.mix32(key);
    }

    public static int mix(int k, int seed) {
        return MurmurHash3.mix32(k ^ seed);
    }

    public static int mix(float x) {
        return MurmurHash3.mix32(Float.floatToIntBits(x));
    }

    public static int mix(float x, int seed) {
        return MurmurHash3.mix32(Float.floatToIntBits(x) ^ seed);
    }

    public static int mix(double x) {
        return (int)MurmurHash3.mix64(Double.doubleToLongBits(x));
    }

    public static int mix(double x, int seed) {
        return (int)MurmurHash3.mix64(Double.doubleToLongBits(x) ^ (long)seed);
    }

    public static int mix(long z) {
        return (int)MurmurHash3.mix64(z);
    }

    public static int mix(long z, int seed) {
        return (int)MurmurHash3.mix64(z ^ (long)seed);
    }

    public static int mix(Object key) {
        return key == null ? 0 : MurmurHash3.mix32(key.hashCode());
    }
}

