/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntCollection;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import java.util.Arrays;

public abstract class AbstractIntCollection
implements IntCollection {
    protected IntLookupContainer testContainer;
    protected IntPredicate testPredicate;
    protected IntPredicate containsTestPredicate = new IntPredicate(){

        public final boolean apply(int k) {
            return AbstractIntCollection.this.testContainer.contains(k);
        }
    };
    protected IntPredicate containsNegateTestPredicate = new IntPredicate(){

        public final boolean apply(int k) {
            return !AbstractIntCollection.this.testContainer.contains(k);
        }
    };
    protected IntPredicate negatePredicate = new IntPredicate(){

        public final boolean apply(int k) {
            return !AbstractIntCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(IntLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(IntLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(IntPredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public int[] toArray(int[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (IntCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public int[] toArray() {
        try {
            return this.toArray(new int[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

