## lsclib
 
Luminescent solar concentrators (LSCs) enhance the power output of solar cells via luminescent emission and internal reflection.
LSCs have long been speculated as BIPV due to their innate architectural flexibility and vast potential for improvement in PV efficiency.
However, it is more difficult to model LSCs as compared with solar panels, and this has limited their integration commercially. lsclib
is a python-based repository hosted on GitHub that employs the Monte Carlo ray-tracing method of radiative transport to effectively model LSCs.

lsclib hopes to short-circuit the learning curve associated with breaking into the field, and present results in both an academic and
commercial context. This repository will continue to become more sophisticated, but for now relies heavily upon the paper submitted for publishing
entitled "An open-source Monte Carlo ray-trace simulation tool for luminescent solar concentrators with validation studies employing scattering phosphor films".
Install the [lsclib package](https://pypi.org/project/lsclib/) to get started!

While lsclib is growing and improving, the visitor to this repository is also encouraged to visit [pvtrace](https://github.com/danieljfarrell/pvtrace). 
lsclib has many advantages, but pvtrace is quite extensive and may be a better fit for certain applications.