/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

public class CSVReaderBuilder {
    private final CSVParserBuilder parserBuilder = new CSVParserBuilder();
    private final Reader reader;
    private int skipLines = 0;
    private ICSVParser icsvParser = null;
    private boolean keepCR;
    private boolean verifyReader = true;
    private CSVReaderNullFieldIndicator nullFieldIndicator = CSVReaderNullFieldIndicator.NEITHER;
    private int multilineLimit = 0;
    private Locale errorLocale = Locale.getDefault();

    public CSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle("opencsv").getString("reader.null"));
        }
        this.reader = reader;
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected int getSkipLines() {
        return this.skipLines;
    }

    protected ICSVParser getCsvParser() {
        return this.icsvParser;
    }

    protected int getMultilineLimit() {
        return this.multilineLimit;
    }

    public CSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    public CSVReaderBuilder withCSVParser(ICSVParser icsvParser) {
        this.icsvParser = icsvParser;
        return this;
    }

    public CSVReader build() {
        ICSVParser parser = ObjectUtils.defaultIfNull(this.icsvParser, this.parserBuilder.withFieldAsNull(this.nullFieldIndicator).withErrorLocale(this.errorLocale).build());
        return new CSVReader(this.reader, this.skipLines, parser, this.keepCR, this.verifyReader, this.multilineLimit, this.errorLocale);
    }

    public CSVReaderBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    protected boolean keepCarriageReturn() {
        return this.keepCR;
    }

    public CSVReaderBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public CSVReaderBuilder withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }

    public CSVReaderBuilder withMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
        return this;
    }

    public CSVReaderBuilder withErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        return this;
    }
}

