/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.models;

import ai.h2o.sparkling.ml.internals.H2OMetric;
import ai.h2o.sparkling.ml.internals.H2OModelCategory$;
import ai.h2o.sparkling.ml.models.H2OMOJOModelUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.attributes.ModelJsonReader;
import java.io.File;
import java.util.Map;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class H2OMOJOModelUtils$class {
    public static JsonElement ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$removeMetaField(H2OMOJOModelUtils $this, JsonElement json) {
        if (json.isJsonObject()) {
            json.getAsJsonObject().remove("__meta");
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(json.getAsJsonObject().entrySet()).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ H2OMOJOModelUtils $outer;

                public final JsonElement apply(Map.Entry<String, JsonElement> entry) {
                    return H2OMOJOModelUtils$class.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$removeMetaField(this.$outer, entry.getValue());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (json.isJsonArray()) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)json.getAsJsonArray()).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ H2OMOJOModelUtils $outer;

                public final JsonElement apply(JsonElement json) {
                    return H2OMOJOModelUtils$class.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$removeMetaField(this.$outer, json);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return json;
    }

    public static JsonObject getModelJson(H2OMOJOModelUtils $this, File mojo) {
        MojoReaderBackend reader = MojoReaderBackendFactory.createReaderBackend(mojo.getAbsolutePath());
        return ModelJsonReader.parseModelJson(reader);
    }

    public static String getModelDetails(H2OMOJOModelUtils $this, JsonObject modelJson) {
        String string;
        JsonObject json = modelJson.get("output").getAsJsonObject();
        if (json == null) {
            string = "Model details not available!";
        } else {
            String prettyJson;
            H2OMOJOModelUtils$class.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$removeMetaField($this, json);
            json.remove("domains");
            json.remove("help");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            string = prettyJson = gson.toJson(json);
        }
        return string;
    }

    public static Map extractMetrics(H2OMOJOModelUtils $this, JsonObject json, String metricType) {
        Map map;
        if (json.get(metricType).isJsonNull()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            JsonObject metricGroup = json.getAsJsonObject(metricType);
            Set fields = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(metricGroup.entrySet()).asScala()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Map.Entry<String, JsonElement> x$2) {
                    return x$2.getKey();
                }
            }, Set$.MODULE$.canBuildFrom());
            Tuple2[] metrics = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])H2OMetric.values()).flatMap((Function1)new Serializable($this, metricGroup, fields){
                public static final long serialVersionUID = 0L;
                private final JsonObject metricGroup$1;
                private final Set fields$1;

                public final Iterable<Tuple2<H2OMetric, Object>> apply(H2OMetric metric) {
                    String metricName = metric.toString();
                    Option fieldName = this.fields$1.find((Function1)new Serializable(this, metricName){
                        public static final long serialVersionUID = 0L;
                        private final String metricName$1;

                        public final boolean apply(String field) {
                            return field.replaceAll("_", "").equalsIgnoreCase(this.metricName$1);
                        }
                        {
                            this.metricName$1 = metricName$1;
                        }
                    });
                    return fieldName.isDefined() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)metric)), (Object)BoxesRunTime.boxToDouble((double)this.metricGroup$1.get((String)fieldName.get()).getAsDouble())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                {
                    this.metricGroup$1 = metricGroup$1;
                    this.fields$1 = fields$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])metrics).sorted((Ordering)$this.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$H2OMetricOrdering())).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(Tuple2<H2OMetric, Object> pair) {
                    return new Tuple2((Object)((Enum)pair._1()).name(), (Object)BoxesRunTime.boxToDouble((double)pair._2$mcD$sp()));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public static Tuple3 extractAllMetrics(H2OMOJOModelUtils $this, JsonObject modelJson) {
        JsonObject json = modelJson.get("output").getAsJsonObject();
        Map<String, Object> trainingMetrics = $this.extractMetrics(json, "training_metrics");
        Map<String, Object> validationMetrics = $this.extractMetrics(json, "validation_metrics");
        Map<String, Object> crossValidationMetrics = $this.extractMetrics(json, "cross_validation_metrics");
        return new Tuple3(trainingMetrics, validationMetrics, crossValidationMetrics);
    }

    public static Map extractParams(H2OMOJOModelUtils $this, JsonObject modelJson) {
        JsonElement[] parameters = (JsonElement[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)modelJson.get("parameters").getAsJsonArray()).asScala()).toArray(ClassTag$.MODULE$.apply(JsonElement.class));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])parameters).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2OMOJOModelUtils $outer;

            public final Iterable<Tuple2<String, String>> apply(JsonElement param) {
                String name = param.getAsJsonObject().get("name").getAsString();
                JsonElement value = param.getAsJsonObject().get("actual_value");
                Option stringValue = H2OMOJOModelUtils$class.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$stringifyJSON(this.$outer, value);
                return Option$.MODULE$.option2Iterable(stringValue.map((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Tuple2<String, String> apply(String x$3) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.name$1), (Object)x$3);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).toMap(Predef$.MODULE$.$conforms());
    }

    public static Enumeration.Value extractModelCategory(H2OMOJOModelUtils $this, JsonObject modelJson) {
        JsonObject json = modelJson.get("output").getAsJsonObject();
        return H2OModelCategory$.MODULE$.fromString(json.get("model_category").getAsString());
    }

    public static Map extractFeatureTypes(H2OMOJOModelUtils $this, JsonObject modelJson) {
        Map map;
        JsonObject output = modelJson.get("output").getAsJsonObject();
        Iterable names = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)output.getAsJsonArray("names")).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(JsonElement x$4) {
                return x$4.getAsString();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        JsonArray columnTypesJsonArray = output.getAsJsonArray("column_types");
        if (columnTypesJsonArray == null) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Iterable types = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)columnTypesJsonArray).asScala()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(JsonElement x$5) {
                    return x$5.getAsString();
                }
            }, Iterable$.MODULE$.canBuildFrom());
            map = ((TraversableOnce)names.zip((GenIterable)types, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public static Option ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$stringifyJSON(H2OMOJOModelUtils $this, JsonElement value) {
        JsonElement jsonElement;
        block5: {
            None$ none$;
            block4: {
                while (true) {
                    if ((jsonElement = value) instanceof JsonPrimitive) {
                        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                        none$ = new Some((Object)jsonPrimitive.getAsString());
                        break block4;
                    }
                    if (jsonElement instanceof JsonArray) {
                        JsonArray jsonArray = (JsonArray)jsonElement;
                        Iterable stringElements = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)jsonArray).asScala()).flatMap((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ H2OMOJOModelUtils $outer;

                            public final Iterable<String> apply(JsonElement value) {
                                return Option$.MODULE$.option2Iterable(H2OMOJOModelUtils$class.ai$h2o$sparkling$ml$models$H2OMOJOModelUtils$$stringifyJSON(this.$outer, value));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                        String arrayAsString = stringElements.mkString("[", ", ", "]");
                        none$ = new Some((Object)arrayAsString);
                        break block4;
                    }
                    if (jsonElement instanceof JsonNull) {
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    if (!(jsonElement instanceof JsonObject)) break block5;
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("name")) break;
                    value = jsonObject.get("name");
                }
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)jsonElement);
    }

    public static void $init$(H2OMOJOModelUtils $this) {
    }
}

