# Generated by Django 3.1.7 on 2021-03-08 01:37

import uuid

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.conf import settings
from django.db import migrations, models

from .. import settings as app_settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.CONFIG_CONFIG_MODEL),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        migrations.swappable_dependency(settings.OPENWISP_IPAM_SUBNET_MODEL),
        migrations.swappable_dependency(settings.OPENWISP_IPAM_IPADDRESS_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SubnetDivisionRule',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'type',
                    models.CharField(
                        choices=app_settings.SUBNET_DIVISION_TYPES, max_length=200
                    ),
                ),
                (
                    'master_subnet',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.OPENWISP_IPAM_SUBNET_MODEL,
                    ),
                ),
                (
                    'label',
                    models.CharField(
                        help_text='Label used to calculate the configuration variables',
                        max_length=30,
                    ),
                ),
                (
                    'number_of_subnets',
                    models.PositiveIntegerField(
                        help_text='Indicates how many subnets will be created',
                        verbose_name='Number of Subnets',
                    ),
                ),
                (
                    'size',
                    models.PositiveIntegerField(
                        help_text='Indicates the size of each created subnet',
                        verbose_name='Size of subnets',
                    ),
                ),
                (
                    'number_of_ips',
                    models.PositiveIntegerField(
                        help_text=(
                            'Indicates how many IP addresses will '
                            'be created for each subnet'
                        ),
                        verbose_name='Number of IPs',
                    ),
                ),
                (
                    'organization',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='openwisp_users.organization',
                        verbose_name='organization',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': 'SUBNET_DIVISION_SUBNETDIVISIONRULE_MODEL',
            },
        ),
        migrations.CreateModel(
            name='SubnetDivisionIndex',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('keyword', models.CharField(max_length=30)),
                (
                    'config',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.CONFIG_CONFIG_MODEL,
                    ),
                ),
                (
                    'ip',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.OPENWISP_IPAM_IPADDRESS_MODEL,
                    ),
                ),
                (
                    'rule',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.SUBNET_DIVISION_SUBNETDIVISIONRULE_MODEL,
                    ),
                ),
                (
                    'subnet',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.OPENWISP_IPAM_SUBNET_MODEL,
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': 'SUBNET_DIVISION_SUBNETDIVISIONINDEX_MODEL',
            },
        ),
        migrations.AddConstraint(
            model_name='subnetdivisionrule',
            constraint=models.UniqueConstraint(
                fields=('organization', 'label'),
                name='unique_subnet_division_rule_label',
            ),
        ),
        migrations.AddConstraint(
            model_name='subnetdivisionrule',
            constraint=models.UniqueConstraint(
                fields=('organization', 'label', 'type', 'master_subnet'),
                name='unique_subnet_division_rule',
            ),
        ),
        migrations.AddIndex(
            model_name='subnetdivisionindex',
            index=models.Index(
                fields=['keyword'], name='subnet_divi_keyword_c76db3_idx'
            ),
        ),
        migrations.AddConstraint(
            model_name='subnetdivisionindex',
            constraint=models.UniqueConstraint(
                fields=('keyword', 'subnet', 'ip', 'config'),
                name='unique_subnet_division_index',
            ),
        ),
    ]
