# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ViewDetailsDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'view_id': 'int',
        'access': 'AccessDTO',
        'view': 'ViewDTO',
        'filter': 'FilterDTO',
        'actions': 'list[ActionDTO]'
    }

    attribute_map = {
        'view_id': 'viewId',
        'access': 'access',
        'view': 'view',
        'filter': 'filter',
        'actions': 'actions'
    }

    def __init__(self, view_id=None, access=None, view=None, filter=None, actions=None):  # noqa: E501
        """ViewDetailsDTO - a model defined in Swagger"""  # noqa: E501
        self._view_id = None
        self._access = None
        self._view = None
        self._filter = None
        self._actions = None
        self.discriminator = None
        if view_id is not None:
            self.view_id = view_id
        if access is not None:
            self.access = access
        if view is not None:
            self.view = view
        if filter is not None:
            self.filter = filter
        if actions is not None:
            self.actions = actions

    @property
    def view_id(self):
        """Gets the view_id of this ViewDetailsDTO.  # noqa: E501


        :return: The view_id of this ViewDetailsDTO.  # noqa: E501
        :rtype: int
        """
        return self._view_id

    @view_id.setter
    def view_id(self, view_id):
        """Sets the view_id of this ViewDetailsDTO.


        :param view_id: The view_id of this ViewDetailsDTO.  # noqa: E501
        :type: int
        """

        self._view_id = view_id

    @property
    def access(self):
        """Gets the access of this ViewDetailsDTO.  # noqa: E501


        :return: The access of this ViewDetailsDTO.  # noqa: E501
        :rtype: AccessDTO
        """
        return self._access

    @access.setter
    def access(self, access):
        """Sets the access of this ViewDetailsDTO.


        :param access: The access of this ViewDetailsDTO.  # noqa: E501
        :type: AccessDTO
        """

        self._access = access

    @property
    def view(self):
        """Gets the view of this ViewDetailsDTO.  # noqa: E501


        :return: The view of this ViewDetailsDTO.  # noqa: E501
        :rtype: ViewDTO
        """
        return self._view

    @view.setter
    def view(self, view):
        """Sets the view of this ViewDetailsDTO.


        :param view: The view of this ViewDetailsDTO.  # noqa: E501
        :type: ViewDTO
        """

        self._view = view

    @property
    def filter(self):
        """Gets the filter of this ViewDetailsDTO.  # noqa: E501


        :return: The filter of this ViewDetailsDTO.  # noqa: E501
        :rtype: FilterDTO
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this ViewDetailsDTO.


        :param filter: The filter of this ViewDetailsDTO.  # noqa: E501
        :type: FilterDTO
        """

        self._filter = filter

    @property
    def actions(self):
        """Gets the actions of this ViewDetailsDTO.  # noqa: E501


        :return: The actions of this ViewDetailsDTO.  # noqa: E501
        :rtype: list[ActionDTO]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this ViewDetailsDTO.


        :param actions: The actions of this ViewDetailsDTO.  # noqa: E501
        :type: list[ActionDTO]
        """

        self._actions = actions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ViewDetailsDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ViewDetailsDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
