# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProviderInvoiceDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'total_gross': 'float',
        'total_netto': 'float',
        'currency_id': 'int',
        'status': 'str',
        'final_number': 'str',
        'draft_number': 'str',
        'internal_number': 'str',
        'provider_id': 'int',
        'total_gross_in_words': 'str',
        'jobs_net_value': 'float',
        'payment_status': 'str',
        'dates': 'ProviderInvoiceDatesDTO',
        'notes_from_provider': 'str'
    }

    attribute_map = {
        'id': 'id',
        'total_gross': 'totalGross',
        'total_netto': 'totalNetto',
        'currency_id': 'currencyId',
        'status': 'status',
        'final_number': 'finalNumber',
        'draft_number': 'draftNumber',
        'internal_number': 'internalNumber',
        'provider_id': 'providerId',
        'total_gross_in_words': 'totalGrossInWords',
        'jobs_net_value': 'jobsNetValue',
        'payment_status': 'paymentStatus',
        'dates': 'dates',
        'notes_from_provider': 'notesFromProvider'
    }

    def __init__(self, id=None, total_gross=None, total_netto=None, currency_id=None, status=None, final_number=None, draft_number=None, internal_number=None, provider_id=None, total_gross_in_words=None, jobs_net_value=None, payment_status=None, dates=None, notes_from_provider=None):  # noqa: E501
        """ProviderInvoiceDTO - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._total_gross = None
        self._total_netto = None
        self._currency_id = None
        self._status = None
        self._final_number = None
        self._draft_number = None
        self._internal_number = None
        self._provider_id = None
        self._total_gross_in_words = None
        self._jobs_net_value = None
        self._payment_status = None
        self._dates = None
        self._notes_from_provider = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if total_gross is not None:
            self.total_gross = total_gross
        if total_netto is not None:
            self.total_netto = total_netto
        if currency_id is not None:
            self.currency_id = currency_id
        if status is not None:
            self.status = status
        if final_number is not None:
            self.final_number = final_number
        if draft_number is not None:
            self.draft_number = draft_number
        if internal_number is not None:
            self.internal_number = internal_number
        if provider_id is not None:
            self.provider_id = provider_id
        if total_gross_in_words is not None:
            self.total_gross_in_words = total_gross_in_words
        if jobs_net_value is not None:
            self.jobs_net_value = jobs_net_value
        if payment_status is not None:
            self.payment_status = payment_status
        if dates is not None:
            self.dates = dates
        if notes_from_provider is not None:
            self.notes_from_provider = notes_from_provider

    @property
    def id(self):
        """Gets the id of this ProviderInvoiceDTO.  # noqa: E501


        :return: The id of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProviderInvoiceDTO.


        :param id: The id of this ProviderInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def total_gross(self):
        """Gets the total_gross of this ProviderInvoiceDTO.  # noqa: E501


        :return: The total_gross of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: float
        """
        return self._total_gross

    @total_gross.setter
    def total_gross(self, total_gross):
        """Sets the total_gross of this ProviderInvoiceDTO.


        :param total_gross: The total_gross of this ProviderInvoiceDTO.  # noqa: E501
        :type: float
        """

        self._total_gross = total_gross

    @property
    def total_netto(self):
        """Gets the total_netto of this ProviderInvoiceDTO.  # noqa: E501


        :return: The total_netto of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: float
        """
        return self._total_netto

    @total_netto.setter
    def total_netto(self, total_netto):
        """Sets the total_netto of this ProviderInvoiceDTO.


        :param total_netto: The total_netto of this ProviderInvoiceDTO.  # noqa: E501
        :type: float
        """

        self._total_netto = total_netto

    @property
    def currency_id(self):
        """Gets the currency_id of this ProviderInvoiceDTO.  # noqa: E501


        :return: The currency_id of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._currency_id

    @currency_id.setter
    def currency_id(self, currency_id):
        """Sets the currency_id of this ProviderInvoiceDTO.


        :param currency_id: The currency_id of this ProviderInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._currency_id = currency_id

    @property
    def status(self):
        """Gets the status of this ProviderInvoiceDTO.  # noqa: E501


        :return: The status of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ProviderInvoiceDTO.


        :param status: The status of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["POSTPONED", "TO_BE_SENT", "SENT", "CONFIRMED", "BILL_CREATED"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def final_number(self):
        """Gets the final_number of this ProviderInvoiceDTO.  # noqa: E501


        :return: The final_number of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._final_number

    @final_number.setter
    def final_number(self, final_number):
        """Sets the final_number of this ProviderInvoiceDTO.


        :param final_number: The final_number of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._final_number = final_number

    @property
    def draft_number(self):
        """Gets the draft_number of this ProviderInvoiceDTO.  # noqa: E501


        :return: The draft_number of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._draft_number

    @draft_number.setter
    def draft_number(self, draft_number):
        """Sets the draft_number of this ProviderInvoiceDTO.


        :param draft_number: The draft_number of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._draft_number = draft_number

    @property
    def internal_number(self):
        """Gets the internal_number of this ProviderInvoiceDTO.  # noqa: E501


        :return: The internal_number of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._internal_number

    @internal_number.setter
    def internal_number(self, internal_number):
        """Sets the internal_number of this ProviderInvoiceDTO.


        :param internal_number: The internal_number of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._internal_number = internal_number

    @property
    def provider_id(self):
        """Gets the provider_id of this ProviderInvoiceDTO.  # noqa: E501


        :return: The provider_id of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: int
        """
        return self._provider_id

    @provider_id.setter
    def provider_id(self, provider_id):
        """Sets the provider_id of this ProviderInvoiceDTO.


        :param provider_id: The provider_id of this ProviderInvoiceDTO.  # noqa: E501
        :type: int
        """

        self._provider_id = provider_id

    @property
    def total_gross_in_words(self):
        """Gets the total_gross_in_words of this ProviderInvoiceDTO.  # noqa: E501


        :return: The total_gross_in_words of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._total_gross_in_words

    @total_gross_in_words.setter
    def total_gross_in_words(self, total_gross_in_words):
        """Sets the total_gross_in_words of this ProviderInvoiceDTO.


        :param total_gross_in_words: The total_gross_in_words of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._total_gross_in_words = total_gross_in_words

    @property
    def jobs_net_value(self):
        """Gets the jobs_net_value of this ProviderInvoiceDTO.  # noqa: E501


        :return: The jobs_net_value of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: float
        """
        return self._jobs_net_value

    @jobs_net_value.setter
    def jobs_net_value(self, jobs_net_value):
        """Sets the jobs_net_value of this ProviderInvoiceDTO.


        :param jobs_net_value: The jobs_net_value of this ProviderInvoiceDTO.  # noqa: E501
        :type: float
        """

        self._jobs_net_value = jobs_net_value

    @property
    def payment_status(self):
        """Gets the payment_status of this ProviderInvoiceDTO.  # noqa: E501


        :return: The payment_status of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._payment_status

    @payment_status.setter
    def payment_status(self, payment_status):
        """Sets the payment_status of this ProviderInvoiceDTO.


        :param payment_status: The payment_status of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """
        allowed_values = ["NOT_PAID", "FULLY_PAID", "IRRECOVERABLE", "PARTIALLY_PAID"]  # noqa: E501
        if payment_status not in allowed_values:
            raise ValueError(
                "Invalid value for `payment_status` ({0}), must be one of {1}"  # noqa: E501
                .format(payment_status, allowed_values)
            )

        self._payment_status = payment_status

    @property
    def dates(self):
        """Gets the dates of this ProviderInvoiceDTO.  # noqa: E501


        :return: The dates of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: ProviderInvoiceDatesDTO
        """
        return self._dates

    @dates.setter
    def dates(self, dates):
        """Sets the dates of this ProviderInvoiceDTO.


        :param dates: The dates of this ProviderInvoiceDTO.  # noqa: E501
        :type: ProviderInvoiceDatesDTO
        """

        self._dates = dates

    @property
    def notes_from_provider(self):
        """Gets the notes_from_provider of this ProviderInvoiceDTO.  # noqa: E501


        :return: The notes_from_provider of this ProviderInvoiceDTO.  # noqa: E501
        :rtype: str
        """
        return self._notes_from_provider

    @notes_from_provider.setter
    def notes_from_provider(self, notes_from_provider):
        """Sets the notes_from_provider of this ProviderInvoiceDTO.


        :param notes_from_provider: The notes_from_provider of this ProviderInvoiceDTO.  # noqa: E501
        :type: str
        """

        self._notes_from_provider = notes_from_provider

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProviderInvoiceDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderInvoiceDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
