# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PaymentDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'payment_date': 'TimeDTO',
        'payment_method_id': 'int',
        'notes': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'payment_date': 'paymentDate',
        'payment_method_id': 'paymentMethodId',
        'notes': 'notes'
    }

    def __init__(self, amount=None, payment_date=None, payment_method_id=None, notes=None):  # noqa: E501
        """PaymentDTO - a model defined in Swagger"""  # noqa: E501
        self._amount = None
        self._payment_date = None
        self._payment_method_id = None
        self._notes = None
        self.discriminator = None
        if amount is not None:
            self.amount = amount
        if payment_date is not None:
            self.payment_date = payment_date
        if payment_method_id is not None:
            self.payment_method_id = payment_method_id
        if notes is not None:
            self.notes = notes

    @property
    def amount(self):
        """Gets the amount of this PaymentDTO.  # noqa: E501


        :return: The amount of this PaymentDTO.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PaymentDTO.


        :param amount: The amount of this PaymentDTO.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def payment_date(self):
        """Gets the payment_date of this PaymentDTO.  # noqa: E501


        :return: The payment_date of this PaymentDTO.  # noqa: E501
        :rtype: TimeDTO
        """
        return self._payment_date

    @payment_date.setter
    def payment_date(self, payment_date):
        """Sets the payment_date of this PaymentDTO.


        :param payment_date: The payment_date of this PaymentDTO.  # noqa: E501
        :type: TimeDTO
        """

        self._payment_date = payment_date

    @property
    def payment_method_id(self):
        """Gets the payment_method_id of this PaymentDTO.  # noqa: E501


        :return: The payment_method_id of this PaymentDTO.  # noqa: E501
        :rtype: int
        """
        return self._payment_method_id

    @payment_method_id.setter
    def payment_method_id(self, payment_method_id):
        """Sets the payment_method_id of this PaymentDTO.


        :param payment_method_id: The payment_method_id of this PaymentDTO.  # noqa: E501
        :type: int
        """

        self._payment_method_id = payment_method_id

    @property
    def notes(self):
        """Gets the notes of this PaymentDTO.  # noqa: E501


        :return: The notes of this PaymentDTO.  # noqa: E501
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """Sets the notes of this PaymentDTO.


        :param notes: The notes of this PaymentDTO.  # noqa: E501
        :type: str
        """

        self._notes = notes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PaymentDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
