# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AddressDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'same_as_billing_address': 'bool',
        'address_line1': 'str',
        'address_line2': 'str',
        'city': 'str',
        'postal_code': 'str',
        'province_id': 'int',
        'country_id': 'int'
    }

    attribute_map = {
        'same_as_billing_address': 'sameAsBillingAddress',
        'address_line1': 'addressLine1',
        'address_line2': 'addressLine2',
        'city': 'city',
        'postal_code': 'postalCode',
        'province_id': 'provinceId',
        'country_id': 'countryId'
    }

    def __init__(self, same_as_billing_address=None, address_line1=None, address_line2=None, city=None, postal_code=None, province_id=None, country_id=None):  # noqa: E501
        """AddressDTO - a model defined in Swagger"""  # noqa: E501
        self._same_as_billing_address = None
        self._address_line1 = None
        self._address_line2 = None
        self._city = None
        self._postal_code = None
        self._province_id = None
        self._country_id = None
        self.discriminator = None
        if same_as_billing_address is not None:
            self.same_as_billing_address = same_as_billing_address
        if address_line1 is not None:
            self.address_line1 = address_line1
        if address_line2 is not None:
            self.address_line2 = address_line2
        if city is not None:
            self.city = city
        if postal_code is not None:
            self.postal_code = postal_code
        if province_id is not None:
            self.province_id = province_id
        if country_id is not None:
            self.country_id = country_id

    @property
    def same_as_billing_address(self):
        """Gets the same_as_billing_address of this AddressDTO.  # noqa: E501

        should billing address be used instead of this one  # noqa: E501

        :return: The same_as_billing_address of this AddressDTO.  # noqa: E501
        :rtype: bool
        """
        return self._same_as_billing_address

    @same_as_billing_address.setter
    def same_as_billing_address(self, same_as_billing_address):
        """Sets the same_as_billing_address of this AddressDTO.

        should billing address be used instead of this one  # noqa: E501

        :param same_as_billing_address: The same_as_billing_address of this AddressDTO.  # noqa: E501
        :type: bool
        """

        self._same_as_billing_address = same_as_billing_address

    @property
    def address_line1(self):
        """Gets the address_line1 of this AddressDTO.  # noqa: E501

        first line of address  # noqa: E501

        :return: The address_line1 of this AddressDTO.  # noqa: E501
        :rtype: str
        """
        return self._address_line1

    @address_line1.setter
    def address_line1(self, address_line1):
        """Sets the address_line1 of this AddressDTO.

        first line of address  # noqa: E501

        :param address_line1: The address_line1 of this AddressDTO.  # noqa: E501
        :type: str
        """

        self._address_line1 = address_line1

    @property
    def address_line2(self):
        """Gets the address_line2 of this AddressDTO.  # noqa: E501

        second line of address  # noqa: E501

        :return: The address_line2 of this AddressDTO.  # noqa: E501
        :rtype: str
        """
        return self._address_line2

    @address_line2.setter
    def address_line2(self, address_line2):
        """Sets the address_line2 of this AddressDTO.

        second line of address  # noqa: E501

        :param address_line2: The address_line2 of this AddressDTO.  # noqa: E501
        :type: str
        """

        self._address_line2 = address_line2

    @property
    def city(self):
        """Gets the city of this AddressDTO.  # noqa: E501

        city  # noqa: E501

        :return: The city of this AddressDTO.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this AddressDTO.

        city  # noqa: E501

        :param city: The city of this AddressDTO.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def postal_code(self):
        """Gets the postal_code of this AddressDTO.  # noqa: E501

        postal code  # noqa: E501

        :return: The postal_code of this AddressDTO.  # noqa: E501
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code):
        """Sets the postal_code of this AddressDTO.

        postal code  # noqa: E501

        :param postal_code: The postal_code of this AddressDTO.  # noqa: E501
        :type: str
        """

        self._postal_code = postal_code

    @property
    def province_id(self):
        """Gets the province_id of this AddressDTO.  # noqa: E501

        province  # noqa: E501

        :return: The province_id of this AddressDTO.  # noqa: E501
        :rtype: int
        """
        return self._province_id

    @province_id.setter
    def province_id(self, province_id):
        """Sets the province_id of this AddressDTO.

        province  # noqa: E501

        :param province_id: The province_id of this AddressDTO.  # noqa: E501
        :type: int
        """

        self._province_id = province_id

    @property
    def country_id(self):
        """Gets the country_id of this AddressDTO.  # noqa: E501

        country  # noqa: E501

        :return: The country_id of this AddressDTO.  # noqa: E501
        :rtype: int
        """
        return self._country_id

    @country_id.setter
    def country_id(self, country_id):
        """Sets the country_id of this AddressDTO.

        country  # noqa: E501

        :param country_id: The country_id of this AddressDTO.  # noqa: E501
        :type: int
        """

        self._country_id = country_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AddressDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddressDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
