var api_spec = {
  "swagger": "2.0",
  "host": "api.indra.bio:8000",
  "schemes": [
    "http"
  ],
  "info": {
    "description": "REST API for INDRA webservice",
    "version": "1.0.0",
    "title": "INDRA REST-API",
    "contact": {
      "email": "benjamin_gyori@hms.harvard.edu"
    },
    "license": {
      "name": "Simplified BSD License",
      "url": "https://github.com/sorgerlab/indra/blob/master/LICENSE"
    }
  },
  "tags": [
    {
      "name": "developers",
      "description": "Operations available to regular developers"
    }
  ],
  "paths": {
    "/cwms/process_text": {
      "post": {
        "tags": [
          "CWMS"
        ],
        "summary": "Read text using CWMS and get INDRA statements.",
        "operationId": "readCWMS",
        "description": "Read text using CWMS and return an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "textObjWM",
            "description": "An object with a key of \"text\" referencing a string of text to be processed by CWMS.",
            "schema": {
              "$ref": "#/definitions/textObjWM"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "text processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/sofia/process_text": {
      "post": {
        "tags": [
          "Sofia"
        ],
        "summary": "Read text using Sofia and get INDRA statements.",
        "operationId": "readSofia",
        "description": "Read text using Sofia and return an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "textAuthObj",
            "description": "An object with a key of \"text\" referencing a string of text to be processed by Sofia, and \"auth\" a list with the user name and password needed to access the service.",
            "schema": {
              "$ref": "#/definitions/textAuthObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "text processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/eidos/process_jsonld": {
      "post": {
        "tags": [
          "Eidos"
        ],
        "summary": "Process a JSON-LD string generated by Eidos and get statements back.",
        "operationId": "jsonEidos",
        "description": "Process a JSON-LD string generated by Eidos and get an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "jsonld",
            "description": "An object with a key of \"json\" referenced a stringified JSON from Eidos that will be turned into INDRA statements.",
            "schema": {
              "$ref": "#/definitions/eidosJsonObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "JSON processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/hume/process_jsonld": {
      "post": {
        "tags": [
          "Hume"
        ],
        "summary": "Process a JSON-LD string generated by Hume and get statements back.",
        "operationId": "jsonHume",
        "description": "Process a JSON-LD string generated by Hume and get an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "jsonld",
            "description": "An object with a key of \"json\" referenced a stringified JSON from Hume that will be turned into INDRA statements.",
            "schema": {
              "$ref": "#/definitions/eidosJsonObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "JSON processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/reach/process_text": {
      "post": {
        "tags": [
          "REACH"
        ],
        "summary": "Read text using REACH and get INDRA statements.",
        "operationId": "readREACH",
        "description": "Read text using REACH and return an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "textUrlObj",
            "description": "An object with keys of \"text\", referencing a string of text to be processed by REACH, and \"url\", referencing a url of REACH API to send request to.",
            "schema": {
              "$ref": "#/definitions/textUrlObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "text processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/reach/process_json": {
      "post": {
        "tags": [
          "REACH"
        ],
        "summary": "Process a JSON string generated by REACH and get statements back.",
        "operationId": "jsonREACH",
        "description": "Process a JSON string generated by REACH and get an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "json",
            "description": "An object with a key of \"json\" referenced a stringified JSON from REACH that will be turned into INDRA statements.",
            "schema": {
              "$ref": "#/definitions/reachJsonObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "JSON processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/reach/process_pmc": {
      "post": {
        "tags": [
          "REACH"
        ],
        "summary": "Process PubMedCentral article and return INDRA Statements.",
        "operationId": "processPMC",
        "description": "Process PubMedCentral article and return an object with a key of \"statements\" referencing a list of INDRA statements. Note that this will most likely timeout in SwaggerUI, but you can verify that it works by running the curl command provided in your terminal.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "pmcIDUrl",
            "description": "An object with keys of \"pmcid\", referencing a string that contains the PMCID of the publication, and \"url\", referencing a url of REACH API to send request to.",
            "schema": {
              "$ref": "#/definitions/pmcIDUrl"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "PMCID processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/trips/process_text": {
      "post": {
        "tags": [
          "TRIPS"
        ],
        "summary": "Read text using TRIPS and get statements back.",
        "operationId": "readTRIPS",
        "description": "Read text using TRIPS and return an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "textObj",
            "description": "An object with a key of \"text\" referencing a string of text.",
            "schema": {
              "$ref": "#/definitions/textObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Text processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/trips/process_xml": {
      "post": {
        "tags": [
          "TRIPS"
        ],
        "summary": "Process an XML string generated by TRIPS and get statements.",
        "operationId": "xmlTRIPS",
        "description": "Process an XML string generated by TRIPS and return an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "tripsXmlObj",
            "description": "An object with a key of \"xml_str\" referencing a stringified XML from TRIPS that will be turned into INDRA statements.",
            "schema": {
              "$ref": "#/definitions/tripsXmlObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "text processed. JSON INDRA statements returned.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/bel/process_pybel_neighborhood": {
      "post": {
        "tags": [
          "BEL"
        ],
        "summary": "Process BEL Large Corpus neighborhood and return INDRA Statements.",
        "operationId": "pybelNeighborhood",
        "description": "Takes in a list of genes and returns an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "genesObj",
            "description": "An object with a key of \"genes\" referencing a list of HGNC names as separate strings.",
            "schema": {
              "$ref": "#/definitions/genesObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "BEL neighborhood extracted from Large Corpus via PyBEL.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/bel/process_belrdf": {
      "post": {
        "tags": [
          "BEL"
        ],
        "summary": "Process BEL RDF and return INDRA Statements.",
        "operationId": "belRdf",
        "description": "Takes in a BEL RDF as string, returns an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "belRdfObj",
            "description": "An object with a key of \"belrdf\" referencing a stringified BEL RDF. Examples of the string are quite long to reasonably display here. A representative file can be found at https://github.com/sorgerlab/indra/blob/master/data/mapk.rdf",
            "schema": {
              "$ref": "#/definitions/belRdfObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "BEL neighborhood extracted from Large Corpus via PyBEL.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/biopax/process_pc_pathsbetween": {
      "post": {
        "tags": [
          "BioPAX"
        ],
        "summary": "Process PathwayCommons paths between genes, return INDRA Statements.",
        "operationId": "pcPathsBetween",
        "description": "Takes in a list of genes and returns an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "genesObj",
            "description": "An object with a key of \"genes\" referencing a list of HGNC names as separate strings.",
            "schema": {
              "$ref": "#/definitions/genesObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "PathwayCommons paths between genes processed.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/biopax/process_pc_pathsfromto": {
      "post": {
        "tags": [
          "BioPAX"
        ],
        "summary": "Process PathwayCommons paths between genes, return INDRA Statements.",
        "operationId": "pcPathsFromTo",
        "description": "Takes in an object with keys \"source\" and \"target\", each of which reference a list of genes. Returns an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "genesSourceTargetObj",
            "description": "an object with keys \"source\" and \"target\", each of which reference a list of genes",
            "schema": {
              "$ref": "#/definitions/genesSourceTargetObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Process PathwayCommons paths from-to genes processed.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/biopax/process_pc_neighborhood": {
      "post": {
        "tags": [
          "BioPAX"
        ],
        "summary": "Process PathwayCommons neighborhood, return INDRA Statements.",
        "operationId": "pcProcessNeighborhood",
        "description": "Takes in a list of genes and returns an object with a key of \"statements\" referencing a list of INDRA statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "genesObj",
            "description": "An object with a key of \"genes\" referencing a list of HGNC names as separate strings.",
            "schema": {
              "$ref": "#/definitions/genesObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "PathwayCommons paths between genes processed.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/map_grounding": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Ground INDRA statments.",
        "operationId": "groundStatments",
        "description": "Takes in INDRA statements and returns grounded statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "statments grounded.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/map_sequence": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Map sequence on a list of INDRA Statements.",
        "operationId": "mapSequence",
        "description": "Takes in a list of INDRA statements and map sequence on the list.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Sequence mapped.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/run_preassembly": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Run preassembly on a list of INDRA Statements.",
        "operationId": "runPreassembly",
        "description": "Takes in a list of INDRA statements and runs preassembly.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "preassemblyObj",
            "description": "object with a key of \"statements\" referencing " +
                "a list of INDRA statements, \"scorer\" specifying a scorer, and \"return_toplevel\" " +
                "to determine whether only top level statements should be returned.",
            "schema": {
              "$ref": "#/definitions/preassemblyObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Preassembly complete.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/filter_by_type": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Filter to a given INDRA Statement type.",
        "operationId": "filterByType",
        "description": "Takes in a list of INDRA statements and returns a list of statements filtered to the specified type.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObjFilterType",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObjFilterType"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Statements filtered.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/filter_grounded_only": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Filter to grounded Statements only.",
        "operationId": "filterGroundedOnly",
        "description": "Takes in a list of INDRA statements and returns a list of only those that are grounded.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "groundingFilterObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements, " +
                "and an optional \"score_threshold\" for filtering scored grounding."
            ,
            "schema": {
              "$ref": "#/definitions/groundingFilterObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Statements filtered to grounded statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/filter_belief": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Filter to Statements with belief above a given threshold.",
        "operationId": "filterBelief",
        "description": "Takes in a list of INDRA statements and returns a list of only those that have belief above the threshold.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "beliefFilterObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements, " +
                "and a \"belief_cutoff\" for filtering based on belief."
            ,
            "schema": {
              "$ref": "#/definitions/beliefFilterObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Statements filtered to belief above the threshold.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/preassembly/pipeline": {
      "post": {
        "tags": [
          "preassembly"
        ],
        "summary": "Run an assembly pipeline for a list of Statements.",
        "operationId": "assemblyPipeline",
        "description": "Takes in a list of INDRA statements and a list of AssemblyPipeline steps and runs the pipeline on statements.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "pipelineObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements, " +
                "and a \"pipeline\" referencing pipeline steps."
            ,
            "schema": {
              "$ref": "#/definitions/pipelineObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Statements after running pipeline.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        }
      }
    },
    "/assemblers/pysb": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble statements into a PySB model.",
        "operationId": "assemblePySB",
        "description": "Takes in a list of INDRA statements and returns an object containing a key \"model\" referencing a stringified PySB model.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "PySB model assembled.",
            "schema": {
              "$ref": "#/definitions/modelObj"
            }
          }
        }
      }
    },
    "/assemblers/cx": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble INDRA Statements and return CX network json.",
        "operationId": "assembleCx",
        "description": "Takes in a list of INDRA statements and returns an object containing a key \"model\" referencing a stringified CX model.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "CX model assembled.",
            "schema": {
              "$ref": "#/definitions/modelObj"
            }
          }
        }
      }
    },
    "/assemblers/graph": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble INDRA Statements and return Graphviz graph dot string.",
        "operationId": "assembleGraph",
        "description": "Takes in a list of INDRA statements and returns an object containing a key \"model\" referencing a stringified graph dot model.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Graph dot model assembled.",
            "schema": {
              "$ref": "#/definitions/modelObj"
            }
          }
        }
      }
    },
    "/assemblers/cyjs": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble INDRA Statements and returns a Cytoscape.js model string.",
        "operationId": "assembleCyjs",
        "description": "Takes in a list of INDRA statements and returns a stringified Cytoscape.js model.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "CyJS model assembled.",
            "schema": {
              "$ref": "#/definitions/cyjsStr"
            }
          }
        }
      }
    },
    "/assemblers/english": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble INDRA Statements and return an English language string.",
        "operationId": "assembleCyjs",
        "description": "Takes in a list of INDRA statements and returns the corresponding mechanisms in English.",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "English language output",
            "schema": {
              "$ref": "#/definitions/textObj"
            }
          }
        }
      }
    },
    "/assemblers/loopy": {
      "post": {
        "tags": [
          "assemblers"
        ],
        "summary": "Assemble INDRA Statements and returns a Loopy URL.",
        "operationId": "assembleLoopy",
        "description": "Takes in a list of INDRA statements and returns a Loopy URL that can be pasted into the browser. Best for small models and",
        "consumes": [
          "application/json"
        ],
        "produces": [
          "application/json"
        ],
        "parameters": [
          {
            "in": "body",
            "name": "statementsObj",
            "description": "object with a key of \"statements\" referencing a list of INDRA statements.",
            "schema": {
              "$ref": "#/definitions/statementsObj"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Loopy model assembled.",
            "schema": {
              "$ref": "#/definitions/loopyURL"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "pmcID": {
      "type": "object",
      "required": [
        "pmcid"
      ],
      "properties": {
        "pmcid": {
          "type": "string",
          "example": "5148607"
        }
      }
    },
    "pmcIDUrl": {
      "type": "object",
      "required": [
        "pmcid",
        "url"
      ],
      "properties": {
        "pmcid": {
          "type": "string",
          "example": "5148607"
        },
        "url": {
          "type": "string",
          "example": "http://localhost:8080/api/uploadFile"
        }
      }
    },
    "textObj": {
      "type": "object",
      "required": [
        "text"
      ],
      "properties": {
        "text": {
          "type": "string",
          "example": "GRB2 binds SHC."
        }
      }
    },
    "textObjWM": {
      "type": "object",
      "required": [
        "text"
      ],
      "properties": {
        "text": {
          "type": "string",
          "example": "Rainfall causes floods."
        }
      }
    },
    "textAuthObj": {
      "type": "object",
      "required": [
        "text",
        "auth"
      ],
      "properties": {
        "text": {
          "type": "string",
          "example": "Rainfall causes floods."
        },
        "auth": {
          "type": "list",
          "example": ['USER', 'PASS']
        }
      }
    },
    "textUrlObj": {
      "type": "object",
      "required": [
        "text",
        "url"
      ],
      "properties": {
        "text": {
          "type": "string",
          "example": "GRB2 binds SHC."
        },
        "url": {
          "type": "string",
          "example": "http://localhost:8080/api/text"
        }
      }
    },
    "genesObj": {
      "type": "object",
      "required": [
        "genes"
      ],
      "properties": {
        "genes": {
          "type": "array",
          "example": [
            "BRAF",
            "MAP2K1"
          ]
        }
      }
    },
    "genesSourceTargetObj": {
      "type": "object",
      "required": [
        "source",
        "target"
      ],
      "properties": {
        "source": {
          "type": "array",
          "example": [
            "BRAF",
            "RAF1",
            "ARAF"
          ]
        },
        "target": {
          "type": "array",
          "example": [
            "MAP2K1",
            "MAP2K2"
          ]
        }
      }
    },
    "statements": {
      "type": "array",
      "items": {
        "type": "object"
      }
    },
    "pipeline": {
      "type": "array",
      "items": {
        "type": "object"
      }
    },
    "statementsObj": {
      "type": "object",
      "required": [
        "statements"
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        }
      }
    },
    "statementsObjFilterType": {
      "type": "object",
      "required": [
        "statements",
        "type"
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        },
        "type": {
          "type": "string",
          "example": "Phosphorylation"
        }
      },
    },
    "preassemblyObj": {
      "type": "object",
      "required": [
        "statements",
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        },
        "scorer": {
          "type": "string",
          "example": "wm"
        },
        "return_toplevel": {
          "type": "bool",
          "example": true
        }
      }
    },
    "groundingFilterObj": {
      "type": "object",
      "required": [
        "statements",
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        },
        "score_threshold": {
          "type": "float",
          "example": 0.7
        }
      }
    },
    "beliefFilterObj": {
      "type": "object",
      "required": [
        "statements",
        "belief_cutoff"
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        },
        "belief_cutoff": {
          "type": "float",
          "example": 0.7
        }
      }
    },
    "pipelineObj": {
      "type": "object",
      "required": [
        "statements",
        "pipeline"
      ],
      "properties": {
        "statements": {
          "$ref": "#/definitions/statements"
        },
        "pipeline": {
          "$ref": "#definitions/pipeline"
        }
      }
    },
    "tripsXmlObj": {
      "type": "object",
      "required": [
        "xml_str"
      ],
      "properties": {
        "xml_str": {
          "type": "string",
          "example": "<ekb><EVENT id=\"V33713\"><type>ONT::PHOSPHORYLATION</type><arg1 id=\"V33708\" role=\":AGENT\" /><arg2 id=\"V33723\" role=\":AFFECTED\" /></EVENT><TERM id=\"V33723\" dbid=\"UP:Q54QB1|NCIT:C52872|NCIT:C17589|HGNC:6871|UP:P46196|UP:P28482|UP:P63085|UP:P63086\"><features></features><type>ONT::GENE-PROTEIN</type><name>ERK-2</name><drum-terms><drum-term dbid=\"UP:Q54QB1\" match-score=\"0.99587\" name=\"Extracellular signal-regulated kinase 2\" /><drum-term dbid=\"NCIT:C52872\" match-score=\"0.82444\" name=\"MAPK1\" /><drum-term dbid=\"NCIT:C17589\" match-score=\"0.82438\" name=\"mitogen-activated protein kinase-1\" /><drum-term dbid=\"HGNC:6871\" match-score=\"0.65301\" name=\"mitogen-activated protein kinase 1\" /><drum-term dbid=\"UP:P46196\" match-score=\"0.65296\" name=\"Mitogen-activated protein kinase 1\" /><drum-term dbid=\"UP:P28482\" match-score=\"0.65296\" name=\"Mitogen-activated protein kinase 1\" /><drum-term dbid=\"UP:P63085\" match-score=\"0.65296\" name=\"Mitogen-activated protein kinase 1\" /><drum-term dbid=\"UP:P63086\" match-score=\"0.65296\" name=\"Mitogen-activated protein kinase 1\" /></drum-terms></TERM><TERM id=\"V33708\" dbid=\"NCIT:C52823|NCIT:C105947|NCIT:C17808|HGNC:6840|UP:Q91447|UP:Q05116\"><features></features><type>ONT::GENE-PROTEIN</type><name>MEK-1</name><drum-terms><drum-term dbid=\"NCIT:C52823\" match-score=\"0.82444\" name=\"MAP2K1\" /><drum-term dbid=\"NCIT:C105947\" match-score=\"0.82444\" name=\"mitogen-activated protein kinase kinase\" /><drum-term dbid=\"NCIT:C17808\" match-score=\"0.82438\" name=\"MAP2K1 protein\" /><drum-term dbid=\"HGNC:6840\" match-score=\"0.65301\" name=\"mitogen-activated protein kinase kinase 1\" /><drum-term dbid=\"UP:Q91447\" match-score=\"0.65301\" name=\"Dual specificity mitogen-activated protein kinase kinase 1\" /><drum-term dbid=\"UP:Q05116\" match-score=\"0.65301\" name=\"Dual specificity mitogen-activated protein kinase kinase 1\" /></drum-terms></TERM></ekb>"
        }
      }
    },
    "reachJsonObj": {
      "type": "object",
      "required": [
        "json"
      ],
      "properties": {
        "json": {
          "type": "string",
          "example": "{\"entities\": {\"frames\": [{\"end-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 22}, \"xrefs\": [{\"object-type\": \"db-reference\", \"namespace\": \"be\", \"species\": \"human\", \"id\": \"ERK\"}], \"object-type\": \"frame\", \"start-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 19}, \"text\": \"ERK\", \"sentence\": \"sent-api554-UAZ-r1-Reach-0\", \"frame-type\": \"entity-mention\", \"frame-id\": \"ment-api554-UAZ-r1-Reach-0-52940\", \"type\": \"family\"}, {\"end-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 3}, \"xrefs\": [{\"object-type\": \"db-reference\", \"namespace\": \"be\", \"id\": \"MEK\"}], \"object-type\": \"frame\", \"start-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 0}, \"text\": \"MEK\", \"sentence\": \"sent-api554-UAZ-r1-Reach-0\", \"frame-type\": \"entity-mention\", \"alt-xrefs\": [{\"object-type\": \"db-reference\", \"namespace\": \"be\", \"id\": \"MEK\"}], \"frame-id\": \"ment-api554-UAZ-r1-Reach-0-52941\", \"type\": \"family\"}], \"object-type\": \"frame-collection\", \"object-meta\": {\"object-type\": \"meta-info\", \"processing-end\": \"2017-07-07T13:24:53Z\", \"component\": \"Reach\", \"doc-id\": \"api554\", \"processing-start\": \"2017-07-07T13:24:53Z\", \"organization\": \"UAZ\", \"component-type\": \"machine\"}}, \"events\": {\"frames\": [{\"end-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 22}, \"object-type\": \"frame\", \"start-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 4}, \"text\": \"phosphorylates ERK\", \"found-by\": \"Phosphorylation_syntax_1a_verb\", \"sentence\": \"sent-api554-UAZ-r1-Reach-0\", \"subtype\": \"phosphorylation\", \"frame-type\": \"event-mention\", \"trigger\": \"phosphorylates\", \"arguments\": [{\"object-type\": \"argument\", \"index\": 0, \"text\": \"ERK\", \"arg\": \"ment-api554-UAZ-r1-Reach-0-52940\", \"type\": \"theme\", \"argument-type\": \"entity\"}], \"frame-id\": \"evem-api554-UAZ-r1-Reach-0-6038\", \"verbose-text\": \"MEK phosphorylates ERK.\", \"is-direct\": true, \"type\": \"protein-modification\"}, {\"end-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 22}, \"object-type\": \"frame\", \"start-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 0}, \"text\": \"MEK phosphorylates ERK\", \"found-by\": \"Phosphorylation_syntax_1a_verb + toRelationMention\", \"sentence\": \"sent-api554-UAZ-r1-Reach-0\", \"subtype\": \"positive-regulation\", \"frame-type\": \"event-mention\", \"arguments\": [{\"object-type\": \"argument\", \"index\": 0, \"text\": \"phosphorylates ERK\", \"arg\": \"evem-api554-UAZ-r1-Reach-0-6038\", \"type\": \"controlled\", \"argument-type\": \"event\"}, {\"object-type\": \"argument\", \"index\": 0, \"text\": \"MEK\", \"arg\": \"ment-api554-UAZ-r1-Reach-0-52941\", \"type\": \"controller\", \"argument-type\": \"entity\"}], \"frame-id\": \"evem-api554-UAZ-r1-Reach-0-6037\", \"verbose-text\": \"MEK phosphorylates ERK.\", \"type\": \"regulation\"}], \"object-type\": \"frame-collection\", \"object-meta\": {\"object-type\": \"meta-info\", \"processing-end\": \"2017-07-07T13:24:53Z\", \"component\": \"Reach\", \"doc-id\": \"api554\", \"processing-start\": \"2017-07-07T13:24:53Z\", \"organization\": \"UAZ\", \"component-type\": \"machine\"}}, \"sentences\": {\"frames\": [{\"object-type\": \"frame\", \"index\": \"Reach\", \"text\": \"MEK phosphorylates ERK.\", \"object-meta\": {\"object-type\": \"meta-info\", \"component\": \"nxml2fries\"}, \"section-id\": \"NoSection\", \"frame-type\": \"passage\", \"section-name\": \"NoSection\", \"is-title\": false, \"frame-id\": \"pass-api554-UAZ-r1-Reach\"}, {\"end-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 23}, \"object-type\": \"frame\", \"start-pos\": {\"object-type\": \"relative-pos\", \"reference\": \"pass-api554-UAZ-r1-Reach\", \"offset\": 0}, \"text\": \"MEK phosphorylates ERK .\", \"object-meta\": {\"object-type\": \"meta-info\", \"component\": \"BioNLPProcessor\"}, \"passage\": \"pass-api554-UAZ-r1-Reach\", \"frame-type\": \"sentence\", \"frame-id\": \"sent-api554-UAZ-r1-Reach-0\"}], \"object-type\": \"frame-collection\", \"object-meta\": {\"object-type\": \"meta-info\", \"processing-end\": \"2017-07-07T13:24:53Z\", \"component\": \"Reach\", \"doc-id\": \"api554\", \"processing-start\": \"2017-07-07T13:24:53Z\", \"organization\": \"UAZ\", \"component-type\": \"machine\"}}}"
        }
      }
    },
    "eidosJsonObj": {
      "type": "object",
      "required": [
        "jsonld"
      ],
      "properties": {
        "jsonld": {
          "type": "string",
          "example": "{}"
        }
      }
    },
    "humeJsonObj": {
      "type": "object",
      "required": [
        "json"
      ],
      "properties": {
        "json": {
          "type": "string",
          "example": "{}"
        }
      }
    },
    "belRdfObj": {
      "type": "object",
      "required": [
        "belrdf"
      ],
      "properties": {
        "belrdf": {
          "type": "string"
        }
      }
    },
    "modelObj": {
      "type": "object",
      "required": [
        "model"
      ],
      "properties": {
        "model": {
          "type": "string"
        }
      }
    },
    "cyjsStr": {
      "type": "string"
    },
    "loopyURL": {
      "type": "string"
    }
  }
}
