/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2graphml;

import com.google.common.collect.Lists;
import java.util.List;
import psidev.psi.mi.tab.converter.tab2graphml.AliasComparator;
import psidev.psi.mi.tab.model.Alias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasByTypeComparator
implements AliasComparator {
    private static List<String> DEFAULT_ALIAS_TYPE = Lists.newArrayList();
    private List<String> aliasTypes = Lists.newArrayList();
    private boolean matchedAny = false;

    public AliasByTypeComparator(List<String> databases) {
        this.aliasTypes = databases;
    }

    public AliasByTypeComparator() {
        this(DEFAULT_ALIAS_TYPE);
    }

    @Override
    public int compare(Alias a1, Alias a2) {
        int idx1 = this.aliasTypes.indexOf(a1.getAliasType());
        int idx2 = this.aliasTypes.indexOf(a2.getAliasType());
        if (idx1 != -1 || idx2 != -1) {
            this.matchedAny = true;
        }
        int compare = 0;
        compare = idx1 == -1 && idx2 == -1 ? 0 : (idx1 == -1 ? 1 : (idx2 == -1 ? -1 : idx1 - idx2));
        return compare;
    }

    @Override
    public boolean hasMatchedAny() {
        return this.matchedAny;
    }

    @Override
    public boolean matches(Alias a) {
        return this.aliasTypes.indexOf(a.getAliasType()) != -1;
    }

    static {
        DEFAULT_ALIAS_TYPE.add("display_short");
        DEFAULT_ALIAS_TYPE.add("display_long");
        DEFAULT_ALIAS_TYPE.add("gene name");
        DEFAULT_ALIAS_TYPE.add("orf name");
        DEFAULT_ALIAS_TYPE.add("locus name");
        DEFAULT_ALIAS_TYPE.add("gene name synonym");
        DEFAULT_ALIAS_TYPE.add("chebi name");
        DEFAULT_ALIAS_TYPE.add("shortlabel");
        DEFAULT_ALIAS_TYPE.add("shortLabel");
        DEFAULT_ALIAS_TYPE.add("short label");
    }
}

