/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.gui.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import psidev.psi.mi.tab.client.gui.dnd.FilesDroppedListener;

public class DragAndDropComponent {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public DragAndDropComponent(Component c, FilesDroppedListener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public DragAndDropComponent(Component c, boolean recursive, FilesDroppedListener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public DragAndDropComponent(PrintStream out, Component c, FilesDroppedListener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public DragAndDropComponent(PrintStream out, Component c, boolean recursive, FilesDroppedListener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public DragAndDropComponent(Component c, Border dragBorder, FilesDroppedListener listener) {
        this(null, c, dragBorder, false, listener);
    }

    public DragAndDropComponent(Component c, Border dragBorder, boolean recursive, FilesDroppedListener listener) {
        this(null, c, dragBorder, recursive, listener);
    }

    public DragAndDropComponent(PrintStream out, Component c, Border dragBorder, FilesDroppedListener listener) {
        this(out, c, dragBorder, false, listener);
    }

    public DragAndDropComponent(final PrintStream out, final Component c, final Border dragBorder, boolean recursive, final FilesDroppedListener listener) {
        if (DragAndDropComponent.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent evt) {
                    DragAndDropComponent.log(out, "FileDrop: dragEnter event.");
                    if (DragAndDropComponent.this.isDragOk(out, evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            DragAndDropComponent.this.normalBorder = jc.getBorder();
                            DragAndDropComponent.log(out, "FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            DragAndDropComponent.log(out, "FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        DragAndDropComponent.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        DragAndDropComponent.log(out, "FileDrop: event rejected.");
                    }
                }

                public void dragOver(DropTargetDragEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void drop(DropTargetDropEvent evt) {
                    DragAndDropComponent.log(out, "FileDrop: drop event.");
                    try {
                        Transferable tr = evt.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            DragAndDropComponent.log(out, "FileDrop: file list accepted.");
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            File[] filesTemp = new File[fileList.size()];
                            fileList.toArray(filesTemp);
                            File[] files = filesTemp;
                            if (listener != null) {
                                listener.filesDropped(files);
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            DragAndDropComponent.log(out, "FileDrop: drop complete.");
                        } else {
                            DragAndDropComponent.log(out, "FileDrop: not a file list - abort.");
                            evt.rejectDrop();
                        }
                    }
                    catch (IOException io) {
                        DragAndDropComponent.log(out, "FileDrop: IOException - abort:");
                        io.printStackTrace(out);
                        evt.rejectDrop();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        DragAndDropComponent.log(out, "FileDrop: UnsupportedFlavorException - abort:");
                        ufe.printStackTrace(out);
                        evt.rejectDrop();
                    }
                    finally {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(DragAndDropComponent.this.normalBorder);
                            DragAndDropComponent.log(out, "FileDrop: normal border restored.");
                        }
                    }
                }

                public void dragExit(DropTargetEvent evt) {
                    DragAndDropComponent.log(out, "FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(DragAndDropComponent.this.normalBorder);
                        DragAndDropComponent.log(out, "FileDrop: normal border restored.");
                    }
                }

                public void dropActionChanged(DropTargetDragEvent evt) {
                    DragAndDropComponent.log(out, "FileDrop: dropActionChanged event.");
                    if (DragAndDropComponent.this.isDragOk(out, evt)) {
                        evt.acceptDrag(1);
                        DragAndDropComponent.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        DragAndDropComponent.log(out, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(out, c, recursive);
        } else {
            DragAndDropComponent.log(out, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support = false;
            try {
                Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            supportsDnD = support;
        }
        return supportsDnD;
    }

    private void makeDropTarget(final PrintStream out, final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            DragAndDropComponent.log(out, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent evt) {
                DragAndDropComponent.log(out, "FileDrop: Hierarchy changed.");
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                    DragAndDropComponent.log(out, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(c, DragAndDropComponent.this.dropListener);
                    DragAndDropComponent.log(out, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(out, comps[i], recursive);
            }
        }
    }

    private boolean isDragOk(PrintStream out, DropTargetDragEvent evt) {
        int i;
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (i = 0; !ok && i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            ok = true;
        }
        if (out != null) {
            if (flavors.length == 0) {
                DragAndDropComponent.log(out, "FileDrop: no data flavors.");
            }
            for (i = 0; i < flavors.length; ++i) {
                DragAndDropComponent.log(out, flavors[i].toString());
            }
        }
        return ok;
    }

    private static void log(PrintStream out, String message) {
        if (out != null) {
            out.println(message);
        }
    }

    public static boolean remove(Component c) {
        return DragAndDropComponent.remove(null, c, true);
    }

    public static boolean remove(PrintStream out, Component c, boolean recursive) {
        if (DragAndDropComponent.supportsDnD()) {
            DragAndDropComponent.log(out, "FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                Component[] comps = ((Container)c).getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    DragAndDropComponent.remove(out, comps[i], recursive);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }
}

