/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.converter.xml2tab.Xml2Tab;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.expansion.MatrixExpansion;
import psidev.psi.mi.tab.expansion.SpokeExpansion;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;

public class FilesProcessor {
    public static final Log log = LogFactory.getLog(FilesProcessor.class);
    public static final int MAX_FILE_DISPLAY = 7;

    public void process(JFrame frame, File[] files, ExpansionStrategy expansionStrategy, PostProcessorStrategy postProcessorStrategy, boolean aggregateFiles) {
        ArrayList<File> inputFiles = new ArrayList<File>(files.length);
        ArrayList<File> unselectedFiles = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory() || file.getName().endsWith(".xml")) {
                inputFiles.add(file);
                continue;
            }
            unselectedFiles.add(file);
        }
        if (!unselectedFiles.isEmpty()) {
            String message = "Some of the file your have dropped are not XML files:";
            int count = 0;
            boolean stop = false;
            Iterator iterator = unselectedFiles.iterator();
            while (iterator.hasNext() && !stop) {
                File file = (File)iterator.next();
                message = message + "\n- " + file.getName();
                if (++count < 7 || !iterator.hasNext()) continue;
                message = message + "\n- ... " + (unselectedFiles.size() - 7) + " more.";
                stop = true;
            }
            message = message + "\nPlease try again.";
            JOptionPane.showMessageDialog(frame, message, "Invalid file(s)", 0);
        }
        if (inputFiles.isEmpty()) {
            String message = "No input file to be processed, please drop one or use File > Open files...";
            JOptionPane.showMessageDialog(frame, message, "No input file.", 2);
        } else {
            String message;
            Xml2Tab x2t = new Xml2Tab();
            x2t.setPostProcessor(postProcessorStrategy);
            PsimiTabWriter fileWriter = new PsimiTabWriter();
            if (aggregateFiles) {
                log.debug("Aggregate conversion starts...");
                File output = this.buildOutputFile((File)inputFiles.get(0), aggregateFiles, expansionStrategy);
                try {
                    FileWriter outputWriter = new FileWriter(output);
                    long start = System.currentTimeMillis();
                    Collection<BinaryInteraction> interactions = x2t.convert((Collection<File>)inputFiles);
                    fileWriter.write(interactions, (Writer)outputWriter);
                    long stop = System.currentTimeMillis();
                    log.debug("conversion took: " + (stop - start) + "ms");
                    String message2 = "Your file" + (files.length > 1 ? "s were" : " was") + " converted succesfully." + "\nLocation: " + output.getAbsolutePath();
                    JOptionPane.showMessageDialog(frame, message2, "Conversion complete", 1);
                    outputWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    message = e.getMessage();
                    JOptionPane.showMessageDialog(frame, message, "Error - " + e.getClass().getSimpleName(), 0);
                }
            } else {
                log.debug("Non aggregative conversion starts...");
                int ok = 0;
                int failed = 0;
                for (File inputFile : inputFiles) {
                    File output = this.buildOutputFile(inputFile, aggregateFiles, expansionStrategy);
                    try {
                        FileWriter outputWriter = new FileWriter(output);
                        long start = System.currentTimeMillis();
                        ArrayList<File> singleFile = new ArrayList<File>(1);
                        singleFile.add(inputFile);
                        Collection<BinaryInteraction> interactions = x2t.convert((Collection<File>)singleFile);
                        fileWriter.write(interactions, (Writer)outputWriter);
                        long stop = System.currentTimeMillis();
                        log.debug("conversion took: " + (stop - start) + "ms");
                        ++ok;
                        outputWriter.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String message3 = e.getMessage();
                        JOptionPane.showMessageDialog(frame, message3, "Error - " + e.getClass().getSimpleName(), 0);
                        ++failed;
                    }
                }
                message = ok + " file" + (ok > 1 ? "s were" : " was") + " converted succesfully.";
                if (failed > 0) {
                    message = message + "\n" + failed + " failed to be converted.";
                }
                JOptionPane.showMessageDialog(frame, message, "Conversion complete.", 1);
            }
        }
    }

    private File buildOutputFile(File file, boolean aggregateName, ExpansionStrategy expansionStrategy) {
        String baseFilename;
        if (aggregateName) {
            baseFilename = file.getParentFile().getAbsolutePath();
            baseFilename = baseFilename + File.separator + file.getParentFile().getName();
        } else {
            baseFilename = file.getAbsolutePath().replaceAll(".xml", "");
        }
        if (expansionStrategy != null) {
            if (expansionStrategy instanceof SpokeExpansion) {
                baseFilename = baseFilename + ".spoke";
            } else if (expansionStrategy instanceof MatrixExpansion) {
                baseFilename = baseFilename + ".matrix";
            }
        }
        File output = new File(baseFilename + ".xls");
        int i = 1;
        while (output.exists()) {
            log.warn(output.getName() + " exists, change filename.");
            output = new File(baseFilename + ".v" + ++i + ".xls");
        }
        return output;
    }
}

