/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabException;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.builder.MitabWriterUtils;
import psidev.psi.mi.tab.model.builder.PsimiTabVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabWriter
implements psidev.psi.mi.tab.io.PsimiTabWriter {
    Log log = LogFactory.getLog(PsimiTabWriter.class);
    private PsimiTabVersion version = PsimiTabVersion.v2_5;

    public PsimiTabWriter(PsimiTabVersion version) {
        this.version = version;
    }

    public PsimiTabWriter() {
        this(PsimiTabVersion.v2_5);
        this.log.warn("MITAB version was not provided. The default version MITAB 2.5 has been assigned by default.");
    }

    @Override
    public void write(Collection<BinaryInteraction> interactions, Writer writer) throws IOException {
        for (BinaryInteraction interaction2 : interactions) {
            this.write(interaction2, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Collection<BinaryInteraction> interactions, OutputStream os) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(os));
            this.write(interactions, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Collection<BinaryInteraction> interactions, PrintStream ps) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(ps));
            this.write(interactions, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Collection<BinaryInteraction> interactions, File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new BufferedWriter(new FileWriter(file, true)));
            this.write(interactions, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    @Override
    public void write(BinaryInteraction binaryInteraction, Writer writer) throws IOException {
        String line = MitabWriterUtils.buildLine(binaryInteraction, this.version);
        writer.write(line);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BinaryInteraction interaction2, OutputStream os) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(os));
            this.write(interaction2, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BinaryInteraction interaction2, PrintStream ps) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(ps));
            this.write(interaction2, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(BinaryInteraction interaction2, File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            this.write(interaction2, (Writer)bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    @Override
    public void writeMitabHeader(Writer writer) throws IOException {
        String line = MitabWriterUtils.buildHeader(this.version);
        writer.write(line);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMitabHeader(OutputStream os) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(os));
            this.writeMitabHeader(bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMitabHeader(PrintStream ps) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(ps));
            this.writeMitabHeader(bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMitabHeader(File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            this.writeMitabHeader(bufferedWriter);
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    @Override
    public void handleError(String message, Throwable e) throws PsimiTabException {
    }
}

