/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;

final class HttpComponentsClientHttpResponse
extends AbstractClientHttpResponse {
    private final CloseableHttpResponse httpResponse;
    private HttpHeaders headers;

    HttpComponentsClientHttpResponse(CloseableHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public int getRawStatusCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            for (Header header : this.httpResponse.getAllHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        HttpEntity entity2 = this.httpResponse.getEntity();
        return entity2 != null ? entity2.getContent() : null;
    }

    @Override
    public void close() {
        try {
            try {
                EntityUtils.consume(this.httpResponse.getEntity());
            }
            finally {
                this.httpResponse.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

