/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.util.ArrayList;
import java.util.Iterator;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.VisibilityEdge;
import org.ivis.layout.sbgn.VisibilityGraph;

public class Compaction {
    private ArrayList<SbgnPDNode> vertices;
    private VisibilityGraph visGraph;
    private CompactionDirection direction;
    ArrayList<SbgnPDNode> orderedNodeList = new ArrayList();

    public Compaction(ArrayList<SbgnPDNode> vertices) {
        this.vertices = new ArrayList();
        this.vertices = vertices;
    }

    public void perform() {
        this.algorithmBody(CompactionDirection.VERTICAL);
        this.removeVisibilityEdges();
        this.algorithmBody(CompactionDirection.HORIZONTAL);
        this.removeVisibilityEdges();
    }

    private void removeVisibilityEdges() {
        Iterator<SbgnPDNode> i$ = this.vertices.iterator();
        while (i$.hasNext()) {
            SbgnPDNode objNode;
            SbgnPDNode sbgnNode = objNode = i$.next();
            for (int i = 0; i < sbgnNode.getEdges().size(); ++i) {
                Object objEdge = sbgnNode.getEdges().get(i);
                if (!(objEdge instanceof VisibilityEdge)) continue;
                sbgnNode.getEdges().remove(i);
                --i;
            }
        }
    }

    private void algorithmBody(CompactionDirection direction) {
        this.direction = direction;
        this.visGraph = new VisibilityGraph(null, null, null);
        this.visGraph.construct(this.direction, this.vertices);
        if (this.visGraph.getEdges().size() > 0) {
            this.topologicallySort();
            this.compactElements();
        }
        this.vertices = (ArrayList)this.visGraph.getNodes();
    }

    private void topologicallySort() {
        for (int i = 0; i < this.visGraph.getNodes().size(); ++i) {
            SbgnPDNode s = (SbgnPDNode)this.visGraph.getNodes().get(i);
            s.visited = false;
        }
        this.orderedNodeList.clear();
        this.DFS();
        this.orderedNodeList = this.reverseList(this.orderedNodeList);
    }

    private void DFS() {
        for (int i = 0; i < this.visGraph.getNodes().size(); ++i) {
            SbgnPDNode s = (SbgnPDNode)this.visGraph.getNodes().get(i);
            if (s.visited) continue;
            this.DFS_Visit(s);
        }
    }

    private void DFS_Visit(SbgnPDNode s) {
        ArrayList<SbgnPDNode> neighbors = s.getChildrenNeighbors(null);
        if (neighbors.size() == 0) {
            s.visited = true;
            this.orderedNodeList.add(s);
            return;
        }
        for (SbgnPDNode n : neighbors) {
            if (n.visited) continue;
            this.DFS_Visit(n);
        }
        s.visited = true;
        this.orderedNodeList.add(s);
    }

    private ArrayList<SbgnPDNode> reverseList(ArrayList<SbgnPDNode> originalList) {
        ArrayList<SbgnPDNode> reverseOutput = new ArrayList<SbgnPDNode>();
        for (int i = originalList.size() - 1; i >= 0; --i) {
            reverseOutput.add(originalList.get(i));
        }
        return reverseOutput;
    }

    private void compactElements() {
        for (SbgnPDNode s : this.orderedNodeList) {
            VisibilityEdge edge = this.visGraph.findShortestEdge(s);
            if (edge == null) continue;
            double distance = edge.getLength();
            if (this.direction == CompactionDirection.VERTICAL) {
                if (distance > 5.0) {
                    s.setLocation(s.getLeft(), s.getTop() - (distance - 5.0));
                    continue;
                }
                s.setLocation(s.getLeft(), edge.getOtherEnd(s).getBottom() + 5.0);
                continue;
            }
            if (this.direction != CompactionDirection.HORIZONTAL) continue;
            if (distance > 5.0) {
                s.setLocation(s.getLeft() - (distance - 5.0), s.getTop());
                continue;
            }
            s.setLocation(edge.getOtherEnd(s).getRight() + 5.0, s.getTop());
        }
    }

    private void printEdges() {
        System.out.println("# of edges: " + this.visGraph.getEdges().size());
        for (int i = 0; i < this.visGraph.getEdges().size(); ++i) {
            VisibilityEdge e = (VisibilityEdge)this.visGraph.getEdges().get(i);
            System.out.println("between: " + e.getSource().label + "  " + e.getTarget().label);
        }
    }

    private void printGraphVertices() {
        for (int i = 0; i < this.visGraph.getNodes().size(); ++i) {
            SbgnPDNode s = (SbgnPDNode)this.visGraph.getNodes().get(i);
            System.out.println(s.label + " (" + s.getLeft() + ", " + s.getTop() + ")" + " || " + "(" + (s.getLeft() + s.getWidth()) + ", " + (s.getTop() + s.getHeight()) + ")");
        }
        System.out.println();
    }

    public static enum CompactionDirection {
        VERTICAL,
        HORIZONTAL;

    }
}

