/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.io.Serializable;

public class LayoutOptionsPack
implements Serializable {
    private static LayoutOptionsPack instance;
    private General general = new General();
    private CoSE coSE = new CoSE();
    private Cluster cluster = new Cluster();
    private CiSE ciSE = new CiSE();
    private AVSDF avsdf = new AVSDF();
    private Spring spring = new Spring();
    private Sgym sgym = new Sgym();

    private LayoutOptionsPack() {
        this.setDefaultLayoutProperties();
    }

    public void setDefaultLayoutProperties() {
        this.general.layoutQuality = this.general.defaultLayoutQuality;
        this.general.animationDuringLayout = this.general.defaultAnimationDuringLayout;
        this.general.animationOnLayout = this.general.defaultAnimationOnLayout;
        this.general.animationPeriod = this.general.defaultAnimationPeriod;
        this.general.incremental = this.general.defaultIncremental;
        this.general.createBendsAsNeeded = this.general.defaultCreateBendsAsNeeded;
        this.general.uniformLeafNodeSizes = this.general.defaultUniformLeafNodeSizes;
        this.coSE.idealEdgeLength = this.coSE.defaultIdealEdgeLength;
        this.coSE.springStrength = this.coSE.defaultSpringStrength;
        this.coSE.repulsionStrength = this.coSE.defaultRepulsionStrength;
        this.coSE.smartRepulsionRangeCalc = this.coSE.defaultSmartRepulsionRangeCalc;
        this.coSE.gravityStrength = this.coSE.defaultGravityStrength;
        this.coSE.gravityRange = this.coSE.defaultGravityRange;
        this.coSE.compoundGravityStrength = this.coSE.defaultCompoundGravityStrength;
        this.coSE.compoundGravityRange = this.coSE.defaultCompoundGravityRange;
        this.coSE.smartEdgeLengthCalc = this.coSE.defaultSmartEdgeLengthCalc;
        this.coSE.multiLevelScaling = this.coSE.defaultMultiLevelScaling;
        this.cluster.idealEdgeLength = this.cluster.defaultIdealEdgeLength;
        this.cluster.clusterSeperation = this.cluster.defaultClusterSeperation;
        this.cluster.clusterGravityStrength = this.cluster.defaultClusterGravityStrength;
        this.ciSE.nodeSeparation = this.ciSE.defaultNodeSeparation;
        this.ciSE.desiredEdgeLength = this.ciSE.defaultDesiredEdgeLength;
        this.ciSE.interClusterEdgeLengthFactor = this.ciSE.defaultInterClusterEdgeLengthFactor;
        this.ciSE.allowNodesInsideCircle = this.ciSE.defaultAllowNodesInsideCircle;
        this.ciSE.maxRatioOfNodesInsideCircle = this.ciSE.defaultMaxRatioOfNodesInsideCircle;
        this.avsdf.nodeSeparation = this.avsdf.defaultNodeSeparation;
        this.spring.nodeDistanceRestLength = this.spring.defaultNodeDistanceRestLength;
        this.spring.disconnectedNodeDistanceSpringRestLength = this.spring.defaultDisconnectedNodeDistanceSpringRestLength;
        this.sgym.horizontalSpacing = this.sgym.defaultHorizontalSpacing;
        this.sgym.verticalSpacing = this.sgym.defaultVerticalSpacing;
        this.sgym.vertical = this.sgym.defaultVertical;
    }

    public static LayoutOptionsPack getInstance() {
        if (instance == null) {
            instance = new LayoutOptionsPack();
        }
        return instance;
    }

    public Sgym getSgym() {
        return this.sgym;
    }

    public CoSE getCoSE() {
        return this.coSE;
    }

    public Spring getSpring() {
        return this.spring;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public CiSE getCiSE() {
        return this.ciSE;
    }

    public AVSDF getAVSDF() {
        return this.avsdf;
    }

    public General getGeneral() {
        return this.general;
    }

    public class Sgym {
        public int horizontalSpacing;
        public int verticalSpacing;
        public boolean vertical;
        public int defaultHorizontalSpacing = 100;
        public int defaultVerticalSpacing = 80;
        public boolean defaultVertical = true;
    }

    public class Spring {
        public int nodeDistanceRestLength;
        public int disconnectedNodeDistanceSpringRestLength;
        public int defaultNodeDistanceRestLength = 60;
        public int defaultDisconnectedNodeDistanceSpringRestLength = 250;
    }

    public class AVSDF {
        public int nodeSeparation;
        public int defaultNodeSeparation = 60;
    }

    public class CiSE {
        public int nodeSeparation;
        public int desiredEdgeLength;
        public int interClusterEdgeLengthFactor;
        public boolean allowNodesInsideCircle;
        public double maxRatioOfNodesInsideCircle;
        public int defaultNodeSeparation = 12;
        public int defaultDesiredEdgeLength = 50;
        public int defaultInterClusterEdgeLengthFactor = 50;
        public boolean defaultAllowNodesInsideCircle = false;
        public double defaultMaxRatioOfNodesInsideCircle = 0.2;
    }

    public class Cluster {
        public int idealEdgeLength;
        public int clusterSeperation;
        public int clusterGravityStrength;
        public int defaultIdealEdgeLength = 50;
        public int defaultClusterSeperation = 50;
        public int defaultClusterGravityStrength = 50;
    }

    public class CoSE {
        public int idealEdgeLength;
        public int springStrength;
        public int repulsionStrength;
        public boolean smartRepulsionRangeCalc;
        public int gravityStrength;
        public int gravityRange;
        public int compoundGravityStrength;
        public int compoundGravityRange;
        public boolean smartEdgeLengthCalc;
        public boolean multiLevelScaling;
        public int defaultIdealEdgeLength = 50;
        public int defaultSpringStrength = 50;
        public int defaultRepulsionStrength = 50;
        public boolean defaultSmartRepulsionRangeCalc = true;
        public int defaultGravityStrength = 50;
        public int defaultGravityRange = 50;
        public int defaultCompoundGravityStrength = 50;
        public int defaultCompoundGravityRange = 50;
        public boolean defaultSmartEdgeLengthCalc = true;
        public boolean defaultMultiLevelScaling = false;
    }

    public class General {
        public int layoutQuality;
        public boolean animationDuringLayout;
        public boolean animationOnLayout;
        public int animationPeriod;
        public boolean incremental;
        public boolean createBendsAsNeeded;
        public boolean uniformLeafNodeSizes;
        public int defaultLayoutQuality = 1;
        public boolean defaultAnimationDuringLayout = false;
        public boolean defaultAnimationOnLayout = true;
        public int defaultAnimationPeriod = 50;
        public boolean defaultIncremental = false;
        public boolean defaultCreateBendsAsNeeded = false;
        public boolean defaultUniformLeafNodeSizes = false;
    }
}

