/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.BPCollections;

public class BiopaxSafeSet<E extends BioPAXElement>
extends AbstractSet<E> {
    private static final Log LOG = LogFactory.getLog(BiopaxSafeSet.class);
    private static final Map empty = Collections.unmodifiableMap(Collections.emptyMap());
    private Map<String, E> map = empty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Map<String, E> map = this.map;
        synchronized (map) {
            return this.map.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<String, E> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E bpe) {
        Map<String, E> map = this.map;
        synchronized (map) {
            if (this.map.isEmpty()) {
                this.map = BPCollections.I.createMap();
            }
        }
        String uri = bpe.getUri();
        Map<String, E> map2 = this.map;
        synchronized (map2) {
            if (!this.map.containsKey(uri)) {
                this.map.put(uri, bpe);
                return true;
            }
            LOG.debug("ignored duplicate:" + uri);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (this.map == empty) {
            return false;
        }
        Map<String, E> map = this.map;
        synchronized (map) {
            return super.contains(o) && this.get(((BioPAXElement)o).getUri()) == o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(String uri) {
        if (this.map == empty) {
            return null;
        }
        Map<String, E> map = this.map;
        synchronized (map) {
            return (E)((BioPAXElement)this.map.get(uri));
        }
    }
}

