/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3undirected;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3undirected.EdgeL3;
import org.biopax.paxtools.query.wrapperL3undirected.GraphL3Undirected;

public class PhysicalEntityWrapper
extends AbstractNode {
    protected PhysicalEntity pe;
    protected boolean upperEquivalentInited;
    protected boolean lowerEquivalentInited;
    protected boolean ubique;

    public PhysicalEntityWrapper(PhysicalEntity pe, GraphL3Undirected graph) {
        super(graph);
        this.pe = pe;
        this.upperEquivalentInited = false;
        this.lowerEquivalentInited = false;
        this.ubique = false;
    }

    @Override
    public boolean isUbique() {
        return this.ubique;
    }

    public void setUbique(boolean ubique) {
        this.ubique = ubique;
    }

    @Override
    public void initUpstream() {
        for (Interaction inter : this.pe.getParticipantOf()) {
            AbstractNode wrapper = (AbstractNode)this.graph.getGraphObject(inter);
            if (wrapper == null) continue;
            EdgeL3 edge = new EdgeL3(wrapper, this, this.graph);
            wrapper.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public void initDownstream() {
        for (Interaction inter : this.pe.getParticipantOf()) {
            AbstractNode wrapper = (AbstractNode)this.graph.getGraphObject(inter);
            if (wrapper == null) continue;
            EdgeL3 edge = new EdgeL3(this, wrapper, this.graph);
            this.getDownstreamNoInit().add(edge);
            wrapper.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public Collection<Node> getUpperEquivalent() {
        if (!this.upperEquivalentInited) {
            this.initUpperEquivalent();
        }
        return super.getUpperEquivalent();
    }

    @Override
    public Collection<Node> getLowerEquivalent() {
        if (!this.lowerEquivalentInited) {
            this.initLowerEquivalent();
        }
        return super.getLowerEquivalent();
    }

    protected void initUpperEquivalent() {
        this.upperEquivalent = new HashSet();
        for (PhysicalEntity eq : this.pe.getMemberPhysicalEntityOf()) {
            Node node = (Node)this.graph.getGraphObject(eq);
            if (node == null) continue;
            this.upperEquivalent.add(node);
        }
        this.upperEquivalentInited = true;
    }

    protected void initLowerEquivalent() {
        this.lowerEquivalent = new HashSet();
        for (PhysicalEntity eq : this.pe.getMemberPhysicalEntity()) {
            Node node = (Node)this.graph.getGraphObject(eq);
            if (node == null) continue;
            this.lowerEquivalent.add(node);
        }
        this.lowerEquivalentInited = true;
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public int getSign() {
        return 1;
    }

    @Override
    public String getKey() {
        return this.pe.getUri();
    }

    public PhysicalEntity getPhysicalEntity() {
        return this.pe;
    }

    public String toString() {
        return this.pe.getDisplayName() + " -- " + this.pe.getUri();
    }
}

