/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.query.wrapperL3.EventWrapper;
import org.biopax.paxtools.query.wrapperL3.GraphL3;

public class ConversionWrapper
extends EventWrapper {
    protected Conversion conv;
    protected boolean direction;
    private ConversionWrapper reverse;
    protected boolean transcription;
    public static final boolean LEFT_TO_RIGHT = true;
    public static final boolean RIGHT_TO_LEFT = false;

    protected ConversionWrapper(Conversion conv, GraphL3 graph) {
        super(graph);
        this.conv = conv;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public ConversionWrapper getReverse() {
        return this.reverse;
    }

    @Override
    public void init() {
        if (this.conv.getConversionDirection() == ConversionDirectionType.REVERSIBLE && this.reverse == null) {
            this.reverse = new ConversionWrapper(this.conv, (GraphL3)this.graph);
            this.direction = true;
            this.reverse.direction = false;
            this.reverse.reverse = this;
        } else {
            this.direction = this.conv.getConversionDirection() != ConversionDirectionType.RIGHT_TO_LEFT;
        }
    }

    @Override
    public void initUpstream() {
        if (this.direction) {
            for (PhysicalEntity pe : this.conv.getLeft()) {
                this.addToUpstream(pe, this.getGraph());
            }
        } else {
            for (PhysicalEntity pe : this.conv.getRight()) {
                this.addToUpstream(pe, this.getGraph());
            }
        }
        for (Control cont : this.conv.getControlledOf()) {
            Catalysis cat;
            if (cont instanceof Catalysis && ((cat = (Catalysis)cont).getCatalysisDirection() == CatalysisDirectionType.LEFT_TO_RIGHT && !this.direction || cat.getCatalysisDirection() == CatalysisDirectionType.RIGHT_TO_LEFT && this.direction)) continue;
            this.addToUpstream(cont, this.graph);
        }
    }

    @Override
    public void initDownstream() {
        if (!this.direction) {
            for (PhysicalEntity pe : this.conv.getLeft()) {
                this.addToDownstream(pe, this.getGraph());
            }
        } else {
            for (PhysicalEntity pe : this.conv.getRight()) {
                this.addToDownstream(pe, this.getGraph());
            }
        }
    }

    @Override
    public boolean isTranscription() {
        return this.transcription;
    }

    @Override
    public String getKey() {
        return this.conv.getUri() + "|" + this.direction;
    }

    public Conversion getConversion() {
        return this.conv;
    }

    public String toString() {
        return this.conv.getDisplayName() + " -- " + this.conv.getUri();
    }
}

