/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.PatternBox;
import org.biopax.paxtools.pattern.miner.MinerAdapter;

public class RelatedGenesOfInteractionsMiner
extends MinerAdapter {
    private static final PathAccessor controlAcc = new PathAccessor("Interaction/controlledOf*");

    public RelatedGenesOfInteractionsMiner() {
        super("related-genes-of-interactions", "This miner finds any related gene that is a participant or a controller of an Interaction (Conversion or TemplateReaction). The output lists the ID of the interaction and the related gene symbols in a row.");
    }

    @Override
    public Pattern constructPattern() {
        return PatternBox.relatedProteinRefOfInter(Conversion.class, TemplateReaction.class);
    }

    @Override
    public void writeResult(Map<BioPAXElement, List<Match>> matches, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        for (BioPAXElement ele : matches.keySet()) {
            HashSet<String> syms = new HashSet<String>();
            for (Match m : matches.get(ele)) {
                ProteinReference pr = (ProteinReference)m.get("PR", this.getPattern());
                String sym2 = this.getGeneSymbol(pr);
                if (sym2 == null) continue;
                syms.add(sym2);
            }
            if (syms.size() <= 1) continue;
            writer.write("\n" + ele.getUri());
            for (Match o : controlAcc.getValueFromBean(ele)) {
                Control ctrl = (Control)((Object)o);
                writer.write(" " + ctrl.getUri());
            }
            for (String sym3 : syms) {
                writer.write("\t" + sym3);
            }
        }
        writer.flush();
    }
}

