/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.util.HGNC;

public class ConfigurableIDFetcher
implements IDFetcher {
    private final List<String> seqDbStartsWithOrEquals = new ArrayList<String>();
    private final List<String> chemDbStartsWithOrEquals = new ArrayList<String>();
    private boolean useNameWhenNoDbMatch = true;

    public ConfigurableIDFetcher seqDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.seqDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public ConfigurableIDFetcher chemDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.chemDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public ConfigurableIDFetcher useNameWhenNoDbMatch(boolean useNameWhenNoDbMatch) {
        this.useNameWhenNoDbMatch = useNameWhenNoDbMatch;
        return this;
    }

    @Override
    public Set<String> fetchID(BioPAXElement ele) {
        HashSet<String> set = new HashSet<String>();
        if (ele instanceof XReferrable) {
            List<String> dbStartsWithOrEquals = ele instanceof SmallMoleculeReference || ele instanceof SmallMoleculeReference ? this.chemDbStartsWithOrEquals : this.seqDbStartsWithOrEquals;
            for (String dbStartsWith : dbStartsWithOrEquals) {
                for (Xref x : ((XReferrable)ele).getXref()) {
                    if (x instanceof PublicationXref) continue;
                    String db = x.getDb();
                    String id = x.getId();
                    if (db == null || id == null || id.trim().isEmpty() || !(db = db.toLowerCase()).startsWith(dbStartsWith)) continue;
                    if (db.startsWith("hgnc")) {
                        id = HGNC.getSymbol(id);
                    }
                    if (id == null || id.isEmpty()) continue;
                    set.add(id);
                }
                if (set.isEmpty()) continue;
                break;
            }
        }
        if (set.isEmpty() && ele instanceof Named && this.useNameWhenNoDbMatch) {
            Named e = (Named)ele;
            if (e.getDisplayName() != null) {
                set.add(e.getDisplayName());
            } else if (e.getStandardName() != null) {
                set.add(e.getStandardName());
            } else if (!e.getName().isEmpty()) {
                set.add(e.getName().toString());
            }
        }
        if (set.isEmpty()) {
            set.add(ele.getUri());
        }
        return set;
    }
}

