/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class ConstraintChain
extends ConstraintAdapter {
    Constraint[] con;

    public ConstraintChain(Constraint ... con) {
        if (con.length < 2) {
            throw new IllegalArgumentException("Parameter constraint has to be more than one.");
        }
        this.con = con;
        for (int i = 1; i < con.length; ++i) {
            if (con[i].getVariableSize() <= 2) continue;
            throw new IllegalArgumentException("All chained constraints (except first) has to have variable size 2. Unlike con[" + i + "]: " + con[i]);
        }
        this.setSize(con[0].getVariableSize());
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        HashSet<BioPAXElement> gen = new HashSet<BioPAXElement>(this.con[0].generate(match, ind));
        HashSet<BioPAXElement> input = new HashSet<BioPAXElement>();
        HashSet<BioPAXElement> output = new HashSet<BioPAXElement>(gen);
        int[] tempInd = new int[]{0, 1};
        for (int i = 1; i < this.con.length && !output.isEmpty(); ++i) {
            input.clear();
            input.addAll(output);
            output.clear();
            for (BioPAXElement ele : input) {
                Match m = new Match(2);
                m.set(ele, 0);
                output.addAll(this.con[i].generate(m, tempInd));
            }
        }
        return output;
    }
}

