/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sbgn.FeatureDecorator;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.ObjectFactory;

public class CommonFeatureStringGenerator
implements FeatureDecorator {
    private static Map<String, String> symbolMapping = new HashMap<String, String>();
    private static Map<String, String> locMapping = new HashMap<String, String>();

    @Override
    public Glyph.State createStateVar(EntityFeature ef, ObjectFactory factory) {
        Set<String> terms;
        ModificationFeature mf;
        SequenceModificationVocabulary modType;
        if (ef instanceof FragmentFeature) {
            FragmentFeature ff = (FragmentFeature)ef;
            SequenceLocation loc = ff.getFeatureLocation();
            if (loc instanceof SequenceInterval) {
                SequenceInterval si = (SequenceInterval)loc;
                SequenceSite begin = si.getSequenceIntervalBegin();
                SequenceSite end = si.getSequenceIntervalEnd();
                if (begin != null && end != null) {
                    Glyph.State state = factory.createGlyphState();
                    state.setValue("x[" + begin.getSequencePosition() + " - " + end.getSequencePosition() + "]");
                    return state;
                }
            }
        } else if (ef instanceof ModificationFeature && (modType = (mf = (ModificationFeature)ef).getModificationType()) != null && (terms = modType.getTerm()) != null && !terms.isEmpty()) {
            SequenceSite ss;
            String orig = terms.iterator().next();
            String term = orig.toLowerCase();
            String s = symbolMapping.containsKey(term) ? symbolMapping.get(term) : orig;
            Glyph.State state = factory.createGlyphState();
            state.setValue(s);
            SequenceLocation loc = mf.getFeatureLocation();
            if (locMapping.containsKey(term)) {
                state.setVariable(locMapping.get(term));
            }
            if (loc instanceof SequenceSite && (ss = (SequenceSite)loc).getSequencePosition() > 0) {
                state.setVariable((state.getVariable() != null ? state.getVariable() : "") + ss.getSequencePosition());
            }
            return state;
        }
        return null;
    }

    static {
        try {
            InputStream is = CommonFeatureStringGenerator.class.getResourceAsStream("feature-shorts.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                if (token.length > 1 && token[1] != null && token[1].length() > 0) {
                    String key = token[0].replace("\"", "").toLowerCase();
                    symbolMapping.put(key, token[1].replace("\"", ""));
                    if (token.length > 2 && token[2] != null && token[2].length() > 0) {
                        locMapping.put(key, token[2].replace("\"", ""));
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

