/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.util.BPCollections;

public abstract class SimplePhysicalEntityImpl
extends PhysicalEntityImpl
implements SimplePhysicalEntity {
    private EntityReference entityReference;
    Log log = LogFactory.getLog(SimplePhysicalEntityImpl.class);

    @Override
    public Set<EntityReference> getGenericEntityReferences() {
        Set<EntityReference> ger = BPCollections.I.createSet();
        EntityReference er = this.getEntityReference();
        if (er != null) {
            ger.add(er);
            ger.addAll(er.getMemberEntityReference());
        }
        for (PhysicalEntity pe : this.getMemberPhysicalEntity()) {
            if (pe instanceof SimplePhysicalEntity) {
                ger.addAll(((SimplePhysicalEntity)pe).getGenericEntityReferences());
                continue;
            }
            this.log.error("Member PE is of different class! Skipping..");
        }
        return ger;
    }

    @Override
    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    @Override
    public void setEntityReference(EntityReference entityReference) {
        if (this.entityReference != null) {
            this.entityReference.getEntityReferenceOf().remove(this);
        }
        this.entityReference = entityReference;
        if (this.entityReference != null) {
            this.entityReference.getEntityReferenceOf().add(this);
        }
    }

    @Override
    public int equivalenceCode() {
        return this.entityReference == null ? this.hashCode() : 31 * super.locationAndFeatureCode() + this.entityReference.equivalenceCode();
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof SimplePhysicalEntity)) {
            return false;
        }
        SimplePhysicalEntity that = (SimplePhysicalEntity)element;
        return (that.getEntityReference() != null ? that.getEntityReference().isEquivalent(this.getEntityReference()) : this.getEntityReference() == null) && super.semanticallyEquivalent(element);
    }
}

