/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.util.BPCollections;

public class EntityFeatureImpl
extends L3ElementImpl
implements EntityFeature {
    private static final Log LOG = LogFactory.getLog(EntityFeatureImpl.class);
    private Set<Evidence> evidence = BPCollections.I.createSafeSet();
    private EntityReference ownerEntityReference;
    private Set<PhysicalEntity> featureOf = BPCollections.I.createSafeSet();
    private Set<PhysicalEntity> notFeatureOf = BPCollections.I.createSafeSet();
    private SequenceLocation featureLocation;
    private Set<EntityFeature> memberFeature;
    private SequenceRegionVocabulary featureLocationType;
    private Set<EntityFeature> memberFeatureOf = BPCollections.I.createSafeSet();

    public EntityFeatureImpl() {
        this.memberFeature = BPCollections.I.createSafeSet();
    }

    public Class<? extends EntityFeature> getModelInterface() {
        return EntityFeature.class;
    }

    @Override
    public EntityReference getEntityFeatureOf() {
        return this.ownerEntityReference;
    }

    public void setEntityFeatureOf(EntityReference entityReference) {
        this.ownerEntityReference = entityReference;
    }

    @Override
    public Set<PhysicalEntity> getFeatureOf() {
        return this.featureOf;
    }

    @Override
    public Set<PhysicalEntity> getNotFeatureOf() {
        return this.notFeatureOf;
    }

    @Override
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }

    @Override
    public SequenceLocation getFeatureLocation() {
        return this.featureLocation;
    }

    @Override
    public void setFeatureLocation(SequenceLocation featureLocation) {
        this.featureLocation = featureLocation;
    }

    @Override
    public SequenceRegionVocabulary getFeatureLocationType() {
        return this.featureLocationType;
    }

    @Override
    public void setFeatureLocationType(SequenceRegionVocabulary regionVocabulary) {
        this.featureLocationType = regionVocabulary;
    }

    @Override
    public Set<EntityFeature> getMemberFeature() {
        return this.memberFeature;
    }

    @Override
    public void addMemberFeature(EntityFeature feature) {
        if (feature != null) {
            this.memberFeature.add(feature);
            feature.getMemberFeatureOf().add(this);
        }
    }

    @Override
    public void removeMemberFeature(EntityFeature feature) {
        if (feature != null) {
            this.memberFeature.remove(feature);
            feature.getMemberFeatureOf().remove(this);
        }
    }

    @Override
    public Set<EntityFeature> getMemberFeatureOf() {
        return this.memberFeatureOf;
    }

    @Override
    public boolean atEquivalentLocation(EntityFeature that) {
        return this.getEntityFeatureOf() != null && this.getEntityFeatureOf().isEquivalent(that.getEntityFeatureOf()) && this.getFeatureLocation() != null && this.getFeatureLocation().isEquivalent(that.getFeatureLocation());
    }

    protected int locationCode() {
        if (this.getEntityFeatureOf() == null || this.getFeatureLocation() == null) {
            return this.hashCode();
        }
        return this.getEntityFeatureOf().equivalenceCode() + 13 * this.getFeatureLocation().equivalenceCode();
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof EntityFeature)) {
            return false;
        }
        EntityFeature that = (EntityFeature)element;
        boolean value = this.atEquivalentLocation(that);
        if (value) {
            SequenceRegionVocabulary myType = this.featureLocationType;
            SequenceRegionVocabulary yourType = that.getFeatureLocationType();
            value = yourType == null ? myType == null : yourType.isEquivalent(myType);
        }
        return value;
    }

    @Override
    public int equivalenceCode() {
        SequenceRegionVocabulary siteType = this.getFeatureLocationType();
        int code = siteType == null ? 0 : siteType.hashCode();
        return code + 13 * this.locationCode();
    }
}

